/*
 * Decompiled with CFR 0.152.
 */
package org.apache.soap.server.http;

import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import javax.mail.MessagingException;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import javax.xml.parsers.DocumentBuilder;
import org.apache.soap.Constants;
import org.apache.soap.Envelope;
import org.apache.soap.SOAPException;
import org.apache.soap.encoding.SOAPMappingRegistry;
import org.apache.soap.rpc.SOAPContext;
import org.apache.soap.server.DeploymentDescriptor;
import org.apache.soap.server.ServerUtils;
import org.apache.soap.server.ServiceManager;
import org.apache.soap.transport.EnvelopeEditor;
import org.apache.soap.util.IOUtils;
import org.apache.soap.util.MethodUtils;

public class ServerHTTPUtils {
    private static final String SERVICE_MANAGER_ID = "serviceManager";
    private static final String SCRIPT_CLASS = "com.ibm.bsf.BSFManager";
    private static final String SCRIPT_INVOKER = "org.apache.soap.server.InvokeBSF";
    private static final String SERVLET_CLASSLOADER = "servletClassLoader";
    static /* synthetic */ Class class$org$apache$soap$server$DeploymentDescriptor;
    static /* synthetic */ Class class$java$lang$Object;
    static /* synthetic */ Class class$java$lang$String;

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public static File getFileFromNameAndContext(String string, ServletContext servletContext) {
        String string2;
        File file = new File(string);
        if (!file.isAbsolute() && servletContext != null && (string2 = servletContext.getRealPath(string)) != null) {
            file = new File(string2);
        }
        return file;
    }

    public static SOAPMappingRegistry getSMRFromContext(ServletContext servletContext) {
        SOAPMappingRegistry sOAPMappingRegistry = null;
        ServletContext servletContext2 = servletContext;
        synchronized (servletContext2) {
            sOAPMappingRegistry = (SOAPMappingRegistry)servletContext.getAttribute("__cached_servlet_SMR__");
            if (sOAPMappingRegistry == null) {
                sOAPMappingRegistry = new SOAPMappingRegistry();
                servletContext.setAttribute("__cached_servlet_SMR__", (Object)sOAPMappingRegistry);
            }
        }
        return sOAPMappingRegistry;
    }

    public static ServiceManager getServiceManagerFromContext(ServletContext servletContext) {
        return ServerHTTPUtils.getServiceManagerFromContext(servletContext, null);
    }

    public static ServiceManager getServiceManagerFromContext(ServletContext servletContext, String string) {
        Object object;
        if (servletContext != null) {
            ServletContext servletContext2 = servletContext;
            synchronized (servletContext2) {
                object = servletContext.getAttribute(SERVICE_MANAGER_ID);
                if (object == null) {
                    object = new ServiceManager(servletContext, string);
                    servletContext.setAttribute(SERVICE_MANAGER_ID, object);
                }
            }
        } else {
            object = new ServiceManager(null, string);
        }
        return object;
    }

    public static ClassLoader getServletClassLoaderFromContext(ServletContext servletContext) {
        if (servletContext != null) {
            Object object;
            ServletContext servletContext2 = servletContext;
            synchronized (servletContext2) {
                object = servletContext.getAttribute(SERVLET_CLASSLOADER);
            }
            return (ClassLoader)object;
        }
        return null;
    }

    public static Object getTargetObject(ServiceManager serviceManager, DeploymentDescriptor deploymentDescriptor, String string, HttpServlet httpServlet, HttpSession httpSession, SOAPContext sOAPContext, ServletContext servletContext) throws SOAPException {
        Class[] classArray;
        Object object;
        int n2 = deploymentDescriptor.getScope();
        byte by = deploymentDescriptor.getProviderType();
        Object object2 = null;
        String string2 = by == 0 || by == 3 ? deploymentDescriptor.getProviderClass() : SCRIPT_CLASS;
        Object object3 = null;
        if (n2 == 0) {
            object3 = httpServlet;
        } else if (n2 == 1) {
            object3 = httpSession;
        } else if (n2 == 2) {
            object3 = servletContext;
        } else {
            throw new SOAPException(Constants.FAULT_CODE_SERVER, "Service uses deprecated object scope 'page': inform provider of error");
        }
        boolean bl = false;
        if (string.equals("urn:xml-soap-service-management-service")) {
            object2 = serviceManager;
        } else {
            if (object3 == null) {
                object3 = string2;
            }
            object = object3;
            synchronized (object) {
                object2 = object3 == httpSession ? httpSession.getValue(string) : (object3 == servletContext ? servletContext.getAttribute(string) : null);
                if (object2 == null) {
                    try {
                        classArray = sOAPContext.loadClass(string2);
                        object2 = deploymentDescriptor.getIsStatic() ? classArray : classArray.newInstance();
                        bl = true;
                        if (object3 == httpSession) {
                            httpSession.putValue(string, object2);
                        } else if (object3 == servletContext) {
                            servletContext.setAttribute(string, object2);
                        }
                    }
                    catch (Exception exception) {
                        String string3 = by == 0 || by == 3 ? "Unable to resolve target object: " + exception.getMessage() : "Unable to load BSF: script services not available without BSF: " + exception.getMessage();
                        throw new SOAPException(Constants.FAULT_CODE_SERVER_BAD_TARGET_OBJECT_URI, string3, exception);
                    }
                }
            }
        }
        if (by != 0 && by != 3 && bl) {
            object = null;
            try {
                object = sOAPContext.loadClass(SCRIPT_INVOKER);
            }
            catch (Exception exception) {
                classArray = "Unable to load BSF invoker (org.apache.soap.server.InvokeBSF): script services not available without BSF: " + exception.getMessage();
                throw new SOAPException(Constants.FAULT_CODE_SERVER, (String)classArray, exception);
            }
            String string4 = deploymentDescriptor.getScriptFilenameOrString();
            if (by == 1) {
                classArray = servletContext.getRealPath(string4);
                try {
                    string4 = IOUtils.getStringFromReader(new FileReader((String)classArray));
                }
                catch (Exception exception) {
                    String string5 = "Unable to load script file (" + (String)classArray + ")" + ": " + exception.getMessage();
                    throw new SOAPException(Constants.FAULT_CODE_SERVER, string5, exception);
                }
            }
            classArray = new Class[]{class$org$apache$soap$server$DeploymentDescriptor != null ? class$org$apache$soap$server$DeploymentDescriptor : (class$org$apache$soap$server$DeploymentDescriptor = ServerHTTPUtils.class$("org.apache.soap.server.DeploymentDescriptor")), class$java$lang$Object != null ? class$java$lang$Object : (class$java$lang$Object = ServerHTTPUtils.class$("java.lang.Object")), class$java$lang$String != null ? class$java$lang$String : (class$java$lang$String = ServerHTTPUtils.class$("java.lang.String"))};
            try {
                Method method = MethodUtils.getMethod((Class)object, "init", classArray, true);
                method.invoke(null, deploymentDescriptor, object2, string4);
            }
            catch (InvocationTargetException invocationTargetException) {
                Throwable throwable = invocationTargetException.getTargetException();
                if (throwable instanceof SOAPException) {
                    throw (SOAPException)throwable;
                }
                String string6 = "Unable to invoke init method of script invoker: " + throwable;
                throw new SOAPException(Constants.FAULT_CODE_SERVER, string6, throwable);
            }
            catch (Exception exception) {
                String string7 = "Unable to invoke init method of script invoker: " + exception;
                throw new SOAPException(Constants.FAULT_CODE_SERVER, string7, exception);
            }
        }
        return object2;
    }

    public static Envelope readEnvelopeFromRequest(DocumentBuilder documentBuilder, String string, int n2, InputStream inputStream, EnvelopeEditor envelopeEditor, HttpServletResponse httpServletResponse, SOAPContext sOAPContext) throws SOAPException, IOException {
        try {
            return ServerUtils.readEnvelopeFromInputStream(documentBuilder, inputStream, n2, string, envelopeEditor, sOAPContext);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            String string2 = illegalArgumentException.getMessage();
            httpServletResponse.sendError(400, "Error unmarshalling envelope: " + string2);
            return null;
        }
        catch (MessagingException messagingException) {
            httpServletResponse.sendError(400, "Error unmarshalling envelope: " + messagingException);
            return null;
        }
    }

    public static void setServletClassLoaderIntoContext(ServletContext servletContext, ClassLoader classLoader) {
        ServletContext servletContext2 = servletContext;
        synchronized (servletContext2) {
            servletContext.setAttribute(SERVLET_CLASSLOADER, (Object)classLoader);
        }
    }
}

