/*
 * Decompiled with CFR 0.152.
 */
package org.apache.soap.server;

import java.io.IOException;
import java.io.InputStream;
import javax.mail.MessagingException;
import javax.mail.internet.MimeBodyPart;
import javax.xml.parsers.DocumentBuilder;
import org.apache.soap.Constants;
import org.apache.soap.Envelope;
import org.apache.soap.SOAPException;
import org.apache.soap.rpc.SOAPContext;
import org.apache.soap.server.DeploymentDescriptor;
import org.apache.soap.transport.EnvelopeEditor;
import org.apache.soap.transport.TransportMessage;
import org.apache.soap.util.Provider;

public class ServerUtils {
    public static Provider loadProvider(DeploymentDescriptor deploymentDescriptor, SOAPContext sOAPContext) throws SOAPException {
        Object t2;
        String string = deploymentDescriptor.getServiceClass();
        if (string == null) {
            return null;
        }
        if (string.equals("java")) {
            string = "org.apache.soap.providers.RPCJavaProvider";
        } else if (string.equals("script")) {
            string = "org.apache.soap.providers.RPCJavaProvider";
        }
        try {
            Class clazz = sOAPContext.loadClass(string);
            t2 = clazz.newInstance();
        }
        catch (Exception exception) {
            throw new SOAPException(Constants.FAULT_CODE_SERVER, "Can't load provider '" + string + "'", exception);
        }
        if (!(t2 instanceof Provider)) {
            throw new SOAPException(Constants.FAULT_CODE_SERVER, "'" + string + "' isn't a provider");
        }
        return (Provider)t2;
    }

    public static Envelope readEnvelopeFromInputStream(DocumentBuilder documentBuilder, InputStream inputStream, int n2, String string, EnvelopeEditor envelopeEditor, SOAPContext sOAPContext) throws SOAPException, IOException, IllegalArgumentException, MessagingException {
        TransportMessage transportMessage = new TransportMessage(inputStream, n2, string, sOAPContext, null);
        transportMessage.read();
        MimeBodyPart mimeBodyPart = sOAPContext.getRootPart();
        if (!mimeBodyPart.isMimeType("text/xml")) {
            throw new SOAPException(Constants.FAULT_CODE_PROTOCOL, "Unsupported content type \"" + mimeBodyPart.getContentType() + "\", must be: \"" + "text/xml" + "\".");
        }
        transportMessage.editIncoming(envelopeEditor);
        return transportMessage.unmarshall(documentBuilder);
    }
}

