/*
 * Decompiled with CFR 0.152.
 */
package org.apache.soap.rpc;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Vector;
import org.apache.soap.Body;
import org.apache.soap.Constants;
import org.apache.soap.Envelope;
import org.apache.soap.Fault;
import org.apache.soap.Header;
import org.apache.soap.SOAPException;
import org.apache.soap.Utils;
import org.apache.soap.encoding.SOAPMappingRegistry;
import org.apache.soap.rpc.Call;
import org.apache.soap.rpc.Parameter;
import org.apache.soap.rpc.RPCConstants;
import org.apache.soap.rpc.Response;
import org.apache.soap.rpc.SOAPContext;
import org.apache.soap.server.DeploymentDescriptor;
import org.apache.soap.server.ServiceManager;
import org.apache.soap.util.Bean;
import org.apache.soap.util.StringUtils;
import org.apache.soap.util.xml.DOMUtils;
import org.apache.soap.util.xml.NSStack;
import org.apache.soap.util.xml.QName;
import org.apache.soap.util.xml.Serializer;
import org.apache.soap.util.xml.XMLJavaMappingRegistry;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class RPCMessage
implements Serializer {
    protected String targetObjectURI;
    protected String fullTargetObjectURI;
    protected String methodName;
    protected Vector params;
    protected Header header;
    protected String encodingStyleURI;
    protected SOAPContext ctx;
    static /* synthetic */ Class class$org$apache$soap$rpc$Response;
    static /* synthetic */ Class class$org$apache$soap$rpc$Call;
    static /* synthetic */ Class class$org$apache$soap$rpc$Parameter;

    protected RPCMessage(String string, String string2, Vector vector, Header header, String string3, SOAPContext sOAPContext) {
        this.setTargetObjectURI(string);
        this.methodName = string2;
        this.params = vector;
        this.header = header;
        this.encodingStyleURI = string3;
        this.ctx = sOAPContext;
    }

    protected Envelope buildEnvelope(boolean bl) {
        Envelope envelope = new Envelope();
        Body body = new Body();
        Vector<Bean> vector = new Vector<Bean>();
        Class clazz = bl ? (class$org$apache$soap$rpc$Response != null ? class$org$apache$soap$rpc$Response : (class$org$apache$soap$rpc$Response = RPCMessage.class$("org.apache.soap.rpc.Response"))) : (class$org$apache$soap$rpc$Call != null ? class$org$apache$soap$rpc$Call : (class$org$apache$soap$rpc$Call = RPCMessage.class$("org.apache.soap.rpc.Call")));
        vector.addElement(new Bean(clazz, this));
        body.setBodyEntries(vector);
        envelope.setBody(body);
        envelope.setHeader(this.header);
        return envelope;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    protected static RPCMessage extractFromEnvelope(Envelope envelope, ServiceManager serviceManager, boolean bl, SOAPMappingRegistry sOAPMappingRegistry, SOAPContext sOAPContext) throws IllegalArgumentException {
        Body body = envelope.getBody();
        Vector vector = body.getBodyEntries();
        RPCMessage rPCMessage = null;
        if (vector.size() > 0) {
            Element element = (Element)vector.elementAt(0);
            Class clazz = bl ? (class$org$apache$soap$rpc$Response != null ? class$org$apache$soap$rpc$Response : (class$org$apache$soap$rpc$Response = RPCMessage.class$("org.apache.soap.rpc.Response"))) : (class$org$apache$soap$rpc$Call != null ? class$org$apache$soap$rpc$Call : (class$org$apache$soap$rpc$Call = RPCMessage.class$("org.apache.soap.rpc.Call")));
            Class clazz2 = clazz;
            String string = envelope.getAttribute(new QName("http://schemas.xmlsoap.org/soap/envelope/", "encodingStyle"));
            String string2 = body.getAttribute(new QName("http://schemas.xmlsoap.org/soap/envelope/", "encodingStyle"));
            String string3 = string2 != null ? string2 : string;
            rPCMessage = RPCMessage.unmarshall(string3, element, clazz2, serviceManager, sOAPMappingRegistry, sOAPContext);
            rPCMessage.setHeader(envelope.getHeader());
            return rPCMessage;
        }
        throw new IllegalArgumentException("An '" + Constants.Q_ELEM_BODY + "' element must contain a " + "child element.");
    }

    public String getEncodingStyleURI() {
        return this.encodingStyleURI;
    }

    public String getFullTargetObjectURI() {
        return this.fullTargetObjectURI;
    }

    public Header getHeader() {
        return this.header;
    }

    public String getMethodName() {
        return this.methodName;
    }

    public Vector getParams() {
        return this.params;
    }

    public SOAPContext getSOAPContext() {
        return this.ctx;
    }

    public String getTargetObjectURI() {
        return this.targetObjectURI;
    }

    public void marshall(String string, Class clazz, Object object, Object object2, Writer writer, NSStack nSStack, XMLJavaMappingRegistry xMLJavaMappingRegistry, SOAPContext sOAPContext) throws IllegalArgumentException, IOException {
        String string2;
        nSStack.pushScope();
        RPCMessage rPCMessage = (RPCMessage)object;
        boolean bl = clazz == (class$org$apache$soap$rpc$Response != null ? class$org$apache$soap$rpc$Response : (class$org$apache$soap$rpc$Response = RPCMessage.class$("org.apache.soap.rpc.Response")));
        String string3 = Utils.cleanString(rPCMessage.getFullTargetObjectURI());
        String string4 = rPCMessage.getMethodName();
        Vector vector = rPCMessage.getParams();
        String string5 = bl ? RPCConstants.RESPONSE_SUFFIX : "";
        String string6 = rPCMessage.getEncodingStyleURI();
        String string7 = string2 = string6 != null ? string6 : string;
        if (bl) {
            Response response = (Response)rPCMessage;
            if (!response.generatedFault()) {
                StringWriter stringWriter = new StringWriter();
                String string8 = nSStack.getPrefixFromURI(string3, stringWriter);
                writer.write(String.valueOf('<') + string8 + ':' + string4 + string5 + stringWriter);
                String string9 = nSStack.getPrefixFromURI("http://schemas.xmlsoap.org/soap/envelope/", writer);
                if (string6 != null && !string6.equals(string)) {
                    writer.write(String.valueOf(' ') + string9 + ':' + "encodingStyle" + "=\"" + string6 + '\"');
                }
                writer.write(String.valueOf('>') + StringUtils.lineSeparator);
                Parameter parameter = response.getReturnValue();
                if (parameter != null) {
                    String string10 = parameter.getEncodingStyleURI();
                    String string11 = string10 != null ? string10 : string2;
                    Serializer serializer = xMLJavaMappingRegistry.querySerializer(class$org$apache$soap$rpc$Parameter != null ? class$org$apache$soap$rpc$Parameter : (class$org$apache$soap$rpc$Parameter = RPCMessage.class$("org.apache.soap.rpc.Parameter")), string11);
                    serializer.marshall(string2, class$org$apache$soap$rpc$Parameter != null ? class$org$apache$soap$rpc$Parameter : (class$org$apache$soap$rpc$Parameter = RPCMessage.class$("org.apache.soap.rpc.Parameter")), parameter, null, writer, nSStack, xMLJavaMappingRegistry, sOAPContext);
                    writer.write(StringUtils.lineSeparator);
                }
                this.serializeParams(vector, string2, writer, nSStack, xMLJavaMappingRegistry, sOAPContext);
                writer.write("</" + string8 + ':' + string4 + string5 + '>' + StringUtils.lineSeparator);
            } else {
                Fault fault = response.getFault();
                fault.marshall(string2, writer, nSStack, xMLJavaMappingRegistry, sOAPContext);
            }
        } else {
            StringWriter stringWriter = new StringWriter();
            String string12 = nSStack.getPrefixFromURI(string3, stringWriter);
            writer.write(String.valueOf('<') + string12 + ':' + string4 + string5 + stringWriter);
            String string13 = nSStack.getPrefixFromURI("http://schemas.xmlsoap.org/soap/envelope/", writer);
            if (string6 != null && !string6.equals(string)) {
                writer.write(String.valueOf(' ') + string13 + ':' + "encodingStyle" + "=\"" + string6 + '\"');
            }
            writer.write(String.valueOf('>') + StringUtils.lineSeparator);
            this.serializeParams(vector, string2, writer, nSStack, xMLJavaMappingRegistry, sOAPContext);
            writer.write("</" + string12 + ':' + string4 + string5 + '>');
        }
        nSStack.popScope();
    }

    private void serializeParams(Vector vector, String string, Writer writer, NSStack nSStack, XMLJavaMappingRegistry xMLJavaMappingRegistry, SOAPContext sOAPContext) throws IOException {
        if (vector != null) {
            int n2 = vector.size();
            int n3 = 0;
            while (n3 < n2) {
                Parameter parameter = (Parameter)vector.elementAt(n3);
                String string2 = parameter.getEncodingStyleURI();
                String string3 = string2 != null ? string2 : string;
                Serializer serializer = xMLJavaMappingRegistry.querySerializer(class$org$apache$soap$rpc$Parameter != null ? class$org$apache$soap$rpc$Parameter : RPCMessage.class$("org.apache.soap.rpc.Parameter"), string3);
                serializer.marshall(string, class$org$apache$soap$rpc$Parameter != null ? class$org$apache$soap$rpc$Parameter : RPCMessage.class$("org.apache.soap.rpc.Parameter"), parameter, null, writer, nSStack, xMLJavaMappingRegistry, sOAPContext);
                writer.write(StringUtils.lineSeparator);
                ++n3;
            }
        }
    }

    public void setEncodingStyleURI(String string) {
        this.encodingStyleURI = string;
    }

    public void setFullTargetObjectURI(String string) {
        this.setTargetObjectURI(string);
    }

    public void setHeader(Header header) {
        this.header = header;
    }

    public void setMethodName(String string) {
        this.methodName = string;
    }

    public void setParams(Vector vector) {
        this.params = vector;
    }

    protected void setSOAPContext(SOAPContext sOAPContext) {
        this.ctx = sOAPContext;
    }

    public void setTargetObjectURI(String string) {
        this.fullTargetObjectURI = string;
        this.targetObjectURI = StringUtils.parseFullTargetObjectURI(string);
    }

    public String toString() {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        boolean bl = this instanceof Response;
        printWriter.print("[Header=" + this.header + "] " + "[methodName=" + this.methodName + "] " + "[targetObjectURI=" + this.targetObjectURI + "] " + "[encodingStyleURI=" + this.encodingStyleURI + "] " + "[SOAPContext=" + this.ctx + "] ");
        if (bl) {
            Response response = (Response)this;
            if (response.generatedFault()) {
                printWriter.print("[fault=" + response.getFault() + "] ");
            } else {
                printWriter.println("[return=" + response.getReturnValue() + "] ");
            }
        }
        printWriter.print("[Params={");
        if (this.params != null) {
            int n2 = 0;
            while (n2 < this.params.size()) {
                if (n2 > 0) {
                    printWriter.print(", ");
                }
                printWriter.print("[" + this.params.elementAt(n2) + "]");
                ++n2;
            }
        }
        printWriter.print("}]");
        return stringWriter.toString();
    }

    public static RPCMessage unmarshall(String string, Node node, Class clazz, ServiceManager serviceManager, SOAPMappingRegistry sOAPMappingRegistry, SOAPContext sOAPContext) throws IllegalArgumentException {
        Object object;
        String string2;
        SOAPMappingRegistry sOAPMappingRegistry2 = null;
        Element element = (Element)node;
        boolean bl = clazz == (class$org$apache$soap$rpc$Response != null ? class$org$apache$soap$rpc$Response : (class$org$apache$soap$rpc$Response = RPCMessage.class$("org.apache.soap.rpc.Response")));
        String string3 = null;
        String string4 = null;
        String string5 = null;
        Parameter parameter = null;
        Fault fault = null;
        Vector<Parameter> vector = null;
        String string6 = DOMUtils.getAttributeNS(element, "http://schemas.xmlsoap.org/soap/envelope/", "encodingStyle");
        String string7 = string2 = string6 != null ? string6 : string;
        if (bl && Constants.Q_ELEM_FAULT.matches(element)) {
            fault = Fault.unmarshall(string2, element, sOAPMappingRegistry, sOAPContext);
        } else {
            Bean bean;
            String string8;
            String string9;
            Object object2;
            object = element.getLocalName();
            string3 = element.getNamespaceURI();
            string4 = StringUtils.parseFullTargetObjectURI(string3);
            if (!bl) {
                object2 = null;
                try {
                    object2 = serviceManager.query(string4);
                    sOAPMappingRegistry2 = DeploymentDescriptor.buildSOAPMappingRegistry((DeploymentDescriptor)object2, sOAPContext);
                }
                catch (SOAPException sOAPException) {
                    throw new IllegalArgumentException("Unable to resolve targetObjectURI '" + string4 + "'.");
                }
            } else {
                sOAPMappingRegistry2 = sOAPMappingRegistry;
            }
            sOAPMappingRegistry2.setDefaultEncodingStyle("http://schemas.xmlsoap.org/soap/encoding/");
            string5 = object;
            if (bl && string5.endsWith(RPCConstants.RESPONSE_SUFFIX)) {
                string5 = string5.substring(0, string5.length() - 8);
            }
            object2 = DOMUtils.getFirstChildElement(element);
            if (bl && object2 != null) {
                string9 = DOMUtils.getAttributeNS((Element)object2, "http://schemas.xmlsoap.org/soap/envelope/", "encodingStyle");
                string8 = string9 != null ? string9 : string2;
                bean = sOAPMappingRegistry2.unmarshall(string8, RPCConstants.Q_ELEM_PARAMETER, (Node)object2, sOAPContext);
                parameter = (Parameter)bean.value;
                if (string9 != null) {
                    parameter.setEncodingStyleURI(string9);
                }
                object2 = DOMUtils.getNextSiblingElement((Element)object2);
            }
            if (object2 != null) {
                vector = new Vector<Parameter>();
                while (object2 != null) {
                    string9 = DOMUtils.getAttributeNS((Element)object2, "http://schemas.xmlsoap.org/soap/envelope/", "encodingStyle");
                    string8 = string9 != null ? string9 : string2;
                    bean = sOAPMappingRegistry2.unmarshall(string8, RPCConstants.Q_ELEM_PARAMETER, (Node)object2, sOAPContext);
                    Parameter parameter2 = (Parameter)bean.value;
                    if (string9 != null) {
                        parameter2.setEncodingStyleURI(string9);
                    }
                    vector.addElement(parameter2);
                    object2 = DOMUtils.getNextSiblingElement((Element)object2);
                }
            }
        }
        Object object3 = bl ? (fault == null ? new Response(string3, string5, parameter, vector, null, string6, sOAPContext) : new Response(string3, string5, fault, vector, null, string6, sOAPContext)) : (object = new Call(string3, string5, vector, null, string2, sOAPContext));
        if (object instanceof Call) {
            ((Call)object).setSOAPMappingRegistry(sOAPMappingRegistry2);
        }
        return object;
    }
}

