/*
 * Decompiled with CFR 0.152.
 */
package org.apache.soap.providers.com;

import java.io.StringWriter;
import java.util.Hashtable;
import java.util.Vector;
import javax.servlet.Servlet;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpSession;
import org.apache.soap.Constants;
import org.apache.soap.Envelope;
import org.apache.soap.SOAPException;
import org.apache.soap.providers.com.Log;
import org.apache.soap.rpc.Call;
import org.apache.soap.rpc.Parameter;
import org.apache.soap.rpc.RPCConstants;
import org.apache.soap.rpc.Response;
import org.apache.soap.rpc.SOAPContext;
import org.apache.soap.server.DeploymentDescriptor;
import org.apache.soap.server.MessageRouter;
import org.apache.soap.util.Provider;

public class RPCProvider
implements Provider {
    private DeploymentDescriptor dd;
    private Envelope envelope;
    private Call call;
    private String methodName;
    private String targetObjectURI;
    private HttpServlet servlet;
    private HttpSession session;
    private byte[] vp = null;
    private String progid = null;
    private ServletContext sc = null;
    private String threadingModel = null;
    private static boolean initLog = false;
    static SOAPException dllLoadException = null;
    static final String libName = "COMProvider";
    static final String pname = "org.apache.soap.providers.com";
    static final String cname = "org.apache.soap.providers.com.RPCProvider";
    private static final int sizeOfVariant = 16;

    static {
        try {
            System.loadLibrary(libName);
        }
        catch (SecurityException securityException) {
            dllLoadException = new SOAPException(Constants.FAULT_CODE_SERVER, "SecurityException from org.apache.soap.providers.com.RPCProvider loading library:COMProvider " + securityException.getMessage(), securityException);
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            dllLoadException = new SOAPException(Constants.FAULT_CODE_SERVER, "UnsatisfiedLinkError from org.apache.soap.providers.com.RPCProvider loading library:COMProvider " + unsatisfiedLinkError.getMessage(), unsatisfiedLinkError);
        }
    }

    private static SOAPException getSOAPException(String string) {
        return new SOAPException(Constants.FAULT_CODE_SERVER, string);
    }

    private static native void initlog(short var0);

    private native Object invoke(String var1, String var2, String var3, byte[] var4) throws SOAPException;

    public void invoke(SOAPContext sOAPContext, SOAPContext sOAPContext2) throws SOAPException {
        if (dllLoadException != null) {
            Log.msg(1, "msg.comprovider.dllfail", dllLoadException);
            throw dllLoadException;
        }
        if (this.progid == null) {
            String string = Log.msg(1, "msg.comprovider.error.nullprog", this.methodName, this.targetObjectURI);
            throw new SOAPException(Constants.FAULT_CODE_SERVER, string);
        }
        if (this.methodName == null) {
            String string = Log.msg(1, "msg.comprovider.error.nullmname", this.targetObjectURI);
            throw new SOAPException(Constants.FAULT_CODE_SERVER, string);
        }
        Object object = null;
        try {
            object = this.invoke(this.threadingModel, this.progid, this.methodName, this.vp);
        }
        catch (Exception exception) {
            String string = Log.msg(1, "msg.comprovider.error.nativeError", exception.toString());
            throw new SOAPException(Constants.FAULT_CODE_SERVER, string);
        }
        try {
            Parameter parameter = null;
            if (object != null) {
                parameter = new Parameter(RPCConstants.ELEM_RETURN, object.getClass(), object, null);
            }
            this.vp = null;
            Response response = new Response(this.targetObjectURI, this.call.getMethodName(), parameter, null, null, this.call.getEncodingStyleURI(), sOAPContext2);
            Envelope envelope = response.buildEnvelope();
            StringWriter stringWriter = new StringWriter();
            envelope.marshall(stringWriter, this.call.getSOAPMappingRegistry(), sOAPContext2);
            sOAPContext2.setRootPart(stringWriter.toString(), "text/xml;charset=utf-8");
        }
        catch (Exception exception) {
            String string = Log.msg(1, "msg.comprovider.error.exp", exception.toString());
            if (exception instanceof SOAPException) {
                throw (SOAPException)exception;
            }
            throw new SOAPException(Constants.FAULT_CODE_SERVER, string);
        }
        Log.msg(256, "msg.comprovider.ok", object == null ? "*null*" : object.toString());
    }

    public void locate(DeploymentDescriptor deploymentDescriptor, Envelope envelope, Call call, String string, String string2, SOAPContext sOAPContext) throws SOAPException {
        HttpServlet httpServlet = (HttpServlet)sOAPContext.getProperty(Constants.BAG_HTTPSERVLET);
        HttpSession httpSession = (HttpSession)sOAPContext.getProperty(Constants.BAG_HTTPSESSION);
        if (!initLog) {
            Log.init((Servlet)httpServlet);
            RPCProvider.initlog(Log.getLevel());
            initLog = true;
        }
        Log.msg(256, "msg.comprovider.inlocate", this.getClass().getName(), string2, string);
        if (dllLoadException != null) {
            Log.msg(1, "msg.comprovider.dllfail", dllLoadException);
            throw dllLoadException;
        }
        if (!MessageRouter.validMessage(deploymentDescriptor, string)) {
            String string3 = Log.msg(1, "msg.comprovider.badMethod", string2, string);
            throw new SOAPException(Constants.FAULT_CODE_SERVER, string3);
        }
        Vector vector = call.getParams();
        int n2 = 0;
        if (vector != null) {
            this.vp = new byte[16 * vector.size()];
            n2 = vector.size();
        }
        int n3 = 0;
        while (n3 < n2) {
            Log.msg(4096, "msg.comprovider.info.parms", new Integer(n3), vector.elementAt(n3).getClass().getName(), vector.elementAt(n3).toString());
            this.objectToVariant(((Parameter)vector.elementAt(n2 - n3 - 1)).getValue(), this.vp, n3 * 16);
            ++n3;
        }
        Hashtable hashtable = deploymentDescriptor.getProps();
        this.progid = (String)hashtable.get("progid");
        if (this.progid == null) {
            this.progid = string2.startsWith("urn:") ? string2.substring(4) : string2;
        }
        this.threadingModel = (String)hashtable.get("threadmodel");
        if (this.threadingModel == null) {
            this.threadingModel = "MULTITHREADED";
        }
        Log.msg(4096, "msg.comprovider.info.cominf", this.progid, this.threadingModel);
        this.dd = deploymentDescriptor;
        this.envelope = envelope;
        this.call = call;
        this.methodName = string;
        this.targetObjectURI = string2;
        this.servlet = httpServlet;
        this.session = httpSession;
    }

    protected void logit(int n2, String string) {
        Log.msg(n2, string);
    }

    private static native byte[] nativeConvertToBString(String var0);

    private final byte[] objectToVariant(Object object) throws SOAPException {
        return this.objectToVariant(object, null, 0);
    }

    private final byte[] objectToVariant(Object object, byte[] byArray, int n2) throws SOAPException {
        byte[] byArray2 = byArray;
        if (byArray2 == null) {
            byArray2 = new byte[16];
            n2 = 0;
        }
        if (object == null) {
            byArray2[n2] = 1;
            byArray2[n2 + 1] = 0;
        } else if (object instanceof Boolean) {
            byte by;
            byArray2[n2] = 11;
            byArray2[n2 + 1] = 0;
            byArray2[n2 + 8] = by = (byte)((Boolean)object != false ? 255 : 0);
            byArray2[n2 + 9] = by;
            byArray2[n2 + 10] = by;
            byArray2[n2 + 11] = by;
        } else if (object instanceof Integer) {
            byArray2[n2] = 3;
            byArray2[n2 + 1] = 0;
            int n3 = (Integer)object;
            byArray2[n2 + 8] = (byte)n3;
            byArray2[n2 + 9] = (byte)(n3 >>> 8 & 0xFF);
            byArray2[n2 + 10] = (byte)(n3 >>> 16 & 0xFF);
            byArray2[n2 + 11] = (byte)(n3 >>> 24 & 0xFF);
        } else if (object instanceof String) {
            byArray2[n2] = 8;
            byArray2[n2 + 1] = 0;
            byte[] byArray3 = RPCProvider.nativeConvertToBString((String)object);
            byArray2[n2 + 8] = byArray3[0];
            byArray2[n2 + 9] = byArray3[1];
            byArray2[n2 + 10] = byArray3[2];
            byArray2[n2 + 11] = byArray3[3];
        } else if (object instanceof Long) {
            byArray2[n2] = 5;
            byArray2[n2 + 1] = 0;
            long l2 = Double.doubleToLongBits(((Long)object).longValue());
            byArray2[n2 + 8] = (byte)l2;
            byArray2[n2 + 9] = (byte)(l2 >>> 8 & 0xFFL);
            byArray2[n2 + 10] = (byte)(l2 >>> 16 & 0xFFL);
            byArray2[n2 + 11] = (byte)(l2 >>> 24 & 0xFFL);
            byArray2[n2 + 12] = (byte)(l2 >>> 32 & 0xFFL);
            byArray2[n2 + 13] = (byte)(l2 >>> 40 & 0xFFL);
            byArray2[n2 + 14] = (byte)(l2 >>> 48 & 0xFFL);
            byArray2[n2 + 15] = (byte)(l2 >>> 56 & 0xFFL);
        } else if (object instanceof Short) {
            byArray2[n2] = 2;
            byArray2[n2 + 1] = 0;
            int n4 = ((Short)object).intValue();
            byArray2[n2 + 8] = (byte)n4;
            byArray2[n2 + 9] = (byte)(n4 >>> 8 & 0xFF);
            byArray2[n2 + 10] = (byte)(n4 >>> 16 & 0xFF);
            byArray2[n2 + 11] = (byte)(n4 >>> 24 & 0xFF);
        } else if (object instanceof Float) {
            byArray2[n2] = 4;
            byArray2[n2 + 1] = 0;
            int n5 = Float.floatToIntBits(((Float)object).floatValue());
            byArray2[n2 + 8] = (byte)n5;
            byArray2[n2 + 9] = (byte)(n5 >>> 8 & 0xFF);
            byArray2[n2 + 10] = (byte)(n5 >>> 16 & 0xFF);
            byArray2[n2 + 11] = (byte)(n5 >>> 24 & 0xFF);
        } else if (object instanceof Double) {
            byArray2[n2] = 5;
            byArray2[n2 + 1] = 0;
            long l3 = Double.doubleToLongBits((Double)object);
            byArray2[n2 + 8] = (byte)l3;
            byArray2[n2 + 9] = (byte)(l3 >>> 8 & 0xFFL);
            byArray2[n2 + 10] = (byte)(l3 >>> 16 & 0xFFL);
            byArray2[n2 + 11] = (byte)(l3 >>> 24 & 0xFFL);
            byArray2[n2 + 12] = (byte)(l3 >>> 32 & 0xFFL);
            byArray2[n2 + 13] = (byte)(l3 >>> 40 & 0xFFL);
            byArray2[n2 + 14] = (byte)(l3 >>> 48 & 0xFFL);
            byArray2[n2 + 15] = (byte)(l3 >>> 56 & 0xFFL);
        } else if (object instanceof Byte) {
            byte by;
            byArray2[n2] = 17;
            byArray2[n2 + 1] = 0;
            byArray2[n2 + 8] = by = ((Byte)object).byteValue();
        } else if (object instanceof Character) {
            byte by;
            byArray2[n2] = 17;
            byArray2[n2 + 1] = 0;
            byArray2[n2 + 8] = by = (byte)((Character)object).charValue();
        } else if (object instanceof Void) {
            byArray2[n2] = 1;
            byArray2[n2 + 1] = 0;
        } else {
            if (object.getClass().isArray()) {
                throw new SOAPException(Constants.FAULT_CODE_SERVER, "Currently arrays are unsupported,  type received:" + object.getClass().getName());
            }
            throw new SOAPException(Constants.FAULT_CODE_SERVER, "Currently unsupported data type received:" + object.getClass().getName());
        }
        return byArray2;
    }

    private final byte[] objectsToVariants(Object[] objectArray) throws SOAPException {
        byte[] byArray = new byte[objectArray.length * 16];
        int n2 = 0;
        while (n2 < objectArray.length) {
            this.objectToVariant(objectArray[n2], byArray, n2 * 16);
            ++n2;
        }
        return byArray;
    }
}

