/*
 * Decompiled with CFR 0.152.
 */
package org.apache.soap.messaging;

import java.io.IOException;
import java.io.StringReader;
import java.net.URL;
import javax.activation.DataHandler;
import javax.mail.MessagingException;
import javax.mail.internet.MimeBodyPart;
import javax.xml.parsers.DocumentBuilder;
import org.apache.soap.Constants;
import org.apache.soap.Envelope;
import org.apache.soap.SOAPException;
import org.apache.soap.rpc.Call;
import org.apache.soap.rpc.SOAPContext;
import org.apache.soap.transport.SOAPTransport;
import org.apache.soap.transport.http.SOAPHTTPConnection;
import org.apache.soap.util.xml.XMLParserUtils;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class Message {
    SOAPTransport st;
    SOAPContext reqCtx = new SOAPContext();
    SOAPContext resCtx = null;
    DocumentBuilder xdb = XMLParserUtils.getXMLDocBuilder();

    public void addBodyPart(MimeBodyPart mimeBodyPart) throws MessagingException {
        this.reqCtx.addBodyPart(mimeBodyPart);
    }

    public MimeBodyPart findBodyPart(String string) {
        if (this.resCtx == null) {
            return null;
        }
        return this.resCtx.findBodyPart(string);
    }

    public MimeBodyPart getBodyPart(int n2) throws IndexOutOfBoundsException {
        if (this.resCtx == null) {
            return null;
        }
        return this.resCtx.getBodyPart(n2);
    }

    public int getPartCount() throws MessagingException {
        if (this.resCtx == null) {
            return 0;
        }
        return this.resCtx.getCount();
    }

    public SOAPContext getRequestSOAPContext() {
        return this.reqCtx;
    }

    public SOAPContext getResponseSOAPContext() {
        return this.resCtx;
    }

    public MimeBodyPart getRootPart() throws MessagingException {
        if (this.resCtx == null) {
            return null;
        }
        return this.resCtx.getRootPart();
    }

    public SOAPTransport getSOAPTransport() {
        return this.st;
    }

    public DataHandler receive() throws SOAPException, MessagingException {
        if (this.st == null) {
            throw new SOAPException(Constants.FAULT_CODE_CLIENT, "Unable to receive without sending on an appropriate transport.");
        }
        this.st.receive();
        this.resCtx = this.st.getResponseSOAPContext();
        return this.resCtx.getRootPart().getDataHandler();
    }

    public Envelope receiveEnvelope() throws SOAPException {
        if (this.st == null) {
            throw new SOAPException(Constants.FAULT_CODE_CLIENT, "Unable to receive without sending on an appropriate transport.");
        }
        try {
            this.resCtx = this.st.getResponseSOAPContext();
            String string = Call.getEnvelopeString(this.st);
            Document document = this.xdb.parse(new InputSource(new StringReader(string)));
            if (document == null) {
                throw new SOAPException(Constants.FAULT_CODE_CLIENT, "Parsing error, response was:\n" + string);
            }
            return Envelope.unmarshall(document.getDocumentElement(), this.resCtx);
        }
        catch (MessagingException messagingException) {
            throw new SOAPException(Constants.FAULT_CODE_CLIENT, messagingException.getMessage(), messagingException);
        }
        catch (SAXException sAXException) {
            throw new SOAPException(Constants.FAULT_CODE_CLIENT, "Parsing error, response was:\n" + sAXException.getMessage(), sAXException);
        }
        catch (IOException iOException) {
            throw new SOAPException(Constants.FAULT_CODE_CLIENT, iOException.getMessage(), iOException);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new SOAPException(Constants.FAULT_CODE_CLIENT, illegalArgumentException.getMessage(), illegalArgumentException);
        }
    }

    public void send(URL uRL, String string, Envelope envelope) throws SOAPException {
        if (this.st == null) {
            this.st = new SOAPHTTPConnection();
        }
        this.st.send(uRL, string, null, envelope, null, this.reqCtx);
    }

    public void setSOAPTransport(SOAPTransport sOAPTransport) {
        this.st = sOAPTransport;
    }
}

