/*
 * Decompiled with CFR 0.152.
 */
package org.apache.soap.encoding.soapenc;

import java.io.IOException;
import java.io.Writer;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;
import org.apache.soap.encoding.soapenc.SoapEncUtils;
import org.apache.soap.rpc.SOAPContext;
import org.apache.soap.util.Bean;
import org.apache.soap.util.xml.DOMUtils;
import org.apache.soap.util.xml.Deserializer;
import org.apache.soap.util.xml.NSStack;
import org.apache.soap.util.xml.QName;
import org.apache.soap.util.xml.Serializer;
import org.apache.soap.util.xml.XMLJavaMappingRegistry;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class DateSerializer
implements Serializer,
Deserializer {
    SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'");
    static /* synthetic */ Class class$java$util$Date;

    public DateSerializer() {
        this.sdf.setTimeZone(TimeZone.getTimeZone("GMT"));
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public void marshall(String string, Class clazz, Object object, Object object2, Writer writer, NSStack nSStack, XMLJavaMappingRegistry xMLJavaMappingRegistry, SOAPContext sOAPContext) throws IllegalArgumentException, IOException {
        if (!clazz.equals(class$java$util$Date != null ? class$java$util$Date : (class$java$util$Date = DateSerializer.class$("java.util.Date")))) {
            throw new IllegalArgumentException("Can only serialize java.util.Date instances");
        }
        nSStack.pushScope();
        if (object != null) {
            SoapEncUtils.generateStructureHeader(string, clazz, object2, writer, nSStack, xMLJavaMappingRegistry);
            String string2 = null;
            SimpleDateFormat simpleDateFormat = this.sdf;
            synchronized (simpleDateFormat) {
                string2 = this.sdf.format((Date)object);
            }
            writer.write(string2);
            writer.write("</" + object2 + '>');
        } else {
            SoapEncUtils.generateNullStructure(string, clazz, object2, writer, nSStack, xMLJavaMappingRegistry);
        }
        nSStack.popScope();
    }

    public Bean unmarshall(String string, QName qName, Node node, XMLJavaMappingRegistry xMLJavaMappingRegistry, SOAPContext sOAPContext) throws IllegalArgumentException {
        Date date = null;
        Element element = (Element)node;
        String string2 = DOMUtils.getChildCharacterData(element);
        if (string2 != null && !(string2 = string2.trim()).equals("")) {
            try {
                SimpleDateFormat simpleDateFormat = this.sdf;
                synchronized (simpleDateFormat) {
                    date = this.sdf.parse(string2);
                }
            }
            catch (ParseException parseException) {
                try {
                    int n2;
                    int n3;
                    if (string2.length() < 19) {
                        throw new ParseException("", 0);
                    }
                    if (string2.charAt(4) != '-' || string2.charAt(7) != '-' || string2.charAt(10) != 'T') {
                        throw new ParseException("", 0);
                    }
                    if (string2.charAt(13) != ':' || string2.charAt(16) != ':') {
                        throw new ParseException("", 0);
                    }
                    try {
                        SimpleDateFormat simpleDateFormat = this.sdf;
                        synchronized (simpleDateFormat) {
                            date = this.sdf.parse(String.valueOf(string2.substring(0, 19)) + ".000Z");
                        }
                    }
                    catch (Exception exception) {
                        throw new ParseException("", 0);
                    }
                    int n4 = 19;
                    if (n4 < string2.length() && string2.charAt(n4) == '.') {
                        n3 = 0;
                        n2 = ++n4;
                        while (n4 < string2.length() && Character.isDigit(string2.charAt(n4))) {
                            ++n4;
                        }
                        String string3 = string2.substring(n2, n4);
                        if (string3.length() == 3) {
                            n3 = Integer.parseInt(string3);
                        } else if (string3.length() < 3) {
                            n3 = Integer.parseInt((String.valueOf(string3) + "000").substring(0, 3));
                        } else {
                            n3 = Integer.parseInt(string3.substring(0, 3));
                            if (string3.charAt(3) >= '5') {
                                ++n3;
                            }
                        }
                        date.setTime(date.getTime() + (long)n3);
                    }
                    if (n4 + 5 < string2.length() && (string2.charAt(n4) == '+' || string2.charAt(n4) == '-')) {
                        if (!(Character.isDigit(string2.charAt(n4 + 1)) && Character.isDigit(string2.charAt(n4 + 2)) && string2.charAt(n4 + 3) == ':' && Character.isDigit(string2.charAt(n4 + 4)) && Character.isDigit(string2.charAt(n4 + 5)))) {
                            throw new ParseException("", 0);
                        }
                        n3 = (string2.charAt(n4 + 1) - 48) * 10 + string2.charAt(n4 + 2) - 48;
                        n2 = (string2.charAt(n4 + 4) - 48) * 10 + string2.charAt(n4 + 5) - 48;
                        int n5 = (n3 * 60 + n2) * 60 * 1000;
                        if (string2.charAt(n4) == '+') {
                            n5 = -n5;
                        }
                        date.setTime(date.getTime() + (long)n5);
                        n4 += 6;
                    }
                    if (n4 < string2.length() && string2.charAt(n4) == 'Z') {
                        ++n4;
                    }
                    if (n4 < string2.length()) {
                        throw new ParseException("", 0);
                    }
                }
                catch (ParseException parseException2) {
                    SimpleDateFormat simpleDateFormat = this.sdf;
                    synchronized (simpleDateFormat) {
                        throw new IllegalArgumentException("String represents no valid Date for this Deserializer; try " + this.sdf.toPattern() + ".");
                    }
                }
            }
        }
        return new Bean(class$java$util$Date != null ? class$java$util$Date : (class$java$util$Date = DateSerializer.class$("java.util.Date")), date);
    }
}

