/*
 * Decompiled with CFR 0.152.
 */
package org.apache.soap.encoding.soapenc;

import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;

public class Base64 {
    private static final char[] S_BASE64CHAR = new char[]{'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '+', '/'};
    private static final char S_BASE64PAD = '=';
    private static final byte[] S_DECODETABLE = new byte[128];

    static {
        int n2 = 0;
        while (n2 < S_DECODETABLE.length) {
            Base64.S_DECODETABLE[n2] = 127;
            ++n2;
        }
        int n3 = 0;
        while (n3 < S_BASE64CHAR.length) {
            Base64.S_DECODETABLE[Base64.S_BASE64CHAR[n3]] = (byte)n3;
            ++n3;
        }
    }

    public static byte[] decode(String string) {
        char[] cArray = new char[4];
        int n2 = 0;
        byte[] byArray = new byte[string.length() / 4 * 3 + 3];
        int n3 = 0;
        int n4 = 0;
        while (n4 < string.length()) {
            char c2 = string.charAt(n4);
            if (c2 == '=' || c2 < S_DECODETABLE.length && S_DECODETABLE[c2] != 127) {
                cArray[n2++] = c2;
                if (n2 == cArray.length) {
                    n2 = 0;
                    n3 += Base64.decode0(cArray, byArray, n3);
                }
            }
            ++n4;
        }
        if (n3 == byArray.length) {
            return byArray;
        }
        byte[] byArray2 = new byte[n3];
        System.arraycopy(byArray, 0, byArray2, 0, n3);
        return byArray2;
    }

    public static void decode(String string, OutputStream outputStream) throws IOException {
        char[] cArray = new char[4];
        int n2 = 0;
        byte[] byArray = new byte[3];
        int n3 = 0;
        while (n3 < string.length()) {
            char c2 = string.charAt(n3);
            if (c2 == '=' || c2 < S_DECODETABLE.length && S_DECODETABLE[c2] != 127) {
                cArray[n2++] = c2;
                if (n2 == cArray.length) {
                    n2 = 0;
                    int n4 = Base64.decode0(cArray, byArray, 0);
                    outputStream.write(byArray, 0, n4);
                }
            }
            ++n3;
        }
    }

    public static byte[] decode(char[] cArray, int n2, int n3) {
        char[] cArray2 = new char[4];
        int n4 = 0;
        byte[] byArray = new byte[n3 / 4 * 3 + 3];
        int n5 = 0;
        int n6 = n2;
        while (n6 < n2 + n3) {
            char c2 = cArray[n6];
            if (c2 == '=' || c2 < S_DECODETABLE.length && S_DECODETABLE[c2] != 127) {
                cArray2[n4++] = c2;
                if (n4 == cArray2.length) {
                    n4 = 0;
                    n5 += Base64.decode0(cArray2, byArray, n5);
                }
            }
            ++n6;
        }
        if (n5 == byArray.length) {
            return byArray;
        }
        byte[] byArray2 = new byte[n5];
        System.arraycopy(byArray, 0, byArray2, 0, n5);
        return byArray2;
    }

    public static void decode(char[] cArray, int n2, int n3, OutputStream outputStream) throws IOException {
        char[] cArray2 = new char[4];
        int n4 = 0;
        byte[] byArray = new byte[3];
        int n5 = n2;
        while (n5 < n2 + n3) {
            char c2 = cArray[n5];
            if (c2 == '=' || c2 < S_DECODETABLE.length && S_DECODETABLE[c2] != 127) {
                cArray2[n4++] = c2;
                if (n4 == cArray2.length) {
                    n4 = 0;
                    int n6 = Base64.decode0(cArray2, byArray, 0);
                    outputStream.write(byArray, 0, n6);
                }
            }
            ++n5;
        }
    }

    private static int decode0(char[] cArray, byte[] byArray, int n2) {
        int n3 = 3;
        if (cArray[3] == '=') {
            n3 = 2;
        }
        if (cArray[2] == '=') {
            n3 = 1;
        }
        byte by = S_DECODETABLE[cArray[0]];
        byte by2 = S_DECODETABLE[cArray[1]];
        byte by3 = S_DECODETABLE[cArray[2]];
        byte by4 = S_DECODETABLE[cArray[3]];
        switch (n3) {
            case 1: {
                byArray[n2] = (byte)(by << 2 & 0xFC | by2 >> 4 & 3);
                return 1;
            }
            case 2: {
                byArray[n2++] = (byte)(by << 2 & 0xFC | by2 >> 4 & 3);
                byArray[n2] = (byte)(by2 << 4 & 0xF0 | by3 >> 2 & 0xF);
                return 2;
            }
            case 3: {
                byArray[n2++] = (byte)(by << 2 & 0xFC | by2 >> 4 & 3);
                byArray[n2++] = (byte)(by2 << 4 & 0xF0 | by3 >> 2 & 0xF);
                byArray[n2] = (byte)(by3 << 6 & 0xC0 | by4 & 0x3F);
                return 3;
            }
        }
        throw new RuntimeException("Internal Errror");
    }

    public static String encode(byte[] byArray) {
        return Base64.encode(byArray, 0, byArray.length);
    }

    public static String encode(byte[] byArray, int n2, int n3) {
        int n4;
        if (n3 <= 0) {
            return "";
        }
        char[] cArray = new char[n3 / 3 * 4 + 4];
        int n5 = n2;
        int n6 = 0;
        int n7 = n3;
        while (n7 >= 3) {
            n4 = ((byArray[n5] & 0xFF) << 16) + ((byArray[n5 + 1] & 0xFF) << 8) + (byArray[n5 + 2] & 0xFF);
            cArray[n6++] = S_BASE64CHAR[n4 >> 18];
            cArray[n6++] = S_BASE64CHAR[n4 >> 12 & 0x3F];
            cArray[n6++] = S_BASE64CHAR[n4 >> 6 & 0x3F];
            cArray[n6++] = S_BASE64CHAR[n4 & 0x3F];
            n5 += 3;
            n7 -= 3;
        }
        if (n7 == 1) {
            n4 = byArray[n5] & 0xFF;
            cArray[n6++] = S_BASE64CHAR[n4 >> 2];
            cArray[n6++] = S_BASE64CHAR[n4 << 4 & 0x3F];
            cArray[n6++] = 61;
            cArray[n6++] = 61;
        } else if (n7 == 2) {
            n4 = ((byArray[n5] & 0xFF) << 8) + (byArray[n5 + 1] & 0xFF);
            cArray[n6++] = S_BASE64CHAR[n4 >> 10];
            cArray[n6++] = S_BASE64CHAR[n4 >> 4 & 0x3F];
            cArray[n6++] = S_BASE64CHAR[n4 << 2 & 0x3F];
            cArray[n6++] = 61;
        }
        return new String(cArray, 0, n6);
    }

    public static void encode(byte[] byArray, int n2, int n3, OutputStream outputStream) throws IOException {
        int n4;
        if (n3 <= 0) {
            return;
        }
        byte[] byArray2 = new byte[4];
        int n5 = n2;
        int n6 = n3;
        while (n6 >= 3) {
            n4 = ((byArray[n5] & 0xFF) << 16) + ((byArray[n5 + 1] & 0xFF) << 8) + (byArray[n5 + 2] & 0xFF);
            byArray2[0] = (byte)S_BASE64CHAR[n4 >> 18];
            byArray2[1] = (byte)S_BASE64CHAR[n4 >> 12 & 0x3F];
            byArray2[2] = (byte)S_BASE64CHAR[n4 >> 6 & 0x3F];
            byArray2[3] = (byte)S_BASE64CHAR[n4 & 0x3F];
            outputStream.write(byArray2, 0, 4);
            n5 += 3;
            n6 -= 3;
        }
        if (n6 == 1) {
            n4 = byArray[n5] & 0xFF;
            byArray2[0] = (byte)S_BASE64CHAR[n4 >> 2];
            byArray2[1] = (byte)S_BASE64CHAR[n4 << 4 & 0x3F];
            byArray2[2] = 61;
            byArray2[3] = 61;
            outputStream.write(byArray2, 0, 4);
        } else if (n6 == 2) {
            n4 = ((byArray[n5] & 0xFF) << 8) + (byArray[n5 + 1] & 0xFF);
            byArray2[0] = (byte)S_BASE64CHAR[n4 >> 10];
            byArray2[1] = (byte)S_BASE64CHAR[n4 >> 4 & 0x3F];
            byArray2[2] = (byte)S_BASE64CHAR[n4 << 2 & 0x3F];
            byArray2[3] = 61;
            outputStream.write(byArray2, 0, 4);
        }
    }

    public static void encode(byte[] byArray, int n2, int n3, Writer writer) throws IOException {
        int n4;
        if (n3 <= 0) {
            return;
        }
        char[] cArray = new char[4];
        int n5 = n2;
        int n6 = n3;
        int n7 = 0;
        while (n6 >= 3) {
            n4 = ((byArray[n5] & 0xFF) << 16) + ((byArray[n5 + 1] & 0xFF) << 8) + (byArray[n5 + 2] & 0xFF);
            cArray[0] = S_BASE64CHAR[n4 >> 18];
            cArray[1] = S_BASE64CHAR[n4 >> 12 & 0x3F];
            cArray[2] = S_BASE64CHAR[n4 >> 6 & 0x3F];
            cArray[3] = S_BASE64CHAR[n4 & 0x3F];
            writer.write(cArray, 0, 4);
            n5 += 3;
            n6 -= 3;
            if ((n7 += 4) % 76 != 0) continue;
            writer.write("\n");
        }
        if (n6 == 1) {
            n4 = byArray[n5] & 0xFF;
            cArray[0] = S_BASE64CHAR[n4 >> 2];
            cArray[1] = S_BASE64CHAR[n4 << 4 & 0x3F];
            cArray[2] = 61;
            cArray[3] = 61;
            writer.write(cArray, 0, 4);
        } else if (n6 == 2) {
            n4 = ((byArray[n5] & 0xFF) << 8) + (byArray[n5 + 1] & 0xFF);
            cArray[0] = S_BASE64CHAR[n4 >> 10];
            cArray[1] = S_BASE64CHAR[n4 >> 4 & 0x3F];
            cArray[2] = S_BASE64CHAR[n4 << 2 & 0x3F];
            cArray[3] = 61;
            writer.write(cArray, 0, 4);
        }
    }
}

