/*
 * Decompiled with CFR 0.152.
 */
package org.apache.soap;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Vector;
import javax.xml.parsers.DocumentBuilder;
import org.apache.soap.Header;
import org.apache.soap.SOAPException;
import org.apache.soap.util.xml.DOM2Writer;
import org.apache.soap.util.xml.XMLParserUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.Text;

public class Utils {
    public static Vector buildFaultDetailsFromThrowable(Throwable throwable) {
        Vector<Element> vector = new Vector<Element>();
        DocumentBuilder documentBuilder = XMLParserUtils.getXMLDocBuilder();
        Document document = documentBuilder.newDocument();
        Element element = document.createElement("stackTrace");
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        throwable.printStackTrace(printWriter);
        printWriter.close();
        Text text = document.createTextNode(Utils.cleanString(stringWriter.toString()));
        element.appendChild(text);
        vector.addElement(element);
        return vector;
    }

    public static void checkMustUnderstands(Header header) throws SOAPException {
        Vector vector = header.getHeaderEntries();
        int n2 = 0;
        while (n2 < vector.size()) {
            Element element = (Element)vector.elementAt(n2);
            String string = element.getAttributeNS("http://schemas.xmlsoap.org/soap/envelope/", "mustUnderstand");
            if (string != null && string.equals("1")) {
                throw new SOAPException("mustUnderstand", "Didn't understand header '" + element.getLocalName() + "'");
            }
            ++n2;
        }
    }

    public static String cleanString(String string) {
        if (string == null) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer();
        char[] cArray = string.toCharArray();
        int n2 = 0;
        while (n2 < cArray.length) {
            switch (cArray[n2]) {
                case '&': {
                    stringBuffer.append("&amp;");
                    break;
                }
                case '\"': {
                    stringBuffer.append("&quot;");
                    break;
                }
                case '\'': {
                    stringBuffer.append("&apos;");
                    break;
                }
                case '<': {
                    stringBuffer.append("&lt;");
                    break;
                }
                case '>': {
                    stringBuffer.append("&gt;");
                    break;
                }
                default: {
                    stringBuffer.append(cArray[n2]);
                    break;
                }
            }
            ++n2;
        }
        return stringBuffer.toString();
    }

    public static void marshallNode(Node node, Writer writer) {
        DOM2Writer.serializeAsXML(node, writer);
    }
}

