/*
 * Decompiled with CFR 0.152.
 */
package javax.mail.internet;

import com.sun.mail.util.LineInputStream;
import com.sun.mail.util.LineOutputStream;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.activation.DataSource;
import javax.mail.BodyPart;
import javax.mail.MessageAware;
import javax.mail.MessageContext;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.MultipartDataSource;
import javax.mail.internet.ContentType;
import javax.mail.internet.InternetHeaders;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.SharedInputStream;
import javax.mail.internet.UniqueValue;

public class MimeMultipart
extends Multipart {
    protected DataSource ds;
    protected boolean parsed = true;

    public MimeMultipart() {
        this("mixed");
    }

    public MimeMultipart(String string) {
        String string2 = UniqueValue.getUniqueBoundaryValue();
        ContentType contentType = new ContentType("multipart", string, null);
        contentType.setParameter("boundary", string2);
        this.contentType = contentType.toString();
    }

    public MimeMultipart(DataSource dataSource) throws MessagingException {
        if (dataSource instanceof MessageAware) {
            MessageContext messageContext = ((MessageAware)((Object)dataSource)).getMessageContext();
            this.setParent(messageContext.getPart());
        }
        if (dataSource instanceof MultipartDataSource) {
            this.setMultipartDataSource((MultipartDataSource)dataSource);
            return;
        }
        this.parsed = false;
        this.ds = dataSource;
        this.contentType = dataSource.getContentType();
    }

    public synchronized void setSubType(String string) throws MessagingException {
        ContentType contentType = new ContentType(this.contentType);
        contentType.setSubType(string);
        this.contentType = contentType.toString();
    }

    public synchronized int getCount() throws MessagingException {
        this.parse();
        return super.getCount();
    }

    public synchronized BodyPart getBodyPart(int n2) throws MessagingException {
        this.parse();
        return super.getBodyPart(n2);
    }

    public synchronized BodyPart getBodyPart(String string) throws MessagingException {
        this.parse();
        int n2 = this.getCount();
        int n3 = 0;
        while (n3 < n2) {
            MimeBodyPart mimeBodyPart = (MimeBodyPart)this.getBodyPart(n3);
            String string2 = mimeBodyPart.getContentID();
            if (string2 != null && string2.equals(string)) {
                return mimeBodyPart;
            }
            ++n3;
        }
        return null;
    }

    protected void updateHeaders() throws MessagingException {
        int n2 = 0;
        while (n2 < this.parts.size()) {
            ((MimeBodyPart)this.parts.elementAt(n2)).updateHeaders();
            ++n2;
        }
    }

    public void writeTo(OutputStream outputStream) throws IOException, MessagingException {
        this.parse();
        String string = "--" + new ContentType(this.contentType).getParameter("boundary");
        LineOutputStream lineOutputStream = new LineOutputStream(outputStream);
        int n2 = 0;
        while (n2 < this.parts.size()) {
            lineOutputStream.writeln(string);
            ((MimeBodyPart)this.parts.elementAt(n2)).writeTo(outputStream);
            lineOutputStream.writeln();
            ++n2;
        }
        lineOutputStream.writeln(String.valueOf(string) + "--");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected synchronized void parse() throws MessagingException {
        if (this.parsed) {
            return;
        }
        InputStream inputStream = null;
        SharedInputStream sharedInputStream = null;
        long l2 = 0L;
        long l3 = 0L;
        try {
            inputStream = this.ds.getInputStream();
            if (!(inputStream instanceof ByteArrayInputStream) && !(inputStream instanceof BufferedInputStream)) {
                inputStream = new BufferedInputStream(inputStream);
            }
        }
        catch (Exception exception) {
            throw new MessagingException("No inputstream from datasource");
        }
        if (inputStream instanceof SharedInputStream) {
            sharedInputStream = (SharedInputStream)((Object)inputStream);
        }
        ContentType contentType = new ContentType(this.contentType);
        String string = "--" + contentType.getParameter("boundary");
        int n2 = string.length();
        byte[] byArray = new byte[n2];
        string.getBytes(0, n2, byArray, 0);
        try {
            String string2;
            LineInputStream lineInputStream = new LineInputStream(inputStream);
            while ((string2 = lineInputStream.readLine()) != null && !string2.trim().equals(string)) {
            }
            if (string2 == null) {
                throw new MessagingException("Missing start boundary");
            }
            boolean bl = false;
            while (!bl) {
                InternetHeaders internetHeaders = null;
                if (sharedInputStream != null) {
                    l2 = sharedInputStream.getPosition();
                    while ((string2 = lineInputStream.readLine()) != null && string2.length() > 0) {
                    }
                    if (string2 == null) {
                        throw new MessagingException("EOF skipping headers");
                    }
                } else {
                    internetHeaders = this.createInternetHeaders(inputStream);
                }
                if (!inputStream.markSupported()) {
                    throw new MessagingException("Stream doesn't support mark");
                }
                ByteArrayOutputStream byteArrayOutputStream = null;
                if (sharedInputStream == null) {
                    byteArrayOutputStream = new ByteArrayOutputStream();
                }
                boolean bl2 = true;
                int n3 = -1;
                int n4 = -1;
                block7: while (true) {
                    int n5;
                    if (bl2) {
                        inputStream.mark(n2 + 4 + 1000);
                        int n6 = 0;
                        while (n6 < n2 && inputStream.read() == byArray[n6]) {
                            ++n6;
                        }
                        if (n6 == n2) {
                            int n7 = inputStream.read();
                            if (n7 == 45 && inputStream.read() == 45) {
                                bl = true;
                                break;
                            }
                            while (true) {
                                if (n7 != 32 && n7 != 9) {
                                    if (n7 == 10) break block7;
                                    if (n7 != 13) break;
                                    inputStream.mark(1);
                                    if (inputStream.read() == 10) break block7;
                                    inputStream.reset();
                                    break block7;
                                }
                                n7 = inputStream.read();
                            }
                        }
                        inputStream.reset();
                        if (byteArrayOutputStream != null && n3 != -1) {
                            byteArrayOutputStream.write(n3);
                            if (n4 != -1) {
                                byteArrayOutputStream.write(n4);
                            }
                            n4 = -1;
                            n3 = -1;
                        }
                    }
                    if ((n5 = inputStream.read()) < 0) {
                        bl = true;
                        break;
                    }
                    if (n5 == 13 || n5 == 10) {
                        bl2 = true;
                        if (sharedInputStream != null) {
                            l3 = sharedInputStream.getPosition() - 1L;
                        }
                        n3 = n5;
                        if (n5 != 13) continue;
                        inputStream.mark(1);
                        n5 = inputStream.read();
                        if (n5 == 10) {
                            n4 = n5;
                            continue;
                        }
                        inputStream.reset();
                        continue;
                    }
                    bl2 = false;
                    if (byteArrayOutputStream == null) continue;
                    byteArrayOutputStream.write(n5);
                }
                MimeBodyPart mimeBodyPart = sharedInputStream != null ? this.createMimeBodyPart(sharedInputStream.newStream(l2, l3)) : this.createMimeBodyPart(internetHeaders, byteArrayOutputStream.toByteArray());
                this.addBodyPart(mimeBodyPart);
            }
        }
        catch (IOException iOException) {
            throw new MessagingException("IO Error", iOException);
        }
        this.parsed = true;
    }

    protected InternetHeaders createInternetHeaders(InputStream inputStream) throws MessagingException {
        return new InternetHeaders(inputStream);
    }

    protected MimeBodyPart createMimeBodyPart(InternetHeaders internetHeaders, byte[] byArray) throws MessagingException {
        return new MimeBodyPart(internetHeaders, byArray);
    }

    protected MimeBodyPart createMimeBodyPart(InputStream inputStream) throws MessagingException {
        return new MimeBodyPart(inputStream);
    }
}

