/*
 * Decompiled with CFR 0.152.
 */
package javax.mail.internet;

import java.io.UnsupportedEncodingException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.mail.Address;
import javax.mail.Session;
import javax.mail.internet.AddressException;
import javax.mail.internet.MimeUtility;

public class InternetAddress
extends Address
implements Cloneable {
    protected String address;
    protected String personal;
    protected String encodedPersonal;
    private static final String rfc822phrase = "()<>@,;:\\\"\t .[]".replace(' ', '\u0000').replace('\t', '\u0000');
    private static final String specialsNoDotNoAt = "()<>,;:\\\"[]";
    private static final String specialsNoDot = "()<>,;:\\\"[]@";

    public InternetAddress() {
    }

    public InternetAddress(String string) throws AddressException {
        InternetAddress[] internetAddressArray = InternetAddress.parse(string, true);
        if (internetAddressArray.length != 1) {
            throw new AddressException("Illegal address", string);
        }
        this.address = internetAddressArray[0].address;
        this.personal = internetAddressArray[0].personal;
        this.encodedPersonal = internetAddressArray[0].encodedPersonal;
    }

    private InternetAddress(String string, boolean bl) throws AddressException {
        this(string);
        if (bl) {
            InternetAddress.checkAddress(this.address, true, true);
        }
    }

    public InternetAddress(String string, String string2) throws UnsupportedEncodingException {
        this(string, string2, null);
    }

    public InternetAddress(String string, String string2, String string3) throws UnsupportedEncodingException {
        this.address = string;
        this.setPersonal(string2, string3);
    }

    public Object clone() {
        InternetAddress internetAddress = null;
        try {
            internetAddress = (InternetAddress)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {}
        return internetAddress;
    }

    public String getType() {
        return "rfc822";
    }

    public void setAddress(String string) {
        this.address = string;
    }

    public void setPersonal(String string, String string2) throws UnsupportedEncodingException {
        this.personal = string;
        if (string != null) {
            this.encodedPersonal = MimeUtility.encodeWord(string, string2, null);
            return;
        }
        this.encodedPersonal = null;
    }

    public void setPersonal(String string) throws UnsupportedEncodingException {
        this.personal = string;
        if (string != null) {
            this.encodedPersonal = MimeUtility.encodeWord(string);
            return;
        }
        this.encodedPersonal = null;
    }

    public String getAddress() {
        return this.address;
    }

    public String getPersonal() {
        if (this.personal != null) {
            return this.personal;
        }
        if (this.encodedPersonal != null) {
            try {
                this.personal = MimeUtility.decodeText(this.encodedPersonal);
                return this.personal;
            }
            catch (Exception exception) {
                return this.encodedPersonal;
            }
        }
        return null;
    }

    public String toString() {
        if (this.encodedPersonal == null && this.personal != null) {
            try {
                this.encodedPersonal = MimeUtility.encodeWord(this.personal);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {}
        }
        if (this.encodedPersonal != null) {
            return String.valueOf(InternetAddress.quotePhrase(this.encodedPersonal)) + " <" + this.address + ">";
        }
        if (this.isGroup() || this.isSimple()) {
            return this.address;
        }
        return "<" + this.address + ">";
    }

    public String toUnicodeString() {
        if (this.getPersonal() != null) {
            return String.valueOf(InternetAddress.quotePhrase(this.personal)) + " <" + this.address + ">";
        }
        if (this.isGroup() || this.isSimple()) {
            return this.address;
        }
        return "<" + this.address + ">";
    }

    private static String quotePhrase(String string) {
        int n2 = string.length();
        boolean bl = false;
        int n3 = 0;
        while (n3 < n2) {
            char c2 = string.charAt(n3);
            if (c2 == '\"' || c2 == '\\') {
                StringBuffer stringBuffer = new StringBuffer(n2 + 3);
                stringBuffer.append('\"');
                int n4 = 0;
                while (n4 < n2) {
                    char c3 = string.charAt(n4);
                    if (c3 == '\"' || c3 == '\\') {
                        stringBuffer.append('\\');
                    }
                    stringBuffer.append(c3);
                    ++n4;
                }
                stringBuffer.append('\"');
                return stringBuffer.toString();
            }
            if (c2 < ' ' && c2 != '\r' && c2 != '\n' && c2 != '\t' || c2 >= '\u007f' || rfc822phrase.indexOf(c2) >= 0) {
                bl = true;
            }
            ++n3;
        }
        if (bl) {
            StringBuffer stringBuffer = new StringBuffer(n2 + 2);
            stringBuffer.append('\"').append(string).append('\"');
            return stringBuffer.toString();
        }
        return string;
    }

    private static String unquote(String string) {
        if (string.startsWith("\"") && string.endsWith("\"") && (string = string.substring(1, string.length() - 1)).indexOf(92) >= 0) {
            StringBuffer stringBuffer = new StringBuffer(string.length());
            int n2 = 0;
            while (n2 < string.length()) {
                char c2 = string.charAt(n2);
                if (c2 == '\\' && n2 < string.length() - 1) {
                    c2 = string.charAt(++n2);
                }
                stringBuffer.append(c2);
                ++n2;
            }
            string = stringBuffer.toString();
        }
        return string;
    }

    public boolean equals(Object object) {
        if (!(object instanceof InternetAddress)) {
            return false;
        }
        String string = ((InternetAddress)object).getAddress();
        if (string == this.address) {
            return true;
        }
        return this.address != null && this.address.equalsIgnoreCase(string);
    }

    public int hashCode() {
        if (this.address == null) {
            return 0;
        }
        return this.address.toLowerCase().hashCode();
    }

    public static String toString(Address[] addressArray) {
        return InternetAddress.toString(addressArray, 0);
    }

    public static String toString(Address[] addressArray, int n2) {
        if (addressArray == null || addressArray.length == 0) {
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer();
        int n3 = 0;
        while (n3 < addressArray.length) {
            String string;
            int n4;
            if (n3 != 0) {
                stringBuffer.append(", ");
                n2 += 2;
            }
            if (n2 + (n4 = InternetAddress.lengthOfFirstSegment(string = addressArray[n3].toString())) > 76) {
                stringBuffer.append("\r\n\t");
                n2 = 8;
            }
            stringBuffer.append(string);
            n2 = InternetAddress.lengthOfLastSegment(string, n2);
            ++n3;
        }
        return stringBuffer.toString();
    }

    private static int lengthOfFirstSegment(String string) {
        int n2 = string.indexOf("\r\n");
        if (n2 != -1) {
            return n2;
        }
        return string.length();
    }

    private static int lengthOfLastSegment(String string, int n2) {
        int n3 = string.lastIndexOf("\r\n");
        if (n3 != -1) {
            return string.length() - n3 - 2;
        }
        return string.length() + n2;
    }

    public static InternetAddress getLocalAddress(Session session) {
        String string = null;
        String string2 = null;
        String string3 = null;
        try {
            if (session == null) {
                string = System.getProperty("user.name");
                string2 = InetAddress.getLocalHost().getHostName();
            } else {
                string3 = session.getProperty("mail.from");
                if (string3 == null) {
                    InetAddress inetAddress;
                    string = session.getProperty("mail.user");
                    if (string == null || string.length() == 0) {
                        string = session.getProperty("user.name");
                    }
                    if (string == null || string.length() == 0) {
                        string = System.getProperty("user.name");
                    }
                    if (((string2 = session.getProperty("mail.host")) == null || string2.length() == 0) && (inetAddress = InetAddress.getLocalHost()) != null) {
                        string2 = inetAddress.getHostName();
                    }
                }
            }
            if (string3 == null && string != null && string.length() != 0 && string2 != null && string2.length() != 0) {
                string3 = String.valueOf(string) + "@" + string2;
            }
            if (string3 != null) {
                return new InternetAddress(string3);
            }
        }
        catch (SecurityException securityException) {
        }
        catch (AddressException addressException) {
        }
        catch (UnknownHostException unknownHostException) {}
        return null;
    }

    public static InternetAddress[] parse(String string) throws AddressException {
        return InternetAddress.parse(string, true);
    }

    /*
     * Unable to fully structure code
     */
    public static InternetAddress[] parse(String var0, boolean var1_1) throws AddressException {
        var6_2 = -1;
        var7_3 = -1;
        var8_4 = var0.length();
        var9_5 = false;
        var10_6 = false;
        var11_7 = false;
        var13_8 = new Vector<InternetAddress>();
        var3_9 = -1;
        var2_10 = -1;
        var4_11 = 0;
        while (var4_11 < var8_4) {
            var12_13 = var0.charAt(var4_11);
            switch (var12_13) {
                case '(': {
                    var11_7 = true;
                    if (var2_10 >= 0 && var3_9 == -1) {
                        var3_9 = var4_11;
                    }
                    if (var6_2 == -1) {
                        var6_2 = var4_11 + 1;
                    }
                    ++var4_11;
                    var5_12 = 1;
                    while (var4_11 < var8_4 && var5_12 > 0) {
                        var12_13 = var0.charAt(var4_11);
                        switch (var12_13) {
                            case '\\': {
                                ++var4_11;
                                break;
                            }
                            case '(': {
                                ++var5_12;
                                break;
                            }
                            case ')': {
                                --var5_12;
                                break;
                            }
                        }
                        ++var4_11;
                    }
                    if (var5_12 > 0) {
                        throw new AddressException("Missing ')'", var0, var4_11);
                    }
                    --var4_11;
                    if (var7_3 != -1) break;
                    var7_3 = var4_11;
                    break;
                }
                case ')': {
                    throw new AddressException("Missing '('", var0, var4_11);
                }
                case '<': {
                    var11_7 = true;
                    if (var10_6) {
                        throw new AddressException("Extra route-addr", var0, var4_11);
                    }
                    if (!var9_5) {
                        var6_2 = var2_10;
                        if (var6_2 >= 0) {
                            var7_3 = var4_11;
                        }
                        var2_10 = var4_11 + 1;
                    }
                    var15_15 = false;
                    ++var4_11;
                    block32: while (var4_11 < var8_4) {
                        var12_13 = var0.charAt(var4_11);
                        switch (var12_13) {
                            case '\\': {
                                ++var4_11;
                                ** GOTO lbl66
                            }
                            case '\"': {
                                var15_15 = var15_15 == false;
                                ** GOTO lbl66
                            }
                            case '>': {
                                if (!var15_15) break block32;
                            }
lbl66:
                            // 4 sources

                            default: {
                                ++var4_11;
                            }
                        }
                    }
                    if (var4_11 >= var8_4) {
                        if (var15_15) {
                            throw new AddressException("Missing '\"'", var0, var4_11);
                        }
                        throw new AddressException("Missing '>'", var0, var4_11);
                    }
                    var10_6 = true;
                    var3_9 = var4_11;
                    break;
                }
                case '>': {
                    throw new AddressException("Missing '<'", var0, var4_11);
                }
                case '\"': {
                    var11_7 = true;
                    if (var2_10 == -1) {
                        var2_10 = var4_11;
                    }
                    ++var4_11;
                    block33: while (var4_11 < var8_4) {
                        var12_13 = var0.charAt(var4_11);
                        switch (var12_13) {
                            case '\\': {
                                ++var4_11;
                            }
                            default: {
                                ++var4_11;
                                continue block33;
                            }
                            case '\"': {
                                break block33;
                            }
                        }
                    }
                    if (var4_11 < var8_4) break;
                    throw new AddressException("Missing '\"'", var0, var4_11);
                }
                case '[': {
                    var11_7 = true;
                    ++var4_11;
                    block34: while (var4_11 < var8_4) {
                        var12_13 = var0.charAt(var4_11);
                        switch (var12_13) {
                            case '\\': {
                                ++var4_11;
                            }
                            default: {
                                ++var4_11;
                                continue block34;
                            }
                            case ']': {
                                break block34;
                            }
                        }
                    }
                    if (var4_11 < var8_4) break;
                    throw new AddressException("Missing ']'", var0, var4_11);
                }
                case ',': {
                    if (var2_10 == -1) {
                        var10_6 = false;
                        var11_7 = false;
                        var3_9 = -1;
                        var2_10 = -1;
                        break;
                    }
                    if (var9_5) break;
                    if (var3_9 == -1) {
                        var3_9 = var4_11;
                    }
                    var16_19 = var0.substring(var2_10, var3_9).trim();
                    if (var11_7 || var1_1) {
                        InternetAddress.checkAddress((String)var16_19, var10_6, var1_1);
                        var14_14 = new InternetAddress();
                        var14_14.setAddress((String)var16_19);
                        if (var6_2 >= 0) {
                            var14_14.encodedPersonal = InternetAddress.unquote(var0.substring(var6_2, var7_3).trim());
                            var7_3 = -1;
                            var6_2 = -1;
                        }
                        var13_8.addElement(var14_14);
                    } else {
                        var17_20 = new StringTokenizer((String)var16_19);
                        while (var17_20.hasMoreTokens()) {
                            var18_21 = var17_20.nextToken();
                            InternetAddress.checkAddress(var18_21, false, var1_1);
                            var14_14 = new InternetAddress();
                            var14_14.setAddress(var18_21);
                            var13_8.addElement(var14_14);
                        }
                    }
                    var10_6 = false;
                    var11_7 = false;
                    var3_9 = -1;
                    var2_10 = -1;
                    break;
                }
                case ':': {
                    var11_7 = true;
                    if (var9_5) {
                        throw new AddressException("Nested group", var0, var4_11);
                    }
                    var9_5 = true;
                    break;
                }
                case ';': {
                    if (!var9_5) {
                        throw new AddressException("Illegal semicolon, not in group", var0, var4_11);
                    }
                    var9_5 = false;
                    var14_14 = new InternetAddress();
                    var3_9 = var4_11 + 1;
                    var14_14.setAddress(var0.substring(var2_10, var3_9).trim());
                    var13_8.addElement(var14_14);
                    var10_6 = false;
                    var3_9 = -1;
                    var2_10 = -1;
                    break;
                }
                default: {
                    if (var2_10 != -1) break;
                    var2_10 = var4_11;
                }
                case '\t': 
                case '\n': 
                case '\r': 
                case ' ': 
            }
            ++var4_11;
        }
        if (var2_10 >= 0) {
            if (var3_9 == -1) {
                var3_9 = var4_11;
            }
            var15_16 = var0.substring(var2_10, var3_9).trim();
            if (var11_7 || var1_1) {
                InternetAddress.checkAddress(var15_16, var10_6, var1_1);
                var14_14 = new InternetAddress();
                var14_14.setAddress(var15_16);
                if (var6_2 >= 0) {
                    var14_14.encodedPersonal = InternetAddress.unquote(var0.substring(var6_2, var7_3).trim());
                }
                var13_8.addElement(var14_14);
            } else {
                var16_19 = new StringTokenizer(var15_16);
                while (var16_19.hasMoreTokens()) {
                    var17_20 = var16_19.nextToken();
                    InternetAddress.checkAddress((String)var17_20, false, var1_1);
                    var14_14 = new InternetAddress();
                    var14_14.setAddress((String)var17_20);
                    var13_8.addElement(var14_14);
                }
            }
        }
        var15_18 = new InternetAddress[var13_8.size()];
        var13_8.copyInto(var15_18);
        return var15_18;
    }

    private static void checkAddress(String string, boolean bl, boolean bl2) throws AddressException {
        String string2;
        String string3;
        int n2;
        int n3 = 0;
        if (string.indexOf(34) >= 0) {
            return;
        }
        if (!bl2 || bl) {
            n3 = 0;
            while ((n2 = InternetAddress.indexOfAny(string, ",:", n3)) >= 0) {
                if (string.charAt(n3) != '@') {
                    throw new AddressException("Illegal route-addr", string);
                }
                if (string.charAt(n2) == ':') {
                    n3 = n2 + 1;
                    break;
                }
                n3 = n2 + 1;
            }
        }
        if ((n2 = string.indexOf(64, n3)) >= 0) {
            if (n2 == n3) {
                throw new AddressException("Missing local name", string);
            }
            if (n2 == string.length() - 1) {
                throw new AddressException("Missing domain", string);
            }
            string3 = string.substring(n3, n2);
            string2 = string.substring(n2 + 1);
        } else {
            string3 = string;
            string2 = null;
        }
        if (InternetAddress.indexOfAny(string, " \t\n\r") >= 0) {
            throw new AddressException("Illegal whitespace in address", string);
        }
        if (InternetAddress.indexOfAny(string3, specialsNoDot) >= 0) {
            throw new AddressException("Illegal character in local name", string);
        }
        if (string2 != null && string2.indexOf(91) < 0 && InternetAddress.indexOfAny(string2, specialsNoDot) >= 0) {
            throw new AddressException("Illegal character in domain", string);
        }
    }

    private boolean isSimple() {
        return InternetAddress.indexOfAny(this.address, specialsNoDotNoAt) < 0;
    }

    private boolean isGroup() {
        return this.address.endsWith(";") && this.address.indexOf(58) > 0;
    }

    private static int indexOfAny(String string, String string2) {
        return InternetAddress.indexOfAny(string, string2, 0);
    }

    private static int indexOfAny(String string, String string2, int n2) {
        try {
            int n3 = string.length();
            int n4 = n2;
            while (n4 < n3) {
                if (string2.indexOf(string.charAt(n4)) >= 0) {
                    return n4;
                }
                ++n4;
            }
            return -1;
        }
        catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
            return -1;
        }
    }
}

