/*
 * Decompiled with CFR 0.152.
 */
package firmaelectronica;

import java.io.StringReader;
import javax.swing.JTree;
import javax.swing.UIManager;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Comment;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.xml.sax.InputSource;

public class XMLTree
extends JTree {
    public XMLTree() {
        try {
            this.jbInit();
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
    }

    public XMLTree(String xmlString) {
        super(XMLTree.makeRootNode(xmlString));
    }

    private static void addChildren(DefaultMutableTreeNode parentTreeNode, Node parentXMLElement) {
        NodeList childElements = parentXMLElement.getChildNodes();
        int i2 = 0;
        while (i2 < childElements.getLength()) {
            Node childElement = childElements.item(i2);
            if (!(childElement instanceof Text) && !(childElement instanceof Comment)) {
                DefaultMutableTreeNode childTreeNode = new DefaultMutableTreeNode(XMLTree.treeNodeLabel(childElement));
                parentTreeNode.add(childTreeNode);
                XMLTree.addChildren(childTreeNode, childElement);
            }
            ++i2;
        }
    }

    private static DefaultMutableTreeNode buildTree(Element rootElement) {
        DefaultMutableTreeNode rootTreeNode = new DefaultMutableTreeNode(XMLTree.treeNodeLabel(rootElement));
        XMLTree.addChildren(rootTreeNode, rootElement);
        return rootTreeNode;
    }

    private void jbInit() throws Exception {
        this.setBackground(UIManager.getColor("InternalFrame.inactiveTitleForeground"));
        this.setDebugGraphicsOptions(0);
    }

    private static DefaultMutableTreeNode makeRootNode(String xmlString) {
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            InputSource input = new InputSource(new StringReader(xmlString));
            Document document = builder.parse(input);
            document.getDocumentElement().normalize();
            Element rootElement = document.getDocumentElement();
            DefaultMutableTreeNode rootTreeNode = XMLTree.buildTree(rootElement);
            return rootTreeNode;
        }
        catch (Exception e2) {
            String errorMessage = "Error making root node: " + e2;
            System.err.println(errorMessage);
            e2.printStackTrace();
            return new DefaultMutableTreeNode(errorMessage);
        }
    }

    private static String treeNodeLabel(Node childElement) {
        int i2;
        NamedNodeMap elementAttributes = childElement.getAttributes();
        String treeNodeLabel = childElement.getNodeName();
        if (childElement.hasChildNodes()) {
            NodeList childNodes = childElement.getChildNodes();
            i2 = 0;
            while (i2 < childNodes.getLength()) {
                Node child = childNodes.item(i2);
                if (child.getNodeType() == 3 && child.getNodeValue() != null) {
                    treeNodeLabel = treeNodeLabel + ": [ " + child.getNodeValue() + " ]";
                }
                if (child.getNodeType() == 4) {
                    treeNodeLabel = treeNodeLabel + ": [ " + child.getNodeValue() + " ]";
                }
                ++i2;
            }
        }
        if (elementAttributes != null && elementAttributes.getLength() > 0) {
            treeNodeLabel = treeNodeLabel + " (";
            int numAttributes = elementAttributes.getLength();
            i2 = 0;
            while (i2 < numAttributes) {
                Node attribute = elementAttributes.item(i2);
                if (i2 > 0) {
                    treeNodeLabel = treeNodeLabel + ", ";
                }
                treeNodeLabel = treeNodeLabel + attribute.getNodeName() + "=" + attribute.getNodeValue();
                ++i2;
            }
            treeNodeLabel = treeNodeLabel + ")";
        }
        return treeNodeLabel;
    }
}

