/*
 * Decompiled with CFR 0.152.
 */
package com.sun.mail.imap.protocol;

import com.sun.mail.iap.Argument;
import com.sun.mail.iap.BadCommandException;
import com.sun.mail.iap.CommandFailedException;
import com.sun.mail.iap.ConnectionException;
import com.sun.mail.iap.Literal;
import com.sun.mail.iap.ParsingException;
import com.sun.mail.iap.Protocol;
import com.sun.mail.iap.ProtocolException;
import com.sun.mail.iap.Response;
import com.sun.mail.imap.ACL;
import com.sun.mail.imap.Quota;
import com.sun.mail.imap.Rights;
import com.sun.mail.imap.protocol.BASE64MailboxEncoder;
import com.sun.mail.imap.protocol.BODY;
import com.sun.mail.imap.protocol.BODYSTRUCTURE;
import com.sun.mail.imap.protocol.FetchResponse;
import com.sun.mail.imap.protocol.IMAPResponse;
import com.sun.mail.imap.protocol.INTERNALDATE;
import com.sun.mail.imap.protocol.ListInfo;
import com.sun.mail.imap.protocol.MailboxInfo;
import com.sun.mail.imap.protocol.MessageSet;
import com.sun.mail.imap.protocol.Namespaces;
import com.sun.mail.imap.protocol.RFC822DATA;
import com.sun.mail.imap.protocol.SearchSequence;
import com.sun.mail.imap.protocol.Status;
import com.sun.mail.imap.protocol.UID;
import com.sun.mail.util.ASCIIUtility;
import com.sun.mail.util.BASE64EncoderStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;
import javax.mail.Flags;
import javax.mail.internet.MimeUtility;
import javax.mail.search.SearchException;
import javax.mail.search.SearchTerm;

public class IMAPProtocol
extends Protocol {
    private boolean rev1 = false;
    private boolean authenticated = false;
    private Hashtable capabilities;
    private String[] searchCharsets;
    static /* synthetic */ Class class$com$sun$mail$imap$protocol$BODYSTRUCTURE;
    static /* synthetic */ Class class$com$sun$mail$imap$protocol$BODY;
    static /* synthetic */ Class class$com$sun$mail$imap$protocol$RFC822DATA;
    static /* synthetic */ Class class$javax$mail$Flags;
    static /* synthetic */ Class class$com$sun$mail$imap$protocol$UID;

    public IMAPProtocol(String string, String string2, int n2, boolean bl, Properties properties) throws IOException, ProtocolException {
        super(string2, n2, bl, properties, "mail." + string);
        Response[] responseArray = this.command("CAPABILITY", null);
        if (!responseArray[responseArray.length - 1].isOK()) {
            throw new ProtocolException(responseArray[responseArray.length - 1].toString());
        }
        this.capabilities = new Hashtable(5);
        int n3 = 0;
        int n4 = responseArray.length;
        while (n3 < n4) {
            IMAPResponse iMAPResponse;
            if (responseArray[n3] instanceof IMAPResponse && (iMAPResponse = (IMAPResponse)responseArray[n3]).keyEquals("CAPABILITY")) {
                String string3;
                while ((string3 = iMAPResponse.readAtom()) != null) {
                    if (string3.length() == 0) {
                        iMAPResponse.skipToken();
                        continue;
                    }
                    this.capabilities.put(string3.toLowerCase(), string3);
                }
            }
            ++n3;
        }
        if (this.hasCapability("IMAP4rev1")) {
            this.rev1 = true;
        }
        this.searchCharsets = new String[2];
        this.searchCharsets[0] = "UTF-8";
        this.searchCharsets[1] = MimeUtility.mimeCharset(MimeUtility.getDefaultJavaCharset());
    }

    protected void processGreeting(Response response) throws ProtocolException {
        super.processGreeting(response);
        if (response.isOK()) {
            return;
        }
        IMAPResponse iMAPResponse = (IMAPResponse)response;
        if (iMAPResponse.keyEquals("PREAUTH")) {
            this.authenticated = true;
            return;
        }
        throw new ConnectionException(response);
    }

    public boolean isAuthenticated() {
        return this.authenticated;
    }

    public boolean isREV1() {
        return this.rev1;
    }

    protected boolean supportsNonSyncLiterals() {
        return this.hasCapability("LITERAL+");
    }

    public Response readResponse() throws IOException, ProtocolException {
        return IMAPResponse.readResponse(this);
    }

    public boolean hasCapability(String string) {
        return this.capabilities.containsKey(string.toLowerCase());
    }

    public void disconnect() {
        super.disconnect();
    }

    public void noop() throws ProtocolException {
        this.simpleCommand("NOOP", null);
    }

    public void logout() throws ProtocolException {
        Response[] responseArray = this.command("LOGOUT", null);
        this.notifyResponseHandlers(responseArray);
        this.disconnect();
    }

    public void login(String string, String string2) throws ProtocolException {
        Argument argument = new Argument();
        argument.writeString(string);
        argument.writeString(string2);
        this.simpleCommand("LOGIN", argument);
    }

    public void authlogin(String string, String string2) throws ProtocolException {
        Object object;
        Vector<Response> vector = new Vector<Response>();
        String string3 = null;
        Response response = null;
        boolean bl = false;
        try {
            string3 = this.writeCommand("AUTHENTICATE LOGIN", null);
        }
        catch (Exception exception) {
            response = Response.ByeResponse;
            bl = true;
        }
        OutputStream outputStream = this.getOutputStream();
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        BASE64EncoderStream bASE64EncoderStream = new BASE64EncoderStream(byteArrayOutputStream, Integer.MAX_VALUE);
        byte[] byArray = new byte[]{13, 10};
        boolean bl2 = true;
        while (!bl) {
            try {
                response = this.readResponse();
                if (response.isContinuation()) {
                    if (bl2) {
                        object = string;
                        bl2 = false;
                    } else {
                        object = string2;
                    }
                    ((OutputStream)bASE64EncoderStream).write(ASCIIUtility.getBytes((String)object));
                    ((OutputStream)bASE64EncoderStream).flush();
                    byteArrayOutputStream.write(byArray);
                    outputStream.write(byteArrayOutputStream.toByteArray());
                    outputStream.flush();
                    byteArrayOutputStream.reset();
                    continue;
                }
                if (response.isTagged() && response.getTag().equals(string3)) {
                    bl = true;
                    continue;
                }
                if (response.isBYE()) {
                    bl = true;
                    continue;
                }
                vector.addElement(response);
            }
            catch (Exception exception) {
                response = Response.ByeResponse;
                bl = true;
            }
        }
        object = new Response[vector.size()];
        vector.copyInto((Object[])object);
        this.notifyResponseHandlers((Response[])object);
        this.handleResult(response);
    }

    public MailboxInfo select(String string) throws ProtocolException {
        string = BASE64MailboxEncoder.encode(string);
        Argument argument = new Argument();
        argument.writeString(string);
        Response[] responseArray = this.command("SELECT", argument);
        MailboxInfo mailboxInfo = new MailboxInfo(responseArray);
        this.notifyResponseHandlers(responseArray);
        Response response = responseArray[responseArray.length - 1];
        if (response.isOK()) {
            mailboxInfo.mode = response.toString().indexOf("READ-ONLY") != -1 ? 1 : 2;
        }
        this.handleResult(response);
        return mailboxInfo;
    }

    public MailboxInfo examine(String string) throws ProtocolException {
        string = BASE64MailboxEncoder.encode(string);
        Argument argument = new Argument();
        argument.writeString(string);
        Response[] responseArray = this.command("EXAMINE", argument);
        MailboxInfo mailboxInfo = new MailboxInfo(responseArray);
        mailboxInfo.mode = 1;
        this.notifyResponseHandlers(responseArray);
        this.handleResult(responseArray[responseArray.length - 1]);
        return mailboxInfo;
    }

    public Status status(String string, String[] stringArray) throws ProtocolException {
        if (!this.isREV1() && !this.hasCapability("IMAP4SUNVERSION")) {
            throw new BadCommandException("STATUS not supported");
        }
        string = BASE64MailboxEncoder.encode(string);
        Argument argument = new Argument();
        argument.writeString(string);
        Argument argument2 = new Argument();
        if (stringArray == null) {
            stringArray = Status.standardItems;
        }
        int n2 = 0;
        int n3 = stringArray.length;
        while (n2 < n3) {
            argument2.writeAtom(stringArray[n2]);
            ++n2;
        }
        argument.writeArgument(argument2);
        Response[] responseArray = this.command("STATUS", argument);
        Status status = null;
        Response response = responseArray[responseArray.length - 1];
        if (response.isOK()) {
            int n4 = 0;
            int n5 = responseArray.length;
            while (n4 < n5) {
                IMAPResponse iMAPResponse;
                if (responseArray[n4] instanceof IMAPResponse && (iMAPResponse = (IMAPResponse)responseArray[n4]).keyEquals("STATUS")) {
                    if (status == null) {
                        status = new Status(iMAPResponse);
                    } else {
                        Status.add(status, new Status(iMAPResponse));
                    }
                    responseArray[n4] = null;
                }
                ++n4;
            }
        }
        this.notifyResponseHandlers(responseArray);
        this.handleResult(response);
        return status;
    }

    public void create(String string) throws ProtocolException {
        string = BASE64MailboxEncoder.encode(string);
        Argument argument = new Argument();
        argument.writeString(string);
        this.simpleCommand("CREATE", argument);
    }

    public void delete(String string) throws ProtocolException {
        string = BASE64MailboxEncoder.encode(string);
        Argument argument = new Argument();
        argument.writeString(string);
        this.simpleCommand("DELETE", argument);
    }

    public void rename(String string, String string2) throws ProtocolException {
        string = BASE64MailboxEncoder.encode(string);
        string2 = BASE64MailboxEncoder.encode(string2);
        Argument argument = new Argument();
        argument.writeString(string);
        argument.writeString(string2);
        this.simpleCommand("RENAME", argument);
    }

    public void subscribe(String string) throws ProtocolException {
        Argument argument = new Argument();
        string = BASE64MailboxEncoder.encode(string);
        argument.writeString(string);
        this.simpleCommand("SUBSCRIBE", argument);
    }

    public void unsubscribe(String string) throws ProtocolException {
        Argument argument = new Argument();
        string = BASE64MailboxEncoder.encode(string);
        argument.writeString(string);
        this.simpleCommand("UNSUBSCRIBE", argument);
    }

    public ListInfo[] list(String string, String string2) throws ProtocolException {
        return this.doList("LIST", string, string2);
    }

    public ListInfo[] lsub(String string, String string2) throws ProtocolException {
        return this.doList("LSUB", string, string2);
    }

    private ListInfo[] doList(String string, String string2, String string3) throws ProtocolException {
        string2 = BASE64MailboxEncoder.encode(string2);
        string3 = BASE64MailboxEncoder.encode(string3);
        Argument argument = new Argument();
        argument.writeString(string2);
        argument.writeString(string3);
        Response[] responseArray = this.command(string, argument);
        Object[] objectArray = null;
        Response response = responseArray[responseArray.length - 1];
        if (response.isOK()) {
            Vector<ListInfo> vector = new Vector<ListInfo>(1);
            int n2 = 0;
            int n3 = responseArray.length;
            while (n2 < n3) {
                IMAPResponse iMAPResponse;
                if (responseArray[n2] instanceof IMAPResponse && (iMAPResponse = (IMAPResponse)responseArray[n2]).keyEquals(string)) {
                    vector.addElement(new ListInfo(iMAPResponse));
                    responseArray[n2] = null;
                }
                ++n2;
            }
            if (vector.size() > 0) {
                objectArray = new ListInfo[vector.size()];
                vector.copyInto(objectArray);
            }
        }
        this.notifyResponseHandlers(responseArray);
        this.handleResult(response);
        return objectArray;
    }

    public void append(String string, Flags flags, Date date, Literal literal) throws ProtocolException {
        string = BASE64MailboxEncoder.encode(string);
        Argument argument = new Argument();
        argument.writeString(string);
        if (flags != null) {
            flags.remove(Flags.Flag.RECENT);
        }
        argument.writeAtom(this.createFlagList(flags));
        if (date != null) {
            argument.writeString(INTERNALDATE.format(date));
        }
        argument.writeBytes(literal);
        this.simpleCommand("APPEND", argument);
    }

    public void check() throws ProtocolException {
        this.simpleCommand("CHECK", null);
    }

    public void close() throws ProtocolException {
        this.simpleCommand("CLOSE", null);
    }

    public void expunge() throws ProtocolException {
        this.simpleCommand("EXPUNGE", null);
    }

    public BODYSTRUCTURE fetchBodyStructure(int n2) throws ProtocolException {
        Response[] responseArray = this.fetch(n2, "BODYSTRUCTURE");
        this.notifyResponseHandlers(responseArray);
        Response response = responseArray[responseArray.length - 1];
        if (response.isOK()) {
            return (BODYSTRUCTURE)FetchResponse.getItem(responseArray, n2, class$com$sun$mail$imap$protocol$BODYSTRUCTURE != null ? class$com$sun$mail$imap$protocol$BODYSTRUCTURE : (class$com$sun$mail$imap$protocol$BODYSTRUCTURE = IMAPProtocol.class$("com.sun.mail.imap.protocol.BODYSTRUCTURE")));
        }
        if (response.isNO()) {
            return null;
        }
        this.handleResult(response);
        return null;
    }

    public BODY peekBody(int n2, String string) throws ProtocolException {
        return this.fetchBody(n2, string, true);
    }

    public BODY fetchBody(int n2, String string) throws ProtocolException {
        return this.fetchBody(n2, string, false);
    }

    private BODY fetchBody(int n2, String string, boolean bl) throws ProtocolException {
        Response[] responseArray = bl ? this.fetch(n2, "BODY.PEEK[" + (string == null ? "]" : String.valueOf(string) + "]")) : this.fetch(n2, "BODY[" + (string == null ? "]" : String.valueOf(string) + "]"));
        this.notifyResponseHandlers(responseArray);
        Response response = responseArray[responseArray.length - 1];
        if (response.isOK()) {
            return (BODY)FetchResponse.getItem(responseArray, n2, class$com$sun$mail$imap$protocol$BODY != null ? class$com$sun$mail$imap$protocol$BODY : (class$com$sun$mail$imap$protocol$BODY = IMAPProtocol.class$("com.sun.mail.imap.protocol.BODY")));
        }
        if (response.isNO()) {
            return null;
        }
        this.handleResult(response);
        return null;
    }

    public BODY fetchBody(int n2, String string, int n3, int n4) throws ProtocolException {
        Response[] responseArray = this.fetch(n2, "BODY[" + (string == null ? "]<" : String.valueOf(string) + "]<") + String.valueOf(n3) + "." + String.valueOf(n4) + ">");
        this.notifyResponseHandlers(responseArray);
        Response response = responseArray[responseArray.length - 1];
        if (response.isOK()) {
            return (BODY)FetchResponse.getItem(responseArray, n2, class$com$sun$mail$imap$protocol$BODY != null ? class$com$sun$mail$imap$protocol$BODY : (class$com$sun$mail$imap$protocol$BODY = IMAPProtocol.class$("com.sun.mail.imap.protocol.BODY")));
        }
        if (response.isNO()) {
            return null;
        }
        this.handleResult(response);
        return null;
    }

    public RFC822DATA fetchRFC822(int n2, String string) throws ProtocolException {
        Response[] responseArray = this.fetch(n2, string == null ? "RFC822" : "RFC822." + string);
        this.notifyResponseHandlers(responseArray);
        Response response = responseArray[responseArray.length - 1];
        if (response.isOK()) {
            return (RFC822DATA)FetchResponse.getItem(responseArray, n2, class$com$sun$mail$imap$protocol$RFC822DATA != null ? class$com$sun$mail$imap$protocol$RFC822DATA : (class$com$sun$mail$imap$protocol$RFC822DATA = IMAPProtocol.class$("com.sun.mail.imap.protocol.RFC822DATA")));
        }
        if (response.isNO()) {
            return null;
        }
        this.handleResult(response);
        return null;
    }

    public Flags fetchFlags(int n2) throws ProtocolException {
        Flags flags = null;
        Response[] responseArray = this.fetch(n2, "FLAGS");
        int n3 = 0;
        int n4 = responseArray.length;
        while (n3 < n4) {
            if (responseArray[n3] != null && responseArray[n3] instanceof FetchResponse && ((FetchResponse)responseArray[n3]).getNumber() == n2) {
                FetchResponse fetchResponse = (FetchResponse)responseArray[n3];
                flags = (Flags)((Object)fetchResponse.getItem(class$javax$mail$Flags != null ? class$javax$mail$Flags : IMAPProtocol.class$("javax.mail.Flags")));
                if (flags != null) {
                    responseArray[n3] = null;
                    break;
                }
            }
            ++n3;
        }
        this.notifyResponseHandlers(responseArray);
        return flags;
    }

    public UID fetchUID(int n2) throws ProtocolException {
        Response[] responseArray = this.fetch(n2, "UID");
        this.notifyResponseHandlers(responseArray);
        Response response = responseArray[responseArray.length - 1];
        if (response.isOK()) {
            return (UID)FetchResponse.getItem(responseArray, n2, class$com$sun$mail$imap$protocol$UID != null ? class$com$sun$mail$imap$protocol$UID : (class$com$sun$mail$imap$protocol$UID = IMAPProtocol.class$("com.sun.mail.imap.protocol.UID")));
        }
        if (response.isNO()) {
            return null;
        }
        this.handleResult(response);
        return null;
    }

    public UID fetchSequenceNumber(long l2) throws ProtocolException {
        UID uID = null;
        Response[] responseArray = this.fetch(String.valueOf(l2), "UID", true);
        int n2 = 0;
        int n3 = responseArray.length;
        while (n2 < n3) {
            if (responseArray[n2] != null && responseArray[n2] instanceof FetchResponse) {
                FetchResponse fetchResponse = (FetchResponse)responseArray[n2];
                uID = (UID)fetchResponse.getItem(class$com$sun$mail$imap$protocol$UID != null ? class$com$sun$mail$imap$protocol$UID : IMAPProtocol.class$("com.sun.mail.imap.protocol.UID"));
                if (uID != null) {
                    if (uID.uid == l2) break;
                    uID = null;
                }
            }
            ++n2;
        }
        this.notifyResponseHandlers(responseArray);
        this.handleResult(responseArray[responseArray.length - 1]);
        return uID;
    }

    public UID[] fetchSequenceNumbers(long l2, long l3) throws ProtocolException {
        Object[] objectArray;
        Response[] responseArray = this.fetch(String.valueOf(String.valueOf(l2)) + ":" + (l3 == -1L ? "*" : String.valueOf(l3)), "UID", true);
        Vector<UID> vector = new Vector<UID>();
        int n2 = 0;
        int n3 = responseArray.length;
        while (n2 < n3) {
            if (responseArray[n2] != null && responseArray[n2] instanceof FetchResponse) {
                objectArray = (Object[])responseArray[n2];
                UID uID = (UID)objectArray.getItem(class$com$sun$mail$imap$protocol$UID != null ? class$com$sun$mail$imap$protocol$UID : IMAPProtocol.class$("com.sun.mail.imap.protocol.UID"));
                if (uID != null) {
                    vector.addElement(uID);
                }
            }
            ++n2;
        }
        this.notifyResponseHandlers(responseArray);
        this.handleResult(responseArray[responseArray.length - 1]);
        objectArray = new UID[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    public UID[] fetchSequenceNumbers(long[] lArray) throws ProtocolException {
        Object[] objectArray;
        StringBuffer stringBuffer = new StringBuffer();
        int n2 = 0;
        while (n2 < lArray.length) {
            if (n2 > 0) {
                stringBuffer.append(",");
            }
            stringBuffer.append(String.valueOf(lArray[n2]));
            ++n2;
        }
        Response[] responseArray = this.fetch(stringBuffer.toString(), "UID", true);
        Vector<UID> vector = new Vector<UID>();
        int n3 = 0;
        int n4 = responseArray.length;
        while (n3 < n4) {
            if (responseArray[n3] != null && responseArray[n3] instanceof FetchResponse) {
                objectArray = (Object[])responseArray[n3];
                UID uID = (UID)objectArray.getItem(class$com$sun$mail$imap$protocol$UID != null ? class$com$sun$mail$imap$protocol$UID : IMAPProtocol.class$("com.sun.mail.imap.protocol.UID"));
                if (uID != null) {
                    vector.addElement(uID);
                }
            }
            ++n3;
        }
        this.notifyResponseHandlers(responseArray);
        this.handleResult(responseArray[responseArray.length - 1]);
        objectArray = new UID[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    public Response[] fetch(MessageSet[] messageSetArray, String string) throws ProtocolException {
        return this.fetch(MessageSet.toString(messageSetArray), string, false);
    }

    public Response[] fetch(int n2, int n3, String string) throws ProtocolException {
        return this.fetch(String.valueOf(String.valueOf(n2)) + ":" + String.valueOf(n3), string, false);
    }

    public Response[] fetch(int n2, String string) throws ProtocolException {
        return this.fetch(String.valueOf(n2), string, false);
    }

    private Response[] fetch(String string, String string2, boolean bl) throws ProtocolException {
        if (bl) {
            return this.command("UID FETCH " + string + " (" + string2 + ")", null);
        }
        return this.command("FETCH " + string + " (" + string2 + ")", null);
    }

    public void copy(MessageSet[] messageSetArray, String string) throws ProtocolException {
        this.copy(MessageSet.toString(messageSetArray), string);
    }

    public void copy(int n2, int n3, String string) throws ProtocolException {
        this.copy(String.valueOf(String.valueOf(n2)) + ":" + String.valueOf(n3), string);
    }

    private void copy(String string, String string2) throws ProtocolException {
        string2 = BASE64MailboxEncoder.encode(string2);
        Argument argument = new Argument();
        argument.writeAtom(string);
        argument.writeString(string2);
        this.simpleCommand("COPY", argument);
    }

    public void storeFlags(MessageSet[] messageSetArray, Flags flags, boolean bl) throws ProtocolException {
        this.storeFlags(MessageSet.toString(messageSetArray), flags, bl);
    }

    public void storeFlags(int n2, int n3, Flags flags, boolean bl) throws ProtocolException {
        this.storeFlags(String.valueOf(String.valueOf(n2)) + ":" + String.valueOf(n3), flags, bl);
    }

    public void storeFlags(int n2, Flags flags, boolean bl) throws ProtocolException {
        this.storeFlags(String.valueOf(n2), flags, bl);
    }

    private void storeFlags(String string, Flags flags, boolean bl) throws ProtocolException {
        Response[] responseArray = bl ? this.command("STORE " + string + " +FLAGS " + this.createFlagList(flags), null) : this.command("STORE " + string + " -FLAGS " + this.createFlagList(flags), null);
        this.notifyResponseHandlers(responseArray);
    }

    private String createFlagList(Flags flags) {
        Object object;
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("(");
        Flags.Flag[] flagArray = flags.getSystemFlags();
        boolean bl = true;
        int n2 = 0;
        while (n2 < flagArray.length) {
            block15: {
                block10: {
                    Flags.Flag flag;
                    block14: {
                        block13: {
                            block12: {
                                block11: {
                                    block9: {
                                        flag = flagArray[n2];
                                        if (flag != Flags.Flag.ANSWERED) break block9;
                                        object = "\\Answered";
                                        break block10;
                                    }
                                    if (flag != Flags.Flag.DELETED) break block11;
                                    object = "\\Deleted";
                                    break block10;
                                }
                                if (flag != Flags.Flag.DRAFT) break block12;
                                object = "\\Draft";
                                break block10;
                            }
                            if (flag != Flags.Flag.FLAGGED) break block13;
                            object = "\\Flagged";
                            break block10;
                        }
                        if (flag != Flags.Flag.RECENT) break block14;
                        object = "\\Recent";
                        break block10;
                    }
                    if (flag != Flags.Flag.SEEN) break block15;
                    object = "\\Seen";
                }
                if (bl) {
                    bl = false;
                } else {
                    stringBuffer.append(' ');
                }
                stringBuffer.append((String)object);
            }
            ++n2;
        }
        object = flags.getUserFlags();
        int n3 = 0;
        while (n3 < ((String[])object).length) {
            if (bl) {
                bl = false;
            } else {
                stringBuffer.append(' ');
            }
            stringBuffer.append(object[n3]);
            ++n3;
        }
        stringBuffer.append(")");
        return stringBuffer.toString();
    }

    public int[] search(MessageSet[] messageSetArray, SearchTerm searchTerm) throws ProtocolException, SearchException {
        return this.search(MessageSet.toString(messageSetArray), searchTerm);
    }

    public int[] search(SearchTerm searchTerm) throws ProtocolException, SearchException {
        return this.search("ALL", searchTerm);
    }

    private int[] search(String string, SearchTerm searchTerm) throws ProtocolException, SearchException {
        if (SearchSequence.isAscii(searchTerm)) {
            try {
                return this.issueSearch(string, searchTerm, null);
            }
            catch (IOException iOException) {}
        }
        int n2 = 0;
        while (n2 < this.searchCharsets.length) {
            if (this.searchCharsets[n2] != null) {
                try {
                    return this.issueSearch(string, searchTerm, this.searchCharsets[n2]);
                }
                catch (CommandFailedException commandFailedException) {
                    this.searchCharsets[n2] = null;
                }
                catch (IOException iOException) {
                }
                catch (ProtocolException protocolException) {
                    throw protocolException;
                }
                catch (SearchException searchException) {
                    throw searchException;
                }
            }
            ++n2;
        }
        throw new SearchException("Search failed");
    }

    private int[] issueSearch(String string, SearchTerm searchTerm, String string2) throws ProtocolException, SearchException, IOException {
        Argument argument = SearchSequence.generateSequence(searchTerm, string2 == null ? null : MimeUtility.javaCharset(string2));
        argument.writeAtom(string);
        Response[] responseArray = string2 == null ? this.command("SEARCH", argument) : this.command("SEARCH CHARSET " + string2, argument);
        Response response = responseArray[responseArray.length - 1];
        int[] nArray = null;
        if (response.isOK()) {
            Vector<Integer> vector = new Vector<Integer>();
            int n2 = 0;
            int n3 = responseArray.length;
            while (n2 < n3) {
                IMAPResponse iMAPResponse;
                if (responseArray[n2] instanceof IMAPResponse && (iMAPResponse = (IMAPResponse)responseArray[n2]).keyEquals("SEARCH")) {
                    int n4;
                    while ((n4 = iMAPResponse.readNumber()) != -1) {
                        vector.addElement(new Integer(n4));
                    }
                    responseArray[n2] = null;
                }
                ++n2;
            }
            int n5 = vector.size();
            nArray = new int[n5];
            int n6 = 0;
            while (n6 < n5) {
                nArray[n6] = (Integer)vector.elementAt(n6);
                ++n6;
            }
        }
        this.notifyResponseHandlers(responseArray);
        this.handleResult(response);
        return nArray;
    }

    public Namespaces namespace() throws ProtocolException {
        if (!this.hasCapability("NAMESPACE")) {
            throw new BadCommandException("NAMESPACE not supported");
        }
        Response[] responseArray = this.command("NAMESPACE", null);
        Namespaces namespaces = null;
        Response response = responseArray[responseArray.length - 1];
        if (response.isOK()) {
            int n2 = 0;
            int n3 = responseArray.length;
            while (n2 < n3) {
                IMAPResponse iMAPResponse;
                if (responseArray[n2] instanceof IMAPResponse && (iMAPResponse = (IMAPResponse)responseArray[n2]).keyEquals("NAMESPACE")) {
                    if (namespaces == null) {
                        namespaces = new Namespaces(iMAPResponse);
                    }
                    responseArray[n2] = null;
                }
                ++n2;
            }
        }
        this.notifyResponseHandlers(responseArray);
        this.handleResult(response);
        return namespaces;
    }

    public Quota[] getQuotaRoot(String string) throws ProtocolException {
        if (!this.hasCapability("QUOTA")) {
            throw new BadCommandException("GETQUOTAROOT not supported");
        }
        string = BASE64MailboxEncoder.encode(string);
        Argument argument = new Argument();
        argument.writeString(string);
        Response[] responseArray = this.command("GETQUOTAROOT", argument);
        Response response = responseArray[responseArray.length - 1];
        Hashtable<Object, Object> hashtable = new Hashtable<Object, Object>();
        if (response.isOK()) {
            int n2 = 0;
            int n3 = responseArray.length;
            while (n2 < n3) {
                if (responseArray[n2] instanceof IMAPResponse) {
                    Object object;
                    IMAPResponse iMAPResponse = (IMAPResponse)responseArray[n2];
                    if (iMAPResponse.keyEquals("QUOTAROOT")) {
                        iMAPResponse.readAtomString();
                        object = null;
                        while ((object = iMAPResponse.readAtom()) != null) {
                            hashtable.put(object, new Quota((String)object));
                        }
                        responseArray[n2] = null;
                    } else if (iMAPResponse.keyEquals("QUOTA")) {
                        object = this.parseQuota(iMAPResponse);
                        Quota quota = (Quota)hashtable.get(((Quota)object).quotaRoot);
                        boolean bl = quota != null && quota.resources != null;
                        hashtable.put(((Quota)object).quotaRoot, object);
                        responseArray[n2] = null;
                    }
                }
                ++n2;
            }
        }
        this.notifyResponseHandlers(responseArray);
        this.handleResult(response);
        Quota[] quotaArray = new Quota[hashtable.size()];
        Enumeration enumeration = hashtable.elements();
        int n4 = 0;
        while (enumeration.hasMoreElements()) {
            quotaArray[n4] = (Quota)enumeration.nextElement();
            ++n4;
        }
        return quotaArray;
    }

    public Quota[] getQuota(String string) throws ProtocolException {
        if (!this.hasCapability("QUOTA")) {
            throw new BadCommandException("QUOTA not supported");
        }
        Argument argument = new Argument();
        argument.writeString(string);
        Response[] responseArray = this.command("GETQUOTA", argument);
        Quota quota = null;
        Vector<Quota> vector = new Vector<Quota>();
        Response response = responseArray[responseArray.length - 1];
        if (response.isOK()) {
            int n2 = 0;
            int n3 = responseArray.length;
            while (n2 < n3) {
                IMAPResponse iMAPResponse;
                if (responseArray[n2] instanceof IMAPResponse && (iMAPResponse = (IMAPResponse)responseArray[n2]).keyEquals("QUOTA")) {
                    quota = this.parseQuota(iMAPResponse);
                    vector.addElement(quota);
                    responseArray[n2] = null;
                }
                ++n2;
            }
        }
        this.notifyResponseHandlers(responseArray);
        this.handleResult(response);
        Object[] objectArray = new Quota[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    public void setQuota(Quota quota) throws ProtocolException {
        if (!this.hasCapability("QUOTA")) {
            throw new BadCommandException("QUOTA not supported");
        }
        Argument argument = new Argument();
        argument.writeString(quota.quotaRoot);
        Argument argument2 = new Argument();
        int n2 = 0;
        while (n2 < quota.resources.length) {
            argument2.writeAtom(quota.resources[n2].name);
            argument2.writeNumber(quota.resources[n2].limit);
            ++n2;
        }
        argument.writeArgument(argument2);
        Response[] responseArray = this.command("SETQUOTA", argument);
        Response response = responseArray[responseArray.length - 1];
        this.notifyResponseHandlers(responseArray);
        this.handleResult(response);
    }

    private Quota parseQuota(Response response) throws ParsingException {
        String string = response.readAtomString();
        Quota quota = new Quota(string);
        response.skipSpaces();
        if (response.readByte() != 40) {
            throw new ParsingException("parse error in QUOTA");
        }
        Vector<Quota.Resource> vector = new Vector<Quota.Resource>();
        while (response.peekByte() != 41) {
            String string2 = response.readAtom();
            if (string2 == null) continue;
            long l2 = response.readLong();
            long l3 = response.readLong();
            Quota.Resource resource = new Quota.Resource(string2, l2, l3);
            vector.addElement(resource);
        }
        response.readByte();
        quota.resources = new Quota.Resource[vector.size()];
        vector.copyInto(quota.resources);
        return quota;
    }

    public void setACL(String string, char c2, ACL aCL) throws ProtocolException {
        if (!this.hasCapability("ACL")) {
            throw new BadCommandException("ACL not supported");
        }
        string = BASE64MailboxEncoder.encode(string);
        Argument argument = new Argument();
        argument.writeString(string);
        argument.writeString(aCL.getName());
        String string2 = aCL.getRights().toString();
        if (c2 == '+' || c2 == '-') {
            string2 = String.valueOf(c2) + string2;
        }
        argument.writeString(string2);
        Response[] responseArray = this.command("SETACL", argument);
        Response response = responseArray[responseArray.length - 1];
        this.notifyResponseHandlers(responseArray);
        this.handleResult(response);
    }

    public void deleteACL(String string, String string2) throws ProtocolException {
        if (!this.hasCapability("ACL")) {
            throw new BadCommandException("ACL not supported");
        }
        string = BASE64MailboxEncoder.encode(string);
        Argument argument = new Argument();
        argument.writeString(string);
        argument.writeString(string2);
        Response[] responseArray = this.command("DELETEACL", argument);
        Response response = responseArray[responseArray.length - 1];
        this.notifyResponseHandlers(responseArray);
        this.handleResult(response);
    }

    public ACL[] getACL(String string) throws ProtocolException {
        if (!this.hasCapability("ACL")) {
            throw new BadCommandException("ACL not supported");
        }
        string = BASE64MailboxEncoder.encode(string);
        Argument argument = new Argument();
        argument.writeString(string);
        Response[] responseArray = this.command("GETACL", argument);
        Response response = responseArray[responseArray.length - 1];
        Vector<ACL> vector = new Vector<ACL>();
        if (response.isOK()) {
            int n2 = 0;
            int n3 = responseArray.length;
            while (n2 < n3) {
                IMAPResponse iMAPResponse;
                if (responseArray[n2] instanceof IMAPResponse && (iMAPResponse = (IMAPResponse)responseArray[n2]).keyEquals("ACL")) {
                    iMAPResponse.readAtomString();
                    String string2 = null;
                    while ((string2 = iMAPResponse.readAtom()) != null) {
                        String string3 = iMAPResponse.readAtomString();
                        if (string3 == null) break;
                        ACL aCL = new ACL(string2, new Rights(string3));
                        vector.addElement(aCL);
                    }
                    responseArray[n2] = null;
                }
                ++n2;
            }
        }
        this.notifyResponseHandlers(responseArray);
        this.handleResult(response);
        Object[] objectArray = new ACL[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    public Rights[] listRights(String string, String string2) throws ProtocolException {
        if (!this.hasCapability("ACL")) {
            throw new BadCommandException("ACL not supported");
        }
        string = BASE64MailboxEncoder.encode(string);
        Argument argument = new Argument();
        argument.writeString(string);
        argument.writeString(string2);
        Response[] responseArray = this.command("LISTRIGHTS", argument);
        Response response = responseArray[responseArray.length - 1];
        Vector<Rights> vector = new Vector<Rights>();
        if (response.isOK()) {
            int n2 = 0;
            int n3 = responseArray.length;
            while (n2 < n3) {
                IMAPResponse iMAPResponse;
                if (responseArray[n2] instanceof IMAPResponse && (iMAPResponse = (IMAPResponse)responseArray[n2]).keyEquals("LISTRIGHTS")) {
                    String string3;
                    iMAPResponse.readAtomString();
                    iMAPResponse.readAtomString();
                    while ((string3 = iMAPResponse.readAtomString()) != null) {
                        vector.addElement(new Rights(string3));
                    }
                    responseArray[n2] = null;
                }
                ++n2;
            }
        }
        this.notifyResponseHandlers(responseArray);
        this.handleResult(response);
        Object[] objectArray = new Rights[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    public Rights myRights(String string) throws ProtocolException {
        if (!this.hasCapability("ACL")) {
            throw new BadCommandException("ACL not supported");
        }
        string = BASE64MailboxEncoder.encode(string);
        Argument argument = new Argument();
        argument.writeString(string);
        Response[] responseArray = this.command("MYRIGHTS", argument);
        Response response = responseArray[responseArray.length - 1];
        Rights rights = null;
        if (response.isOK()) {
            int n2 = 0;
            int n3 = responseArray.length;
            while (n2 < n3) {
                IMAPResponse iMAPResponse;
                if (responseArray[n2] instanceof IMAPResponse && (iMAPResponse = (IMAPResponse)responseArray[n2]).keyEquals("MYRIGHTS")) {
                    iMAPResponse.readAtomString();
                    String string2 = iMAPResponse.readAtomString();
                    if (rights == null) {
                        rights = new Rights(string2);
                    }
                    responseArray[n2] = null;
                }
                ++n2;
            }
        }
        this.notifyResponseHandlers(responseArray);
        this.handleResult(response);
        return rights;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

