/*
 * Decompiled with CFR 0.152.
 */
package com.sun.mail.imap;

import java.io.IOException;
import java.io.OutputStream;

class LengthCounter
extends OutputStream {
    private int size;
    private byte[] buf = new byte[8192];
    private int maxsize;

    public LengthCounter(int n2) {
        this.maxsize = n2;
    }

    public void write(int n2) {
        int n3 = this.size + 1;
        if (this.buf != null) {
            if (n3 > this.maxsize && this.maxsize >= 0) {
                this.buf = null;
            } else if (n3 > this.buf.length) {
                byte[] byArray = new byte[Math.max(this.buf.length << 1, n3)];
                System.arraycopy(this.buf, 0, byArray, 0, this.size);
                this.buf = byArray;
                this.buf[this.size] = (byte)n2;
            } else {
                this.buf[this.size] = (byte)n2;
            }
        }
        this.size = n3;
    }

    public void write(byte[] byArray, int n2, int n3) {
        if (n2 < 0 || n2 > byArray.length || n3 < 0 || n2 + n3 > byArray.length || n2 + n3 < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (n3 == 0) {
            return;
        }
        int n4 = this.size + n3;
        if (this.buf != null) {
            if (n4 > this.maxsize && this.maxsize >= 0) {
                this.buf = null;
            } else if (n4 > this.buf.length) {
                byte[] byArray2 = new byte[Math.max(this.buf.length << 1, n4)];
                System.arraycopy(this.buf, 0, byArray2, 0, this.size);
                this.buf = byArray2;
                System.arraycopy(byArray, n2, this.buf, this.size, n3);
            } else {
                System.arraycopy(byArray, n2, this.buf, this.size, n3);
            }
        }
        this.size = n4;
    }

    public void write(byte[] byArray) throws IOException {
        this.write(byArray, 0, byArray.length);
    }

    public int getSize() {
        return this.size;
    }

    public byte[] getBytes() {
        return this.buf;
    }
}

