/*
 * Decompiled with CFR 0.152.
 */
package com.borland.jbcl.view;

import com.borland.jb.util.EventMulticaster;
import com.borland.jbcl.model.ItemPaintSite;
import com.borland.jbcl.model.ItemPainter;
import com.borland.jbcl.model.SingleVectorSelection;
import com.borland.jbcl.model.VectorModel;
import com.borland.jbcl.model.VectorModelEvent;
import com.borland.jbcl.model.VectorModelListener;
import com.borland.jbcl.model.VectorModelMulticaster;
import com.borland.jbcl.model.VectorSelectionEvent;
import com.borland.jbcl.model.VectorSelectionListener;
import com.borland.jbcl.model.VectorSelectionMulticaster;
import com.borland.jbcl.model.VectorSubfocusEvent;
import com.borland.jbcl.model.VectorSubfocusListener;
import com.borland.jbcl.model.VectorViewManager;
import com.borland.jbcl.model.WritableVectorModel;
import com.borland.jbcl.model.WritableVectorSelection;
import com.borland.jbcl.util.ImageTexture;
import com.borland.jbcl.view.BeanPanel;
import com.borland.jbcl.view.FocusableItemPainter;
import com.borland.jbcl.view.TabInfo;
import com.borland.jbcl.view.TextItemPainter;
import com.borland.jbcl.view.VectorView;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.SystemColor;
import java.awt.event.FocusEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Hashtable;
import java.util.Vector;

public class TabsetView
extends BeanPanel
implements ItemPaintSite,
VectorModelListener,
VectorSelectionListener,
VectorView,
Serializable {
    private static final long serialVersionUID = 200L;
    static final int SEL_HEIGHT_INCREASE = 2;
    static final int SLOPE = 1;
    static final int EDGE = 2;
    static final int LINE = 2;
    static final int SCROLLER_WIDTH = 28;
    static final int SCROLLER_HEIGHT = 14;
    protected transient VectorModel model;
    protected transient WritableVectorModel writeModel;
    protected transient VectorViewManager viewManager;
    protected transient WritableVectorSelection selection = new SingleVectorSelection();
    protected transient ItemPainter defaultPainter;
    private int alignment = 34;
    private boolean clientBordered = false;
    private Insets itemMargins = new Insets(1, 4, 1, 4);
    private boolean readOnly = false;
    private boolean tabsOnTop = true;
    private boolean showRollover = false;
    private int rollover = -1;
    boolean thickBorder = true;
    int border = 2;
    private int tabBarTop;
    protected int tabBarWidth;
    protected int tabBarHeight;
    private int oldIndex = -1;
    int firstVisible = 0;
    int lastVisible = -1;
    int xOffset = 0;
    Rectangle leftArrowRect = new Rectangle();
    Rectangle rightArrowRect = new Rectangle();
    boolean needScroller = false;
    boolean lastClipped = false;
    transient EventMulticaster subfocusListeners = new EventMulticaster();
    private transient VectorModelMulticaster modelMulticaster = new VectorModelMulticaster();
    private transient VectorSelectionMulticaster selectionMulticaster = new VectorSelectionMulticaster();
    Vector tabInfo = new Vector();

    public TabsetView() {
        super(null);
        this.setBackground(SystemColor.control);
        this.selection.addSelectionListener(this);
        this.selection.addSelectionListener(this.selectionMulticaster);
        TextItemPainter textPainter = new TextItemPainter(33, new Insets(1, 1, 1, 1));
        this.defaultPainter = new FocusableItemPainter(textPainter);
    }

    public void setLabels(String[] labels) {
        if (this.isReadOnly()) {
            return;
        }
        if (labels != null) {
            this.writeModel.enableModelEvents(false);
            this.writeModel.removeAll();
            for (int i2 = 0; i2 < labels.length; ++i2) {
                this.writeModel.addItem(labels[i2]);
            }
            this.writeModel.enableModelEvents(true);
        } else {
            this.writeModel.removeAll();
        }
    }

    public String[] getLabels() {
        String[] labels = new String[this.model.getCount()];
        for (int i2 = 0; i2 < this.model.getCount(); ++i2) {
            labels[i2] = this.model.get(i2).toString();
        }
        return labels;
    }

    public void setLabel(int index, Object item) {
        if (this.isReadOnly()) {
            return;
        }
        this.writeModel.set(index, item);
    }

    public String getLabel(int index) {
        return this.model.get(index).toString();
    }

    public void addTab(Object item) {
        if (this.isReadOnly()) {
            return;
        }
        this.writeModel.addItem(item);
    }

    public void removeTab(Object item) {
        if (this.isReadOnly()) {
            return;
        }
        int index = this.writeModel.find(item);
        if (index != -1) {
            this.writeModel.remove(index);
        }
    }

    public void addTab(int aheadOf, Object item) {
        if (this.isReadOnly()) {
            return;
        }
        if (aheadOf == -1) {
            this.writeModel.addItem(item);
        } else {
            this.writeModel.addItem(aheadOf, item);
        }
    }

    public void renameTab(String oldName, String newName) {
        if (this.isReadOnly()) {
            return;
        }
        int index = this.writeModel.find(oldName);
        if (index != -1) {
            this.writeModel.set(index, newName);
        }
    }

    public VectorModel getModel() {
        return this.model;
    }

    public WritableVectorModel getWriteModel() {
        return this.readOnly ? null : this.writeModel;
    }

    public void setModel(VectorModel vm) {
        if (this.model != null) {
            this.model.removeModelListener(this);
            this.model.removeModelListener(this.modelMulticaster);
        }
        this.model = vm;
        if (this.model != null) {
            this.model.addModelListener(this);
            this.model.addModelListener(this.modelMulticaster);
        }
        this.writeModel = this.model instanceof WritableVectorModel ? (WritableVectorModel)this.model : null;
        this.updateTabInfo();
    }

    public VectorViewManager getViewManager() {
        return this.viewManager;
    }

    public void setViewManager(VectorViewManager viewManager) {
        this.viewManager = viewManager;
        this.invalidate();
        this.repaint(100L);
    }

    public int getSubfocus() {
        return this.getSelectedIndex();
    }

    public void setSubfocus(int subfocus) {
        this.selectTab(subfocus);
    }

    public WritableVectorSelection getSelection() {
        return this.selection;
    }

    public void setSelection(WritableVectorSelection vs) {
        if (this.selection != null) {
            this.selection.removeSelectionListener(this);
            this.selection.removeSelectionListener(this.selectionMulticaster);
        }
        this.selection = vs;
        if (this.selection != null) {
            this.selection.addSelectionListener(this);
            this.selection.addSelectionListener(this.selectionMulticaster);
        }
        int newIndex = this.getSelectedIndex();
        this.repaintTab(newIndex);
        this.repaintTab(this.oldIndex);
        this.oldIndex = newIndex;
    }

    public void setShowRollover(boolean showRollover) {
        this.showRollover = showRollover;
    }

    public boolean isShowRollover() {
        return this.showRollover;
    }

    public int getSelectedIndex() {
        int[] sels = this.selection.getAll();
        return sels.length > 0 ? sels[0] : -1;
    }

    public void setSelectedIndex(int index) {
        this.selectTab(index);
    }

    public String getSelectedTab() {
        int sel = this.getSelectedIndex();
        if (sel >= 0) {
            return this.model.get(sel).toString();
        }
        return null;
    }

    public void setSelectedTab(Object item) {
        this.selectTab(this.model.find(item));
    }

    public int getAlignment() {
        return this.alignment;
    }

    public void setAlignment(int align) {
        this.alignment = align;
        this.repaint(100L);
    }

    public boolean isClientBordered() {
        return this.clientBordered;
    }

    public void setClientBordered(boolean bordered) {
        this.clientBordered = bordered;
        this.repaint(100L);
    }

    public boolean isFocusAware() {
        return super.isFocusAware();
    }

    public void setFocusAware(boolean focusAware) {
        super.setFocusAware(focusAware);
        this.repaintTab(this.getSelectedIndex());
    }

    public Insets getItemMargins() {
        return this.itemMargins;
    }

    public void setItemMargins(Insets margins) {
        this.itemMargins = margins;
        this.invalidate();
        this.repaint(100L);
    }

    public Component getSiteComponent() {
        return this;
    }

    public boolean isTransparent() {
        return this.texture != null ? true : !this.isOpaque();
    }

    public boolean isReadOnly() {
        return this.readOnly ? true : this.writeModel == null;
    }

    public void setReadOnly(boolean ro) {
        this.readOnly = ro;
    }

    public boolean isTabsOnTop() {
        return this.tabsOnTop;
    }

    public void setTabsOnTop(boolean tabsOnTop) {
        this.tabsOnTop = tabsOnTop;
        this.invalidate();
        this.repaint(100L);
    }

    public void setThickBorder(boolean thickBorder) {
        this.thickBorder = thickBorder;
        this.repaint(100L);
    }

    public boolean isThickBorder() {
        return this.thickBorder;
    }

    public int hitTest(int x2, int y2) {
        if (this.needScroller && x2 > this.leftArrowRect.x) {
            return -1;
        }
        if (this.tabsOnTop ? y2 < this.border || y2 >= this.border + this.tabBarHeight : y2 < this.getSize().height - this.border - this.tabBarHeight || y2 >= this.getSize().height - this.border) {
            return -1;
        }
        return this.hitTestX(x2);
    }

    int hitTestX(int x2) {
        try {
            int i2;
            for (i2 = this.firstVisible; i2 <= this.lastVisible; ++i2) {
                TabInfo t2 = (TabInfo)this.tabInfo.elementAt(i2);
                if (!t2.hitTestX(x2 + this.xOffset)) continue;
                int n2 = i2;
                return n2;
            }
            i2 = -1;
            return i2;
        }
        catch (Exception e2) {
            int n3 = -1;
            return n3;
        }
    }

    public void addModelListener(VectorModelListener l2) {
        this.modelMulticaster.add(l2);
    }

    public void removeModelListener(VectorModelListener l2) {
        this.modelMulticaster.remove(l2);
    }

    public void addSelectionListener(VectorSelectionListener l2) {
        this.selectionMulticaster.add(l2);
    }

    public void removeSelectionListener(VectorSelectionListener l2) {
        this.selectionMulticaster.remove(l2);
    }

    public void addSubfocusListener(VectorSubfocusListener l2) {
        this.subfocusListeners.add(l2);
    }

    public void removeSubfocusListener(VectorSubfocusListener l2) {
        this.subfocusListeners.remove(l2);
    }

    public void modelContentChanged(VectorModelEvent e2) {
        switch (e2.getChange()) {
            case 1: {
                this.updateTabInfo();
                break;
            }
            case 17: 
            case 33: {
                TabInfo t2 = (TabInfo)this.tabInfo.elementAt(e2.getLocation());
                t2.item = this.model.get(e2.getLocation());
                this.updateTabRects();
                this.adjustScrollbar();
                this.repaint(100L);
            }
        }
    }

    public void modelStructureChanged(VectorModelEvent e2) {
        this.updateTabInfo();
    }

    public void selectionItemChanged(VectorSelectionEvent e2) {
    }

    public void selectionRangeChanged(VectorSelectionEvent e2) {
    }

    public void selectionChanged(VectorSelectionEvent e2) {
        int newIndex = this.getSelectedIndex();
        this.repaintTab(newIndex);
        this.repaintTab(this.oldIndex);
        this.oldIndex = newIndex;
    }

    protected void processFocusEvent(FocusEvent e2) {
        super.processFocusEvent(e2);
        this.repaintTab(this.getSelectedIndex());
    }

    protected void processKeyPressed(KeyEvent e2) {
        switch (e2.getKeyCode()) {
            case 36: {
                this.selectTab(0);
                break;
            }
            case 37: {
                int sel = this.getSelectedIndex();
                if (sel <= 0) break;
                this.selectTab(sel - 1);
                break;
            }
            case 39: {
                int sel = this.getSelectedIndex();
                if (sel >= this.tabInfo.size() - 1) break;
                this.selectTab(sel + 1);
                break;
            }
            case 35: {
                if (this.tabInfo.size() <= 0) break;
                this.selectTab(this.tabInfo.size() - 1);
                break;
            }
        }
    }

    protected boolean preProcessSubfocusEvent(VectorSubfocusEvent e2) {
        if (this.subfocusListeners.hasListeners()) {
            return this.subfocusListeners.vetoableDispatch(e2);
        }
        return true;
    }

    protected void processSubfocusEvent(VectorSubfocusEvent e2) {
        if (this.subfocusListeners.hasListeners()) {
            this.subfocusListeners.dispatch(e2);
        }
    }

    protected void processMousePressed(MouseEvent e2) {
        this.requestFocus();
        this.rollover = -1;
        if (e2.isMetaDown()) {
            return;
        }
        if (this.scrollCheck(e2.getX(), e2.getY())) {
            return;
        }
        int hit = this.hitTest(e2.getX(), e2.getY());
        if (hit >= 0) {
            this.selectTab(hit);
        }
    }

    protected void processMouseMoved(MouseEvent e2) {
        int hit;
        if (this.showRollover && (hit = this.hitTest(e2.getX(), e2.getY())) >= 0 && hit != this.rollover) {
            int oldRollover = this.rollover;
            this.rollover = hit;
            this.repaintTab(oldRollover);
            this.repaintTab(this.rollover);
        }
    }

    protected void processMouseExited(MouseEvent e2) {
        if (this.showRollover) {
            int oldRollover = this.rollover;
            this.rollover = -1;
            this.repaintTab(oldRollover);
        }
    }

    protected void setBorderHeight(int height) {
        this.border = height;
    }

    protected void updateTabInfo() {
        this.tabInfo.removeAllElements();
        for (int i2 = 0; i2 < this.model.getCount(); ++i2) {
            this.tabInfo.addElement(new TabInfo(this.model.get(i2)));
        }
        int[] sels = this.selection.getAll();
        if (sels.length > 0 && sels[0] >= this.tabInfo.size()) {
            int[] nosels = new int[]{};
            this.selection.removeAll();
            this.selection.add(nosels);
        }
        this.updateTabRects();
        this.adjustScrollbar();
        this.invalidate();
        this.repaint(100L);
    }

    protected void selectTab(int index) {
        if (index != this.getSelectedIndex() && index < this.tabInfo.size()) {
            if (!this.preProcessSubfocusEvent(new VectorSubfocusEvent(this, 1, index))) {
                return;
            }
            int previous = this.getSelectedIndex();
            this.selection.enableSelectionEvents(false);
            this.selection.removeAll();
            if (index >= 0) {
                this.selection.add(index);
            }
            this.selection.enableSelectionEvents(true);
            this.processSubfocusEvent(new VectorSubfocusEvent(this, 2, index));
        }
    }

    protected void scrollLeft() {
        if (this.firstVisible > 0) {
            --this.firstVisible;
            this.adjustScrollbar();
            this.repaint(100L);
        }
    }

    protected void scrollRight() {
        if ((this.lastClipped || this.lastVisible < this.tabInfo.size() - 1) && this.firstVisible < this.tabInfo.size() - 1) {
            ++this.firstVisible;
            this.adjustScrollbar();
            this.repaint(100L);
        }
    }

    protected boolean scrollCheck(int x2, int y2) {
        if (this.needScroller) {
            if (this.leftArrowRect.contains(x2, y2)) {
                this.scrollLeft();
                return true;
            }
            if (this.rightArrowRect.contains(x2, y2)) {
                this.scrollRight();
                return true;
            }
        }
        return false;
    }

    void updateTabRects() {
        Graphics g2 = this.getGraphics();
        this.tabBarWidth = 0;
        if (g2 != null) {
            int xCurrent = 2;
            int maxHeight = 0;
            g2.setFont(this.getFont());
            for (int i2 = 0; i2 < this.tabInfo.size(); ++i2) {
                Dimension dimension;
                TabInfo t2 = (TabInfo)this.tabInfo.elementAt(i2);
                int state = 0;
                if (i2 == this.getSelectedIndex()) {
                    state |= 4;
                    state |= this.focusState;
                }
                if (t2.item != null) {
                    ItemPainter painter = this.getPainter(i2, state);
                    dimension = painter.getPreferredSize(t2.item, g2, state, this);
                } else {
                    dimension = new Dimension(10, 10);
                }
                t2.x = xCurrent;
                t2.itemWidth = dimension.width;
                t2.width = 2 + t2.itemWidth + 2;
                t2.itemHeight = dimension.height;
                int height = 4 + t2.itemHeight + 2 - 3;
                xCurrent += t2.width;
                if (height <= maxHeight) continue;
                maxHeight = height;
            }
            this.tabBarWidth = xCurrent + 2;
            this.tabBarHeight = maxHeight;
        }
    }

    protected void adjustScrollbar() {
        this.tabBarTop = this.tabsOnTop ? this.border : this.getSize().height - this.border - this.tabBarHeight;
        this.xOffset = 0;
        this.needScroller = false;
        this.lastClipped = false;
        if (this.tabBarWidth <= this.getSize().width) {
            this.firstVisible = 0;
            this.lastVisible = this.tabInfo.size() - 1;
            return;
        }
        int xS = this.getSize().width - 28 - 2 - this.itemMargins.right;
        int yS = (this.tabBarHeight - 14) / 2;
        yS = this.tabsOnTop ? (yS += this.border) : (yS += this.getSize().height - this.border - this.tabBarHeight);
        if (this.tabInfo.size() > 0) {
            if (this.firstVisible >= this.tabInfo.size()) {
                --this.firstVisible;
            }
            this.xOffset = ((TabInfo)this.tabInfo.elementAt((int)this.firstVisible)).x - 2;
            this.lastVisible = this.firstVisible;
            int i2 = this.firstVisible;
            while (i2 < this.tabInfo.size()) {
                TabInfo t2 = (TabInfo)this.tabInfo.elementAt(i2);
                this.lastVisible = i2;
                if (t2.x - this.xOffset + t2.width > xS - 2 - this.itemMargins.right) {
                    this.lastClipped = true;
                    this.needScroller = true;
                    break;
                }
                this.lastVisible = i2++;
            }
        }
        if (this.firstVisible != 0) {
            this.needScroller = true;
        }
        if (this.needScroller) {
            this.leftArrowRect = new Rectangle(xS, yS, 14, 14);
            this.rightArrowRect = new Rectangle(xS + 14 + 1, yS, 14, 14);
        }
    }

    ItemPainter getPainter(int index, int state) {
        return this.viewManager != null ? this.viewManager.getPainter(index, ((TabInfo)this.tabInfo.elementAt((int)index)).item, state) : this.defaultPainter;
    }

    public Insets insets() {
        this.updateTabRects();
        if (this.tabsOnTop) {
            return new Insets(this.tabBarHeight + this.border, 2, this.clientBordered ? 2 : 0, 2);
        }
        return new Insets(this.clientBordered ? 2 : 0, 2, this.tabBarHeight + this.border, 2);
    }

    public Dimension getPreferredSize() {
        Insets in = this.insets();
        return new Dimension(this.tabBarWidth, in.top + in.bottom);
    }

    public void setFont(Font font) {
        super.setFont(font);
        this.doLayout();
        this.repaint(100L);
    }

    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.repaint(100L);
    }

    public void doLayout() {
        super.doLayout();
        this.updateTabRects();
        this.adjustScrollbar();
    }

    public void paintComponent(Graphics g2) {
        Rectangle clip = g2.getClipBounds();
        if (clip == null) {
            return;
        }
        if (clip.width <= 0 || clip.height <= 0 || this.getSize().width <= 0 || this.getSize().height <= 0) {
            return;
        }
        if (this.isOpaque()) {
            g2.setColor(this.getBackground());
            g2.fillRect(0, 0, this.getSize().width, this.getSize().height);
            g2.fillRect(clip.x, clip.y, clip.width, clip.height);
        }
        if (this.texture != null) {
            if (this.tabsOnTop) {
                ImageTexture.texture(this.texture, g2, 2, this.tabBarHeight, this.getSize().width - 2, this.getSize().height - 2);
            } else {
                ImageTexture.texture(this.texture, g2, 2, 2, this.getSize().width - 2, this.getSize().height - this.tabBarHeight - 2);
            }
        } else if (this.isOpaque()) {
            g2.setColor(this.getBackground());
            g2.fillRect(0, 0, this.getSize().width, this.getSize().height);
            g2.fillRect(clip.x, clip.y, clip.width, clip.height);
        }
        this.paintBorderLines(g2);
        if (this.tabInfo.size() > 0) {
            if (clip.y < this.tabBarTop + this.tabBarHeight && clip.y + clip.height > this.tabBarTop) {
                int first = this.hitTestX(clip.x);
                int last = this.hitTestX(clip.x + clip.width - 1);
                if (first == -1) {
                    TabInfo firstTab = (TabInfo)this.tabInfo.elementAt(this.firstVisible);
                    if (clip.x + this.xOffset < firstTab.x) {
                        first = this.firstVisible;
                    }
                }
                if (last == -1) {
                    try {
                        TabInfo lastTab = (TabInfo)this.tabInfo.elementAt(this.lastVisible);
                        if (clip.x + clip.width + this.xOffset > lastTab.x + lastTab.width) {
                            last = this.lastVisible;
                        }
                    }
                    catch (Exception lastTab) {
                        // empty catch block
                    }
                }
                if (first != -1 && last != -1) {
                    for (int i2 = first; i2 <= last; ++i2) {
                        this.paintTab(g2, i2);
                    }
                }
            }
            if (this.needScroller) {
                this.paintScrollArrows(g2);
            }
        }
    }

    void paintBorderLines(Graphics g2) {
        int left = 0;
        int right = this.getSize().width - 1;
        int top = 0;
        int bottom = this.getSize().height - 1;
        int leftStart = left;
        if (this.tabInfo.size() > 0) {
            try {
                TabInfo lastTab = (TabInfo)this.tabInfo.elementAt(this.lastVisible);
                leftStart = lastTab.x + lastTab.width - 1;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (this.tabsOnTop) {
            top = this.border + this.tabBarHeight - 2;
            if (this.clientBordered) {
                g2.setColor(SystemColor.controlLtHighlight);
                g2.drawLine(left, top, left, bottom - 1);
                g2.setColor(SystemColor.controlDkShadow);
                g2.drawLine(left, bottom, right, bottom);
                g2.drawLine(right, top, right, bottom);
                if (this.thickBorder) {
                    g2.setColor(SystemColor.controlHighlight);
                    g2.drawLine(left + 1, top + 1, left + 1, bottom - 2);
                    g2.setColor(SystemColor.controlShadow);
                    g2.drawLine(left + 1, bottom - 1, right - 2, bottom - 1);
                    g2.drawLine(right - 1, top + 1, right - 1, bottom - 1);
                }
            }
            g2.setColor(SystemColor.controlLtHighlight);
            g2.drawLine(left, top, left + 2, top);
            g2.drawLine(leftStart, top, right - 1, top);
            g2.setColor(SystemColor.controlHighlight);
            g2.drawLine(left + 1, top + 1, left + 2 - 1, top + 1);
            g2.drawLine(leftStart + 1, top + 1, right - 2, top + 1);
        } else {
            bottom = this.getSize().height - this.border - this.tabBarHeight + 1;
            if (this.clientBordered) {
                g2.setColor(SystemColor.controlLtHighlight);
                g2.drawLine(left, top, right - 1, top);
                g2.drawLine(left, top, left, bottom - 1);
                g2.setColor(SystemColor.controlDkShadow);
                g2.drawLine(right, top, right, bottom);
                if (this.thickBorder) {
                    g2.setColor(SystemColor.controlHighlight);
                    g2.drawLine(left + 1, top + 1, right - 2, top + 1);
                    g2.drawLine(left + 1, top + 1, left + 1, bottom - 2);
                    g2.setColor(SystemColor.controlShadow);
                    g2.drawLine(right - 1, top + 1, right - 1, bottom - 1);
                }
            }
            g2.setColor(SystemColor.controlDkShadow);
            g2.drawLine(left, bottom, left + 2, bottom);
            g2.drawLine(leftStart, bottom, right, bottom);
            g2.setColor(SystemColor.controlShadow);
            g2.drawLine(left + 1, bottom - 1, left + 2 - 1, bottom - 1);
            g2.drawLine(leftStart + 1, bottom - 1, right - 2, bottom - 1);
        }
    }

    public void repaintTab(int index) {
        if (index == -1 || index > this.tabInfo.size() - 1) {
            return;
        }
        TabInfo t2 = (TabInfo)this.tabInfo.elementAt(index);
        this.repaint(100L, t2.x - this.xOffset, this.tabBarTop, t2.width, this.tabBarHeight);
    }

    private void paintTab(Graphics g2, int index) {
        if (this.tabsOnTop) {
            this.paintTopTab(g2, index);
        } else {
            this.paintBottomTab(g2, index);
        }
    }

    private void paintTopTab(Graphics g2, int index) {
        boolean isSelected;
        TabInfo t2 = (TabInfo)this.tabInfo.elementAt(index);
        int selectedIndex = this.getSelectedIndex();
        if (selectedIndex == -1) {
            selectedIndex = -2;
        }
        boolean bl = isSelected = index == selectedIndex;
        if (this.model.getCount() == 1) {
            selectedIndex = -2;
        }
        int state = 0;
        if (this.texture != null) {
            ImageTexture.texture(this.texture, g2, t2.x - this.xOffset + 2, this.tabBarTop + 2, t2.width - 2 - 2, this.tabBarHeight);
        } else if (this.isOpaque()) {
            g2.setColor(this.getBackground());
            g2.fillRect(t2.x - this.xOffset, this.tabBarTop, t2.width, this.tabBarHeight);
        }
        int left = t2.x - this.xOffset;
        int right = left + t2.width - 1;
        int top = this.border + 2;
        int bottom = this.border + this.tabBarHeight - 2;
        if (isSelected) {
            top -= 2;
        }
        ItemPainter painter = null;
        if (t2.item != null) {
            painter = this.getPainter(index, state);
        }
        Font normalFont = this.getFont();
        Font selectedFont = this.getFont();
        if (isSelected) {
            state |= 4;
            state |= this.focusState;
            g2.setFont(selectedFont);
        } else {
            g2.setFont(normalFont);
        }
        Rectangle itemRect = new Rectangle(left + 2, top + 2 - 2, t2.itemWidth, t2.itemHeight);
        if (!this.isEnabled()) {
            state |= 1;
        }
        state |= index == this.rollover ? 64 : 0;
        g2.setColor(this.getBackground());
        if (painter != null) {
            painter.paint(t2.item, g2, itemRect, state, this);
        }
        if (index == selectedIndex + 1) {
            g2.setColor(SystemColor.controlDkShadow);
            g2.drawLine(left, top + 1 - 2, left + 1, top + 1 + 1 - 2);
            g2.drawLine(left + 1, top + 1 + 2 - 2, left + 1, bottom);
            g2.setColor(SystemColor.controlShadow);
            g2.drawLine(left, top + 2 - 2, left + 1 - 1, top + 1 + 2 - 2);
            g2.drawLine(left + 1 - 1, top + 1 + 3 - 2, left + 1 - 1, bottom);
        } else if (index != selectedIndex || index == 0) {
            g2.setColor(SystemColor.controlLtHighlight);
            g2.drawLine(left, top + 1 + 1, left, bottom);
            g2.drawLine(left + 1, top + 1, left + 1, top + 1);
            g2.setColor(SystemColor.controlHighlight);
            g2.drawLine(left + 1, top + 1 + 2, left + 1, bottom);
            g2.drawLine(left + 1, top + 1 + 1, left + 1 + 1, top + 1);
        }
        int leftAdjust = 0;
        int rightAdjust = 0;
        if (index == selectedIndex) {
            if (index == 0) {
                leftAdjust = 2;
            }
            if (index == this.model.getCount() - 1) {
                rightAdjust = 2;
            }
        } else if (index >= 0) {
            leftAdjust = 2;
            rightAdjust = 2;
        }
        g2.setColor(SystemColor.controlLtHighlight);
        g2.drawLine(left + leftAdjust, top, right - rightAdjust, top);
        g2.setColor(SystemColor.controlHighlight);
        g2.drawLine(left + leftAdjust, top + 1, right - rightAdjust, top + 1);
        if (index == selectedIndex - 1) {
            g2.setColor(SystemColor.controlLtHighlight);
            g2.drawLine(right - 1, top + 1 + 1 - 2, right - 1, bottom);
            g2.drawLine(right - 1 + 1, top + 1 - 2, right, top + 1 - 2);
            g2.setColor(SystemColor.controlHighlight);
            g2.drawLine(right - 1 + 1, top + 1 + 2 - 2, right - 1 + 1, bottom);
            g2.drawLine(right - 1 + 1, top + 1 + 1, right + 1, top + 1 - 2);
        } else if (index != selectedIndex || index == this.model.getCount() - 1) {
            g2.setColor(SystemColor.controlDkShadow);
            g2.drawLine(right - 1, top + 1, right, top + 1 + 1);
            g2.drawLine(right, top + 1 + 2, right, bottom);
            g2.setColor(SystemColor.controlShadow);
            g2.drawLine(right - 1, top + 2, right - 1, top + 1 + 2);
            g2.drawLine(right - 1, top + 1 + 3, right - 1, bottom);
        }
        if (!isSelected) {
            leftAdjust = 0;
            rightAdjust = 0;
            if (index == selectedIndex - 1) {
                rightAdjust = 2;
            } else if (index == selectedIndex + 1) {
                leftAdjust = 2;
            }
            int lineY = this.border + this.tabBarHeight - 2;
            g2.setColor(SystemColor.controlLtHighlight);
            g2.drawLine(left + leftAdjust, lineY, right - rightAdjust, lineY);
            g2.setColor(SystemColor.controlHighlight);
            g2.drawLine(left + leftAdjust, lineY + 1, right - rightAdjust, lineY + 1);
        }
    }

    private void paintBottomTab(Graphics g2, int index) {
        int lineY;
        TabInfo t2 = (TabInfo)this.tabInfo.elementAt(index);
        boolean isSelected = index == this.getSelectedIndex();
        int state = 0;
        if (this.texture != null) {
            ImageTexture.texture(this.texture, g2, t2.x - this.xOffset + 2, this.tabBarTop, t2.width - 2 - 2, this.tabBarHeight - 2);
        } else if (this.isOpaque()) {
            g2.setColor(this.getBackground());
            g2.fillRect(t2.x - this.xOffset, this.tabBarTop, t2.width, this.tabBarHeight);
        }
        int left = t2.x - this.xOffset;
        int right = left + t2.width - 1;
        int top = this.getSize().height - this.border - this.tabBarHeight + 2 - 1;
        int bottom = this.getSize().height - this.border - (isSelected ? 0 : 2) - 1;
        ItemPainter painter = null;
        if (t2.item != null) {
            painter = this.getPainter(index, state);
        }
        Font normalFont = this.getFont();
        Font selectedFont = this.getFont();
        g2.setColor(SystemColor.controlDkShadow);
        g2.drawLine(right, top, right, bottom - 1 - 1);
        g2.drawLine(right, bottom - 1 - 1, right - 1, bottom - 1);
        g2.drawLine(right - 1 - 1, bottom, left + 1 + 1, bottom);
        g2.setColor(SystemColor.controlShadow);
        g2.drawLine(right - 1, top, right - 1, bottom - 1 - 1);
        g2.drawLine(right - 1, bottom - 2 - 1, right - 1 - 1, bottom - 2);
        g2.drawLine(right - 1 - 1, bottom - 1, left + 1, bottom - 1);
        g2.setColor(SystemColor.controlLtHighlight);
        g2.drawLine(left + 1, bottom - 1, left, bottom - 1 - 1);
        g2.drawLine(left, bottom - 1 - 1, left, top);
        g2.setColor(SystemColor.controlHighlight);
        g2.drawLine(left + 1, bottom - 2, left + 1, bottom - 2 - 1);
        g2.drawLine(left + 1, bottom - 2 - 1, left + 1, top);
        if (isSelected) {
            state |= 4;
            state |= this.focusState;
            g2.setFont(selectedFont);
            lineY = this.getSize().height - this.tabBarHeight - this.border;
            g2.setColor(SystemColor.controlShadow);
            g2.drawLine(left, lineY, left, lineY);
            g2.drawLine(right - 1, lineY, right, lineY);
        } else {
            lineY = this.getSize().height - this.tabBarHeight - this.border;
            g2.setColor(SystemColor.controlDkShadow);
            g2.drawLine(left, lineY + 1, right, lineY + 1);
            g2.setColor(SystemColor.controlShadow);
            g2.drawLine(left, lineY, right, lineY);
            g2.setFont(normalFont);
        }
        Rectangle itemRect = new Rectangle(left + 2, bottom - 2 - t2.itemHeight + 1, t2.itemWidth, t2.itemHeight);
        if (!this.isEnabled()) {
            state |= 1;
        }
        state |= index == this.rollover ? 64 : 0;
        g2.setColor(this.getBackground());
        if (t2.item != null) {
            painter.paint(t2.item, g2, itemRect, state, this);
        }
    }

    private void paintScrollArrows(Graphics g2) {
        if (this.lastClipped) {
            int sel;
            int lineY = 0;
            int top = this.tabBarTop;
            int bottom = this.tabBarTop + this.tabBarHeight - 1;
            int left = this.leftArrowRect.x - 2 - this.itemMargins.left + 1;
            int right = this.getSize().width - 1;
            g2.setColor(this.getBackground());
            g2.fillRect(left, top, right - left + 1, this.tabBarHeight);
            if (this.tabsOnTop) {
                lineY = this.border + this.tabBarHeight - 2;
                g2.setColor(SystemColor.controlLtHighlight);
                g2.drawLine(left, lineY, right, lineY);
                g2.setColor(SystemColor.controlHighlight);
                g2.drawLine(left, lineY + 1, right, lineY + 1);
                if (this.clientBordered) {
                    g2.setColor(SystemColor.controlDkShadow);
                    g2.drawLine(right, lineY, right, lineY + 1);
                    if (this.thickBorder) {
                        g2.setColor(SystemColor.controlShadow);
                        g2.drawLine(right - 1, lineY + 1, right - 1, lineY + 1);
                    }
                }
            } else {
                lineY = this.getSize().height - this.tabBarHeight - this.border;
                g2.setColor(SystemColor.controlDkShadow);
                g2.drawLine(left, lineY + 1, right, lineY + 1);
                g2.setColor(SystemColor.controlShadow);
                g2.drawLine(left, lineY, right, lineY);
                if (this.clientBordered) {
                    g2.setColor(SystemColor.controlDkShadow);
                    g2.drawLine(right, lineY, right, lineY);
                }
            }
            if ((sel = this.getSelectedIndex()) == -1 || sel != this.hitTestX(left)) {
                if (this.tabsOnTop) {
                    top += 2;
                } else {
                    bottom -= 2;
                }
            }
            g2.setColor(SystemColor.controlShadow);
            int horizAdj = 0;
            int horizIncr = 1;
            int lineLength = 0;
            int numPoints = bottom - top;
            int[] xPoints = new int[numPoints];
            int[] yPoints = new int[numPoints];
            int pointCounter = 0;
            for (int i2 = top; i2 < bottom; ++i2) {
                xPoints[pointCounter] = left + horizAdj;
                yPoints[pointCounter] = i2;
                ++pointCounter;
                if (lineLength == 1) {
                    lineLength = 0;
                    if ((horizAdj += horizIncr) == 2) {
                        horizIncr = -1;
                        continue;
                    }
                    if (horizAdj != 0) continue;
                    horizIncr = 1;
                    continue;
                }
                ++lineLength;
            }
            g2.drawPolyline(xPoints, yPoints, numPoints);
        }
        this.paintScrollArrow(g2, true);
        this.paintScrollArrow(g2, false);
    }

    private void paintScrollArrow(Graphics g2, boolean left) {
        Rectangle r2 = left ? this.leftArrowRect : this.rightArrowRect;
        g2.setColor(SystemColor.controlLtHighlight);
        g2.drawLine(r2.x, r2.y, r2.x + r2.width - 1, r2.y);
        g2.drawLine(r2.x, r2.y, r2.x, r2.y + r2.height - 1);
        g2.setColor(SystemColor.controlHighlight);
        g2.drawLine(r2.x + 1, r2.y + 1, r2.x + r2.width - 2, r2.y + 1);
        g2.drawLine(r2.x + 1, r2.y + 1, r2.x + 1, r2.y + r2.height - 2);
        g2.setColor(SystemColor.controlShadow);
        g2.drawLine(r2.x + 1, r2.y + r2.height - 1, r2.x + r2.width - 1, r2.y + r2.height - 1);
        g2.drawLine(r2.x + r2.width - 1, r2.y + 1, r2.x + r2.width - 1, r2.y + r2.height - 1);
        g2.setColor(SystemColor.controlDkShadow);
        g2.drawLine(r2.x, r2.y + r2.height, r2.x + r2.width, r2.y + r2.height);
        g2.drawLine(r2.x + r2.width, r2.y, r2.x + r2.width, r2.y + r2.height);
        if (left) {
            if (this.firstVisible > 0) {
                g2.setColor(SystemColor.controlDkShadow);
            } else {
                g2.setColor(SystemColor.controlShadow);
            }
            g2.drawLine(r2.x + r2.width / 2 - 1, r2.y + r2.height / 2, r2.x + r2.width / 2 - 1, r2.y + r2.height / 2);
            g2.drawLine(r2.x + r2.width / 2, r2.y + r2.height / 2 - 1, r2.x + r2.width / 2, r2.y + r2.height / 2 + 1);
            g2.drawLine(r2.x + r2.width / 2 + 1, r2.y + r2.height / 2 - 2, r2.x + r2.width / 2 + 1, r2.y + r2.height / 2 + 2);
        } else {
            if (this.lastClipped) {
                g2.setColor(SystemColor.controlDkShadow);
            } else {
                g2.setColor(SystemColor.controlShadow);
            }
            g2.drawLine(r2.x + r2.width / 2 + 1, r2.y + r2.height / 2, r2.x + r2.width / 2 + 1, r2.y + r2.height / 2);
            g2.drawLine(r2.x + r2.width / 2, r2.y + r2.height / 2 - 1, r2.x + r2.width / 2, r2.y + r2.height / 2 + 1);
            g2.drawLine(r2.x + r2.width / 2 - 1, r2.y + r2.height / 2 - 2, r2.x + r2.width / 2 - 1, r2.y + r2.height / 2 + 2);
        }
    }

    public void setDoubleBuffer(boolean buffer) {
        this.setDoubleBuffered(buffer);
    }

    public boolean isDoubleBuffer() {
        return this.isDoubleBuffered();
    }

    private void writeObject(ObjectOutputStream s2) throws IOException {
        s2.defaultWriteObject();
        Hashtable<String, Object> hash = new Hashtable<String, Object>(4);
        if (this.model instanceof Serializable) {
            hash.put("m", this.model);
        }
        if (this.viewManager instanceof Serializable) {
            hash.put("v", this.viewManager);
        }
        if (this.selection instanceof Serializable) {
            hash.put("s", this.selection);
        }
        if (this.defaultPainter instanceof Serializable) {
            hash.put("p", this.defaultPainter);
        }
        s2.writeObject(hash);
    }

    private void readObject(ObjectInputStream s2) throws ClassNotFoundException, IOException {
        s2.defaultReadObject();
        Hashtable hash = (Hashtable)s2.readObject();
        Object data = hash.get("m");
        if (data instanceof VectorModel) {
            this.model = (VectorModel)data;
        }
        if (this.model instanceof WritableVectorModel) {
            this.writeModel = (WritableVectorModel)this.model;
        }
        if ((data = hash.get("v")) instanceof VectorViewManager) {
            this.viewManager = (VectorViewManager)data;
        }
        if ((data = hash.get("s")) instanceof WritableVectorSelection) {
            this.selection = (WritableVectorSelection)data;
        }
        if ((data = hash.get("p")) instanceof ItemPainter) {
            this.defaultPainter = (ItemPainter)data;
        }
    }

    static {
        serialVersionUID = 200L;
        SEL_HEIGHT_INCREASE = 2;
        SLOPE = 1;
        EDGE = 2;
        LINE = 2;
        SCROLLER_WIDTH = 28;
        SCROLLER_HEIGHT = 14;
    }
}

