/*
 * Decompiled with CFR 0.152.
 */
package com.borland.jbcl.view;

import com.borland.jbcl.model.ItemPaintSite;
import com.borland.jbcl.model.ItemPainter;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.SystemColor;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;

public class SelectableItemPainter
implements ItemPainter,
ItemPaintSite,
Serializable {
    private static final long serialVersionUID = 200L;
    protected transient ItemPainter painter;
    protected transient ItemPaintSite site;
    protected int state;
    protected boolean paintBackground = false;
    protected Color selectedFg = SystemColor.textHighlightText;
    protected Color selectedBg = SystemColor.textHighlight;
    protected Color inactiveSelectedFg = SystemColor.menuText;
    protected Color inactiveSelectedBg = SystemColor.menu;

    public SelectableItemPainter() {
    }

    public SelectableItemPainter(ItemPainter painter) {
        this.painter = painter;
    }

    public SelectableItemPainter(ItemPainter painter, boolean paintBackground) {
        this.painter = painter;
        this.paintBackground = paintBackground;
    }

    public void setPainter(ItemPainter painter) {
        this.painter = painter;
    }

    public ItemPainter getPainter() {
        return this.painter;
    }

    public void setPaintBackground(boolean paintBackground) {
        this.paintBackground = paintBackground;
    }

    public boolean isPaintBackground() {
        return this.paintBackground;
    }

    public void setSelectedBackground(Color c2) {
        this.selectedBg = c2;
    }

    public Color getSelectedBackground() {
        return this.selectedBg;
    }

    public void setSelectedForeground(Color c2) {
        this.selectedFg = c2;
    }

    public Color getSelectedForeground() {
        return this.selectedFg;
    }

    public void setInactiveSelectedBackground(Color c2) {
        this.inactiveSelectedBg = c2;
    }

    public Color getInactiveSelectedBackground() {
        return this.inactiveSelectedBg;
    }

    public void setInactiveSelectedForeground(Color c2) {
        this.inactiveSelectedFg = c2;
    }

    public Color getInactiveSelectedForeground() {
        return this.inactiveSelectedFg;
    }

    public Dimension getPreferredSize(Object data, Graphics g2, int state, ItemPaintSite site) {
        this.site = site;
        this.state = state;
        if (this.painter != null) {
            return this.painter.getPreferredSize(data, g2, state, this);
        }
        return new Dimension();
    }

    public void paint(Object data, Graphics g2, Rectangle rect, int state, ItemPaintSite site) {
        this.site = site;
        this.state = state;
        if (this.paintBackground) {
            Color oc = g2.getColor();
            g2.setColor(this.getBackground());
            g2.fillRect(rect.x, rect.y, rect.width, rect.height);
            g2.setColor(oc);
        }
        if (this.painter != null) {
            this.painter.paint(data, g2, rect, state, this);
        }
    }

    public Color getBackground() {
        return (this.state & 4) != 0 ? ((this.state & 0x20) != 0 ? this.inactiveSelectedBg : this.selectedBg) : (this.site != null ? this.site.getBackground() : null);
    }

    public Color getForeground() {
        return (this.state & 4) != 0 ? ((this.state & 0x20) != 0 ? this.inactiveSelectedFg : this.selectedFg) : (this.site != null ? this.site.getForeground() : null);
    }

    public boolean isTransparent() {
        return (this.state & 4) != 0 ? false : (this.site != null ? this.site.isTransparent() : false);
    }

    public Font getFont() {
        return this.site != null ? this.site.getFont() : null;
    }

    public int getAlignment() {
        return this.site != null ? this.site.getAlignment() : 0;
    }

    public Insets getItemMargins() {
        return this.site != null ? this.site.getItemMargins() : null;
    }

    public Component getSiteComponent() {
        return this.site != null ? this.site.getSiteComponent() : null;
    }

    private void writeObject(ObjectOutputStream s2) throws IOException {
        s2.defaultWriteObject();
        s2.writeObject(this.painter instanceof Serializable ? this.painter : null);
    }

    private void readObject(ObjectInputStream s2) throws ClassNotFoundException, IOException {
        s2.defaultReadObject();
        Object data = s2.readObject();
        if (data instanceof ItemPainter) {
            this.painter = (ItemPainter)data;
        }
    }

    static {
        serialVersionUID = 200L;
    }
}

