/*
 * Decompiled with CFR 0.152.
 */
package com.borland.jbcl.view;

import com.borland.jb.util.EventMulticaster;
import com.borland.jbcl.model.BasicVectorContainer;
import com.borland.jbcl.model.BasicViewManager;
import com.borland.jbcl.model.ItemPaintSite;
import com.borland.jbcl.model.ItemPainter;
import com.borland.jbcl.model.VectorModel;
import com.borland.jbcl.model.VectorModelEvent;
import com.borland.jbcl.model.VectorModelListener;
import com.borland.jbcl.model.VectorViewManager;
import com.borland.jbcl.view.BeanPanel;
import com.borland.jbcl.view.ButtonItemPainter;
import com.borland.jbcl.view.FixedSizeVector;
import com.borland.jbcl.view.HeaderEvent;
import com.borland.jbcl.view.HeaderListener;
import com.borland.jbcl.view.SizeVector;
import com.borland.jbcl.view.TextItemPainter;
import com.borland.jbcl.view.VariableSizeVector;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Hashtable;
import javax.swing.UIManager;

public class HeaderView
extends BeanPanel
implements ItemPaintSite,
VectorModelListener,
Serializable {
    private static final long serialVersionUID = 200L;
    private transient VectorViewManager viewManager;
    private transient VectorModel model;
    private transient SizeVector sizes = new VariableSizeVector(new int[0]);
    private int thickness = 0;
    private int orientation = 0;
    private boolean horz = true;
    private int selection = -1;
    private int margin = 8;
    private int alignment = 34;
    private Insets margins = new Insets(1, 1, 1, 1);
    private boolean resizable = true;
    private boolean liveResize = true;
    private boolean moveable = true;
    private boolean resizing = false;
    private boolean startMove = false;
    private boolean moving = false;
    private boolean batchMode = false;
    private boolean showRollover = false;
    private int rollover = -1;
    private int offset;
    private int clickItem;
    private transient EventMulticaster headerListeners = new EventMulticaster();
    private static Cursor DEFAULT_CURSOR;
    private static Cursor MOVE_CURSOR;
    private static Cursor H_SIZE_CURSOR;
    private static Cursor V_SIZE_CURSOR;

    public HeaderView() {
        this(0);
    }

    public HeaderView(int defaultOrientation) {
        super(null);
        this.orientation = defaultOrientation;
        this.horz = this.orientation == 0;
        this.model = this.createDefaultModel();
        this.viewManager = this.createDefaultViewManager();
        this.setFocusAware(false);
        super.setBackground(UIManager.getColor("TableHeader.background"));
        super.setForeground(UIManager.getColor("TableHeader.foreground"));
    }

    public void updateUI() {
        super.updateUI();
        super.setBackground(UIManager.getColor("TableHeader.background"));
        super.setForeground(UIManager.getColor("TableHeader.foreground"));
    }

    protected VectorModel createDefaultModel() {
        return new BasicVectorContainer();
    }

    protected VectorViewManager createDefaultViewManager() {
        return new BasicViewManager(new ButtonItemPainter(new TextItemPainter()));
    }

    public VectorModel getModel() {
        return this.model;
    }

    public void setModel(VectorModel vm) {
        if (this.model != null) {
            this.model.removeModelListener(this);
        }
        this.model = vm;
        if (this.model != null) {
            this.model.addModelListener(this);
        }
    }

    public boolean isTransparent() {
        return this.texture != null ? true : !this.isOpaque();
    }

    public void setItemMargins(Insets margins) {
        this.margins = margins;
    }

    public Insets getItemMargins() {
        return this.margins;
    }

    public void setAlignment(int a2) {
        this.alignment = a2;
    }

    public int getAlignment() {
        return this.alignment;
    }

    public Component getSiteComponent() {
        return this;
    }

    public VectorViewManager getViewManager() {
        return this.viewManager;
    }

    public void setViewManager(VectorViewManager newViewManager) {
        this.viewManager = newViewManager;
    }

    public void addHeaderListener(HeaderListener listener) {
        this.headerListeners.add(listener);
    }

    public void removeHeaderListener(HeaderListener listener) {
        this.headerListeners.remove(listener);
    }

    public int getOrientation() {
        return this.orientation;
    }

    public void setOrientation(int orientation) {
        this.orientation = orientation;
        this.horz = orientation == 0;
        this.invalidate();
        this.repaint();
    }

    public boolean isResizable() {
        return this.resizable;
    }

    public void setResizable(boolean resizable) {
        this.resizable = resizable;
    }

    public boolean isLiveResize() {
        return this.liveResize;
    }

    public void setLiveResize(boolean liveResize) {
        this.liveResize = liveResize;
    }

    public boolean isMoveable() {
        return this.moveable;
    }

    public void setMoveable(boolean moveable) {
        this.moveable = moveable;
    }

    public void setShowRollover(boolean showRollover) {
        this.showRollover = showRollover;
    }

    public boolean isShowRollover() {
        return this.showRollover;
    }

    public void setBatchMode(boolean batchMode) {
        this.batchMode = batchMode;
        if (!this.batchMode) {
            this.repaint();
        }
    }

    public boolean isBatchMode() {
        return this.batchMode;
    }

    public void modelStructureChanged(VectorModelEvent e2) {
        this.resetSize();
    }

    public void modelContentChanged(VectorModelEvent e2) {
        this.resetSize();
    }

    public int getThickness() {
        if (this.thickness == 0 && this.model != null && this.viewManager != null) {
            Graphics g2 = this.getGraphics();
            if (g2 == null) {
                return 0;
            }
            Font f2 = this.getFont();
            if (this.horz) {
                FontMetrics fm;
                Dimension ps;
                g2.setFont(f2);
                Object data = this.model.getCount() > 0 ? this.model.get(0) : null;
                ItemPainter ip = this.viewManager.getPainter(0, null, 0);
                Dimension dimension = ps = ip != null ? ip.getPreferredSize(data, g2, 0, null) : new Dimension(0, 0);
                this.thickness = this.model.getCount() > 0 ? (ps != null ? ps.height : 0) : ((fm = g2.getFontMetrics(f2)) != null ? fm.getHeight() : 0);
            } else {
                FontMetrics fm = g2.getFontMetrics(f2);
                this.thickness = fm != null ? fm.stringWidth("WWW") : 0;
            }
        }
        return this.thickness;
    }

    public void setThickness(int thickness) {
        if (this.thickness != thickness) {
            this.thickness = thickness;
            this.getThickness();
            this.invalidate();
            this.repaint();
        }
    }

    public SizeVector getItemSizes() {
        return this.sizes;
    }

    public void setItemSizes(SizeVector newSizes) {
        this.sizes = newSizes;
    }

    public Dimension getPreferredSize() {
        this.getThickness();
        if (this.model == null || this.sizes == null) {
            return new Dimension(this.thickness, this.thickness);
        }
        if (this.horz) {
            return new Dimension(this.sizes.getSizeUpTo(this.model.getCount()), this.thickness);
        }
        return new Dimension(this.thickness, this.sizes.getSizeUpTo(this.model.getCount()));
    }

    private int hitTest(int pos) {
        int item = 0;
        int count = this.model.getCount();
        for (int width = this.sizes.getSize(item); pos >= width && ++item < count; width += this.sizes.getSize(item)) {
        }
        if (item == count) {
            --item;
        }
        return item;
    }

    protected void resetSize() {
        this.getThickness();
        Dimension size = new Dimension(this.thickness, this.thickness);
        if (this.horz) {
            size.width = this.sizes.getSizeUpTo(this.model.getCount());
        } else {
            size.height = this.sizes.getSizeUpTo(this.model.getCount());
        }
        this.setSize(size);
    }

    protected void processHeaderEvent(HeaderEvent e2) {
        if (this.headerListeners.hasListeners()) {
            this.headerListeners.dispatch(e2);
        }
    }

    protected void processMousePressed(MouseEvent e2) {
        int x2 = e2.getX();
        int y2 = e2.getY();
        this.rollover = -1;
        if (this.headerListeners.hasListeners()) {
            int item = this.horz ? this.hitTest(x2) : this.hitTest(y2);
            Rectangle rect = this.getItemBounds(item);
            if (this.horz) {
                if (x2 <= rect.x + rect.width) {
                    this.clickItem = item;
                    if (x2 >= rect.x + rect.width - this.margin && this.resizable) {
                        if (this.sizes instanceof FixedSizeVector && item != 0) {
                            return;
                        }
                        this.offset = rect.x + rect.width - x2;
                        this.resizing = true;
                        this.processHeaderEvent(new HeaderEvent(this, 4, this.clickItem, x2, y2));
                    } else if (this.moveable) {
                        this.startMove = true;
                    }
                }
            } else if (y2 <= rect.y + rect.height) {
                this.clickItem = item;
                if (y2 >= rect.y + rect.height - this.margin && this.resizable) {
                    if (this.sizes instanceof FixedSizeVector && item != 0) {
                        return;
                    }
                    this.offset = rect.y + rect.height - y2;
                    this.resizing = true;
                    this.processHeaderEvent(new HeaderEvent(this, 4, this.clickItem, x2, y2));
                }
            }
        }
    }

    protected void processMouseMoved(MouseEvent e2) {
        int pos = this.horz ? e2.getX() : e2.getY();
        int item = this.hitTest(pos);
        if (this.showRollover && item >= 0 && item != this.rollover) {
            int oldRollover = this.rollover;
            this.rollover = item;
            this.repaintItem(oldRollover);
            this.repaintItem(this.rollover);
        }
        if (this.sizes instanceof FixedSizeVector && item != 0) {
            this.setCursor(DEFAULT_CURSOR);
            return;
        }
        Rectangle rect = this.getItemBounds(item);
        if (this.horz) {
            if (pos <= rect.x + rect.width && pos >= rect.x + rect.width - this.margin && this.resizable) {
                this.setCursor(H_SIZE_CURSOR);
                return;
            }
        } else if (pos <= rect.y + rect.height && pos >= rect.y + rect.height - this.margin && this.resizable) {
            this.setCursor(V_SIZE_CURSOR);
            return;
        }
        this.setCursor(DEFAULT_CURSOR);
    }

    protected void processMouseDragged(MouseEvent e2) {
        this.rollover = -1;
        if (this.headerListeners.hasListeners()) {
            if (this.resizing || this.moving || this.startMove) {
                int x2 = e2.getX();
                int y2 = e2.getY();
                if (this.resizing) {
                    if (this.sizes instanceof FixedSizeVector && this.clickItem != 0) {
                        this.setCursor(DEFAULT_CURSOR);
                        return;
                    }
                    if (this.liveResize) {
                        Rectangle rect = this.getItemBounds(this.clickItem);
                        int newSize = (this.horz ? x2 : y2) - (this.horz ? rect.x : rect.y) + this.offset;
                        if (newSize < 4) {
                            newSize = 4;
                        }
                        this.sizes.setSize(this.clickItem, newSize);
                        this.resetSize();
                    }
                    this.processHeaderEvent(new HeaderEvent(this, 5, this.clickItem, x2, y2));
                    return;
                }
                if (this.startMove) {
                    this.startMove = false;
                    this.moving = true;
                    this.processHeaderEvent(new HeaderEvent(this, 1, this.clickItem, x2, y2));
                    return;
                }
                if (this.moving) {
                    this.setCursor(MOVE_CURSOR);
                    this.processHeaderEvent(new HeaderEvent(this, 2, this.clickItem, x2, y2));
                    return;
                }
            }
            this.setCursor(DEFAULT_CURSOR);
        }
    }

    protected void processMouseReleased(MouseEvent e2) {
        this.rollover = -1;
        int x2 = e2.getX();
        int y2 = e2.getY();
        if (this.headerListeners.hasListeners()) {
            if (this.resizing) {
                this.processHeaderEvent(new HeaderEvent(this, 6, this.clickItem, x2, y2));
                this.repaint();
            }
            if (this.moving) {
                this.processHeaderEvent(new HeaderEvent(this, 3, this.clickItem, x2, y2));
                this.repaint();
            }
        }
        this.resizing = false;
        this.moving = false;
        this.startMove = false;
        this.setCursor(DEFAULT_CURSOR);
    }

    protected void processMouseExited(MouseEvent e2) {
        if (this.showRollover) {
            int oldRollover = this.rollover;
            this.rollover = -1;
            this.repaintItem(oldRollover);
        }
        this.setCursor(DEFAULT_CURSOR);
    }

    protected void processMouseClicked(MouseEvent e2) {
        this.rollover = -1;
        int x2 = e2.getX();
        int y2 = e2.getY();
        int pos = this.horz ? x2 : y2;
        int index = this.hitTest(pos);
        if (index == this.clickItem) {
            this.processHeaderEvent(new HeaderEvent(this, 0, index, x2, y2));
        }
        this.setCursor(DEFAULT_CURSOR);
    }

    public Rectangle getItemBounds(int item) {
        Rectangle rect = this.getBounds();
        if (rect == null) {
            return new Rectangle();
        }
        rect.x -= rect.x;
        rect.y -= rect.y;
        int l2 = 0;
        for (int index = 0; index < item; ++index) {
            l2 += this.sizes.getSize(index);
        }
        if (this.horz) {
            rect.x = l2;
            rect.width = this.sizes.getSize(item);
        } else {
            rect.y = l2;
            rect.height = this.sizes.getSize(item);
        }
        return rect;
    }

    public void repaintItem(int index) {
        Rectangle rect = this.getItemBounds(index);
        if (rect != null) {
            this.repaint(rect.x, rect.y, rect.width, rect.height);
        }
    }

    public void update(Graphics g2) {
        this.paint(g2);
    }

    public void paintComponent(Graphics g2) {
        if (this.batchMode) {
            return;
        }
        super.paintComponent(g2);
        Rectangle cr = g2.getClipBounds();
        if (cr == null) {
            return;
        }
        Rectangle clip = new Rectangle(0, 0, this.getSize().width, this.getSize().height);
        if (clip.isEmpty() || cr.isEmpty()) {
            return;
        }
        g2.setClip(cr.x, cr.y, cr.width, cr.height);
        int count = this.model != null ? this.model.getCount() : 0;
        int vx = this.horz ? cr.x : cr.y;
        int vw = this.horz ? cr.width : cr.height;
        int start = this.hitTest(vx) < count ? this.hitTest(vx) : count;
        int end = this.hitTest(vx + vw) < count ? this.hitTest(vx + vw) : count;
        int viewstate = (this.isEnabled() ? 0 : 1) | this.focusState;
        if (count > 0 && start >= 0) {
            Rectangle rect = this.getItemBounds(start);
            for (int index = start; index <= end; ++index) {
                ItemPainter ip;
                if (this.horz) {
                    rect.width = this.sizes.getSize(index);
                } else {
                    rect.height = this.sizes.getSize(index);
                }
                Object value = this.model.get(index);
                int state = viewstate | (index == this.selection ? 4 : 0);
                int n2 = index == this.rollover && this.showRollover ? 64 : 0;
                g2.setColor(this.getBackground());
                g2.setFont(this.getFont());
                ItemPainter itemPainter = ip = this.viewManager != null ? this.viewManager.getPainter(index, value, state |= n2) : null;
                if (ip != null) {
                    g2.clipRect(rect.x, rect.y, rect.width, rect.height);
                    ip.paint(value, g2, rect, state, this);
                    g2.setClip(cr.x, cr.y, cr.width, cr.height);
                }
                if (this.horz) {
                    rect.x += rect.width;
                    continue;
                }
                rect.y += rect.height;
            }
            if (this.horz) {
                rect.width = clip.x + clip.width - rect.x;
            } else {
                rect.height = clip.y + clip.height - rect.y;
            }
            if (rect.width > 0 && rect.height > 0 && this.isOpaque() && this.texture == null) {
                g2.setColor(this.getBackground());
                g2.fillRect(rect.x, rect.y, rect.width, rect.height);
            }
        } else if (this.isOpaque() && this.texture == null) {
            g2.setColor(this.getBackground());
            g2.fillRect(clip.x, clip.y, clip.width, clip.height);
        }
    }

    private void writeObject(ObjectOutputStream s2) throws IOException {
        s2.defaultWriteObject();
        Hashtable<String, Object> hash = new Hashtable<String, Object>(3);
        if (this.model instanceof Serializable) {
            hash.put("m", this.model);
        }
        if (this.viewManager instanceof Serializable) {
            hash.put("v", this.viewManager);
        }
        if (this.sizes instanceof Serializable) {
            hash.put("s", this.sizes);
        }
        s2.writeObject(hash);
    }

    private void readObject(ObjectInputStream s2) throws ClassNotFoundException, IOException {
        s2.defaultReadObject();
        Hashtable hash = (Hashtable)s2.readObject();
        Object data = hash.get("m");
        if (data instanceof VectorModel) {
            this.model = (VectorModel)data;
        }
        if ((data = hash.get("v")) instanceof VectorViewManager) {
            this.viewManager = (VectorViewManager)data;
        }
        if ((data = hash.get("s")) instanceof SizeVector) {
            this.sizes = (SizeVector)data;
        }
    }

    static {
        serialVersionUID = 200L;
        DEFAULT_CURSOR = Cursor.getDefaultCursor();
        MOVE_CURSOR = new Cursor(13);
        H_SIZE_CURSOR = new Cursor(10);
        V_SIZE_CURSOR = new Cursor(8);
    }
}

