/*
 * Decompiled with CFR 0.152.
 */
package com.borland.jbcl.util;

import com.borland.jbcl.util.TimerClient;
import com.borland.jbcl.util.TimerTask;
import java.util.Vector;

class TimerTasks
extends Thread {
    Vector tasks = new Vector();
    boolean suspended = false;
    boolean sleeping = false;

    TimerTasks() {
    }

    public void run() {
        while (true) {
            long sleepTime = 0L;
            Vector vector = this.tasks;
            synchronized (vector) {
                sleepTime = this.scan();
                this.purge();
            }
            if (this.tasks.size() == 0) {
                try {
                    TimerTasks timerTasks = this;
                    synchronized (timerTasks) {
                        this.suspended = true;
                        this.wait();
                    }
                }
                catch (InterruptedException interruptedException) {}
                continue;
            }
            if (sleepTime < (long)0) continue;
            try {
                this.sleeping = true;
                Thread.sleep(sleepTime);
                this.sleeping = false;
            }
            catch (InterruptedException interruptedException) {
            }
        }
    }

    public void add(TimerClient client, int eventId, long delay, boolean repeat) {
        TimerTask t2 = new TimerTask(client, eventId, delay, repeat);
        Vector vector = this.tasks;
        synchronized (vector) {
            this.tasks.addElement(t2);
        }
        if (this.suspended) {
            TimerTasks timerTasks = this;
            synchronized (timerTasks) {
                this.notify();
                this.suspended = false;
            }
        }
    }

    public void end(TimerClient client, int eventId) {
        Vector vector = this.tasks;
        synchronized (vector) {
            for (int i2 = 0; i2 < this.tasks.size(); ++i2) {
                TimerTask t2 = (TimerTask)this.tasks.elementAt(i2);
                if (t2.deletePending || t2.client != client || t2.eventId != eventId) continue;
                t2.repeat = false;
                t2.deletePending = true;
                break;
            }
        }
    }

    void purge() {
        for (int i2 = 0; i2 < this.tasks.size(); ++i2) {
            TimerTask t2 = (TimerTask)this.tasks.elementAt(i2);
            if (!t2.deletePending) continue;
            this.tasks.removeElementAt(i2);
            --i2;
        }
    }

    long scan() {
        long nextTime = System.currentTimeMillis() + (long)100;
        for (int i2 = 0; i2 < this.tasks.size(); ++i2) {
            TimerTask t2 = (TimerTask)this.tasks.elementAt(i2);
            if (!t2.deletePending) {
                t2.test();
            }
            if (t2.deletePending) continue;
            nextTime = Math.min(nextTime, t2.timeNext);
        }
        return nextTime - System.currentTimeMillis();
    }
}

