/*
 * Decompiled with CFR 0.152.
 */
package com.borland.jbcl.util;

import java.awt.Graphics;
import java.awt.Image;
import java.awt.Rectangle;
import java.io.Serializable;

public class ImageTexture
implements Serializable {
    public static void texture(Image src, Graphics dest, int x2, int y2, int w2, int h2) {
        ImageTexture.texture(src, -1, -1, dest, 0, 0, x2, y2, w2, h2);
    }

    public static void texture(Image src, Graphics dest, int ox, int oy, int x2, int y2, int w2, int h2) {
        ImageTexture.texture(src, -1, -1, dest, ox, oy, x2, y2, w2, h2);
    }

    public static void texture(Image src, int sw, int sh, Graphics dest, int x2, int y2, int w2, int h2) {
        ImageTexture.texture(src, sw, sh, dest, 0, 0, x2, y2, w2, h2);
    }

    public static void texture(Image src, int sw, int sh, Graphics dest, int ox, int oy, int x2, int y2, int w2, int h2) {
        int ystart;
        int iw = src.getWidth(null);
        int ih = src.getHeight(null);
        if (iw < 1 || ih < 1) {
            return;
        }
        int tw = sw > 0 ? sw : iw;
        int th = sh > 0 ? sh : ih;
        Rectangle clip = dest.getClipBounds();
        dest.clipRect(x2, y2, w2, h2);
        while (x2 < ox) {
            ox -= tw;
        }
        while (y2 < oy) {
            oy -= th;
        }
        int xblits = (int)Math.ceil((x2 - ox + w2) / tw);
        int yblits = (int)Math.ceil((y2 - oy + h2) / th);
        int xstart = (x2 - ox) / tw;
        for (int yb = ystart = (y2 - oy) / th; yb <= yblits; ++yb) {
            for (int xb = xstart; xb <= xblits; ++xb) {
                int tx1 = xb * tw + ox;
                int ty1 = yb * th + oy;
                int tx2 = (xb + 1) * tw + ox;
                int ty2 = (yb + 1) * th + oy;
                dest.drawImage(src, tx1, ty1, tx2, ty2, 0, 0, iw, ih, null);
            }
        }
        if (clip != null) {
            dest.setClip(clip.x, clip.y, clip.width, clip.height);
        }
    }
}

