/*
 * Decompiled with CFR 0.152.
 */
package com.borland.jbcl.model;

import com.borland.jb.util.EventMulticaster;
import com.borland.jbcl.model.MatrixLocation;
import com.borland.jbcl.model.MatrixSelectionEvent;
import com.borland.jbcl.model.MatrixSelectionListener;
import com.borland.jbcl.model.WritableMatrixSelection;
import java.io.Serializable;

public class SingleMatrixSelection
implements WritableMatrixSelection,
Serializable {
    private MatrixLocation cell;
    private transient EventMulticaster selectionListeners = new EventMulticaster();
    private boolean events = true;

    public SingleMatrixSelection() {
    }

    public SingleMatrixSelection(MatrixLocation location) {
        this.cell = location;
    }

    public boolean contains(MatrixLocation location) {
        return location.equals(this.cell);
    }

    public boolean contains(int row, int column) {
        if (this.cell != null) {
            return this.cell.row == row && this.cell.column == column;
        }
        return false;
    }

    public int getCount() {
        return this.cell != null ? 1 : 0;
    }

    public MatrixLocation[] getAll() {
        MatrixLocation[] contents = new MatrixLocation[this.cell != null ? 1 : 0];
        if (this.cell != null) {
            contents[0] = this.cell;
        }
        return contents;
    }

    public void addSelectionListener(MatrixSelectionListener listener) {
        this.selectionListeners.add(listener);
    }

    public void removeSelectionListener(MatrixSelectionListener listener) {
        this.selectionListeners.remove(listener);
    }

    public void set(MatrixLocation[] locations) {
        this.add(locations);
    }

    public void add(MatrixLocation location) {
        if (!location.equals(this.cell)) {
            this.cell = new MatrixLocation(location);
            this.processSelectionEvent(new MatrixSelectionEvent(this, 12290));
        }
    }

    public void add(int row, int column) {
        if (this.cell != null) {
            if (this.cell.row != row || this.cell.column != column) {
                this.cell.row = row;
                this.cell.column = column;
                this.processSelectionEvent(new MatrixSelectionEvent(this, 12290));
            }
        } else {
            this.cell = new MatrixLocation(row, column);
            this.processSelectionEvent(new MatrixSelectionEvent(this, 12290));
        }
    }

    public void add(MatrixLocation[] locations) {
        if (locations.length > 0 && !locations[0].equals(this.cell)) {
            this.cell = new MatrixLocation(locations[0]);
            this.processSelectionEvent(new MatrixSelectionEvent(this, 12290));
        }
    }

    public void addRange(MatrixLocation begin, MatrixLocation end) {
        if (!end.equals(this.cell)) {
            this.cell = new MatrixLocation(end);
            this.processSelectionEvent(new MatrixSelectionEvent(this, 12290));
        }
    }

    public void addRange(int beginRow, int beginColumn, int endRow, int endColumn) {
        if (this.cell != null) {
            if (this.cell.row != endRow || this.cell.column != endColumn) {
                this.cell.row = endRow;
                this.cell.column = endColumn;
                this.processSelectionEvent(new MatrixSelectionEvent(this, 12290));
            }
        } else {
            this.cell = new MatrixLocation(endRow, endColumn);
            this.processSelectionEvent(new MatrixSelectionEvent(this, 12290));
        }
    }

    public void remove(MatrixLocation location) {
        if (location.equals(this.cell)) {
            this.cell = null;
            this.processSelectionEvent(new MatrixSelectionEvent(this, 12290));
        }
    }

    public void remove(int row, int column) {
        if (this.cell != null && this.cell.row == row && this.cell.column == column) {
            this.cell = null;
            this.processSelectionEvent(new MatrixSelectionEvent(this, 12290));
        }
    }

    public void remove(MatrixLocation[] locations) {
        if (this.cell != null) {
            for (int i2 = 0; i2 < locations.length; ++i2) {
                if (!locations[i2].equals(this.cell)) continue;
                this.cell = null;
                this.processSelectionEvent(new MatrixSelectionEvent(this, 12290));
                return;
            }
        }
    }

    public void removeRange(MatrixLocation begin, MatrixLocation end) {
        this.removeRange(begin.row, begin.column, end.row, end.column);
    }

    public void removeRange(int beginRow, int beginColumn, int endRow, int endColumn) {
        if (this.cell != null && this.cell.row >= beginRow && this.cell.row <= endRow && this.cell.column >= beginColumn && this.cell.column <= endColumn) {
            this.cell = null;
            this.processSelectionEvent(new MatrixSelectionEvent(this, 12290));
        }
    }

    public void removeAll() {
        if (this.cell != null) {
            this.cell = null;
            this.processSelectionEvent(new MatrixSelectionEvent(this, 12289));
        }
    }

    public void enableSelectionEvents(boolean enable) {
        this.events = enable;
        if (this.events) {
            this.processSelectionEvent(new MatrixSelectionEvent(this, 12290));
        }
    }

    protected void processSelectionEvent(MatrixSelectionEvent e2) {
        if (this.events && this.selectionListeners.hasListeners()) {
            this.selectionListeners.dispatch(e2);
        }
    }

    public final String toString() {
        String cn = this.getClass().getName();
        return String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(cn.substring(cn.lastIndexOf(46) + 1)))).append("[").append(this.paramString()).append("]")));
    }

    protected String paramString() {
        return "cell=".concat(String.valueOf(String.valueOf(this.cell)));
    }
}

