/*
 * Decompiled with CFR 0.152.
 */
package com.borland.jbcl.control;

import com.borland.jbcl.control.Res;
import com.borland.jbcl.control.TreeItems;
import com.borland.jbcl.model.BasicGraphSelection;
import com.borland.jbcl.model.BasicTreeContainer;
import com.borland.jbcl.model.BasicViewManager;
import com.borland.jbcl.model.GraphLocation;
import com.borland.jbcl.model.GraphModel;
import com.borland.jbcl.model.WritableGraphModel;
import com.borland.jbcl.util.BlackBox;
import com.borland.jbcl.util.ImageLoader;
import com.borland.jbcl.view.ExpandingTextItemEditor;
import com.borland.jbcl.view.FocusableItemPainter;
import com.borland.jbcl.view.SelectableItemPainter;
import com.borland.jbcl.view.TextItemPainter;
import com.borland.jbcl.view.TreeView;
import java.awt.Component;
import java.awt.Image;
import java.io.Serializable;

public class TreeControl
extends TreeView
implements BlackBox,
GraphModel,
Serializable {
    private String[] items;
    protected String textureName;

    public TreeControl() {
        this.setModel(new BasicTreeContainer());
        this.setupViewers();
        this.setSelection(new BasicGraphSelection());
    }

    public void setItems(String[] items) {
        this.items = items;
        TreeItems ti = new TreeItems(items);
        this.setModel(ti.getModel());
        this.setupViewers();
    }

    public String[] getItems() {
        return this.items;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setTextureName(String path) {
        if (path != null && !path.equals("")) {
            Image i2 = ImageLoader.load(path, (Component)this);
            if (i2 == null) throw new IllegalArgumentException(path);
            ImageLoader.waitForImage(this, i2);
            this.textureName = path;
            this.setTexture(i2);
            return;
        } else {
            this.textureName = null;
            this.setTexture(null);
        }
    }

    public String getTextureName() {
        return this.textureName;
    }

    public void setModel(GraphModel model) {
        if (model == this) {
            throw new IllegalArgumentException(Res._RecursiveModel);
        }
        super.setModel(model);
    }

    private void setupViewers() {
        FocusableItemPainter iv = new FocusableItemPainter(new SelectableItemPainter(new TextItemPainter()));
        ExpandingTextItemEditor ie = new ExpandingTextItemEditor();
        this.setViewManager(new BasicViewManager(iv, ie));
    }

    public GraphLocation getRoot() {
        GraphModel m2 = this.getModel();
        return m2 != null ? m2.getRoot() : null;
    }

    public Object get(GraphLocation node) {
        GraphModel m2 = this.getModel();
        return m2 != null ? m2.get(node) : null;
    }

    public GraphLocation find(Object data) {
        GraphModel m2 = this.getModel();
        return m2 != null ? m2.find(data) : null;
    }

    public GraphLocation setRoot(Object data) {
        WritableGraphModel m2 = this.getWriteModel();
        return m2 != null ? m2.setRoot(data) : null;
    }

    public boolean canSet(GraphLocation node) {
        WritableGraphModel m2 = this.getWriteModel();
        return m2 != null ? m2.canSet(node) : false;
    }

    public void set(GraphLocation node, Object data) {
        WritableGraphModel m2 = this.getWriteModel();
        if (m2 != null) {
            m2.set(node, data);
        }
    }

    public void touched(GraphLocation node) {
        WritableGraphModel m2 = this.getWriteModel();
        if (m2 != null) {
            m2.touched(node);
        }
    }

    public boolean isVariableSize() {
        WritableGraphModel m2 = this.getWriteModel();
        return m2 != null ? m2.isVariableSize() : false;
    }

    public GraphLocation addChild(GraphLocation parent, Object data) {
        WritableGraphModel m2 = this.getWriteModel();
        return m2 != null ? m2.addChild(parent, data) : null;
    }

    public GraphLocation addChild(GraphLocation parent, GraphLocation aheadOf, Object data) {
        WritableGraphModel m2 = this.getWriteModel();
        return m2 != null ? m2.addChild(parent, aheadOf, data) : null;
    }

    public void removeChildren(GraphLocation parent) {
        WritableGraphModel m2 = this.getWriteModel();
        if (m2 != null) {
            m2.removeChildren(parent);
        }
    }

    public void remove(GraphLocation node) {
        WritableGraphModel m2 = this.getWriteModel();
        if (m2 != null) {
            m2.remove(node);
        }
    }

    public void removeAll() {
        super.removeAll();
    }

    public void removeAllItems() {
        WritableGraphModel m2 = this.getWriteModel();
        if (m2 != null) {
            m2.removeAll();
        }
    }

    public void enableModelEvents(boolean enable) {
        WritableGraphModel m2 = this.getWriteModel();
        if (m2 != null) {
            m2.enableModelEvents(enable);
        }
    }
}

