/*
 * Decompiled with CFR 0.152.
 */
package com.borland.jbcl.control;

import com.borland.dx.dataset.AccessEvent;
import com.borland.dx.dataset.AccessListener;
import com.borland.dx.dataset.Column;
import com.borland.dx.dataset.ColumnAware;
import com.borland.dx.dataset.DataChangeEvent;
import com.borland.dx.dataset.DataChangeListener;
import com.borland.dx.dataset.DataSet;
import com.borland.dx.dataset.DataSetException;
import com.borland.jbcl.model.BasicSingletonContainer;
import com.borland.jbcl.model.DataSetModel;
import com.borland.jbcl.model.SingletonDataSetManager;
import com.borland.jbcl.view.LabelView;
import java.awt.Color;
import java.awt.Font;
import java.io.Serializable;

public class LabelControl
extends LabelView
implements DataChangeListener,
AccessListener,
ColumnAware,
Serializable {
    private DataSet dataSet;
    private String columnName;
    private boolean addNotifyCalled = false;

    public LabelControl() {
        this.setModel(new BasicSingletonContainer());
    }

    public LabelControl(String text) {
        this.setModel(new BasicSingletonContainer());
    }

    public void accessChange(AccessEvent event) {
        switch (event.getID()) {
            case 1: {
                try {
                    this.openDataSet(this.dataSet);
                }
                catch (Exception ex) {
                    event.appendException(ex);
                }
                break;
            }
            case 2: {
                break;
            }
        }
    }

    public void dataChanged(DataChangeEvent event) {
        this.updateText();
    }

    public void postRow(DataChangeEvent event) throws Exception {
        this.updateText();
    }

    public DataSet getDataSet() {
        return this.dataSet;
    }

    public void setDataSet(DataSet newDataSet) {
        if (this.dataSet != null) {
            this.dataSet.removeAccessListener(this);
            this.dataSet.removeDataChangeListener(this);
        }
        this.openDataSet(newDataSet);
        if (this.dataSet != null) {
            this.dataSet.addAccessListener(this);
            this.dataSet.addDataChangeListener(this);
        }
    }

    public String getColumnName() {
        return this.columnName;
    }

    public void setColumnName(String newColumnName) {
        this.columnName = newColumnName;
        if (this.addNotifyCalled) {
            this.openDataSet(this.dataSet);
        }
    }

    public void addNotify() {
        super.addNotify();
        if (!this.addNotifyCalled) {
            this.addNotifyCalled = true;
            if (this.dataSet != null) {
                this.openDataSet(this.dataSet);
            }
        }
    }

    private void openDataSet(DataSet newDataSet) {
        this.dataSet = newDataSet;
        if (this.dataSet == null) {
            this.setModel(new BasicSingletonContainer());
            return;
        }
        if (this.addNotifyCalled && !this.dataSet.isOpen()) {
            try {
                this.dataSet.open();
            }
            catch (DataSetException ex) {
                DataSetModel.handleException(this.dataSet, this, ex);
                this.setModel(new BasicSingletonContainer());
                return;
            }
        }
        if (this.dataSet.isOpen()) {
            this.bindDataSet();
        }
    }

    private void bindDataSet() {
        Column column;
        if (this.dataSet != null && this.dataSet.isOpen() && (column = this.dataSet.hasColumn(this.columnName)) != null) {
            this.setModel(new SingletonDataSetManager(this.dataSet, column, this));
            this.bindProperties(column);
        }
    }

    private void bindProperties(Column column) {
        Color bg = column.getBackground();
        Color fg = column.getForeground();
        Font f2 = column.getFont();
        if (bg != null) {
            this.setBackground(bg);
        }
        if (fg != null) {
            this.setForeground(fg);
        }
        if (f2 != null) {
            this.setFont(f2);
        }
    }
}

