/*
 * Decompiled with CFR 0.152.
 */
package sun.tools.jar;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import sun.misc.BASE64Encoder;
import sun.net.www.MessageHeader;
import sun.security.pkcs.PKCS7;
import sun.security.pkcs.SignerInfo;
import sun.tools.jar.JarException;
import sun.tools.jar.Manifest;

public class SignatureFile {
    static final boolean debug = false;
    private Vector entries = new Vector();
    static final String[] hashes = new String[]{"SHA"};
    private Manifest manifest;
    private String rawName;
    private PKCS7 signatureBlock;
    private Hashtable digests = new Hashtable();

    public SignatureFile(byte[] byArray) throws IOException {
        this(new ByteArrayInputStream(byArray));
    }

    public SignatureFile(InputStream inputStream) throws IOException {
        this(inputStream, null);
    }

    public void stream(OutputStream outputStream) throws IOException {
        MessageHeader messageHeader = (MessageHeader)this.entries.elementAt(0);
        if (messageHeader.findValue("Signature-Version") == null) {
            throw new JarException("Signature file requires Signature-Version: 1.0 in 1st header");
        }
        PrintStream printStream = new PrintStream(outputStream);
        messageHeader.print(printStream);
        int n2 = 1;
        while (n2 < this.entries.size()) {
            MessageHeader messageHeader2 = (MessageHeader)this.entries.elementAt(n2);
            messageHeader2.print(printStream);
            ++n2;
        }
    }

    public String getBlockName() {
        String string = "DSA";
        if (this.signatureBlock != null) {
            SignerInfo signerInfo = this.signatureBlock.getSignerInfos()[0];
            string = signerInfo.getDigestEncryptionAlgorithmId().getName();
            string = string.substring(string.length() - 3);
        }
        return "META-INF/" + this.rawName + "." + string;
    }

    public String getName() {
        return "META-INF/" + this.rawName + ".SF";
    }

    private SignatureFile(String string) throws JarException {
        this.entries = new Vector();
        if (string != null) {
            if (string.length() > 8 || string.indexOf(46) != -1) {
                throw new JarException("invalid file name");
            }
            this.rawName = string.toUpperCase();
        }
    }

    public void add(String string) throws JarException {
        MessageHeader messageHeader;
        MessageHeader messageHeader2 = this.manifest.getEntry(string);
        if (messageHeader2 == null) {
            throw new JarException("entry " + string + " not in manifest");
        }
        try {
            messageHeader = this.computeEntry(messageHeader2);
        }
        catch (IOException iOException) {
            throw new JarException(iOException.getMessage());
        }
        this.entries.addElement(messageHeader);
    }

    static final void debug(String string) {
    }

    private SignatureFile(String string, boolean bl2) throws JarException {
        this(string);
        if (bl2) {
            MessageHeader messageHeader = new MessageHeader();
            messageHeader.set("Signature-Version", "1.0");
            this.entries.addElement(messageHeader);
        }
    }

    public void add(String[] stringArray) throws JarException {
        int n2 = 0;
        while (n2 < stringArray.length) {
            this.add(stringArray[n2]);
            ++n2;
        }
    }

    public Enumeration entries() {
        return this.entries.elements();
    }

    public MessageHeader entryAt(int n2) {
        return (MessageHeader)this.entries.elementAt(n2);
    }

    public PKCS7 getBlock() {
        return this.signatureBlock;
    }

    public void setBlock(PKCS7 pKCS7) {
        this.signatureBlock = pKCS7;
    }

    public SignatureFile(InputStream inputStream, String string) throws IOException {
        this(string);
        while (inputStream.available() > 0) {
            MessageHeader messageHeader = new MessageHeader(inputStream);
            this.entries.addElement(messageHeader);
        }
    }

    public SignatureFile(Manifest manifest, String string) throws JarException {
        this(string, true);
        this.manifest = manifest;
        Enumeration enumeration = manifest.entries();
        while (enumeration.hasMoreElements()) {
            MessageHeader messageHeader = (MessageHeader)enumeration.nextElement();
            String string2 = messageHeader.findValue("Name");
            if (string2 == null) continue;
            this.add(string2);
        }
    }

    private MessageDigest getDigest(String string) throws NoSuchAlgorithmException {
        MessageDigest messageDigest = (MessageDigest)this.digests.get(string);
        if (messageDigest == null) {
            messageDigest = MessageDigest.getInstance(string);
            this.digests.put(string, messageDigest);
        }
        messageDigest.reset();
        return messageDigest;
    }

    public MessageHeader getEntry(String string) {
        Enumeration enumeration = this.entries();
        while (enumeration.hasMoreElements()) {
            MessageHeader messageHeader = (MessageHeader)enumeration.nextElement();
            if (!string.equals(messageHeader.findValue("Name"))) continue;
            return messageHeader;
        }
        return null;
    }

    private MessageHeader computeEntry(MessageHeader messageHeader) throws IOException {
        MessageHeader messageHeader2 = new MessageHeader();
        String string = messageHeader.findValue("Name");
        if (string == null) {
            return null;
        }
        messageHeader2.set("Name", string);
        BASE64Encoder bASE64Encoder = new BASE64Encoder();
        try {
            int n2 = 0;
            while (n2 < hashes.length) {
                MessageDigest messageDigest = this.getDigest(hashes[n2]);
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                PrintStream printStream = new PrintStream(byteArrayOutputStream);
                messageHeader.print(printStream);
                byte[] byArray = byteArrayOutputStream.toByteArray();
                byte[] byArray2 = messageDigest.digest(byArray);
                messageHeader2.set(hashes[n2] + "-Digest", bASE64Encoder.encode(byArray2));
                ++n2;
            }
            return messageHeader2;
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new JarException(noSuchAlgorithmException.getMessage());
        }
    }

    public SignatureFile(Manifest manifest, String[] stringArray, String string) throws JarException {
        this(string, true);
        this.manifest = manifest;
        this.add(stringArray);
    }
}

