/*
 * Decompiled with CFR 0.152.
 */
package sun.text;

import sun.text.Utility;

public final class CompactCharArray
implements Cloneable {
    public static final int UNICODECOUNT = 65536;
    private static final int BLOCKSHIFT = 5;
    private static final int BLOCKCOUNT = 32;
    private static final int INDEXSHIFT = 11;
    private static final int INDEXCOUNT = 2048;
    private static final int BLOCKMASK = 31;
    private char[] values;
    private char[] indices;
    private int[] hashes;
    private boolean isCompact;
    private char defaultValue;

    public int hashCode() {
        int n2 = 0;
        int n3 = Math.min(3, this.values.length / 16);
        int n4 = 0;
        while (n4 < this.values.length) {
            n2 = n2 * 37 + this.values[n4];
            n4 += n3;
        }
        return n2;
    }

    public CompactCharArray() {
        this('\u0000');
    }

    public void compact() {
        if (!this.isCompact) {
            int n2;
            int n3 = 0;
            int n4 = 0;
            int n5 = 65535;
            int n6 = 0;
            while (n6 < this.indices.length) {
                this.indices[n6] = 65535;
                n2 = this.blockTouched(n6) ? 1 : 0;
                if (n2 == 0 && n5 != 65535) {
                    this.indices[n6] = n5;
                } else {
                    int n7 = 0;
                    int n8 = 0;
                    n8 = 0;
                    while (n8 < n3) {
                        if (this.hashes[n6] == this.hashes[n8] && CompactCharArray.arrayRegionMatches(this.values, n4, this.values, n7, 32)) {
                            this.indices[n6] = (char)n7;
                        }
                        ++n8;
                        n7 += 32;
                    }
                    if (this.indices[n6] == '\uffff') {
                        System.arraycopy(this.values, n4, this.values, n7, 32);
                        this.indices[n6] = (char)n7;
                        this.hashes[n8] = this.hashes[n6];
                        ++n3;
                        if (n2 == 0) {
                            n5 = (char)n7;
                        }
                    }
                }
                ++n6;
                n4 += 32;
            }
            n2 = n3 * 32;
            char[] cArray = new char[n2];
            System.arraycopy(this.values, 0, cArray, 0, n2);
            this.values = cArray;
            this.isCompact = true;
            this.hashes = null;
        }
    }

    private void expand() {
        if (this.isCompact) {
            char[] cArray = new char[65536];
            this.hashes = new int[2048];
            int n2 = 0;
            while (n2 < 65536) {
                char c2;
                cArray[n2] = c2 = this.elementAt((char)n2);
                this.touchBlock(n2 >> 5, c2);
                ++n2;
            }
            n2 = 0;
            while (n2 < 2048) {
                this.indices[n2] = (char)(n2 << 5);
                ++n2;
            }
            this.values = null;
            this.values = cArray;
            this.isCompact = false;
        }
    }

    public char[] getIndexArray() {
        return this.indices;
    }

    public char[] getStringArray() {
        return this.values;
    }

    public char elementAt(char c2) {
        return this.values[(this.indices[c2 >> 5] & 0xFFFF) + (c2 & 0x1F)];
    }

    public CompactCharArray(char c2) {
        this.values = new char[65536];
        this.indices = new char[2048];
        this.hashes = new int[2048];
        int n2 = 0;
        while (n2 < 65536) {
            this.values[n2] = c2;
            ++n2;
        }
        n2 = 0;
        while (n2 < 2048) {
            this.indices[n2] = (char)(n2 << 5);
            this.hashes[n2] = 0;
            ++n2;
        }
        this.isCompact = false;
        this.defaultValue = c2;
    }

    public void setElementAt(char c2, char c3) {
        if (this.isCompact) {
            this.expand();
        }
        this.values[c2] = c3;
        this.touchBlock(c2 >> 5, c3);
    }

    public void setElementAt(char n2, char c2, char c3) {
        if (this.isCompact) {
            this.expand();
        }
        int n3 = n2;
        while (n3 <= c2) {
            this.values[n3] = c3;
            this.touchBlock(n3 >> 5, c3);
            ++n3;
        }
    }

    private char getArrayValue(int n2) {
        return this.values[n2];
    }

    private char getIndexArrayValue(int n2) {
        return this.indices[n2];
    }

    private final boolean blockTouched(int n2) {
        return this.hashes[n2] != 0;
    }

    private final void touchBlock(int n2, int n3) {
        this.hashes[n2] = this.hashes[n2] + (n3 << 1) | 1;
    }

    static final boolean arrayRegionMatches(char[] cArray, int n2, char[] cArray2, int n3, int n4) {
        int n5 = n2 + n4;
        int n6 = n3 - n2;
        int n7 = n2;
        while (n7 < n5) {
            if (cArray[n7] != cArray2[n7 + n6]) {
                return false;
            }
            ++n7;
        }
        return true;
    }

    public CompactCharArray(char[] cArray, char[] cArray2) {
        if (cArray.length != 2048) {
            throw new IllegalArgumentException("Index out of bounds.");
        }
        int n2 = 0;
        while (n2 < 2048) {
            char c2 = cArray[n2];
            if (c2 < '\u0000' || c2 >= cArray2.length + 32) {
                throw new IllegalArgumentException("Index out of bounds.");
            }
            ++n2;
        }
        this.indices = cArray;
        this.values = cArray2;
        this.isCompact = true;
    }

    public Object clone() {
        try {
            CompactCharArray compactCharArray = (CompactCharArray)super.clone();
            compactCharArray.values = (char[])this.values.clone();
            compactCharArray.indices = (char[])this.indices.clone();
            if (this.hashes != null) {
                compactCharArray.hashes = (int[])this.hashes.clone();
            }
            return compactCharArray;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError();
        }
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (this == object) {
            return true;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        CompactCharArray compactCharArray = (CompactCharArray)object;
        int n2 = 0;
        while (n2 < 65536) {
            if (this.elementAt((char)n2) != compactCharArray.elementAt((char)n2)) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    public CompactCharArray(String string, String string2) {
        this(Utility.RLEStringToCharArray(string), Utility.RLEStringToCharArray(string2));
    }
}

