/*
 * Decompiled with CFR 0.152.
 */
package sun.security.x509;

import java.io.IOException;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import sun.security.util.DerInputStream;
import sun.security.util.DerOutputStream;
import sun.security.util.DerValue;
import sun.security.util.ObjectIdentifier;
import sun.security.x509.GeneralNameInterface;
import sun.security.x509.OIDMap;

public class OtherName
implements GeneralNameInterface {
    private String name;
    private ObjectIdentifier oid;
    private byte[] nameValue = null;
    private GeneralNameInterface gni = null;
    private static final byte TAG_VALUE = 0;
    static Class class$java$lang$Object;

    public int getType() {
        return 0;
    }

    public int subtreeDepth() throws UnsupportedOperationException {
        throw new UnsupportedOperationException("subtreeDepth() not supported for generic OtherName");
    }

    public byte[] getNameValue() {
        return (byte[])this.nameValue.clone();
    }

    public boolean equals(Object object) {
        boolean bl2;
        if (!(object instanceof OtherName)) {
            return false;
        }
        if (this == object) {
            return true;
        }
        OtherName otherName = (OtherName)object;
        if (!otherName.oid.equals(this.oid)) {
            return false;
        }
        GeneralNameInterface generalNameInterface = null;
        try {
            generalNameInterface = this.getGNI(otherName.oid, otherName.nameValue);
        }
        catch (IOException iOException) {
            return false;
        }
        if (generalNameInterface != null) {
            try {
                bl2 = generalNameInterface.constrains(this) == 0;
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                bl2 = false;
            }
        } else {
            bl2 = Arrays.equals(this.nameValue, otherName.nameValue);
        }
        return bl2;
    }

    public String toString() {
        return "Other-Name: " + this.name;
    }

    public void encode(DerOutputStream derOutputStream) throws IOException {
        if (this.gni != null) {
            this.gni.encode(derOutputStream);
            return;
        }
        DerOutputStream derOutputStream2 = new DerOutputStream();
        derOutputStream2.putOID(this.oid);
        derOutputStream2.write(DerValue.createTag((byte)-128, true, (byte)0), this.nameValue);
        derOutputStream.write((byte)48, derOutputStream2);
    }

    public OtherName(DerValue derValue) throws IOException {
        DerInputStream derInputStream = derValue.toDerInputStream();
        this.oid = derInputStream.getOID();
        DerValue derValue2 = derInputStream.getDerValue();
        this.nameValue = derValue2.toByteArray();
        this.gni = this.getGNI(this.oid, this.nameValue);
        this.name = this.gni != null ? this.gni.toString() : "Unrecognized ObjectIdentifier: " + this.oid.toString();
    }

    public ObjectIdentifier getOID() {
        return this.oid;
    }

    public OtherName(ObjectIdentifier objectIdentifier, byte[] byArray) throws IOException {
        if (objectIdentifier == null || byArray == null) {
            throw new IOException("parameters may not be null");
        }
        this.oid = objectIdentifier;
        this.nameValue = byArray;
        this.gni = this.getGNI(objectIdentifier, byArray);
        this.name = this.gni != null ? this.gni.toString() : "Unrecognized ObjectIdentifier: " + objectIdentifier.toString();
    }

    public int constrains(GeneralNameInterface generalNameInterface) throws UnsupportedOperationException {
        int n2;
        if (generalNameInterface == null) {
            n2 = -1;
        } else if (generalNameInterface.getType() != 0) {
            n2 = -1;
        } else {
            throw new UnsupportedOperationException("Narrowing, widening, and matching are not supported for OtherName.");
        }
        return n2;
    }

    static Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private GeneralNameInterface getGNI(ObjectIdentifier objectIdentifier, byte[] byArray) throws IOException {
        try {
            Class clazz = OIDMap.getClass(objectIdentifier);
            if (clazz == null) {
                return null;
            }
            Class[] classArray = new Class[]{class$java$lang$Object == null ? (class$java$lang$Object = OtherName.class$("java.lang.Object")) : class$java$lang$Object};
            Constructor constructor = clazz.getConstructor(classArray);
            int n2 = byArray.length;
            Object object = Array.newInstance(Byte.TYPE, n2);
            int n3 = 0;
            while (n3 < n2) {
                Array.setByte(object, n3, byArray[n3]);
                ++n3;
            }
            Object[] objectArray = new Object[]{object};
            GeneralNameInterface generalNameInterface = (GeneralNameInterface)constructor.newInstance(objectArray);
            return generalNameInterface;
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new IOException(noSuchMethodException.toString());
        }
        catch (InvocationTargetException invocationTargetException) {
            throw (IOException)new IOException(invocationTargetException.getTargetException().toString()).initCause(invocationTargetException);
        }
        catch (Exception exception) {
            throw new IOException(exception.toString());
        }
    }
}

