/*
 * Decompiled with CFR 0.152.
 */
package sun.security.x509;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Array;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateParsingException;
import java.security.cert.X509Certificate;
import java.util.Enumeration;
import java.util.Vector;
import sun.security.util.DerOutputStream;
import sun.security.util.DerValue;
import sun.security.x509.AttributeNameEnumeration;
import sun.security.x509.CertAttrSet;
import sun.security.x509.CertificateExtensions;
import sun.security.x509.CertificateSubjectName;
import sun.security.x509.Extension;
import sun.security.x509.GeneralName;
import sun.security.x509.GeneralNameInterface;
import sun.security.x509.GeneralNames;
import sun.security.x509.GeneralSubtree;
import sun.security.x509.GeneralSubtrees;
import sun.security.x509.PKIXExtensions;
import sun.security.x509.SubjectAlternativeNameExtension;
import sun.security.x509.X500Name;
import sun.security.x509.X509CertInfo;

public class NameConstraintsExtension
extends Extension
implements CertAttrSet {
    public static final String IDENT = "x509.info.extensions.NameConstraints";
    public static final String NAME = "NameConstraints";
    public static final String PERMITTED_SUBTREES = "permitted_subtrees";
    public static final String EXCLUDED_SUBTREES = "excluded_subtrees";
    private static final byte TAG_PERMITTED = 0;
    private static final byte TAG_EXCLUDED = 1;
    private GeneralSubtrees permitted = null;
    private GeneralSubtrees excluded = null;
    private boolean hasMin;
    private boolean hasMax;
    private boolean minMaxValid = false;

    private void calcMinMax() throws IOException {
        GeneralSubtree generalSubtree;
        int n2;
        this.hasMin = false;
        this.hasMax = false;
        if (this.excluded != null) {
            n2 = 0;
            while (n2 < this.excluded.size()) {
                generalSubtree = (GeneralSubtree)this.excluded.elementAt(n2);
                if (generalSubtree.getMinimum() != 0) {
                    this.hasMin = true;
                }
                if (generalSubtree.getMaximum() != -1) {
                    this.hasMax = true;
                }
                ++n2;
            }
        }
        if (this.permitted != null) {
            n2 = 0;
            while (n2 < this.permitted.size()) {
                generalSubtree = (GeneralSubtree)this.permitted.elementAt(n2);
                if (generalSubtree.getMinimum() != 0) {
                    this.hasMin = true;
                }
                if (generalSubtree.getMaximum() != -1) {
                    this.hasMax = true;
                }
                ++n2;
            }
        }
        this.minMaxValid = true;
    }

    private void encodeThis() throws IOException {
        DerOutputStream derOutputStream;
        this.minMaxValid = false;
        if (this.permitted == null && this.excluded == null) {
            this.extensionValue = null;
            return;
        }
        DerOutputStream derOutputStream2 = new DerOutputStream();
        DerOutputStream derOutputStream3 = new DerOutputStream();
        if (this.permitted != null) {
            derOutputStream = new DerOutputStream();
            this.permitted.encode(derOutputStream);
            derOutputStream3.writeImplicit(DerValue.createTag((byte)-128, true, (byte)0), derOutputStream);
        }
        if (this.excluded != null) {
            derOutputStream = new DerOutputStream();
            this.excluded.encode(derOutputStream);
            derOutputStream3.writeImplicit(DerValue.createTag((byte)-128, true, (byte)1), derOutputStream);
        }
        derOutputStream2.write((byte)48, derOutputStream3);
        this.extensionValue = derOutputStream2.toByteArray();
    }

    public void decode(InputStream inputStream) throws IOException {
        throw new IOException("Method not to be called directly.");
    }

    public void encode(OutputStream outputStream) throws IOException {
        DerOutputStream derOutputStream = new DerOutputStream();
        if (this.extensionValue == null) {
            this.extensionId = PKIXExtensions.NameConstraints_Id;
            this.critical = true;
            this.encodeThis();
        }
        super.encode(derOutputStream);
        outputStream.write(derOutputStream.toByteArray());
    }

    public String getName() {
        return NAME;
    }

    public String toString() {
        return super.toString() + "NameConstraints: [" + (this.permitted == null ? "" : "\n    Permitted:" + this.permitted.toString()) + (this.excluded == null ? "" : "\n    Excluded:" + this.excluded.toString()) + "   ]\n";
    }

    public void delete(String string) throws IOException {
        if (string.equalsIgnoreCase(PERMITTED_SUBTREES)) {
            this.permitted = null;
        } else if (string.equalsIgnoreCase(EXCLUDED_SUBTREES)) {
            this.excluded = null;
        } else {
            throw new IOException("Attribute name not recognized by CertAttrSet:NameConstraintsExtension.");
        }
        this.encodeThis();
    }

    public boolean verify(X509Certificate x509Certificate) throws IOException {
        Object object;
        Vector vector;
        block19: {
            Object object2;
            if (x509Certificate == null) {
                throw new IOException("Certificate is null");
            }
            vector = null;
            byte[] byArray = null;
            X509CertInfo x509CertInfo = null;
            if (!this.minMaxValid) {
                this.calcMinMax();
            }
            if (this.hasMin) {
                throw new IOException("Non-zero minimum BaseDistance in name constraints not supported");
            }
            if (this.hasMax) {
                throw new IOException("Maximum BaseDistance in name constraints not supported");
            }
            try {
                byArray = x509Certificate.getTBSCertificate();
            }
            catch (CertificateEncodingException certificateEncodingException) {
                throw new IOException("Unable to extract TBSCertificate from X509Certificate: " + certificateEncodingException.getMessage());
            }
            try {
                x509CertInfo = new X509CertInfo(byArray);
            }
            catch (CertificateParsingException certificateParsingException) {
                throw new IOException("Unable to create certificate info from X509Certificate: " + certificateParsingException.getMessage());
            }
            try {
                X500Name x500Name;
                object2 = x509Certificate.getSubjectDN();
                if (object2 != null && object2.getName() != null && !this.verify(x500Name = (X500Name)((CertificateSubjectName)(object = (CertificateSubjectName)x509CertInfo.get("subject"))).get("dname"))) {
                    return false;
                }
            }
            catch (CertificateException certificateException) {
                throw new IOException("Unable to extract certificate subject: " + certificateException.getMessage());
            }
            try {
                object2 = (CertificateExtensions)x509CertInfo.get("extensions");
                if (object2 == null) break block19;
                object = null;
                try {
                    object = (SubjectAlternativeNameExtension)((CertificateExtensions)object2).get("SubjectAlternativeName");
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                if (object != null) {
                    vector = (GeneralNames)((SubjectAlternativeNameExtension)object).get("subject_name");
                }
            }
            catch (CertificateException certificateException) {
                throw new IOException("Unable to extract extensions from certificate: " + certificateException.getMessage());
            }
        }
        if (vector == null) {
            return true;
        }
        int n2 = 0;
        while (n2 < vector.size()) {
            object = ((GeneralName)vector.elementAt(n2)).getName();
            if (!this.verify((GeneralNameInterface)object)) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    public Enumeration getElements() {
        AttributeNameEnumeration attributeNameEnumeration = new AttributeNameEnumeration();
        attributeNameEnumeration.addElement(PERMITTED_SUBTREES);
        attributeNameEnumeration.addElement(EXCLUDED_SUBTREES);
        return attributeNameEnumeration.elements();
    }

    public boolean verify(GeneralNameInterface generalNameInterface) throws IOException {
        Object object;
        Object object2;
        int n2;
        if (generalNameInterface == null) {
            throw new IOException("name is null");
        }
        if (this.excluded != null && this.excluded.size() > 0) {
            n2 = 0;
            while (n2 < this.excluded.size()) {
                GeneralSubtree generalSubtree = (GeneralSubtree)this.excluded.get(n2);
                if (generalSubtree != null && (object2 = generalSubtree.getName()) != null && (object = ((GeneralName)object2).getName()) != null) {
                    switch (object.constrains(generalNameInterface)) {
                        case -1: 
                        case 2: 
                        case 3: {
                            break;
                        }
                        case 0: 
                        case 1: {
                            return false;
                        }
                    }
                }
                ++n2;
            }
        }
        if (this.permitted != null && this.permitted.size() > 0) {
            n2 = 0;
            int n3 = 0;
            while (n3 < this.permitted.size()) {
                GeneralNameInterface generalNameInterface2;
                object2 = (GeneralSubtree)this.permitted.get(n3);
                if (object2 != null && (object = ((GeneralSubtree)object2).getName()) != null && (generalNameInterface2 = ((GeneralName)object).getName()) != null) {
                    switch (generalNameInterface2.constrains(generalNameInterface)) {
                        case -1: {
                            break;
                        }
                        case 2: 
                        case 3: {
                            n2 = 1;
                            break;
                        }
                        case 0: 
                        case 1: {
                            return true;
                        }
                    }
                }
                ++n3;
            }
            if (n2 != 0) {
                return false;
            }
        }
        return true;
    }

    public void merge(NameConstraintsExtension nameConstraintsExtension) throws IOException {
        if (nameConstraintsExtension == null) {
            return;
        }
        GeneralSubtrees generalSubtrees = (GeneralSubtrees)nameConstraintsExtension.get(EXCLUDED_SUBTREES);
        if (this.excluded == null) {
            this.excluded = generalSubtrees != null ? (GeneralSubtrees)generalSubtrees.clone() : null;
        } else if (generalSubtrees != null) {
            this.excluded.union(generalSubtrees);
        }
        GeneralSubtrees generalSubtrees2 = (GeneralSubtrees)nameConstraintsExtension.get(PERMITTED_SUBTREES);
        if (this.permitted == null) {
            this.permitted = generalSubtrees2 != null ? (GeneralSubtrees)generalSubtrees2.clone() : null;
        } else if (generalSubtrees2 != null && (generalSubtrees = this.permitted.intersect(generalSubtrees2)) != null) {
            if (this.excluded != null) {
                this.excluded.union(generalSubtrees);
            } else {
                this.excluded = (GeneralSubtrees)generalSubtrees.clone();
            }
        }
        if (this.permitted != null) {
            this.permitted.reduce(this.excluded);
        }
        this.encodeThis();
    }

    /*
     * Unable to fully structure code
     */
    public NameConstraintsExtension(Boolean var1_1, Object var2_2) throws IOException {
        super();
        this.extensionId = PKIXExtensions.NameConstraints_Id;
        this.critical = var1_1;
        if (!(var2_2 instanceof byte[])) {
            throw new IOException("Illegal argument type");
        }
        var3_3 = Array.getLength(var2_2);
        var4_4 = new byte[var3_3];
        System.arraycopy(var2_2, 0, var4_4, 0, var3_3);
        this.extensionValue = var4_4;
        var5_5 = new DerValue(var4_4);
        if (var5_5.tag != 48) {
            throw new IOException("Invalid encoding for NameConstraintsExtension.");
        }
        if (var5_5.data != null) ** GOTO lbl32
        return;
lbl-1000:
        // 1 sources

        {
            var6_6 = var5_5.data.getDerValue();
            if (var6_6.isContextSpecific((byte)0) && var6_6.isConstructed()) {
                if (this.permitted != null) {
                    throw new IOException("Duplicate permitted GeneralSubtrees in NameConstraintsExtension.");
                }
                var6_6.resetTag((byte)48);
                this.permitted = new GeneralSubtrees(var6_6);
                continue;
            }
            if (var6_6.isContextSpecific((byte)1) && var6_6.isConstructed()) {
                if (this.excluded != null) {
                    throw new IOException("Duplicate excluded GeneralSubtrees in NameConstraintsExtension.");
                }
                var6_6.resetTag((byte)48);
                this.excluded = new GeneralSubtrees(var6_6);
                continue;
            }
            throw new IOException("Invalid encoding of NameConstraintsExtension.");
lbl32:
            // 3 sources

            ** while (var5_5.data.available() != 0)
        }
lbl33:
        // 1 sources

        this.minMaxValid = false;
    }

    public Object get(String string) throws IOException {
        if (string.equalsIgnoreCase(PERMITTED_SUBTREES)) {
            return this.permitted;
        }
        if (string.equalsIgnoreCase(EXCLUDED_SUBTREES)) {
            return this.excluded;
        }
        throw new IOException("Attribute name not recognized by CertAttrSet:NameConstraintsExtension.");
    }

    public void set(String string, Object object) throws IOException {
        if (string.equalsIgnoreCase(PERMITTED_SUBTREES)) {
            if (!(object instanceof GeneralSubtrees)) {
                throw new IOException("Attribute value should be of type GeneralSubtrees.");
            }
            this.permitted = (GeneralSubtrees)object;
        } else if (string.equalsIgnoreCase(EXCLUDED_SUBTREES)) {
            if (!(object instanceof GeneralSubtrees)) {
                throw new IOException("Attribute value should be of type GeneralSubtrees.");
            }
            this.excluded = (GeneralSubtrees)object;
        } else {
            throw new IOException("Attribute name not recognized by CertAttrSet:NameConstraintsExtension.");
        }
        this.encodeThis();
    }

    public NameConstraintsExtension(GeneralSubtrees generalSubtrees, GeneralSubtrees generalSubtrees2) throws IOException {
        this.permitted = generalSubtrees;
        this.excluded = generalSubtrees2;
        this.extensionId = PKIXExtensions.NameConstraints_Id;
        this.critical = true;
        this.encodeThis();
    }
}

