/*
 * Decompiled with CFR 0.152.
 */
package sun.security.x509;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Array;
import java.math.BigInteger;
import java.util.Enumeration;
import sun.security.util.Debug;
import sun.security.util.DerOutputStream;
import sun.security.util.DerValue;
import sun.security.x509.AttributeNameEnumeration;
import sun.security.x509.CertAttrSet;
import sun.security.x509.Extension;
import sun.security.x509.PKIXExtensions;

public class CRLNumberExtension
extends Extension
implements CertAttrSet {
    public static final String NAME = "CRLNumber";
    public static final String NUMBER = "value";
    private BigInteger crlNumber = null;

    private void encodeThis() throws IOException {
        if (this.crlNumber == null) {
            this.extensionValue = null;
            return;
        }
        DerOutputStream derOutputStream = new DerOutputStream();
        derOutputStream.putInteger(this.crlNumber);
        this.extensionValue = derOutputStream.toByteArray();
    }

    public CRLNumberExtension(int n2) throws IOException {
        this.crlNumber = BigInteger.valueOf(n2);
        this.extensionId = PKIXExtensions.CRLNumber_Id;
        this.critical = false;
        this.encodeThis();
    }

    public void decode(InputStream inputStream) throws IOException {
        throw new IOException("Method not to be called directly.");
    }

    public void encode(OutputStream outputStream) throws IOException {
        DerOutputStream derOutputStream = new DerOutputStream();
        if (this.extensionValue == null) {
            this.extensionId = PKIXExtensions.CRLNumber_Id;
            this.critical = true;
            this.encodeThis();
        }
        super.encode(derOutputStream);
        outputStream.write(derOutputStream.toByteArray());
    }

    public String getName() {
        return NAME;
    }

    public String toString() {
        String string = super.toString() + "CRL Number: " + (this.crlNumber == null ? "" : Debug.toHexString(this.crlNumber)) + "\n";
        return string;
    }

    public void delete(String string) throws IOException {
        if (!string.equalsIgnoreCase(NUMBER)) {
            throw new IOException("Attribute name not recognized by CertAttrSet:CRLNumber.");
        }
        this.crlNumber = null;
        this.encodeThis();
    }

    public CRLNumberExtension(BigInteger bigInteger) throws IOException {
        this.crlNumber = bigInteger;
        this.extensionId = PKIXExtensions.CRLNumber_Id;
        this.critical = false;
        this.encodeThis();
    }

    public Enumeration getElements() {
        AttributeNameEnumeration attributeNameEnumeration = new AttributeNameEnumeration();
        attributeNameEnumeration.addElement(NUMBER);
        return attributeNameEnumeration.elements();
    }

    public CRLNumberExtension(Boolean bl2, Object object) throws IOException {
        this.extensionId = PKIXExtensions.CRLNumber_Id;
        this.critical = bl2;
        int n2 = Array.getLength(object);
        byte[] byArray = new byte[n2];
        int n3 = 0;
        while (n3 < n2) {
            byArray[n3] = Array.getByte(object, n3);
            ++n3;
        }
        this.extensionValue = byArray;
        DerValue derValue = new DerValue(byArray);
        this.crlNumber = derValue.getBigInteger();
    }

    public Object get(String string) throws IOException {
        if (string.equalsIgnoreCase(NUMBER)) {
            if (this.crlNumber == null) {
                return null;
            }
            return this.crlNumber;
        }
        throw new IOException("Attribute name not recognized by CertAttrSet:CRLNumber.");
    }

    public void set(String string, Object object) throws IOException {
        if (string.equalsIgnoreCase(NUMBER)) {
            if (!(object instanceof BigInteger)) {
                throw new IOException("Attribute must be of type BigInteger.");
            }
        } else {
            throw new IOException("Attribute name not recognized by CertAttrSet:CRLNumber.");
        }
        this.crlNumber = (BigInteger)object;
        this.encodeThis();
    }
}

