/*
 * Decompiled with CFR 0.152.
 */
package sun.security.util;

import java.io.IOException;
import java.io.Serializable;
import sun.security.util.DerInputBuffer;
import sun.security.util.DerInputStream;
import sun.security.util.DerOutputStream;

public final class ObjectIdentifier
implements Serializable {
    private static final long serialVersionUID = 8697030238860181294L;
    private static final int maxFirstComponent = 2;
    private static final int maxSecondComponent = 39;
    private int[] components;
    private int componentLen;
    private static final int allocationQuantum = 5;

    public int hashCode() {
        return this.toString().hashCode();
    }

    public ObjectIdentifier(int[] nArray) throws IOException {
        if (nArray.length >= 1 && (nArray[0] < 0 || nArray[0] > 2)) {
            throw new IOException("First oid component is invalid ");
        }
        if (nArray.length >= 2 && (nArray[1] < 0 || nArray[1] > 39)) {
            throw new IOException("Second oid component is invalid ");
        }
        this.components = (int[])nArray.clone();
        this.componentLen = nArray.length;
    }

    public boolean equals(Object object) {
        if (object instanceof ObjectIdentifier) {
            return this.equals((ObjectIdentifier)object);
        }
        return false;
    }

    public String toString() {
        int n2 = 0;
        String string = "";
        while (n2 < this.componentLen) {
            if (n2 != 0) {
                string = string + ".";
            }
            string = string + this.components[n2];
            ++n2;
        }
        return string;
    }

    public ObjectIdentifier(String string) throws IOException {
        int n2 = 46;
        int n3 = 0;
        int n4 = 0;
        this.componentLen = 0;
        while ((n4 = string.indexOf(n2, n3)) != -1) {
            n3 = n4 + 1;
            ++this.componentLen;
        }
        ++this.componentLen;
        this.components = new int[this.componentLen];
        n3 = 0;
        int n5 = 0;
        String string2 = null;
        while ((n4 = string.indexOf(n2, n3)) != -1) {
            string2 = string.substring(n3, n4);
            this.components[n5++] = Integer.valueOf(string2);
            if (this.components[n5++] < 0) {
                throw new IOException("oid components must be nonnegative");
            }
            n3 = n4 + 1;
        }
        string2 = string.substring(n3);
        this.components[n5] = Integer.valueOf(string2);
        if (this.components[0] < 0 || this.components[0] > 2) {
            throw new IOException("First oid component is invalid ");
        }
        if (this.components[1] < 0 || this.components[1] > 39) {
            throw new IOException("Second oid component is invalid ");
        }
    }

    ObjectIdentifier(DerInputBuffer derInputBuffer) throws IOException {
        this.initFromEncoding(new DerInputStream(derInputBuffer), 0);
    }

    private static int getComponent(DerInputStream derInputStream) throws IOException {
        int n2 = 0;
        int n3 = 0;
        while (n2 < 4) {
            n3 <<= 7;
            int n4 = derInputStream.getByte();
            n3 |= n4 & 0x7F;
            if ((n4 & 0x80) == 0) {
                return n3;
            }
            ++n2;
        }
        throw new IOException("X509.OID, component value too big");
    }

    public ObjectIdentifier(DerInputStream derInputStream) throws IOException {
        byte by = (byte)derInputStream.getByte();
        if (by != 6) {
            throw new IOException("X509.ObjectIdentifier() -- data isn't an object ID (tag = " + by + ")");
        }
        int n2 = derInputStream.available() - derInputStream.getLength() - 1;
        if (n2 < 0) {
            throw new IOException("X509.ObjectIdentifier() -- not enough data");
        }
        this.initFromEncoding(derInputStream, n2);
    }

    private void initFromEncoding(DerInputStream derInputStream, int n2) throws IOException {
        boolean bl2 = true;
        this.components = new int[5];
        this.componentLen = 0;
        while (derInputStream.available() > n2) {
            int n3 = ObjectIdentifier.getComponent(derInputStream);
            if (n3 < 0) {
                throw new IOException("X509.ObjectIdentifier() -- component values must be nonnegative");
            }
            if (bl2) {
                int n4 = n3 < 40 ? 0 : (n3 < 80 ? 1 : 2);
                int n5 = n3 - n4 * 40;
                if (n5 > 39) {
                    throw new IOException("X509.ObjectIdentifier() -- Invalid second component");
                }
                this.components[0] = n4;
                this.components[1] = n5;
                this.componentLen = 2;
                bl2 = false;
                continue;
            }
            if (this.componentLen >= this.components.length) {
                int[] nArray = new int[this.components.length + 5];
                System.arraycopy(this.components, 0, nArray, 0, this.components.length);
                this.components = nArray;
            }
            this.components[this.componentLen++] = n3;
        }
        if (derInputStream.available() != n2) {
            throw new IOException("X509.ObjectIdentifier() -- malformed input data");
        }
    }

    void encode(DerOutputStream derOutputStream) throws IOException {
        DerOutputStream derOutputStream2 = new DerOutputStream();
        derOutputStream2.write(this.components[0] * 40 + this.components[1]);
        int n2 = 2;
        while (n2 < this.componentLen) {
            ObjectIdentifier.putComponent(derOutputStream2, this.components[n2]);
            ++n2;
        }
        derOutputStream.write((byte)6, derOutputStream2);
    }

    private static void putComponent(DerOutputStream derOutputStream, int n2) throws IOException {
        byte[] byArray = new byte[4];
        int n3 = 0;
        while (n3 < 4) {
            byArray[n3] = (byte)(n2 & 0x7F);
            if ((n2 >>>= 7) == 0) break;
            ++n3;
        }
        while (n3 > 0) {
            derOutputStream.write(byArray[n3] | 0x80);
            --n3;
        }
        derOutputStream.write(byArray[0]);
    }

    public boolean equals(ObjectIdentifier objectIdentifier) {
        if (objectIdentifier == this) {
            return true;
        }
        if (this.componentLen != objectIdentifier.componentLen) {
            return false;
        }
        int n2 = 0;
        while (n2 < this.componentLen) {
            if (this.components[n2] != objectIdentifier.components[n2]) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    public boolean precedes(ObjectIdentifier objectIdentifier) {
        if (objectIdentifier == this || this.componentLen < objectIdentifier.componentLen) {
            return false;
        }
        if (objectIdentifier.componentLen < this.componentLen) {
            return true;
        }
        int n2 = 0;
        while (n2 < this.componentLen) {
            if (objectIdentifier.components[n2] < this.components[n2]) {
                return true;
            }
            ++n2;
        }
        return false;
    }
}

