/*
 * Decompiled with CFR 0.152.
 */
package sun.security.util;

import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.util.Date;
import java.util.Vector;
import sun.security.util.BitArray;
import sun.security.util.DerIndefLenConverter;
import sun.security.util.DerInputBuffer;
import sun.security.util.DerValue;
import sun.security.util.ObjectIdentifier;

public class DerInputStream {
    DerInputBuffer buffer;

    public int available() {
        return this.buffer.available();
    }

    int getByte() throws IOException {
        return 0xFF & this.buffer.read();
    }

    public int getEnumerated() throws IOException {
        if (this.buffer.read() != 10) {
            throw new IOException("DER input, Enumerated tag error");
        }
        return this.buffer.getInteger(DerInputStream.getLength(this.buffer));
    }

    public int getInteger() throws IOException {
        if (this.buffer.read() != 2) {
            throw new IOException("DER input, Integer tag error");
        }
        return this.buffer.getInteger(DerInputStream.getLength(this.buffer));
    }

    int getLength() throws IOException {
        return DerInputStream.getLength(this.buffer);
    }

    public int peekByte() throws IOException {
        return this.buffer.peek();
    }

    public void getNull() throws IOException {
        if (this.buffer.read() != 5 || this.buffer.read() != 0) {
            throw new IOException("getNull, bad data");
        }
    }

    public void reset() {
        this.buffer.reset();
    }

    public byte[] getBitString() throws IOException {
        if (this.buffer.read() != 3) {
            throw new IOException("DER input not an bit string");
        }
        return this.buffer.getBitString(DerInputStream.getLength(this.buffer));
    }

    public byte[] getOctetString() throws IOException {
        if (this.buffer.read() != 4) {
            throw new IOException("DER input not an octet string");
        }
        int n2 = DerInputStream.getLength(this.buffer);
        byte[] byArray = new byte[n2];
        if (n2 != 0 && this.buffer.read(byArray) != n2) {
            throw new IOException("short read of DER octet string");
        }
        return byArray;
    }

    public byte[] toByteArray() {
        return this.buffer.toByteArray();
    }

    public void mark(int n2) {
        this.buffer.mark(n2);
    }

    public DerInputStream(byte[] byArray) throws IOException {
        this.init(byArray, 0, byArray.length);
    }

    public void getBytes(byte[] byArray) throws IOException {
        if (byArray.length != 0 && this.buffer.read(byArray) != byArray.length) {
            throw new IOException("short read of DER octet string");
        }
    }

    public DerInputStream(byte[] byArray, int n2, int n3) throws IOException {
        this.init(byArray, n2, n3);
    }

    private void init(byte[] byArray, int n2, int n3) throws IOException {
        if (n2 + 2 > byArray.length || n2 + n3 > byArray.length) {
            throw new IOException("Encoding bytes too short");
        }
        if (DerIndefLenConverter.isIndefinite(byArray[n2 + 1])) {
            byte[] byArray2 = new byte[n3];
            System.arraycopy(byArray, n2, byArray2, 0, n3);
            DerIndefLenConverter derIndefLenConverter = new DerIndefLenConverter();
            this.buffer = new DerInputBuffer(derIndefLenConverter.convert(byArray2));
        } else {
            this.buffer = new DerInputBuffer(byArray, n2, n3);
        }
        this.buffer.mark(Integer.MAX_VALUE);
    }

    static int getLength(int n2, InputStream inputStream) throws IOException {
        int n3;
        int n4 = n2;
        if ((n4 & 0x80) == 0) {
            n3 = n4;
        } else {
            if ((n4 &= 0x7F) == 0) {
                return -1;
            }
            if (n4 < 0 || n4 > 4) {
                throw new IOException("DerInputStream.getLength(): lengthTag=" + n4 + ", " + (n4 < 0 ? "incorrect DER encoding." : "too big."));
            }
            n3 = 0;
            while (n4 > 0) {
                n3 <<= 8;
                n3 += 0xFF & inputStream.read();
                --n4;
            }
        }
        return n3;
    }

    static int getLength(InputStream inputStream) throws IOException {
        return DerInputStream.getLength(inputStream.read(), inputStream);
    }

    public String getBMPString() throws IOException {
        return this.readString((byte)30, "BMP", "UnicodeBigUnmarked");
    }

    public String getGeneralString() throws IOException {
        return this.readString((byte)27, "General", "ASCII");
    }

    public String getIA5String() throws IOException {
        return this.readString((byte)22, "IA5", "ASCII");
    }

    public String getPrintableString() throws IOException {
        return this.readString((byte)19, "Printable", "ASCII");
    }

    public String getT61String() throws IOException {
        return this.readString((byte)20, "T61", "ISO-8859-1");
    }

    public String getUTF8String() throws IOException {
        return this.readString((byte)12, "UTF-8", "UTF8");
    }

    public BigInteger getBigInteger() throws IOException {
        if (this.buffer.read() != 2) {
            throw new IOException("DER input, Integer tag error");
        }
        return this.buffer.getBigInteger(DerInputStream.getLength(this.buffer));
    }

    public Date getGeneralizedTime() throws IOException {
        if (this.buffer.read() != 24) {
            throw new IOException("DER input, GeneralizedTime tag invalid ");
        }
        return this.buffer.getGeneralizedTime(DerInputStream.getLength(this.buffer));
    }

    public Date getUTCTime() throws IOException {
        if (this.buffer.read() != 23) {
            throw new IOException("DER input, UTCtime tag invalid ");
        }
        return this.buffer.getUTCTime(DerInputStream.getLength(this.buffer));
    }

    public BitArray getUnalignedBitString() throws IOException {
        if (this.buffer.read() != 3) {
            throw new IOException("DER input not a bit string");
        }
        int n2 = DerInputStream.getLength(this.buffer) - 1;
        int n3 = n2 * 8 - this.buffer.read();
        byte[] byArray = new byte[n2];
        if (n2 != 0 && this.buffer.read(byArray) != n2) {
            throw new IOException("short read of DER bit string");
        }
        return new BitArray(n3, byArray);
    }

    DerInputStream(DerInputBuffer derInputBuffer) {
        this.buffer = derInputBuffer;
        this.buffer.mark(Integer.MAX_VALUE);
    }

    public DerInputStream subStream(int n2, boolean bl2) throws IOException {
        DerInputBuffer derInputBuffer = this.buffer.dup();
        derInputBuffer.truncate(n2);
        if (bl2) {
            this.buffer.skip(n2);
        }
        return new DerInputStream(derInputBuffer);
    }

    public DerValue getDerValue() throws IOException {
        return new DerValue(this.buffer);
    }

    public DerValue[] getSequence(int n2) throws IOException {
        if (this.buffer.read() != 48) {
            throw new IOException("Sequence tag error");
        }
        return this.readVector(n2);
    }

    public DerValue[] getSet(int n2) throws IOException {
        if (this.buffer.read() != 49) {
            throw new IOException("Set tag error");
        }
        return this.readVector(n2);
    }

    protected DerValue[] readVector(int n2) throws IOException {
        int n3 = DerInputStream.getLength(this.buffer);
        if (n3 == 0) {
            return new DerValue[0];
        }
        DerInputStream derInputStream = this.buffer.available() == n3 ? this : this.subStream(n3, true);
        Vector vector = new Vector(n2, 5);
        do {
            DerValue derValue = new DerValue(derInputStream.buffer);
            vector.addElement(derValue);
        } while (derInputStream.available() > 0);
        if (derInputStream.available() != 0) {
            throw new IOException("extra data at end of vector");
        }
        int n4 = vector.size();
        DerValue[] derValueArray = new DerValue[n4];
        int n5 = 0;
        while (n5 < n4) {
            derValueArray[n5] = (DerValue)vector.elementAt(n5);
            ++n5;
        }
        return derValueArray;
    }

    public DerValue[] getSet(int n2, boolean bl2) throws IOException {
        int n3 = this.buffer.read();
        if (!bl2 && n3 != 49) {
            throw new IOException("Set tag error");
        }
        return this.readVector(n2);
    }

    public ObjectIdentifier getOID() throws IOException {
        return new ObjectIdentifier(this);
    }

    private String readString(byte by, String string, String string2) throws IOException {
        if (this.buffer.read() != by) {
            throw new IOException("DER input not a " + string + " string");
        }
        int n2 = DerInputStream.getLength(this.buffer);
        byte[] byArray = new byte[n2];
        if (n2 != 0 && this.buffer.read(byArray) != n2) {
            throw new IOException("short read of DER " + string + " string");
        }
        return new String(byArray, string2);
    }
}

