/*
 * Decompiled with CFR 0.152.
 */
package sun.security.util;

import java.io.IOException;
import java.util.ArrayList;

class DerIndefLenConverter {
    private static final int TAG_MASK = 31;
    private static final int FORM_MASK = 32;
    private static final int CLASS_MASK = 192;
    private static final int LEN_LONG = 128;
    private static final int LEN_MASK = 127;
    private static final int SKIP_EOC_BYTES = 2;
    private byte[] data;
    private byte[] newData;
    private int newDataPos;
    private int dataPos;
    private int dataSize;
    private int index;
    private ArrayList ndefsList = new ArrayList();
    private int numOfTotalLenBytes = 0;

    private int parseLength() throws IOException {
        int n2;
        int n3 = 0;
        if (this.dataPos == this.dataSize) {
            return n3;
        }
        if (DerIndefLenConverter.isIndefinite(n2 = this.data[this.dataPos++] & 0xFF)) {
            this.ndefsList.add(new Integer(this.dataPos));
            return n3;
        }
        if (DerIndefLenConverter.isLongForm(n2)) {
            if ((n2 &= 0x7F) > 4) {
                throw new IOException("Too much data");
            }
            if (this.dataSize - this.dataPos < n2 + 1) {
                throw new IOException("Too little data");
            }
            int n4 = 0;
            while (n4 < n2) {
                n3 = (n3 << 8) + (this.data[this.dataPos++] & 0xFF);
                ++n4;
            }
        } else {
            n3 = n2 & 0x7F;
        }
        return n3;
    }

    DerIndefLenConverter() {
    }

    private void parseTag() throws IOException {
        if (this.dataPos == this.dataSize) {
            return;
        }
        if (this.isEOC(this.data[this.dataPos]) && this.data[this.dataPos + 1] == 0) {
            int n2 = 0;
            Object object = null;
            int n3 = this.ndefsList.size() - 1;
            while (n3 >= 0) {
                object = this.ndefsList.get(n3);
                if (object instanceof Integer) break;
                n2 += ((byte[])object).length - 3;
                --n3;
            }
            if (n3 < 0) {
                throw new IOException("EOC does not have matching indefinite-length tag");
            }
            int n4 = this.dataPos - (Integer)object + n2;
            byte[] byArray = this.getLengthBytes(n4);
            this.ndefsList.set(n3, byArray);
            this.numOfTotalLenBytes += byArray.length - 3;
        }
        ++this.dataPos;
    }

    private void writeLengthAndValue() throws IOException {
        int n2;
        if (this.dataPos == this.dataSize) {
            return;
        }
        int n3 = 0;
        if (DerIndefLenConverter.isIndefinite(n2 = this.data[this.dataPos++] & 0xFF)) {
            byte[] byArray = (byte[])this.ndefsList.get(this.index++);
            System.arraycopy(byArray, 0, this.newData, this.newDataPos, byArray.length);
            this.newDataPos += byArray.length;
            return;
        }
        if (DerIndefLenConverter.isLongForm(n2)) {
            n2 &= 0x7F;
            int n4 = 0;
            while (n4 < n2) {
                n3 = (n3 << 8) + (this.data[this.dataPos++] & 0xFF);
                ++n4;
            }
        } else {
            n3 = n2 & 0x7F;
        }
        this.writeLength(n3);
        this.writeValue(n3);
    }

    private void writeTag() {
        byte by;
        if (this.dataPos == this.dataSize) {
            return;
        }
        if (this.isEOC(by = this.data[this.dataPos++]) && this.data[this.dataPos] == 0) {
            ++this.dataPos;
            this.writeTag();
        } else {
            this.newData[this.newDataPos++] = by;
        }
    }

    private int getNumOfLenBytes(int n2) {
        int n3 = 0;
        n3 = n2 < 128 ? 1 : (n2 < 256 ? 2 : (n2 < 65536 ? 3 : (n2 < 0x1000000 ? 4 : 5)));
        return n3;
    }

    private void parseValue(int n2) {
        this.dataPos += n2;
    }

    private void writeLength(int n2) {
        if (n2 < 128) {
            this.newData[this.newDataPos++] = (byte)n2;
        } else if (n2 < 256) {
            this.newData[this.newDataPos++] = -127;
            this.newData[this.newDataPos++] = (byte)n2;
        } else if (n2 < 65536) {
            this.newData[this.newDataPos++] = -126;
            this.newData[this.newDataPos++] = (byte)(n2 >> 8);
            this.newData[this.newDataPos++] = (byte)n2;
        } else if (n2 < 0x1000000) {
            this.newData[this.newDataPos++] = -125;
            this.newData[this.newDataPos++] = (byte)(n2 >> 16);
            this.newData[this.newDataPos++] = (byte)(n2 >> 8);
            this.newData[this.newDataPos++] = (byte)n2;
        } else {
            this.newData[this.newDataPos++] = -124;
            this.newData[this.newDataPos++] = (byte)(n2 >> 24);
            this.newData[this.newDataPos++] = (byte)(n2 >> 16);
            this.newData[this.newDataPos++] = (byte)(n2 >> 8);
            this.newData[this.newDataPos++] = (byte)n2;
        }
    }

    private void writeValue(int n2) {
        int n3 = 0;
        while (n3 < n2) {
            this.newData[this.newDataPos++] = this.data[this.dataPos++];
            ++n3;
        }
    }

    private boolean isEOC(int n2) {
        return (n2 & 0x1F) == 0 && (n2 & 0x20) == 0 && (n2 & 0xC0) == 0;
    }

    static boolean isIndefinite(int n2) {
        return DerIndefLenConverter.isLongForm(n2) && (n2 & 0x7F) == 0;
    }

    static boolean isLongForm(int n2) {
        return (n2 & 0x80) == 128;
    }

    private byte[] getLengthBytes(int n2) {
        byte[] byArray;
        int n3 = 0;
        if (n2 < 128) {
            byArray = new byte[1];
            byArray[n3++] = (byte)n2;
        } else if (n2 < 256) {
            byArray = new byte[2];
            byArray[n3++] = -127;
            byArray[n3++] = (byte)n2;
        } else if (n2 < 65536) {
            byArray = new byte[3];
            byArray[n3++] = -126;
            byArray[n3++] = (byte)(n2 >> 8);
            byArray[n3++] = (byte)n2;
        } else if (n2 < 0x1000000) {
            byArray = new byte[4];
            byArray[n3++] = -125;
            byArray[n3++] = (byte)(n2 >> 16);
            byArray[n3++] = (byte)(n2 >> 8);
            byArray[n3++] = (byte)n2;
        } else {
            byArray = new byte[5];
            byArray[n3++] = -124;
            byArray[n3++] = (byte)(n2 >> 24);
            byArray[n3++] = (byte)(n2 >> 16);
            byArray[n3++] = (byte)(n2 >> 8);
            byArray[n3++] = (byte)n2;
        }
        return byArray;
    }

    byte[] convert(byte[] byArray) throws IOException {
        this.data = byArray;
        this.dataPos = 0;
        this.index = 0;
        this.dataSize = this.data.length;
        int n2 = 0;
        while (this.dataPos < this.dataSize) {
            this.parseTag();
            n2 = this.parseLength();
            this.parseValue(n2);
        }
        this.newData = new byte[this.dataSize + this.numOfTotalLenBytes];
        this.dataPos = 0;
        this.newDataPos = 0;
        this.index = 0;
        while (this.dataPos < this.dataSize) {
            this.writeTag();
            this.writeLengthAndValue();
        }
        return this.newData;
    }
}

