/*
 * Decompiled with CFR 0.152.
 */
package sun.security.provider.certpath;

import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.Principal;
import java.security.cert.CertPathValidatorException;
import java.security.cert.CertStore;
import java.security.cert.CertStoreException;
import java.security.cert.CertificateException;
import java.security.cert.PKIXBuilderParameters;
import java.security.cert.PKIXCertPathChecker;
import java.security.cert.X509CertSelector;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import sun.security.provider.certpath.Builder;
import sun.security.provider.certpath.KeyChecker;
import sun.security.provider.certpath.PolicyChecker;
import sun.security.provider.certpath.ReverseState;
import sun.security.provider.certpath.State;
import sun.security.util.Debug;
import sun.security.x509.PKIXExtensions;
import sun.security.x509.X500Name;
import sun.security.x509.X509CertImpl;

class ReverseBuilder
extends Builder {
    private Debug debug = Debug.getInstance("certpath");
    private Date date;
    private X509CertSelector targetCertSelector;
    Set initPolicies;

    boolean isPathCompleted(X509Certificate x509Certificate) {
        return x509Certificate.getSubjectDN().equals(this.targetSubjectDN);
    }

    void removeFinalCertFromPath(LinkedList linkedList) {
        linkedList.removeLast();
    }

    private Collection getMatchingCACerts(ReverseState reverseState) throws CertificateException, CertStoreException, IOException {
        X509CertSelector x509CertSelector = new X509CertSelector();
        x509CertSelector.setIssuer(reverseState.subjectDN);
        x509CertSelector.setCertificateValid(this.date);
        x509CertSelector.addPathToName(4, this.targetCertSelector.getSubjectAsBytes());
        if (reverseState.explicitPolicy == 0) {
            x509CertSelector.setPolicy(this.getMatchingPolicies());
        }
        x509CertSelector.setBasicConstraints(0);
        ArrayList arrayList = new ArrayList();
        Iterator iterator = this.buildParams.getCertStores().iterator();
        while (iterator.hasNext()) {
            try {
                Collection collection = ((CertStore)iterator.next()).getCertificates(x509CertSelector);
                Iterator iterator2 = collection.iterator();
                while (iterator2.hasNext()) {
                    X509Certificate x509Certificate = (X509Certificate)iterator2.next();
                    if (x509Certificate.getIssuerDN().equals(x509Certificate.getSubjectDN())) continue;
                    arrayList.add(x509Certificate);
                }
            }
            catch (CertStoreException certStoreException) {
                // empty catch block
            }
        }
        Collections.sort(arrayList, new PKIXCertComparator(this));
        if (this.debug != null) {
            this.debug.println("ReverseBuilder.getMatchingCACerts got " + arrayList.size() + " certs.");
        }
        return arrayList;
    }

    private Collection getMatchingEECerts(ReverseState reverseState) throws CertStoreException, CertificateException, IOException {
        X509CertSelector x509CertSelector = (X509CertSelector)this.buildParams.getTargetCertConstraints();
        x509CertSelector.setIssuer(reverseState.subjectDN);
        x509CertSelector.setCertificateValid(this.date);
        if (reverseState.explicitPolicy == 0) {
            x509CertSelector.setPolicy(this.getMatchingPolicies());
        }
        x509CertSelector.setBasicConstraints(-2);
        HashSet hashSet = new HashSet();
        Iterator iterator = this.buildParams.getCertStores().iterator();
        while (iterator.hasNext()) {
            try {
                Collection collection = ((CertStore)iterator.next()).getCertificates(x509CertSelector);
                Iterator iterator2 = collection.iterator();
                while (iterator2.hasNext()) {
                    X509Certificate x509Certificate = (X509Certificate)iterator2.next();
                    if (x509Certificate.getIssuerDN().equals(x509Certificate.getSubjectDN())) continue;
                    hashSet.add(x509Certificate);
                }
            }
            catch (CertStoreException certStoreException) {
                // empty catch block
            }
        }
        if (this.debug != null) {
            this.debug.println("ReverseBuilder.getMatchingEECerts got " + hashSet.size() + " certs.");
        }
        return hashSet;
    }

    Collection getMatchingCerts(State state) throws CertStoreException, CertificateException, IOException {
        ReverseState reverseState = (ReverseState)state;
        if (this.debug != null) {
            this.debug.println("In ReverseBuilder.getMatchingCerts.");
        }
        Collection collection = this.getMatchingEECerts(reverseState);
        collection.addAll(this.getMatchingCACerts(reverseState));
        return collection;
    }

    void addCertToPath(X509Certificate x509Certificate, LinkedList linkedList) {
        linkedList.addLast(x509Certificate);
    }

    ReverseBuilder(PKIXBuilderParameters pKIXBuilderParameters, X500Name x500Name) {
        super(pKIXBuilderParameters, x500Name);
        this.date = pKIXBuilderParameters.getDate();
        if (this.date == null) {
            this.date = new Date();
        }
        this.targetCertSelector = (X509CertSelector)pKIXBuilderParameters.getTargetCertConstraints();
        Set set = pKIXBuilderParameters.getInitialPolicies();
        this.initPolicies = new HashSet();
        if (set.isEmpty()) {
            this.initPolicies.add("2.5.29.32.0");
        } else {
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                this.initPolicies.add(iterator.next());
            }
        }
    }

    void verifyCert(X509Certificate x509Certificate, State state, List list) throws GeneralSecurityException {
        boolean bl2;
        Object object;
        Object object2;
        X509Certificate x509Certificate2;
        Object object3;
        ReverseState reverseState;
        if (this.debug != null) {
            this.debug.println("ReverseBuilder.verifyCert(SN: " + Debug.toHexString(x509Certificate.getSerialNumber()) + "\n  Subject: " + x509Certificate.getSubjectDN() + ")");
        }
        if ((reverseState = (ReverseState)state).isInitial()) {
            return;
        }
        if (list != null && !list.isEmpty()) {
            ArrayList arrayList = new ArrayList();
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                arrayList.add(0, iterator.next());
            }
            object3 = arrayList.iterator();
            boolean bl3 = false;
            while (object3.hasNext()) {
                x509Certificate2 = (X509Certificate)object3.next();
                object2 = new X509CertImpl(x509Certificate2.getEncoded());
                object = ((X509CertImpl)object2).getPolicyMappingsExtension();
                if (object != null) {
                    bl3 = true;
                }
                if (this.debug != null) {
                    this.debug.println("policyMappingFound = " + bl3);
                }
                if (!x509Certificate.equals(x509Certificate2) || !this.buildParams.isPolicyMappingInhibited() && bl3) continue;
                if (this.debug != null) {
                    this.debug.println("loop detected!!");
                }
                throw new CertPathValidatorException("loop detected");
            }
        }
        boolean bl4 = x509Certificate.getSubjectDN().equals(this.targetSubjectDN);
        boolean bl5 = x509Certificate.getBasicConstraints() != -1;
        object3 = x509Certificate.getIssuerDN();
        Principal principal = x509Certificate.getSubjectDN();
        if (!bl4) {
            if (!bl5) {
                throw new CertPathValidatorException("cert is NOT a CA cert");
            }
            if (!object3.equals(principal) && reverseState.remainingCACerts <= 0) {
                throw new CertPathValidatorException("pathLenConstraint violated, path too long");
            }
            KeyChecker.verifyCAKeyUsage(x509Certificate);
        } else if (!this.targetCertSelector.match(x509Certificate)) {
            throw new CertPathValidatorException("target certificate constraints check failed");
        }
        if (this.buildParams.isRevocationEnabled() && !(bl2 = reverseState.crlChecker.check(x509Certificate, reverseState.pubKey, true)) && !bl4) {
            throw new CertPathValidatorException("cert can't vouch for crl");
        }
        if ((bl4 || !object3.equals(principal)) && reverseState.nc != null) {
            try {
                if (!reverseState.nc.verify(x509Certificate)) {
                    throw new CertPathValidatorException("name constraints check failed");
                }
            }
            catch (IOException iOException) {
                throw new CertPathValidatorException(iOException);
            }
        }
        x509Certificate2 = new X509CertImpl(x509Certificate.getEncoded());
        reverseState.rootNode = PolicyChecker.processPolicies(reverseState.certIndex, this.initPolicies, reverseState.explicitPolicy, reverseState.policyMapping, reverseState.inhibitAnyPolicy, this.buildParams.getPolicyQualifiersRejected(), reverseState.rootNode, (X509CertImpl)x509Certificate2, bl4);
        object2 = x509Certificate.getCriticalExtensionOIDs();
        if (object2 == null) {
            object2 = Collections.EMPTY_SET;
        }
        object = reverseState.userCheckers.iterator();
        while (object.hasNext()) {
            PKIXCertPathChecker pKIXCertPathChecker = (PKIXCertPathChecker)object.next();
            pKIXCertPathChecker.check(x509Certificate, (Collection)object2);
        }
        if (!object2.isEmpty()) {
            object2.remove(PKIXExtensions.BasicConstraints_Id.toString());
            object2.remove(PKIXExtensions.NameConstraints_Id.toString());
            object2.remove(PKIXExtensions.CertificatePolicies_Id.toString());
            object2.remove(PKIXExtensions.PolicyMappings_Id.toString());
            object2.remove(PKIXExtensions.PolicyConstraints_Id.toString());
            object2.remove(PKIXExtensions.InhibitAnyPolicy_Id.toString());
            object2.remove(PKIXExtensions.SubjectAlternativeName_Id.toString());
            object2.remove(PKIXExtensions.KeyUsage_Id.toString());
            object2.remove(PKIXExtensions.ExtendedKeyUsage_Id.toString());
            if (!object2.isEmpty()) {
                throw new CertificateException("Unrecognized critical extension(s)");
            }
        }
        if (this.buildParams.getSigProvider() != null) {
            x509Certificate.verify(reverseState.pubKey, this.buildParams.getSigProvider());
        } else {
            x509Certificate.verify(reverseState.pubKey);
        }
    }

    class PKIXCertComparator
    implements Comparator {
        private Debug debug;
        private final ReverseBuilder this$0;

        PKIXCertComparator(ReverseBuilder reverseBuilder) {
            this.this$0 = reverseBuilder;
            this.debug = Debug.getInstance("certpath");
        }

        public int compare(Object object, Object object2) {
            int n2;
            int n3;
            X509Certificate x509Certificate = (X509Certificate)object;
            X509Certificate x509Certificate2 = (X509Certificate)object2;
            if (x509Certificate.getSubjectDN().equals(this.this$0.targetSubjectDN)) {
                return -1;
            }
            if (x509Certificate2.getSubjectDN().equals(this.this$0.targetSubjectDN)) {
                return 1;
            }
            try {
                n3 = Builder.targetDistance(null, x509Certificate, this.this$0.targetSubjectDN);
                n2 = Builder.targetDistance(null, x509Certificate2, this.this$0.targetSubjectDN);
            }
            catch (IOException iOException) {
                if (this.debug != null) {
                    this.debug.println("IOException in call to Builder.targetDistance");
                    iOException.printStackTrace();
                }
                throw new ClassCastException("Invalid target subject distinguished name");
            }
            if (n3 == n2) {
                return 0;
            }
            if (n3 == -1) {
                return 1;
            }
            if (n3 < n2) {
                return -1;
            }
            return 1;
        }
    }
}

