/*
 * Decompiled with CFR 0.152.
 */
package sun.security.provider;

import java.security.InvalidKeyException;
import java.security.Key;
import java.security.KeyFactorySpi;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.interfaces.DSAParams;
import java.security.spec.DSAPrivateKeySpec;
import java.security.spec.DSAPublicKeySpec;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.KeySpec;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import sun.security.provider.DSAPrivateKey;
import sun.security.provider.DSAPublicKey;

public class DSAKeyFactory
extends KeyFactorySpi {
    static Class class$java$security$spec$DSAPublicKeySpec;
    static Class class$java$security$spec$DSAPrivateKeySpec;

    static Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    protected Key engineTranslateKey(Key key) throws InvalidKeyException {
        try {
            if (key instanceof java.security.interfaces.DSAPublicKey) {
                if (key instanceof DSAPublicKey) {
                    return key;
                }
                DSAPublicKeySpec dSAPublicKeySpec = (DSAPublicKeySpec)this.engineGetKeySpec(key, class$java$security$spec$DSAPublicKeySpec == null ? (class$java$security$spec$DSAPublicKeySpec = DSAKeyFactory.class$("java.security.spec.DSAPublicKeySpec")) : class$java$security$spec$DSAPublicKeySpec);
                return this.engineGeneratePublic(dSAPublicKeySpec);
            }
            if (key instanceof java.security.interfaces.DSAPrivateKey) {
                if (key instanceof DSAPrivateKey) {
                    return key;
                }
                DSAPrivateKeySpec dSAPrivateKeySpec = (DSAPrivateKeySpec)this.engineGetKeySpec(key, class$java$security$spec$DSAPrivateKeySpec == null ? (class$java$security$spec$DSAPrivateKeySpec = DSAKeyFactory.class$("java.security.spec.DSAPrivateKeySpec")) : class$java$security$spec$DSAPrivateKeySpec);
                return this.engineGeneratePrivate(dSAPrivateKeySpec);
            }
            throw new InvalidKeyException("Wrong algorithm type");
        }
        catch (InvalidKeySpecException invalidKeySpecException) {
            throw new InvalidKeyException("Cannot translate key: " + invalidKeySpecException.getMessage());
        }
    }

    protected PrivateKey engineGeneratePrivate(KeySpec keySpec) throws InvalidKeySpecException {
        try {
            if (keySpec instanceof DSAPrivateKeySpec) {
                DSAPrivateKeySpec dSAPrivateKeySpec = (DSAPrivateKeySpec)keySpec;
                return new DSAPrivateKey(dSAPrivateKeySpec.getX(), dSAPrivateKeySpec.getP(), dSAPrivateKeySpec.getQ(), dSAPrivateKeySpec.getG());
            }
            if (keySpec instanceof PKCS8EncodedKeySpec) {
                return new DSAPrivateKey(((PKCS8EncodedKeySpec)keySpec).getEncoded());
            }
            throw new InvalidKeySpecException("Inappropriate key specification");
        }
        catch (InvalidKeyException invalidKeyException) {
            throw new InvalidKeySpecException("Inappropriate key specification: " + invalidKeyException.getMessage());
        }
    }

    protected PublicKey engineGeneratePublic(KeySpec keySpec) throws InvalidKeySpecException {
        try {
            if (keySpec instanceof DSAPublicKeySpec) {
                DSAPublicKeySpec dSAPublicKeySpec = (DSAPublicKeySpec)keySpec;
                return new DSAPublicKey(dSAPublicKeySpec.getY(), dSAPublicKeySpec.getP(), dSAPublicKeySpec.getQ(), dSAPublicKeySpec.getG());
            }
            if (keySpec instanceof X509EncodedKeySpec) {
                return new DSAPublicKey(((X509EncodedKeySpec)keySpec).getEncoded());
            }
            throw new InvalidKeySpecException("Inappropriate key specification");
        }
        catch (InvalidKeyException invalidKeyException) {
            throw new InvalidKeySpecException("Inappropriate key specification: " + invalidKeyException.getMessage());
        }
    }

    protected KeySpec engineGetKeySpec(Key key, Class clazz) throws InvalidKeySpecException {
        try {
            if (key instanceof java.security.interfaces.DSAPublicKey) {
                Class clazz2 = Class.forName("java.security.spec.DSAPublicKeySpec");
                Class clazz3 = Class.forName("java.security.spec.X509EncodedKeySpec");
                if (clazz2.isAssignableFrom(clazz)) {
                    java.security.interfaces.DSAPublicKey dSAPublicKey = (java.security.interfaces.DSAPublicKey)key;
                    DSAParams dSAParams = dSAPublicKey.getParams();
                    return new DSAPublicKeySpec(dSAPublicKey.getY(), dSAParams.getP(), dSAParams.getQ(), dSAParams.getG());
                }
                if (clazz3.isAssignableFrom(clazz)) {
                    return new X509EncodedKeySpec(key.getEncoded());
                }
                throw new InvalidKeySpecException("Inappropriate key specification");
            }
            if (key instanceof java.security.interfaces.DSAPrivateKey) {
                Class clazz4 = Class.forName("java.security.spec.DSAPrivateKeySpec");
                Class clazz5 = Class.forName("java.security.spec.PKCS8EncodedKeySpec");
                if (clazz4.isAssignableFrom(clazz)) {
                    java.security.interfaces.DSAPrivateKey dSAPrivateKey = (java.security.interfaces.DSAPrivateKey)key;
                    DSAParams dSAParams = dSAPrivateKey.getParams();
                    return new DSAPrivateKeySpec(dSAPrivateKey.getX(), dSAParams.getP(), dSAParams.getQ(), dSAParams.getG());
                }
                if (clazz5.isAssignableFrom(clazz)) {
                    return new PKCS8EncodedKeySpec(key.getEncoded());
                }
                throw new InvalidKeySpecException("Inappropriate key specification");
            }
            throw new InvalidKeySpecException("Inappropriate key type");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new InvalidKeySpecException("Unsupported key specification: " + classNotFoundException.getMessage());
        }
    }
}

