/*
 * Decompiled with CFR 0.152.
 */
package sun.security.pkcs;

import java.io.IOException;
import sun.security.pkcs.ParsingException;
import sun.security.util.DerInputStream;
import sun.security.util.DerOutputStream;
import sun.security.util.DerValue;
import sun.security.util.ObjectIdentifier;

public class ContentInfo {
    private static int[] pkcs7 = new int[]{1, 2, 840, 113549, 1, 7};
    private static int[] data = new int[]{1, 2, 840, 113549, 1, 7, 1};
    private static int[] sdata = new int[]{1, 2, 840, 113549, 1, 7, 2};
    private static int[] edata = new int[]{1, 2, 840, 113549, 1, 7, 3};
    private static int[] sedata = new int[]{1, 2, 840, 113549, 1, 7, 4};
    private static int[] ddata = new int[]{1, 2, 840, 113549, 1, 7, 5};
    private static int[] crdata = new int[]{1, 2, 840, 113549, 1, 7, 6};
    private static int[] nsdata = new int[]{2, 16, 840, 1, 113730, 2, 5};
    private static final int[] OLD_SDATA = new int[]{1, 2, 840, 1113549, 1, 7, 2};
    private static final int[] OLD_DATA = new int[]{1, 2, 840, 1113549, 1, 7, 1};
    public static ObjectIdentifier PKCS7_OID;
    public static ObjectIdentifier DATA_OID;
    public static ObjectIdentifier SIGNED_DATA_OID;
    public static ObjectIdentifier ENVELOPED_DATA_OID;
    public static ObjectIdentifier SIGNED_AND_ENVELOPED_DATA_OID;
    public static ObjectIdentifier DIGESTED_DATA_OID;
    public static ObjectIdentifier ENCRYPTED_DATA_OID;
    public static ObjectIdentifier OLD_SIGNED_DATA_OID;
    public static ObjectIdentifier OLD_DATA_OID;
    public static ObjectIdentifier NETSCAPE_CERT_SEQUENCE_OID;
    ObjectIdentifier contentType;
    DerValue content;

    static {
        try {
            PKCS7_OID = new ObjectIdentifier(pkcs7);
            DATA_OID = new ObjectIdentifier(data);
            SIGNED_DATA_OID = new ObjectIdentifier(sdata);
            ENVELOPED_DATA_OID = new ObjectIdentifier(edata);
            SIGNED_AND_ENVELOPED_DATA_OID = new ObjectIdentifier(sedata);
            DIGESTED_DATA_OID = new ObjectIdentifier(ddata);
            ENCRYPTED_DATA_OID = new ObjectIdentifier(crdata);
            OLD_SIGNED_DATA_OID = new ObjectIdentifier(OLD_SDATA);
            OLD_DATA_OID = new ObjectIdentifier(OLD_DATA);
            NETSCAPE_CERT_SEQUENCE_OID = new ObjectIdentifier(nsdata);
        }
        catch (IOException iOException) {}
    }

    public byte[] getContentBytes() throws IOException {
        if (this.content == null) {
            return null;
        }
        DerInputStream derInputStream = new DerInputStream(this.content.toByteArray());
        return derInputStream.getOctetString();
    }

    public byte[] getData() throws IOException {
        if (this.contentType.equals(DATA_OID) || this.contentType.equals(OLD_DATA_OID)) {
            if (this.content == null) {
                return null;
            }
            return this.content.getOctetString();
        }
        throw new IOException("content type is not DATA: " + this.contentType);
    }

    public ContentInfo(byte[] byArray) {
        DerValue derValue = new DerValue(4, byArray);
        this.contentType = DATA_OID;
        this.content = derValue;
    }

    public String toString() {
        String string = "";
        string = string + "Content Info Sequence\n\tContent type: " + this.contentType + "\n";
        string = string + "\tContent: " + this.content;
        return string;
    }

    public ContentInfo(DerInputStream derInputStream) throws IOException, ParsingException {
        this(derInputStream, false);
    }

    public ContentInfo(DerInputStream derInputStream, boolean bl2) throws IOException, ParsingException {
        DerValue[] derValueArray = derInputStream.getSequence(2);
        DerValue derValue = derValueArray[0];
        DerInputStream derInputStream2 = new DerInputStream(derValue.toByteArray());
        this.contentType = derInputStream2.getOID();
        if (bl2) {
            this.content = derValueArray[1];
        } else if (derValueArray.length > 1) {
            DerValue derValue2 = derValueArray[1];
            DerInputStream derInputStream3 = new DerInputStream(derValue2.toByteArray());
            DerValue[] derValueArray2 = derInputStream3.getSet(1, true);
            this.content = derValueArray2[0];
        }
    }

    public void encode(DerOutputStream derOutputStream) throws IOException {
        DerOutputStream derOutputStream2 = new DerOutputStream();
        derOutputStream2.putOID(this.contentType);
        if (this.content != null) {
            DerValue derValue = null;
            DerOutputStream derOutputStream3 = new DerOutputStream();
            this.content.encode(derOutputStream3);
            derValue = new DerValue(-96, derOutputStream3.toByteArray());
            derOutputStream2.putDerValue(derValue);
        }
        derOutputStream.write((byte)48, derOutputStream2);
    }

    public DerValue getContent() {
        return this.content;
    }

    public ObjectIdentifier getContentType() {
        return this.contentType;
    }

    public ContentInfo(ObjectIdentifier objectIdentifier, DerValue derValue) {
        this.contentType = objectIdentifier;
        this.content = derValue;
    }
}

