/*
 * Decompiled with CFR 0.152.
 */
package sun.security.jgss.krb5;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.Provider;
import javax.security.auth.kerberos.ServicePermission;
import org.ietf.jgss.ChannelBinding;
import org.ietf.jgss.GSSException;
import org.ietf.jgss.MessageProp;
import org.ietf.jgss.Oid;
import sun.security.jgss.TokenTracker;
import sun.security.jgss.krb5.AcceptSecContextToken;
import sun.security.jgss.krb5.InitSecContextToken;
import sun.security.jgss.krb5.InitialToken;
import sun.security.jgss.krb5.Krb5AcceptCredential;
import sun.security.jgss.krb5.Krb5CredElement;
import sun.security.jgss.krb5.Krb5InitCredential;
import sun.security.jgss.krb5.Krb5MechFactory;
import sun.security.jgss.krb5.Krb5NameElement;
import sun.security.jgss.krb5.MessageToken;
import sun.security.jgss.krb5.MicToken;
import sun.security.jgss.krb5.WrapToken;
import sun.security.jgss.spi.GSSContextSpi;
import sun.security.jgss.spi.GSSCredentialSpi;
import sun.security.jgss.spi.GSSNameSpi;
import sun.security.krb5.Credentials;
import sun.security.krb5.EncryptionKey;
import sun.security.krb5.KrbApReq;
import sun.security.krb5.KrbException;
import sun.security.krb5.PrincipalName;

class Krb5Context
implements GSSContextSpi {
    private static final int STATE_NEW = 1;
    private static final int STATE_IN_PROCESS = 2;
    private static final int STATE_DONE = 3;
    private static final int STATE_DELETED = 4;
    private int state = 1;
    private boolean credDelegState = false;
    private boolean mutualAuthState = true;
    private boolean replayDetState = true;
    private boolean sequenceDetState = true;
    private boolean confState = true;
    private boolean integState = true;
    private int mySeqNumber;
    private int peerSeqNumber;
    private TokenTracker peerTokenTracker;
    private Object mySeqNumberLock = new Object();
    private Object peerSeqNumberLock = new Object();
    private EncryptionKey key;
    private Krb5NameElement myName;
    private Krb5NameElement peerName;
    private int lifetime;
    private boolean initiator;
    private ChannelBinding channelBinding;
    private Krb5CredElement myCred;
    private Krb5CredElement delegatedCred;
    private Credentials serviceCreds;
    private KrbApReq apReq;

    public final int getLifetime() {
        return Integer.MAX_VALUE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final int incrementMySequenceNumber() {
        int n2;
        Object object = this.mySeqNumberLock;
        synchronized (object) {
            n2 = this.mySeqNumber;
            this.mySeqNumber = n2 + 1;
        }
        return n2;
    }

    public final void dispose() throws GSSException {
        this.state = 4;
        this.delegatedCred = null;
    }

    public final boolean getAnonymityState() {
        return false;
    }

    public final boolean getConfState() {
        return this.confState;
    }

    public final boolean getCredDelegState() {
        return this.credDelegState;
    }

    public final boolean getIntegState() {
        return this.integState;
    }

    public final boolean getMutualAuthState() {
        return this.mutualAuthState;
    }

    public final boolean getReplayDetState() {
        return this.replayDetState || this.sequenceDetState;
    }

    public final boolean getSequenceDetState() {
        return this.sequenceDetState || this.replayDetState;
    }

    public final boolean isEstablished() {
        return this.state == 3;
    }

    public final boolean isInitiator() {
        return this.initiator;
    }

    public final boolean isProtReady() {
        return this.state == 3;
    }

    public final boolean isTransferable() throws GSSException {
        return false;
    }

    public final byte[] export() throws GSSException {
        throw new GSSException(16, -1, "GSS Export Context not available");
    }

    public void requestLifetime(int n2) throws GSSException {
        if (this.state == 1 && this.isInitiator()) {
            this.lifetime = n2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void resetMySequenceNumber(int n2) {
        Object object = this.mySeqNumberLock;
        synchronized (object) {
            this.mySeqNumber = n2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void resetPeerSequenceNumber(int n2) {
        Object object = this.peerSeqNumberLock;
        synchronized (object) {
            this.peerSeqNumber = n2;
            this.peerTokenTracker = new TokenTracker(this.peerSeqNumber);
        }
    }

    public final int getWrapSizeLimit(int n2, boolean bl2, int n3) throws GSSException {
        return WrapToken.getSizeLimit(n2, bl2, n3);
    }

    public final void requestAnonymity(boolean bl2) throws GSSException {
    }

    public final void requestConf(boolean bl2) throws GSSException {
        if (this.state == 1 && this.isInitiator()) {
            this.confState = bl2;
        }
    }

    public final void requestCredDeleg(boolean bl2) throws GSSException {
        if (this.state == 1 && this.isInitiator()) {
            this.credDelegState = bl2;
        }
    }

    public final void requestInteg(boolean bl2) throws GSSException {
        if (this.state == 1 && this.isInitiator()) {
            this.integState = bl2;
        }
    }

    public final void requestMutualAuth(boolean bl2) throws GSSException {
        if (this.state == 1 && this.isInitiator()) {
            this.mutualAuthState = bl2;
        }
    }

    public final void requestReplayDet(boolean bl2) throws GSSException {
        if (this.state == 1 && this.isInitiator()) {
            this.replayDetState = bl2;
        }
    }

    public final void requestSequenceDet(boolean bl2) throws GSSException {
        if (this.state == 1 && this.isInitiator()) {
            this.sequenceDetState = bl2;
        }
    }

    final void setConfState(boolean bl2) {
        this.confState = bl2;
    }

    final void setCredDelegState(boolean bl2) {
        this.credDelegState = bl2;
    }

    final void setIntegState(boolean bl2) {
        this.integState = bl2;
    }

    final void setMutualAuthState(boolean bl2) {
        this.mutualAuthState = bl2;
    }

    final void setReplayDetState(boolean bl2) {
        this.replayDetState = bl2;
    }

    final void setSequenceDetState(boolean bl2) {
        this.sequenceDetState = bl2;
    }

    public Krb5Context(byte[] byArray) throws GSSException {
        throw new GSSException(16, -1, "GSS Import Context not available");
    }

    public final byte[] acceptSecContext(InputStream inputStream, int n2) throws GSSException {
        byte[] byArray = null;
        if (this.isInitiator()) {
            throw new GSSException(11, -1, "acceptSecContext on an initiator GSSContext");
        }
        try {
            if (this.state == 1) {
                this.state = 2;
                if (this.myCred == null) {
                    this.myCred = Krb5AcceptCredential.getInstance(this.myName);
                } else if (!this.myCred.isAcceptorCredential()) {
                    throw new GSSException(13, -1, "No Secret Key available");
                }
                this.myName = (Krb5NameElement)this.myCred.getName();
                EncryptionKey encryptionKey = ((Krb5AcceptCredential)this.myCred).getKrb5EncryptionKey();
                this.checkPermission(this.myName.getKrb5PrincipalName().getName(), "accept");
                InitSecContextToken initSecContextToken = new InitSecContextToken(this, encryptionKey, inputStream);
                PrincipalName principalName = initSecContextToken.getKrbApReq().getClient();
                this.peerName = Krb5NameElement.getInstance(principalName);
                if (this.getMutualAuthState()) {
                    byArray = new AcceptSecContextToken(this, initSecContextToken.getKrbApReq()).encode();
                }
                this.myCred = null;
                this.state = 3;
            }
        }
        catch (KrbException krbException) {
            throw new GSSException(11, -1, krbException.getMessage());
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            throw new GSSException(11, -1, iOException.getMessage());
        }
        return byArray;
    }

    public final byte[] initSecContext(InputStream inputStream, int n2) throws GSSException {
        byte[] byArray = null;
        InitSecContextToken initSecContextToken = null;
        int n3 = 11;
        if (!this.isInitiator()) {
            throw new GSSException(11, -1, "initSecContext on an acceptor GSSContext");
        }
        try {
            if (this.state == 1) {
                this.state = 2;
                n3 = 13;
                if (this.myCred == null) {
                    this.myCred = Krb5InitCredential.getInstance(this.myName, 0);
                } else if (!this.myCred.isInitiatorCredential()) {
                    throw new GSSException(n3, -1, "No TGT available");
                }
                this.myName = (Krb5NameElement)this.myCred.getName();
                Credentials credentials = ((Krb5InitCredential)this.myCred).getKrb5Credentials();
                this.checkPermission(this.peerName.getKrb5PrincipalName().getName(), "initiate");
                this.serviceCreds = Credentials.acquireServiceCreds(this.peerName.getKrb5PrincipalName().getName(), credentials);
                n3 = 11;
                initSecContextToken = new InitSecContextToken(this, credentials, this.serviceCreds);
                this.apReq = initSecContextToken.getKrbApReq();
                byArray = ((InitialToken)initSecContextToken).encode();
                this.myCred = null;
                if (!this.getMutualAuthState()) {
                    this.state = 3;
                }
            } else if (this.state == 2) {
                new AcceptSecContextToken(this, this.serviceCreds, this.apReq, inputStream);
                this.serviceCreds = null;
                this.apReq = null;
                this.state = 3;
            } else {
                System.out.println(this.state);
            }
        }
        catch (KrbException krbException) {
            krbException.printStackTrace();
            throw new GSSException(n3, -1, krbException.getMessage());
        }
        catch (IOException iOException) {
            throw new GSSException(n3, -1, iOException.getMessage());
        }
        return byArray;
    }

    public final Provider getProvider() {
        return Krb5MechFactory.PROVIDER;
    }

    final ChannelBinding getChannelBinding() {
        return this.channelBinding;
    }

    public final void setChannelBinding(ChannelBinding channelBinding) throws GSSException {
        this.channelBinding = channelBinding;
    }

    public final byte[] getMIC(byte[] byArray, int n2, int n3, MessageProp messageProp) throws GSSException {
        if (this.state != 3) {
            throw new GSSException(12, -1, "GetMIC called in invalid state!");
        }
        MicToken micToken = new MicToken(this, messageProp, byArray, n2, n3);
        try {
            return micToken.encode();
        }
        catch (IOException iOException) {
            throw new GSSException(11, -1, iOException.getMessage());
        }
    }

    public final byte[] unwrap(byte[] byArray, int n2, int n3, MessageProp messageProp) throws GSSException {
        if (this.state != 3) {
            throw new GSSException(12, -1, " Unwrap called in invalid state!");
        }
        WrapToken wrapToken = new WrapToken(this, byArray, n2, n3, messageProp);
        byte[] byArray2 = wrapToken.getData();
        this.setSequencingAndReplayProps(wrapToken, messageProp);
        return byArray2;
    }

    public final byte[] wrap(byte[] byArray, int n2, int n3, MessageProp messageProp) throws GSSException {
        if (this.state != 3) {
            throw new GSSException(12, -1, "Wrap called in invalid state!");
        }
        try {
            WrapToken wrapToken = new WrapToken(this, messageProp, byArray, n2, n3);
            byte[] byArray2 = wrapToken.encode();
            return byArray2;
        }
        catch (IOException iOException) {
            throw new GSSException(11, -1, iOException.getMessage());
        }
    }

    public final void verifyMIC(byte[] byArray, int n2, int n3, byte[] byArray2, int n4, int n5, MessageProp messageProp) throws GSSException {
        if (this.state != 3) {
            throw new GSSException(12, -1, "verifyMIC called in invalid state!");
        }
        MicToken micToken = new MicToken(this, byArray, n2, n3, messageProp);
        micToken.verify(byArray2, n4, n5);
        this.setSequencingAndReplayProps(micToken, messageProp);
    }

    private int getMIC(byte[] byArray, int n2, int n3, byte[] byArray2, int n4, MessageProp messageProp) throws GSSException {
        if (this.state != 3) {
            throw new GSSException(12, -1, "GetMIC called in invalid state!");
        }
        MicToken micToken = new MicToken(this, messageProp, byArray, n2, n3);
        try {
            return micToken.encode(byArray2, n4);
        }
        catch (IOException iOException) {
            throw new GSSException(11, -1, iOException.getMessage());
        }
    }

    public final int unwrap(byte[] byArray, int n2, int n3, byte[] byArray2, int n4, MessageProp messageProp) throws GSSException {
        if (this.state != 3) {
            throw new GSSException(12, -1, "Unwrap called in invalid state!");
        }
        WrapToken wrapToken = new WrapToken(this, byArray, n2, n3, messageProp);
        n3 = wrapToken.getData(byArray2, n4);
        this.setSequencingAndReplayProps(wrapToken, messageProp);
        return n3;
    }

    public final int wrap(byte[] byArray, int n2, int n3, byte[] byArray2, int n4, MessageProp messageProp) throws GSSException {
        if (this.state != 3) {
            throw new GSSException(12, -1, "Wrap called in invalid state!");
        }
        try {
            WrapToken wrapToken = new WrapToken(this, messageProp, byArray, n2, n3);
            int n5 = wrapToken.encode(byArray2, n4);
            return n5;
        }
        catch (IOException iOException) {
            throw new GSSException(11, -1, iOException.getMessage());
        }
    }

    public final Oid getMech() {
        return Krb5MechFactory.GSS_KRB5_MECH_OID;
    }

    Krb5Context(Krb5CredElement krb5CredElement) throws GSSException {
        this.myCred = krb5CredElement;
        this.initiator = false;
    }

    final void setDelegCred(Krb5CredElement krb5CredElement) {
        this.delegatedCred = krb5CredElement;
    }

    public final GSSCredentialSpi getDelegCred() throws GSSException {
        if (this.state != 2 && this.state != 3) {
            throw new GSSException(12);
        }
        if (this.delegatedCred == null) {
            throw new GSSException(13);
        }
        return this.delegatedCred;
    }

    public final GSSNameSpi getSrcName() throws GSSException {
        return this.isInitiator() ? this.myName : this.peerName;
    }

    public final GSSNameSpi getTargName() throws GSSException {
        return !this.isInitiator() ? this.myName : this.peerName;
    }

    final EncryptionKey getKey() {
        return this.key;
    }

    final void setKey(EncryptionKey encryptionKey) {
        this.key = encryptionKey;
    }

    private void checkPermission(String string, String string2) {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            ServicePermission servicePermission = new ServicePermission(string, string2);
            securityManager.checkPermission(servicePermission);
        }
    }

    private void verifyMIC(InputStream inputStream, byte[] byArray, int n2, int n3, MessageProp messageProp) throws GSSException {
        if (this.state != 3) {
            throw new GSSException(12, -1, "verifyMIC called in invalid state!");
        }
        MicToken micToken = new MicToken(this, inputStream, messageProp);
        micToken.verify(byArray, n2, n3);
        this.setSequencingAndReplayProps(micToken, messageProp);
    }

    public final int unwrap(InputStream inputStream, byte[] byArray, int n2, MessageProp messageProp) throws GSSException {
        if (this.state != 3) {
            throw new GSSException(12, -1, "Unwrap called in invalid state!");
        }
        WrapToken wrapToken = new WrapToken(this, inputStream, messageProp);
        int n3 = wrapToken.getData(byArray, n2);
        this.setSequencingAndReplayProps(wrapToken, messageProp);
        return n3;
    }

    private void getMIC(byte[] byArray, int n2, int n3, OutputStream outputStream, MessageProp messageProp) throws GSSException {
        if (this.state != 3) {
            throw new GSSException(12, -1, "GetMIC called in invalid state!");
        }
        MicToken micToken = new MicToken(this, messageProp, byArray, n2, n3);
        try {
            micToken.encode(outputStream);
        }
        catch (IOException iOException) {
            throw new GSSException(11, -1, iOException.getMessage());
        }
    }

    public final void wrap(byte[] byArray, int n2, int n3, OutputStream outputStream, MessageProp messageProp) throws GSSException {
        if (this.state != 3) {
            throw new GSSException(12, -1, "Wrap called in invalid state!");
        }
        WrapToken wrapToken = new WrapToken(this, messageProp, byArray, n2, n3);
        try {
            wrapToken.encode(outputStream);
        }
        catch (IOException iOException) {
            throw new GSSException(11, -1, iOException.getMessage());
        }
    }

    private void setSequencingAndReplayProps(MessageToken messageToken, MessageProp messageProp) {
        if (this.replayDetState || this.sequenceDetState) {
            int n2 = messageToken.getSequenceNumber();
            this.peerTokenTracker.getProps(n2, messageProp);
        }
    }

    Krb5Context(Krb5NameElement krb5NameElement, Krb5CredElement krb5CredElement, int n2) throws GSSException {
        if (krb5NameElement == null) {
            throw new IllegalArgumentException("Cannot have null for peer name");
        }
        this.peerName = krb5NameElement;
        this.myCred = krb5CredElement;
        this.lifetime = n2;
        this.initiator = true;
    }

    public final void verifyMIC(InputStream inputStream, InputStream inputStream2, MessageProp messageProp) throws GSSException {
        byte[] byArray;
        try {
            byArray = new byte[inputStream2.available()];
            inputStream2.read(byArray);
        }
        catch (IOException iOException) {
            throw new GSSException(11, -1, iOException.getMessage());
        }
        this.verifyMIC(inputStream, byArray, 0, byArray.length, messageProp);
    }

    public final void getMIC(InputStream inputStream, OutputStream outputStream, MessageProp messageProp) throws GSSException {
        byte[] byArray;
        try {
            byArray = new byte[inputStream.available()];
            inputStream.read(byArray);
        }
        catch (IOException iOException) {
            throw new GSSException(11, -1, iOException.getMessage());
        }
        this.getMIC(byArray, 0, byArray.length, outputStream, messageProp);
    }

    public final void unwrap(InputStream inputStream, OutputStream outputStream, MessageProp messageProp) throws GSSException {
        if (this.state != 3) {
            throw new GSSException(12, -1, "Unwrap called in invalid state!");
        }
        WrapToken wrapToken = new WrapToken(this, inputStream, messageProp);
        try {
            outputStream.write(wrapToken.getData());
        }
        catch (IOException iOException) {
            throw new GSSException(11, -1, iOException.getMessage());
        }
        this.setSequencingAndReplayProps(wrapToken, messageProp);
    }

    public final void wrap(InputStream inputStream, OutputStream outputStream, MessageProp messageProp) throws GSSException {
        byte[] byArray;
        try {
            byArray = new byte[inputStream.available()];
            inputStream.read(byArray);
        }
        catch (IOException iOException) {
            throw new GSSException(11, -1, iOException.getMessage());
        }
        this.wrap(byArray, 0, byArray.length, outputStream, messageProp);
    }
}

