/*
 * Decompiled with CFR 0.152.
 */
package sun.security.jgss.krb5;

import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.Provider;
import java.util.Iterator;
import javax.security.auth.DestroyFailedException;
import javax.security.auth.Subject;
import javax.security.auth.kerberos.KerberosKey;
import org.ietf.jgss.GSSException;
import org.ietf.jgss.Oid;
import sun.security.jgss.LoginUtility;
import sun.security.jgss.krb5.Krb5CredElement;
import sun.security.jgss.krb5.Krb5MechFactory;
import sun.security.jgss.krb5.Krb5NameElement;
import sun.security.jgss.spi.GSSNameSpi;
import sun.security.krb5.EncryptionKey;

public class Krb5AcceptCredential
extends KerberosKey
implements Krb5CredElement {
    private static Class KEY_CLASS;
    private Krb5NameElement name;
    private EncryptionKey krb5EncryptionKey;

    public int getAcceptLifetime() throws GSSException {
        return Integer.MAX_VALUE;
    }

    public int getInitLifetime() throws GSSException {
        return 0;
    }

    static {
        try {
            KEY_CLASS = Class.forName("javax.security.auth.kerberos.KerberosKey");
        }
        catch (ClassNotFoundException classNotFoundException) {}
    }

    public void destroy() throws DestroyFailedException {
        this.krb5EncryptionKey.destroy();
        super.destroy();
    }

    public void dispose() throws GSSException {
        try {
            this.destroy();
        }
        catch (DestroyFailedException destroyFailedException) {
            GSSException gSSException = new GSSException(11, -1, "Could not destroy credentials - " + destroyFailedException.getMessage());
            gSSException.initCause(destroyFailedException);
        }
    }

    public boolean isAcceptorCredential() throws GSSException {
        return true;
    }

    public boolean isInitiatorCredential() throws GSSException {
        return false;
    }

    static Class access$000() {
        return KEY_CLASS;
    }

    public final Provider getProvider() {
        return Krb5MechFactory.PROVIDER;
    }

    public final Oid getMechanism() {
        return Krb5MechFactory.GSS_KRB5_MECH_OID;
    }

    public final GSSNameSpi getName() throws GSSException {
        return this.name;
    }

    EncryptionKey getKrb5EncryptionKey() {
        return this.krb5EncryptionKey;
    }

    private static KerberosKey getKeyFromSubject(Krb5NameElement krb5NameElement) throws GSSException {
        String string = krb5NameElement == null ? null : krb5NameElement.getKrb5PrincipalName().getName();
        AccessControlContext accessControlContext = AccessController.getContext();
        Object object = AccessController.doPrivileged(new SubjectComber(accessControlContext, string));
        if (object == null && !LoginUtility.useSubjectCredsOnly()) {
            Subject subject = null;
            try {
                subject = (Subject)AccessController.doPrivileged(new LoginUtility(LoginUtility.GSS_ACCEPT_ENTRY));
            }
            catch (PrivilegedActionException privilegedActionException) {
                GSSException gSSException = new GSSException(13, -1, "Attempt to obtain new ACCEPT credentials failed!");
                gSSException.initCause(privilegedActionException.getException());
                throw gSSException;
            }
            object = AccessController.doPrivileged(new SubjectComber(subject, string));
        }
        return object == null ? null : (KerberosKey)object;
    }

    private Krb5AcceptCredential(Krb5NameElement krb5NameElement, KerberosKey kerberosKey) {
        super(kerberosKey.getPrincipal(), kerberosKey.getEncoded(), kerberosKey.getKeyType(), kerberosKey.getVersionNumber());
        this.name = krb5NameElement;
        this.krb5EncryptionKey = new EncryptionKey(kerberosKey.getEncoded(), kerberosKey.getKeyType(), new Integer(kerberosKey.getVersionNumber()));
    }

    static Krb5AcceptCredential getInstance(Krb5NameElement krb5NameElement) throws GSSException {
        KerberosKey kerberosKey = Krb5AcceptCredential.getKeyFromSubject(krb5NameElement);
        if (kerberosKey == null) {
            throw new GSSException(13, -1, "Failed to find any Kerberos Key");
        }
        if (krb5NameElement == null) {
            String string = kerberosKey.getPrincipal().getName();
            krb5NameElement = Krb5NameElement.getInstance(string, Krb5MechFactory.NT_GSS_KRB5_PRINCIPAL);
        }
        return new Krb5AcceptCredential(krb5NameElement, kerberosKey);
    }

    private static class SubjectComber
    implements PrivilegedAction {
        private AccessControlContext acc;
        private String principal;
        private Subject subject;

        public Object run() {
            if (this.subject == null) {
                this.subject = Subject.getSubject(this.acc);
            }
            if (this.subject != null) {
                Iterator iterator = this.subject.getPrivateCredentials(Krb5AcceptCredential.access$000()).iterator();
                while (iterator.hasNext()) {
                    KerberosKey kerberosKey = (KerberosKey)iterator.next();
                    if (this.principal != null && !this.principal.equals(kerberosKey.getPrincipal().getName())) continue;
                    return kerberosKey;
                }
            }
            return null;
        }

        public SubjectComber(AccessControlContext accessControlContext, String string) {
            this.acc = accessControlContext;
            this.principal = string;
        }

        public SubjectComber(Subject subject, String string) {
            this.subject = subject;
            this.principal = string;
        }
    }
}

