/*
 * Decompiled with CFR 0.152.
 */
package sun.security.jgss.krb5;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.ietf.jgss.GSSException;
import sun.security.jgss.krb5.InitialToken;
import sun.security.jgss.krb5.Krb5Context;
import sun.security.jgss.krb5.Krb5Token;
import sun.security.krb5.Credentials;
import sun.security.krb5.EncryptionKey;
import sun.security.krb5.KrbApRep;
import sun.security.krb5.KrbApReq;
import sun.security.krb5.KrbException;
import sun.security.util.DerValue;

class AcceptSecContextToken
extends InitialToken {
    private KrbApRep apRep = null;

    public final byte[] encode() throws IOException {
        byte[] byArray = this.apRep.getMessage();
        byte[] byArray2 = new byte[2 + byArray.length];
        Krb5Token.writeInt(512, byArray2, 0);
        System.arraycopy(byArray, 0, byArray2, 2, byArray.length);
        return byArray2;
    }

    public AcceptSecContextToken(Krb5Context krb5Context, KrbApReq krbApReq) throws KrbException, IOException {
        boolean bl2 = false;
        boolean bl3 = true;
        this.apRep = new KrbApRep(krbApReq, bl3, bl2);
        krb5Context.resetMySequenceNumber(this.apRep.getSeqNumber());
    }

    public AcceptSecContextToken(Krb5Context krb5Context, Credentials credentials, KrbApReq krbApReq, byte[] byArray, int n2, int n3) throws IOException, GSSException, KrbException {
        this(krb5Context, credentials, krbApReq, new ByteArrayInputStream(byArray, n2, n3));
    }

    public AcceptSecContextToken(Krb5Context krb5Context, Credentials credentials, KrbApReq krbApReq, InputStream inputStream) throws IOException, GSSException, KrbException {
        Integer n2;
        int n3 = inputStream.read() << 8 | inputStream.read();
        if (n3 != 512) {
            throw new GSSException(10, -1, "AP_REP token id does not match!");
        }
        byte[] byArray = new DerValue(inputStream).toByteArray();
        KrbApRep krbApRep = new KrbApRep(byArray, credentials, krbApReq);
        EncryptionKey encryptionKey = krbApRep.getSubKey();
        if (encryptionKey != null) {
            krb5Context.setKey(encryptionKey);
        }
        int n4 = (n2 = krbApRep.getSeqNumber()) != null ? n2 : 0;
        krb5Context.resetPeerSequenceNumber(n4);
    }
}

