/*
 * Decompiled with CFR 0.152.
 */
package sun.security.jgss;

import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Map;
import java.util.Set;
import org.ietf.jgss.GSSCredential;
import org.ietf.jgss.GSSException;
import org.ietf.jgss.GSSName;
import org.ietf.jgss.Oid;
import sun.security.jgss.GSSExceptionImpl;
import sun.security.jgss.GSSManagerImpl;
import sun.security.jgss.GSSNameImpl;
import sun.security.jgss.spi.GSSCredentialSpi;
import sun.security.jgss.spi.GSSNameSpi;

class GSSCredentialImpl
implements GSSCredential {
    private GSSManagerImpl gssManager = null;
    private Hashtable hashtable = null;
    private GSSCredentialSpi tempCred = null;

    public int getRemainingLifetime() throws GSSException {
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = Integer.MAX_VALUE;
        Enumeration enumeration = this.hashtable.keys();
        while (enumeration.hasMoreElements()) {
            SearchKey searchKey = (SearchKey)enumeration.nextElement();
            GSSCredentialSpi gSSCredentialSpi = (GSSCredentialSpi)this.hashtable.get(searchKey);
            if (searchKey.getUsage() == 1) {
                n2 = gSSCredentialSpi.getInitLifetime();
            } else if (searchKey.getUsage() == 2) {
                n2 = gSSCredentialSpi.getAcceptLifetime();
            } else {
                n3 = gSSCredentialSpi.getInitLifetime();
                int n6 = n2 = n3 < (n4 = gSSCredentialSpi.getAcceptLifetime()) ? n3 : n4;
            }
            if (n5 <= n2) continue;
            n5 = n2;
        }
        return n5;
    }

    public int getUsage() throws GSSException {
        boolean bl2 = false;
        boolean bl3 = false;
        Enumeration enumeration = this.hashtable.keys();
        while (enumeration.hasMoreElements()) {
            SearchKey searchKey = (SearchKey)enumeration.nextElement();
            if (searchKey.getUsage() == 1) {
                bl2 = true;
                continue;
            }
            if (searchKey.getUsage() == 2) {
                bl3 = true;
                continue;
            }
            return 0;
        }
        if (bl2) {
            if (bl3) {
                return 0;
            }
            return 1;
        }
        return 2;
    }

    public int hashCode() {
        return 1;
    }

    public void dispose() throws GSSException {
        throw new GSSException(16);
    }

    public boolean equals(Object object) {
        if (!(object instanceof GSSCredentialImpl)) {
            return false;
        }
        return false;
    }

    public String toString() {
        GSSCredentialSpi gSSCredentialSpi = null;
        StringBuffer stringBuffer = new StringBuffer("[GSSCredential: ");
        Object[] objectArray = this.hashtable.entrySet().toArray();
        int n2 = 0;
        while (n2 < objectArray.length) {
            try {
                stringBuffer.append('\n');
                gSSCredentialSpi = (GSSCredentialSpi)((Map.Entry)objectArray[n2]).getValue();
                stringBuffer.append(gSSCredentialSpi.getName());
                stringBuffer.append(' ');
                stringBuffer.append(gSSCredentialSpi.getMechanism());
                stringBuffer.append(gSSCredentialSpi.isInitiatorCredential() ? " Initiate" : "");
                stringBuffer.append(gSSCredentialSpi.isAcceptorCredential() ? " Accept" : "");
                stringBuffer.append(" [");
                stringBuffer.append(gSSCredentialSpi.toString());
                stringBuffer.append(']');
            }
            catch (GSSException gSSException) {
                // empty catch block
            }
            ++n2;
        }
        stringBuffer.append(']');
        return stringBuffer.toString();
    }

    Set getElements() {
        HashSet hashSet = new HashSet(this.hashtable.size());
        Enumeration enumeration = this.hashtable.elements();
        while (enumeration.hasMoreElements()) {
            Object object = enumeration.nextElement();
            hashSet.add(object);
        }
        return hashSet;
    }

    public GSSName getName() throws GSSException {
        return new GSSNameImpl(this.gssManager, this.tempCred.getName());
    }

    public Oid[] getMechs() throws GSSException {
        Oid[] oidArray = new Oid[]{this.tempCred.getMechanism()};
        return oidArray;
    }

    public int getRemainingAcceptLifetime(Oid oid) throws GSSException {
        GSSCredentialSpi gSSCredentialSpi = null;
        SearchKey searchKey = null;
        boolean bl2 = false;
        int n2 = 0;
        if (oid == null) {
            oid = this.gssManager.getDefaultMechanism();
        }
        if ((gSSCredentialSpi = (GSSCredentialSpi)this.hashtable.get(searchKey = new SearchKey(oid, 2))) != null) {
            bl2 = true;
            if (n2 < gSSCredentialSpi.getAcceptLifetime()) {
                n2 = gSSCredentialSpi.getAcceptLifetime();
            }
        }
        if ((gSSCredentialSpi = (GSSCredentialSpi)this.hashtable.get(searchKey = new SearchKey(oid, 0))) != null) {
            bl2 = true;
            if (n2 < gSSCredentialSpi.getAcceptLifetime()) {
                n2 = gSSCredentialSpi.getAcceptLifetime();
            }
        }
        if (!bl2) {
            throw new GSSExceptionImpl(2, oid.toString());
        }
        return n2;
    }

    public int getRemainingInitLifetime(Oid oid) throws GSSException {
        GSSCredentialSpi gSSCredentialSpi = null;
        SearchKey searchKey = null;
        boolean bl2 = false;
        int n2 = 0;
        if (oid == null) {
            oid = this.gssManager.getDefaultMechanism();
        }
        if ((gSSCredentialSpi = (GSSCredentialSpi)this.hashtable.get(searchKey = new SearchKey(oid, 1))) != null) {
            bl2 = true;
            if (n2 < gSSCredentialSpi.getInitLifetime()) {
                n2 = gSSCredentialSpi.getInitLifetime();
            }
        }
        if ((gSSCredentialSpi = (GSSCredentialSpi)this.hashtable.get(searchKey = new SearchKey(oid, 0))) != null) {
            bl2 = true;
            if (n2 < gSSCredentialSpi.getInitLifetime()) {
                n2 = gSSCredentialSpi.getInitLifetime();
            }
        }
        if (!bl2) {
            throw new GSSExceptionImpl(2, oid.toString());
        }
        return n2;
    }

    public int getUsage(Oid oid) throws GSSException {
        GSSCredentialSpi gSSCredentialSpi = null;
        SearchKey searchKey = null;
        boolean bl2 = false;
        boolean bl3 = false;
        if (oid == null) {
            oid = this.gssManager.getDefaultMechanism();
        }
        if ((gSSCredentialSpi = (GSSCredentialSpi)this.hashtable.get(searchKey = new SearchKey(oid, 1))) != null) {
            bl2 = true;
        }
        if ((gSSCredentialSpi = (GSSCredentialSpi)this.hashtable.get(searchKey = new SearchKey(oid, 2))) != null) {
            bl3 = true;
        }
        if ((gSSCredentialSpi = (GSSCredentialSpi)this.hashtable.get(searchKey = new SearchKey(oid, 0))) != null) {
            bl2 = true;
            bl3 = true;
        }
        if (bl2 && bl3) {
            return 0;
        }
        if (bl2) {
            return 1;
        }
        if (bl3) {
            return 2;
        }
        throw new GSSExceptionImpl(2, oid.toString());
    }

    void init(GSSManagerImpl gSSManagerImpl) {
        this.gssManager = gSSManagerImpl;
        this.hashtable = new Hashtable(gSSManagerImpl.getMechs().length);
    }

    public GSSCredentialImpl(GSSManagerImpl gSSManagerImpl, int n2) throws GSSException {
        this(gSSManagerImpl, null, 0, (Oid[])null, n2);
    }

    private static String getElementStr(Oid oid, int n2) {
        String string = oid.toString();
        string = n2 == 1 ? string.concat(" usage: Initiate") : (n2 == 2 ? string.concat(" usage: Accept") : string.concat(" usage: Initiate and Accept"));
        return string;
    }

    public GSSName getName(Oid oid) throws GSSException {
        SearchKey searchKey = null;
        GSSCredentialSpi gSSCredentialSpi = null;
        if (oid == null) {
            oid = this.gssManager.getDefaultMechanism();
        }
        if ((gSSCredentialSpi = (GSSCredentialSpi)this.hashtable.get(searchKey = new SearchKey(oid, 1))) == null) {
            searchKey = new SearchKey(oid, 2);
            gSSCredentialSpi = (GSSCredentialSpi)this.hashtable.get(searchKey);
        }
        if (gSSCredentialSpi == null) {
            searchKey = new SearchKey(oid, 0);
            gSSCredentialSpi = (GSSCredentialSpi)this.hashtable.get(searchKey);
        }
        if (gSSCredentialSpi == null) {
            throw new GSSExceptionImpl(2, oid.toString());
        }
        return new GSSNameImpl(this.gssManager, gSSCredentialSpi.getName());
    }

    public void add(GSSName gSSName, int n2, int n3, Oid oid, int n4) throws GSSException {
        SearchKey searchKey;
        if (oid == null) {
            oid = this.gssManager.getDefaultMechanism();
        }
        if (this.hashtable.containsKey(searchKey = new SearchKey(oid, n4))) {
            throw new GSSExceptionImpl(17, GSSCredentialImpl.getElementStr(oid, n4));
        }
        GSSNameSpi gSSNameSpi = gSSName == null ? null : ((GSSNameImpl)gSSName).getElement(oid);
        this.tempCred = this.gssManager.getCredentialElement(gSSNameSpi, n2, n3, oid, n4);
        if (!(n4 != 0 || this.tempCred.isAcceptorCredential() && this.tempCred.isInitiatorCredential())) {
            int n5;
            int n6;
            if (!this.tempCred.isInitiatorCredential()) {
                n6 = 2;
                n5 = 1;
            } else {
                n6 = 1;
                n5 = 2;
            }
            searchKey = new SearchKey(oid, n6);
            this.hashtable.put(searchKey, this.tempCred);
            this.tempCred = this.gssManager.getCredentialElement(gSSNameSpi, n2, n3, oid, n5);
            searchKey = new SearchKey(oid, n5);
            this.hashtable.put(searchKey, this.tempCred);
        } else {
            this.hashtable.put(searchKey, this.tempCred);
        }
    }

    GSSCredentialSpi getElement(Oid oid, boolean bl2) throws GSSException {
        GSSCredentialSpi gSSCredentialSpi;
        if (oid == null) {
            oid = this.gssManager.getDefaultMechanism();
            SearchKey searchKey = new SearchKey(oid, bl2 ? 1 : 2);
            gSSCredentialSpi = (GSSCredentialSpi)this.hashtable.get(searchKey);
            if (gSSCredentialSpi == null && (gSSCredentialSpi = (GSSCredentialSpi)this.hashtable.get(searchKey = new SearchKey(oid, 0))) == null) {
                Object[] objectArray = this.hashtable.entrySet().toArray();
                int n2 = 0;
                while (n2 < objectArray.length) {
                    gSSCredentialSpi = (GSSCredentialSpi)((Map.Entry)objectArray[n2]).getValue();
                    if (gSSCredentialSpi.isInitiatorCredential() != bl2) {
                        ++n2;
                        continue;
                    }
                    break;
                }
            }
        } else {
            SearchKey searchKey = bl2 ? new SearchKey(oid, 1) : new SearchKey(oid, 2);
            gSSCredentialSpi = (GSSCredentialSpi)this.hashtable.get(searchKey);
            if (gSSCredentialSpi == null) {
                searchKey = new SearchKey(oid, 0);
                gSSCredentialSpi = (GSSCredentialSpi)this.hashtable.get(searchKey);
            }
        }
        if (gSSCredentialSpi == null) {
            throw new GSSExceptionImpl(13, GSSCredentialImpl.getElementStr(oid, bl2 ? 1 : 2));
        }
        return gSSCredentialSpi;
    }

    GSSCredentialImpl(GSSManagerImpl gSSManagerImpl, GSSCredentialSpi gSSCredentialSpi) throws GSSException {
        this.init(gSSManagerImpl);
        int n2 = 2;
        if (gSSCredentialSpi.isInitiatorCredential()) {
            n2 = gSSCredentialSpi.isAcceptorCredential() ? 0 : 1;
        }
        SearchKey searchKey = new SearchKey(gSSCredentialSpi.getMechanism(), n2);
        this.tempCred = gSSCredentialSpi;
        this.hashtable.put(searchKey, this.tempCred);
    }

    public GSSCredentialImpl(GSSManagerImpl gSSManagerImpl, GSSName gSSName, int n2, Oid oid, int n3) throws GSSException {
        this.init(gSSManagerImpl);
        this.add(gSSName, n2, n2, oid, n3);
    }

    public GSSCredentialImpl(GSSManagerImpl gSSManagerImpl, GSSName gSSName, int n2, Oid[] oidArray, int n3) throws GSSException {
        this.init(gSSManagerImpl);
        boolean bl2 = false;
        if (oidArray == null) {
            oidArray = gSSManagerImpl.getMechs();
            bl2 = true;
        }
        int n4 = 0;
        while (n4 < oidArray.length) {
            block5: {
                try {
                    this.add(gSSName, n2, n2, oidArray[n4], n3);
                }
                catch (GSSException gSSException) {
                    gSSException.printStackTrace();
                    if (bl2) break block5;
                    throw gSSException;
                }
            }
            ++n4;
        }
        if (this.hashtable.size() == 0) {
            throw new GSSException(13);
        }
    }

    static class SearchKey {
        private Oid mechOid = null;
        private int usage = 0;

        public int getUsage() {
            return this.usage;
        }

        public int hashCode() {
            return this.mechOid.hashCode();
        }

        public boolean equals(Object object) {
            if (!(object instanceof SearchKey)) {
                return false;
            }
            SearchKey searchKey = (SearchKey)object;
            return this.mechOid.equals(searchKey.mechOid) && this.usage == searchKey.usage;
        }

        public SearchKey(Oid oid, int n2) {
            this.mechOid = oid;
            this.usage = n2;
        }
    }
}

