/*
 * Decompiled with CFR 0.152.
 */
package sun.rmi.transport.tcp;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.lang.ref.SoftReference;
import java.lang.reflect.InvocationTargetException;
import java.net.BindException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.rmi.RemoteException;
import java.rmi.server.ExportException;
import java.rmi.server.LogStream;
import java.rmi.server.RMIFailureHandler;
import java.rmi.server.RMISocketFactory;
import java.rmi.server.ServerNotActiveException;
import java.rmi.server.UID;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.WeakHashMap;
import sun.rmi.runtime.Log;
import sun.rmi.runtime.NewThreadAction;
import sun.rmi.transport.Channel;
import sun.rmi.transport.Connection;
import sun.rmi.transport.DGCAckHandler;
import sun.rmi.transport.Endpoint;
import sun.rmi.transport.StreamRemoteCall;
import sun.rmi.transport.Target;
import sun.rmi.transport.Transport;
import sun.rmi.transport.proxy.HttpReceiveSocket;
import sun.rmi.transport.tcp.ConnectionMultiplexer;
import sun.rmi.transport.tcp.TCPChannel;
import sun.rmi.transport.tcp.TCPConnection;
import sun.rmi.transport.tcp.TCPEndpoint;
import sun.security.action.GetIntegerAction;
import sun.security.action.GetPropertyAction;

public class TCPTransport
extends Transport
implements Runnable {
    static final int logLevel = LogStream.parseLevel(TCPTransport.getLogLevel());
    static final Log tcpLog = Log.getLog("sun.rmi.transport.tcp", "tcp", logLevel);
    private static int threadNum = 0;
    private static final ThreadLocal threadConnectionHandler = new ThreadLocal();
    private final LinkedList epList;
    private ServerSocket server = null;
    private final Map channelTable = new HashMap(11);
    static final RMISocketFactory defaultSocketFactory = RMISocketFactory.getDefaultSocketFactory();
    private static final int connectionReadTimeout = (Integer)AccessController.doPrivileged(new GetIntegerAction("sun.rmi.transport.tcp.readTimeout", 0x6DDD00));
    private transient long acceptFailureTime = 0L;
    private transient int acceptFailureCount;

    static int access$200() {
        return connectionReadTimeout;
    }

    private synchronized void listen() throws RemoteException {
        TCPEndpoint tCPEndpoint = this.getEndpoint();
        int n2 = tCPEndpoint.getPort();
        if (this.server == null) {
            if (tcpLog.isLoggable(Log.BRIEF)) {
                tcpLog.log(Log.BRIEF, "(port " + n2 + ") create server socket");
            }
            try {
                this.server = tCPEndpoint.newServerSocket();
                Thread thread = (Thread)AccessController.doPrivileged(new NewThreadAction(this, "TCP Accept-" + n2, true));
                thread.start();
            }
            catch (BindException bindException) {
                throw new ExportException("Port already in use: " + n2, bindException);
            }
            catch (IOException iOException) {
                throw new ExportException("Listen failed on port: " + n2, iOException);
            }
        } else {
            SecurityManager securityManager = System.getSecurityManager();
            if (securityManager != null) {
                securityManager.checkListen(n2);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    public void run() {
        if (TCPTransport.tcpLog.isLoggable(Log.BRIEF)) {
            TCPTransport.tcpLog.log(Log.BRIEF, "listening on port " + this.getEndpoint().getPort());
        }
        while (true) {
            if ((var1_1 = this.server) == null) {
                return;
            }
            var2_2 /* !! */  = null;
            try {
                var3_3 = var1_1.accept();
                var4_4 = var3_3.getInetAddress();
                var5_7 = var4_4 != null ? var4_4.getHostAddress() : "0.0.0.0";
                var6_11 = (Thread)AccessController.doPrivileged(new NewThreadAction(new ConnectionHandler(this, var3_3, var5_7), "TCP Connection(" + ++TCPTransport.threadNum + ")-" + var5_7, true, true));
                var6_11.start();
                continue;
            }
            catch (IOException var4_6) {
                var2_2 /* !! */  = var4_6;
            }
            catch (RuntimeException var5_10) {
                var2_2 /* !! */  = var5_10;
            }
            catch (Error var6_14) {
                var2_2 /* !! */  = var6_14;
            }
            finally {
                if (var2_2 /* !! */  == null) continue;
                if (!(var2_2 /* !! */  instanceof SecurityException)) {
                    try {
                        TCPEndpoint.shedConnectionCaches();
                    }
                    catch (OutOfMemoryError var5_9) {
                    }
                    catch (Exception var6_12) {}
                }
                if (var2_2 /* !! */  instanceof IOException || var2_2 /* !! */  instanceof OutOfMemoryError || var2_2 /* !! */  instanceof NoClassDefFoundError || var2_2 /* !! */  instanceof MissingResourceException || var2_2 /* !! */  instanceof SecurityException) {
                    if (!this.continueAfterAcceptFailure(var2_2 /* !! */ )) ** break;
                    continue;
                    return;
                }
                if (var2_2 /* !! */  instanceof RuntimeException) {
                    throw (RuntimeException)var2_2 /* !! */ ;
                }
                throw (Error)var2_2 /* !! */ ;
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void shedConnectionCaches() {
        int n2;
        TCPChannel[] tCPChannelArray;
        Map map = this.channelTable;
        synchronized (map) {
            tCPChannelArray = new TCPChannel[this.channelTable.size()];
            Iterator iterator = this.channelTable.values().iterator();
            n2 = 0;
            while (iterator.hasNext()) {
                tCPChannelArray[n2] = (TCPChannel)iterator.next();
                ++n2;
            }
        }
        while (--n2 >= 0) {
            tCPChannelArray[n2].shedCache();
        }
    }

    public static String getClientHost() throws ServerNotActiveException {
        ConnectionHandler connectionHandler = (ConnectionHandler)threadConnectionHandler.get();
        if (connectionHandler != null) {
            return connectionHandler.getClientHost();
        }
        throw new ServerNotActiveException("not in a remote call");
    }

    private static String getLogLevel() {
        return (String)AccessController.doPrivileged(new GetPropertyAction("sun.rmi.transport.tcp.logLevel"));
    }

    static ThreadLocal access$100() {
        return threadConnectionHandler;
    }

    private synchronized boolean continueAfterAcceptFailure(Throwable throwable) {
        boolean bl2;
        RMIFailureHandler rMIFailureHandler = RMISocketFactory.getFailureHandler();
        if (rMIFailureHandler != null) {
            bl2 = throwable instanceof Exception ? rMIFailureHandler.failure((Exception)throwable) : rMIFailureHandler.failure(new InvocationTargetException(throwable));
        } else {
            long l2 = System.currentTimeMillis();
            if (this.acceptFailureTime == 0L || l2 - this.acceptFailureTime > 5000L) {
                this.acceptFailureTime = l2;
                this.acceptFailureCount = 0;
            } else {
                ++this.acceptFailureCount;
                if (this.acceptFailureCount >= 10) {
                    try {
                        Thread.sleep(10000L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
            }
            bl2 = true;
        }
        return bl2;
    }

    static void access$300(Socket socket) {
        TCPTransport.closeSocket(socket);
    }

    private static void closeSocket(Socket socket) {
        try {
            socket.close();
        }
        catch (IOException iOException) {}
    }

    protected void checkAcceptPermission(AccessControlContext accessControlContext) {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager == null) {
            return;
        }
        ConnectionHandler connectionHandler = (ConnectionHandler)threadConnectionHandler.get();
        if (connectionHandler == null) {
            throw new Error("checkAcceptPermission not in ConnectionHandler thread");
        }
        connectionHandler.checkAcceptPermission(securityManager, accessControlContext);
    }

    TCPTransport(LinkedList linkedList) {
        this.epList = linkedList;
        if (tcpLog.isLoggable(Log.BRIEF)) {
            tcpLog.log(Log.BRIEF, "Version = 2, ep = " + this.getEndpoint());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void handleMessages(Connection var1_1, boolean var2_2) {
        block20: {
            block21: {
                var3_3 = this.getEndpoint().getPort();
                try {
                    try {
                        var4_4 = new DataInputStream(var1_1.getInputStream());
                        block14: do {
                            if ((var5_6 = var4_4.read()) == -1) {
                                if (TCPTransport.tcpLog.isLoggable(Log.BRIEF)) {
                                    TCPTransport.tcpLog.log(Log.BRIEF, "(port " + var3_3 + ") connection closed");
                                }
                                break block20;
                            }
                            if (TCPTransport.tcpLog.isLoggable(Log.BRIEF)) {
                                TCPTransport.tcpLog.log(Log.BRIEF, "(port " + var3_3 + ") op = " + var5_6);
                            }
                            switch (var5_6) {
                                case 80: {
                                    var6_7 = new StreamRemoteCall(var1_1);
                                    if (this.serviceCall(var6_7)) continue block14;
                                    var9_9 = null;
                                    break block21;
                                }
                                case 82: {
                                    var7_8 = new DataOutputStream(var1_1.getOutputStream());
                                    var7_8.writeByte(83);
                                    var1_1.releaseOutputStream();
                                    break;
                                }
                                case 84: {
                                    DGCAckHandler.received(UID.read(var4_4));
                                    break;
                                }
                                default: {
                                    throw new IOException("unknown transport op " + var5_6);
                                }
                            }
                        } while (var2_2);
                        break block20;
                    }
                    catch (IOException var4_5) {
                        if (TCPTransport.tcpLog.isLoggable(Log.BRIEF)) {
                            TCPTransport.tcpLog.log(Log.BRIEF, "(port " + var3_3 + ") exception: ", var4_5);
                        }
                        var9_11 = null;
                        try {
                            var1_1.close();
                            return;
                        }
                        catch (IOException var10_15) {
                            return;
                        }
                    }
                }
                catch (Throwable var8_17) {
                    var9_12 = null;
                    ** try [egrp 2[TRYBLOCK] [6 : 340->349)] { 
lbl45:
                    // 1 sources

                    var1_1.close();
                    throw var8_17;
lbl47:
                    // 1 sources

                    catch (IOException var10_16) {
                        // empty catch block
                    }
                    throw var8_17;
                }
            }
            ** try [egrp 2[TRYBLOCK] [6 : 340->349)] { 
lbl52:
            // 1 sources

            var1_1.close();
            return;
lbl54:
            // 1 sources

            catch (IOException var10_13) {
                // empty catch block
            }
            return;
        }
        var9_10 = null;
        try {}
        catch (IOException var10_14) {}
        var1_1.close();
        return;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void free(Endpoint endpoint) {
        if (endpoint instanceof TCPEndpoint) {
            Map map = this.channelTable;
            synchronized (map) {
                TCPChannel tCPChannel = (TCPChannel)this.channelTable.remove(endpoint);
                if (tCPChannel != null) {
                    tCPChannel.shedCache();
                }
            }
        }
    }

    public void exportObject(Target target) throws RemoteException {
        this.listen();
        target.setExportedTransport(this);
        super.exportObject(target);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TCPEndpoint getEndpoint() {
        LinkedList linkedList = this.epList;
        synchronized (linkedList) {
            return (TCPEndpoint)this.epList.getLast();
        }
    }

    static Map access$400(TCPTransport tCPTransport) {
        return tCPTransport.channelTable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Channel getChannel(Endpoint endpoint) {
        Channel channel = null;
        if (endpoint instanceof TCPEndpoint) {
            Map map = this.channelTable;
            synchronized (map) {
                channel = (Channel)this.channelTable.get(endpoint);
                if (channel == null) {
                    channel = new TCPChannel(this, (TCPEndpoint)endpoint);
                    this.channelTable.put(endpoint, channel);
                }
            }
        }
        return channel;
    }

    static TCPEndpoint access$000(TCPTransport tCPTransport) {
        return tCPTransport.getEndpoint();
    }

    private class ConnectionHandler
    implements Runnable {
        private static final int POST = 1347375956;
        private AccessControlContext okContext;
        private WeakHashMap authCache;
        private SecurityManager cacheSecurityManager;
        private Socket socket;
        private String remoteHost;
        private final TCPTransport this$0;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Unable to fully structure code
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void run() {
            block28: {
                block27: {
                    var1_1 = TCPTransport.access$000(this.this$0);
                    var2_2 = var1_1.getPort();
                    TCPTransport.access$100().set(this);
                    try {
                        this.socket.setTcpNoDelay(true);
                    }
                    catch (Exception var3_3) {
                        // empty catch block
                    }
                    try {
                        if (TCPTransport.access$200() > 0) {
                            this.socket.setSoTimeout(TCPTransport.access$200());
                        }
                    }
                    catch (Exception var3_4) {
                        // empty catch block
                    }
                    try {
                        try {
                            var3_5 = this.socket.getInputStream();
                            var4_7 = var3_5.markSupported() != false ? var3_5 : new BufferedInputStream(var3_5);
                            var4_7.mark(4);
                            var5_8 = new DataInputStream(var4_7);
                            var6_9 = var5_8.readInt();
                            if (var6_9 == 1347375956) {
                                TCPTransport.tcpLog.log(Log.BRIEF, "decoding HTTP-wrapped call");
                                var4_7.reset();
                                try {
                                    this.socket = new HttpReceiveSocket(this.socket, var4_7, null);
                                    this.remoteHost = "0.0.0.0";
                                    var3_5 = this.socket.getInputStream();
                                    var4_7 = new BufferedInputStream(var3_5);
                                    var5_8 = new DataInputStream(var4_7);
                                    var6_9 = var5_8.readInt();
                                }
                                catch (IOException var7_10) {
                                    throw new RemoteException("Error HTTP-unwrapping call", var7_10);
                                }
                            }
                            var7_11 = var5_8.readShort();
                            if (var6_9 != 1246907721 || var7_11 != 2) {
                                TCPTransport.access$300(this.socket);
                                var22_12 = null;
                                break block27;
                            }
                            var8_16 = this.socket.getOutputStream();
                            var9_17 = new BufferedOutputStream(var8_16);
                            var10_18 = new DataOutputStream(var9_17);
                            var11_19 = this.socket.getPort();
                            if (TCPTransport.tcpLog.isLoggable(Log.BRIEF)) {
                                TCPTransport.tcpLog.log(Log.BRIEF, "accepted socket from [" + this.remoteHost + ":" + var11_19 + "]");
                            }
                            var15_20 = var5_8.readByte();
                            switch (var15_20) {
                                case 76: {
                                    var12_21 = new TCPEndpoint(this.remoteHost, this.socket.getLocalPort(), var1_1.getClientSocketFactory(), var1_1.getServerSocketFactory());
                                    var13_24 = new TCPChannel(this.this$0, var12_21);
                                    var14_27 = new TCPConnection(var13_24, this.socket, var4_7, var9_17);
                                    this.this$0.handleMessages(var14_27, false);
                                    ** break;
                                }
                                case 75: {
                                    var10_18.writeByte(78);
                                    if (TCPTransport.tcpLog.isLoggable(Log.VERBOSE)) {
                                        TCPTransport.tcpLog.log(Log.VERBOSE, "(port " + var2_2 + ") " + "suggesting " + this.remoteHost + ":" + var11_19);
                                    }
                                    var10_18.writeUTF(this.remoteHost);
                                    var10_18.writeInt(var11_19);
                                    var10_18.flush();
                                    var16_29 = var5_8.readUTF();
                                    var17_30 = var5_8.readInt();
                                    if (TCPTransport.tcpLog.isLoggable(Log.VERBOSE)) {
                                        TCPTransport.tcpLog.log(Log.VERBOSE, "(port " + var2_2 + ") client using " + var16_29 + ":" + var17_30);
                                    }
                                    var12_22 = new TCPEndpoint(this.remoteHost, this.socket.getLocalPort(), var1_1.getClientSocketFactory(), var1_1.getServerSocketFactory());
                                    var13_25 = new TCPChannel(this.this$0, var12_22);
                                    var14_28 = new TCPConnection(var13_25, this.socket, var4_7, var9_17);
                                    this.this$0.handleMessages(var14_28, true);
                                    ** break;
                                }
                                case 77: {
                                    if (TCPTransport.tcpLog.isLoggable(Log.VERBOSE)) {
                                        TCPTransport.tcpLog.log(Log.VERBOSE, "(port " + var2_2 + ") accepting multiplex protocol");
                                    }
                                    var10_18.writeByte(78);
                                    if (TCPTransport.tcpLog.isLoggable(Log.VERBOSE)) {
                                        TCPTransport.tcpLog.log(Log.VERBOSE, "(port " + var2_2 + ") suggesting " + this.remoteHost + ":" + var11_19);
                                    }
                                    var10_18.writeUTF(this.remoteHost);
                                    var10_18.writeInt(var11_19);
                                    var10_18.flush();
                                    var12_23 = new TCPEndpoint(var5_8.readUTF(), var5_8.readInt(), var1_1.getClientSocketFactory(), var1_1.getServerSocketFactory());
                                    if (TCPTransport.tcpLog.isLoggable(Log.VERBOSE)) {
                                        TCPTransport.tcpLog.log(Log.VERBOSE, "(port " + var2_2 + ") client using " + var12_23.getHost() + ":" + var12_23.getPort());
                                    }
                                    var19_31 = TCPTransport.access$400(this.this$0);
                                    synchronized (var19_31) {
                                        var13_26 = (TCPChannel)this.this$0.getChannel(var12_23);
                                        var18_32 = new ConnectionMultiplexer(var13_26, var4_7, var8_16, false);
                                        var13_26.useMultiplexer(var18_32);
                                    }
                                    var18_32.run();
                                    ** break;
                                }
                            }
                            var10_18.writeByte(79);
                            var10_18.flush();
                            break block28;
                        }
                        catch (IOException var3_6) {
                            TCPTransport.tcpLog.log(Log.BRIEF, "terminated with exception:", var3_6);
                            var22_14 = null;
                            TCPTransport.access$300(this.socket);
                            return;
                        }
                    }
                    catch (Throwable var21_33) {
                        var22_15 = null;
                        TCPTransport.access$300(this.socket);
                        throw var21_33;
                    }
                }
                TCPTransport.access$300(this.socket);
                return;
            }
            var22_13 = null;
            TCPTransport.access$300(this.socket);
        }

        String getClientHost() {
            return this.remoteHost;
        }

        void checkAcceptPermission(SecurityManager securityManager, AccessControlContext accessControlContext) {
            if (securityManager != this.cacheSecurityManager) {
                this.okContext = null;
                this.authCache = new WeakHashMap();
                this.cacheSecurityManager = securityManager;
            }
            if (accessControlContext.equals(this.okContext) || this.authCache.containsKey(accessControlContext)) {
                return;
            }
            InetAddress inetAddress = this.socket.getInetAddress();
            String string = inetAddress != null ? inetAddress.getHostAddress() : "*";
            securityManager.checkAccept(string, this.socket.getPort());
            this.authCache.put(accessControlContext, new SoftReference(accessControlContext));
            this.okContext = accessControlContext;
        }

        ConnectionHandler(TCPTransport tCPTransport, Socket socket, String string) {
            this.this$0 = tCPTransport;
            this.cacheSecurityManager = null;
            this.socket = socket;
            this.remoteHost = string;
        }
    }
}

