/*
 * Decompiled with CFR 0.152.
 */
package sun.rmi.server;

import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.rmi.MarshalledObject;
import java.rmi.NoSuchObjectException;
import java.rmi.RMISecurityManager;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.rmi.activation.Activatable;
import java.rmi.activation.ActivationDesc;
import java.rmi.activation.ActivationException;
import java.rmi.activation.ActivationGroup;
import java.rmi.activation.ActivationGroupID;
import java.rmi.activation.ActivationID;
import java.rmi.activation.UnknownObjectException;
import java.rmi.server.RMIClassLoader;
import java.rmi.server.UnicastRemoteObject;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Hashtable;

public class ActivationGroupImpl
extends ActivationGroup {
    private static final long serialVersionUID = 5758693559430427303L;
    private Hashtable active = new Hashtable(101);
    private boolean groupInactive = false;
    private ActivationGroupID groupID;
    private ArrayList lockedIDs = new ArrayList();
    private static Class[] objConstrParams = new Class[]{class$java$rmi$activation$ActivationID == null ? (class$java$rmi$activation$ActivationID = ActivationGroupImpl.class$("java.rmi.activation.ActivationID")) : class$java$rmi$activation$ActivationID, class$java$rmi$MarshalledObject == null ? (class$java$rmi$MarshalledObject = ActivationGroupImpl.class$("java.rmi.MarshalledObject")) : class$java$rmi$MarshalledObject};
    static Class class$java$rmi$activation$ActivationID;
    static Class class$java$rmi$MarshalledObject;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkInactiveGroup() {
        block8: {
            boolean bl2 = false;
            ActivationGroupImpl activationGroupImpl = this;
            synchronized (activationGroupImpl) {
                if (this.active.size() == 0 && this.lockedIDs.size() == 0 && !this.groupInactive) {
                    this.groupInactive = true;
                    bl2 = true;
                }
            }
            if (!bl2) break block8;
            try {
                super.inactiveGroup();
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                UnicastRemoteObject.unexportObject(this, true);
            }
            catch (NoSuchObjectException noSuchObjectException) {}
        }
    }

    static Class[] access$000() {
        return objConstrParams;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void acquireLock(ActivationID activationID) {
        while (true) {
            ActivationID activationID2;
            ArrayList arrayList = this.lockedIDs;
            synchronized (arrayList) {
                int n2 = this.lockedIDs.indexOf(activationID);
                if (n2 < 0) {
                    this.lockedIDs.add(activationID);
                    return;
                }
                activationID2 = (ActivationID)this.lockedIDs.get(n2);
            }
            ActivationID activationID3 = activationID2;
            synchronized (activationID3) {
                ArrayList arrayList2 = this.lockedIDs;
                synchronized (arrayList2) {
                    int n3 = this.lockedIDs.indexOf(activationID2);
                    if (n3 < 0) {
                        continue;
                    }
                    ActivationID activationID4 = (ActivationID)this.lockedIDs.get(n3);
                    if (activationID4 != activationID2) {
                        continue;
                    }
                }
                try {
                    activationID2.wait();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void releaseLock(ActivationID activationID) {
        ArrayList arrayList = this.lockedIDs;
        synchronized (arrayList) {
            activationID = (ActivationID)this.lockedIDs.remove(this.lockedIDs.indexOf(activationID));
        }
        ActivationID activationID2 = activationID;
        synchronized (activationID2) {
            activationID.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean inactiveObject(ActivationID activationID) throws ActivationException, UnknownObjectException, RemoteException {
        try {
            block10: {
                boolean bl2;
                this.acquireLock(activationID);
                ActivationGroupImpl activationGroupImpl = this;
                synchronized (activationGroupImpl) {
                    if (this.groupInactive) {
                        throw new ActivationException("group is inactive");
                    }
                }
                ActiveEntry activeEntry = (ActiveEntry)this.active.get(activationID);
                if (activeEntry == null) {
                    throw new UnknownObjectException("object not active");
                }
                try {
                    if (Activatable.unexportObject(activeEntry.impl, false)) break block10;
                    bl2 = false;
                }
                catch (NoSuchObjectException bl22) {
                    // empty catch block
                    break block10;
                }
                Object var6_7 = null;
                this.releaseLock(activationID);
                this.checkInactiveGroup();
                return bl2;
            }
            try {
                super.inactiveObject(activationID);
            }
            catch (UnknownObjectException noSuchObjectException) {
                // empty catch block
            }
            this.active.remove(activationID);
        }
        catch (Throwable throwable) {
            Object var6_9 = null;
            this.releaseLock(activationID);
            this.checkInactiveGroup();
            throw throwable;
        }
        Object var6_8 = null;
        this.releaseLock(activationID);
        this.checkInactiveGroup();
        return true;
    }

    static Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public ActivationGroupImpl(ActivationGroupID activationGroupID, MarshalledObject marshalledObject) throws RemoteException {
        super(activationGroupID);
        this.groupID = activationGroupID;
        if (System.getSecurityManager() == null) {
            try {
                System.setSecurityManager(new RMISecurityManager());
            }
            catch (Exception exception) {
                throw new RemoteException("unable to set security manager", exception);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void activeObject(ActivationID activationID, Remote remote) throws ActivationException, UnknownObjectException, RemoteException {
        try {
            this.acquireLock(activationID);
            ActivationGroupImpl activationGroupImpl = this;
            synchronized (activationGroupImpl) {
                if (this.groupInactive) {
                    throw new ActivationException("group is inactive");
                }
            }
            if (!this.active.contains(activationID)) {
                ActiveEntry activeEntry = new ActiveEntry(remote);
                this.active.put(activationID, activeEntry);
                super.activeObject(activationID, activeEntry.mobj);
            }
            Object var6_6 = null;
            this.releaseLock(activationID);
            this.checkInactiveGroup();
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            this.releaseLock(activationID);
            this.checkInactiveGroup();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public MarshalledObject newInstance(ActivationID activationID, ActivationDesc activationDesc) throws ActivationException {
        MarshalledObject marshalledObject;
        if (!this.groupID.equals(activationDesc.getGroupID())) {
            throw new ActivationException("newInstance in wrong group");
        }
        try {
            try {
                Remote remote;
                ActiveEntry activeEntry;
                block20: {
                    this.acquireLock(activationID);
                    ActivationGroupImpl activationGroupImpl = this;
                    synchronized (activationGroupImpl) {
                        if (this.groupInactive) {
                            throw new ActivationException("group is inactive");
                        }
                    }
                    activeEntry = (ActiveEntry)this.active.get(activationID);
                    if (activeEntry != null) {
                        MarshalledObject marshalledObject2 = activeEntry.mobj;
                        Object var14_9 = null;
                        this.releaseLock(activationID);
                        this.checkInactiveGroup();
                        return marshalledObject2;
                    }
                    String string = activationDesc.getClassName();
                    Class clazz = RMIClassLoader.loadClass(activationDesc.getLocation(), string);
                    remote = null;
                    Thread thread = Thread.currentThread();
                    ClassLoader classLoader = thread.getContextClassLoader();
                    try {
                        remote = (Remote)AccessController.doPrivileged(new PrivilegedExceptionAction(this, clazz, activationID, activationDesc, thread, classLoader){
                            private final Class val$cl;
                            private final ActivationID val$id;
                            private final ActivationDesc val$desc;
                            private final Thread val$t;
                            private final ClassLoader val$savedCcl;
                            private final ActivationGroupImpl this$0;

                            /*
                             * WARNING - Removed try catching itself - possible behaviour change.
                             */
                            public Object run() throws InstantiationException, NoSuchMethodException, IllegalAccessException, InvocationTargetException {
                                Constructor constructor = this.val$cl.getDeclaredConstructor(ActivationGroupImpl.access$000());
                                constructor.setAccessible(true);
                                Object[] objectArray = new Object[]{this.val$id, this.val$desc.getData()};
                                try {
                                    this.val$t.setContextClassLoader(this.val$cl.getClassLoader());
                                    Remote remote = (Remote)constructor.newInstance(objectArray);
                                    Object var5_4 = null;
                                    this.val$t.setContextClassLoader(this.val$savedCcl);
                                    return remote;
                                }
                                catch (Throwable throwable) {
                                    Object var5_5 = null;
                                    this.val$t.setContextClassLoader(this.val$savedCcl);
                                    throw throwable;
                                }
                            }
                            {
                                this.this$0 = activationGroupImpl;
                                this.val$cl = clazz;
                                this.val$id = activationID;
                                this.val$desc = activationDesc;
                                this.val$t = thread;
                                this.val$savedCcl = classLoader;
                            }
                        });
                    }
                    catch (PrivilegedActionException privilegedActionException) {
                        Exception exception = privilegedActionException.getException();
                        if (exception instanceof InstantiationException) {
                            throw (InstantiationException)exception;
                        }
                        if (exception instanceof NoSuchMethodException) {
                            throw (NoSuchMethodException)exception;
                        }
                        if (exception instanceof IllegalAccessException) {
                            throw (IllegalAccessException)exception;
                        }
                        if (exception instanceof InvocationTargetException) {
                            throw (InvocationTargetException)exception;
                        }
                        if (exception instanceof RuntimeException) {
                            throw (RuntimeException)exception;
                        }
                        if (!(exception instanceof Error)) break block20;
                        throw (Error)((Object)exception);
                    }
                }
                activeEntry = new ActiveEntry(remote);
                this.active.put(activationID, activeEntry);
                marshalledObject = activeEntry.mobj;
            }
            catch (NoSuchMethodException noSuchMethodException) {
                throw new ActivationException("Activatable object must provide an activation constructor", noSuchMethodException);
            }
            catch (NoSuchMethodError noSuchMethodError) {
                throw new ActivationException("Activatable object must provide an activation constructor", noSuchMethodError);
            }
            catch (InvocationTargetException invocationTargetException) {
                throw new ActivationException("exception in object constructor", invocationTargetException.getTargetException());
            }
            catch (Exception exception) {
                throw new ActivationException("unable to activate object", exception);
            }
        }
        catch (Throwable throwable) {
            Object var14_11 = null;
            this.releaseLock(activationID);
            this.checkInactiveGroup();
            throw throwable;
        }
        Object var14_10 = null;
        this.releaseLock(activationID);
        this.checkInactiveGroup();
        return marshalledObject;
    }

    private static class ActiveEntry {
        Remote impl;
        MarshalledObject mobj;

        ActiveEntry(Remote remote) throws ActivationException {
            this.impl = remote;
            try {
                this.mobj = new MarshalledObject(remote);
            }
            catch (IOException iOException) {
                throw new ActivationException("failed to marshal remote object", iOException);
            }
        }
    }
}

