/*
 * Decompiled with CFR 0.152.
 */
package sun.reflect;

import java.lang.reflect.Modifier;
import java.security.AccessController;
import java.security.PrivilegedAction;
import sun.reflect.AccessorGenerator;
import sun.reflect.ByteVector;
import sun.reflect.ByteVectorFactory;
import sun.reflect.ClassDefiner;
import sun.reflect.ClassFileAssembler;
import sun.reflect.FieldAccessor;
import sun.reflect.Label;

class FieldAccessorGenerator
extends AccessorGenerator {
    private static final short NUM_BASE_CPOOL_ENTRIES = 46;
    private static final short NUM_NONPRIMITIVE_CPOOL_ENTRIES = 2;
    private static final short NUM_FINAL_FIELD_CPOOL_ENTRIES = 5;
    private static final short NUM_METHODS = 19;
    private static volatile int symnum = 0;
    private Class type;
    private short targetFieldRef;
    private short targetFieldType;
    private short getIdx;
    private short getBooleanIdx;
    private short getByteIdx;
    private short getCharIdx;
    private short getShortIdx;
    private short getIntIdx;
    private short getLongIdx;
    private short getFloatIdx;
    private short getDoubleIdx;
    private short setIdx;
    private short setBooleanIdx;
    private short setByteIdx;
    private short setCharIdx;
    private short setShortIdx;
    private short setIntIdx;
    private short setLongIdx;
    private short setFloatIdx;
    private short setDoubleIdx;
    private short fieldIsFinalIdx;
    private short illegalAccessClass;
    private short illegalAccessStringCtorIdx;

    FieldAccessorGenerator() {
    }

    private void emitGet() {
        ClassFileAssembler classFileAssembler = new ClassFileAssembler();
        classFileAssembler.setMaxLocals(2);
        if (AccessorGenerator.isPrimitive(this.type)) {
            classFileAssembler.opc_new(this.indexForPrimitiveType(this.type));
            classFileAssembler.opc_dup();
            if (this.isStatic()) {
                classFileAssembler.opc_getstatic(this.targetFieldRef, this.typeSizeInStackSlots(this.type));
            } else {
                classFileAssembler.opc_aload_1();
                classFileAssembler.opc_checkcast(this.targetClass);
                classFileAssembler.opc_getfield(this.targetFieldRef, this.typeSizeInStackSlots(this.type));
            }
            classFileAssembler.opc_invokespecial(this.ctorIndexForPrimitiveType(this.type), this.typeSizeInStackSlots(this.type), 0);
        } else if (this.isStatic()) {
            classFileAssembler.opc_getstatic(this.targetFieldRef, 1);
        } else {
            classFileAssembler.opc_aload_1();
            classFileAssembler.opc_checkcast(this.targetClass);
            classFileAssembler.opc_getfield(this.targetFieldRef, 1);
        }
        classFileAssembler.opc_areturn();
        short s2 = classFileAssembler.getLength();
        this.emitIllegalArgumentConversionExceptionHandler(classFileAssembler);
        ClassFileAssembler classFileAssembler2 = new ClassFileAssembler();
        classFileAssembler2.emitShort((short)0);
        classFileAssembler2.emitShort(s2);
        classFileAssembler2.emitShort(s2);
        classFileAssembler2.emitShort(this.classCastClass);
        this.emitMethod(this.getIdx, classFileAssembler.getMaxLocals(), classFileAssembler, classFileAssembler2, null);
    }

    private void emitGetBoolean() {
        this.emitGetPrimitive(this.getBooleanIdx, Boolean.TYPE);
    }

    private void emitGetByte() {
        this.emitGetPrimitive(this.getByteIdx, Byte.TYPE);
    }

    private void emitGetChar() {
        this.emitGetPrimitive(this.getCharIdx, Character.TYPE);
    }

    private void emitGetDouble() {
        this.emitGetPrimitive(this.getDoubleIdx, Double.TYPE);
    }

    private void emitGetFloat() {
        this.emitGetPrimitive(this.getFloatIdx, Float.TYPE);
    }

    private void emitGetInt() {
        this.emitGetPrimitive(this.getIntIdx, Integer.TYPE);
    }

    private void emitGetLong() {
        this.emitGetPrimitive(this.getLongIdx, Long.TYPE);
    }

    private void emitGetShort() {
        this.emitGetPrimitive(this.getShortIdx, Short.TYPE);
    }

    private void emitSet() {
        ClassFileAssembler classFileAssembler = new ClassFileAssembler();
        classFileAssembler.setMaxLocals(3);
        if (!this.isStatic()) {
            classFileAssembler.opc_aload_1();
            classFileAssembler.opc_checkcast(this.targetClass);
        }
        if (AccessorGenerator.isPrimitive(this.type)) {
            Label label = null;
            int n2 = 0;
            while (n2 < AccessorGenerator.primitiveTypes.length) {
                Class clazz = AccessorGenerator.primitiveTypes[n2];
                if (AccessorGenerator.canWidenTo(clazz, this.type)) {
                    if (label != null) {
                        label.bind();
                    }
                    classFileAssembler.opc_aload_2();
                    classFileAssembler.opc_instanceof(this.indexForPrimitiveType(clazz));
                    label = new Label();
                    classFileAssembler.opc_ifeq(label);
                    classFileAssembler.opc_aload_2();
                    classFileAssembler.opc_checkcast(this.indexForPrimitiveType(clazz));
                    classFileAssembler.opc_invokevirtual(this.unboxingMethodForPrimitiveType(clazz), 0, this.typeSizeInStackSlots(clazz));
                    AccessorGenerator.emitWideningBytecodeForPrimitiveConversion(classFileAssembler, clazz, this.type);
                    if (this.isStatic()) {
                        classFileAssembler.opc_putstatic(this.targetFieldRef, this.typeSizeInStackSlots(this.type));
                    } else {
                        classFileAssembler.opc_putfield(this.targetFieldRef, this.typeSizeInStackSlots(this.type));
                    }
                    classFileAssembler.opc_return();
                }
                ++n2;
            }
            if (label == null) {
                throw new InternalError("Must have found at least identity conversion");
            }
            label.bind();
            classFileAssembler.opc_new(this.illegalArgumentClass);
            classFileAssembler.opc_dup();
            classFileAssembler.opc_invokespecial(this.illegalArgumentCtorIdx, 0, 0);
            classFileAssembler.opc_athrow();
        } else {
            classFileAssembler.opc_aload_2();
            classFileAssembler.opc_checkcast(this.targetFieldType);
            if (this.isStatic()) {
                classFileAssembler.opc_putstatic(this.targetFieldRef, 1);
            } else {
                classFileAssembler.opc_putfield(this.targetFieldRef, 1);
            }
            classFileAssembler.opc_return();
        }
        short s2 = classFileAssembler.getLength();
        this.emitIllegalArgumentConversionExceptionHandler(classFileAssembler);
        ClassFileAssembler classFileAssembler2 = new ClassFileAssembler();
        classFileAssembler2.emitShort((short)0);
        classFileAssembler2.emitShort(s2);
        classFileAssembler2.emitShort(s2);
        classFileAssembler2.emitShort(this.classCastClass);
        this.emitMethod(this.setIdx, classFileAssembler.getMaxLocals(), classFileAssembler, classFileAssembler2, null);
    }

    private void emitSetBoolean() {
        this.emitSetPrimitive(this.setBooleanIdx, Boolean.TYPE);
    }

    private void emitSetByte() {
        this.emitSetPrimitive(this.setByteIdx, Byte.TYPE);
    }

    private void emitSetChar() {
        this.emitSetPrimitive(this.setCharIdx, Character.TYPE);
    }

    private void emitSetDouble() {
        this.emitSetPrimitive(this.setDoubleIdx, Double.TYPE);
    }

    private void emitSetFloat() {
        this.emitSetPrimitive(this.setFloatIdx, Float.TYPE);
    }

    private void emitSetInt() {
        this.emitSetPrimitive(this.setIntIdx, Integer.TYPE);
    }

    private void emitSetLong() {
        this.emitSetPrimitive(this.setLongIdx, Long.TYPE);
    }

    private void emitSetShort() {
        this.emitSetPrimitive(this.setShortIdx, Short.TYPE);
    }

    private void emitThrowIllegalAccessForFinalField(short s2, boolean bl2) {
        ClassFileAssembler classFileAssembler = new ClassFileAssembler();
        classFileAssembler.opc_new(this.illegalAccessClass);
        classFileAssembler.opc_dup();
        classFileAssembler.opc_ldc((byte)this.fieldIsFinalIdx);
        classFileAssembler.opc_invokespecial(this.illegalAccessStringCtorIdx, 1, 0);
        classFileAssembler.opc_athrow();
        int n2 = bl2 ? 4 : 3;
        this.emitMethod(s2, n2, classFileAssembler, null, new short[]{this.illegalAccessClass});
    }

    private void emitGetPrimitive(short s2, Class clazz) {
        ClassFileAssembler classFileAssembler;
        ClassFileAssembler classFileAssembler2 = null;
        if (!AccessorGenerator.canWidenTo(this.type, clazz)) {
            classFileAssembler = this.illegalArgumentCodeBuffer();
        } else {
            classFileAssembler = new ClassFileAssembler();
            if (this.isStatic()) {
                classFileAssembler.opc_getstatic(this.targetFieldRef, this.typeSizeInStackSlots(this.type));
            } else {
                classFileAssembler.opc_aload_1();
                classFileAssembler.opc_checkcast(this.targetClass);
                classFileAssembler.opc_getfield(this.targetFieldRef, this.typeSizeInStackSlots(this.type));
            }
            AccessorGenerator.emitWideningBytecodeForPrimitiveConversion(classFileAssembler, this.type, clazz);
            this.emitReturnInstructionForPrimitiveType(classFileAssembler, clazz);
            short s3 = classFileAssembler.getLength();
            this.emitIllegalArgumentConversionExceptionHandler(classFileAssembler);
            classFileAssembler2 = new ClassFileAssembler();
            classFileAssembler2.emitShort((short)0);
            classFileAssembler2.emitShort(s3);
            classFileAssembler2.emitShort(s3);
            classFileAssembler2.emitShort(this.classCastClass);
        }
        this.emitMethod(s2, 2, classFileAssembler, classFileAssembler2, null);
    }

    private void emitSetPrimitive(short s2, Class clazz) {
        short s3;
        ClassFileAssembler classFileAssembler;
        ClassFileAssembler classFileAssembler2 = null;
        if (!AccessorGenerator.canWidenTo(clazz, this.type)) {
            classFileAssembler = this.illegalArgumentCodeBuffer();
        } else {
            classFileAssembler = new ClassFileAssembler();
            if (!this.isStatic()) {
                classFileAssembler.opc_aload_1();
                classFileAssembler.opc_checkcast(this.targetClass);
            }
            this.emitLoad2ForPrimitiveType(classFileAssembler, clazz);
            AccessorGenerator.emitWideningBytecodeForPrimitiveConversion(classFileAssembler, clazz, this.type);
            if (this.isStatic()) {
                classFileAssembler.opc_putstatic(this.targetFieldRef, this.typeSizeInStackSlots(this.type));
            } else {
                classFileAssembler.opc_putfield(this.targetFieldRef, this.typeSizeInStackSlots(this.type));
            }
            classFileAssembler.opc_return();
            s3 = classFileAssembler.getLength();
            this.emitIllegalArgumentConversionExceptionHandler(classFileAssembler);
            classFileAssembler2 = new ClassFileAssembler();
            classFileAssembler2.emitShort((short)0);
            classFileAssembler2.emitShort(s3);
            classFileAssembler2.emitShort(s3);
            classFileAssembler2.emitShort(this.classCastClass);
        }
        s3 = 3;
        if (clazz == Long.TYPE || clazz == Double.TYPE) {
            s3 = 4;
        }
        this.emitMethod(s2, s3, classFileAssembler, classFileAssembler2, null);
    }

    private static synchronized String generateName() {
        int n2 = ++symnum;
        return "sun/reflect/GeneratedFieldAccessor" + n2;
    }

    private void emitIllegalArgumentConversionExceptionHandler(ClassFileAssembler classFileAssembler) {
        classFileAssembler.setStack(1);
        classFileAssembler.opc_invokevirtual(this.toStringIdx, 0, 1);
        classFileAssembler.opc_new(this.illegalArgumentClass);
        classFileAssembler.opc_dup_x1();
        classFileAssembler.opc_swap();
        classFileAssembler.opc_invokespecial(this.illegalArgumentStringCtorIdx, 1, 0);
        classFileAssembler.opc_athrow();
    }

    private void emitLoad2ForPrimitiveType(ClassFileAssembler classFileAssembler, Class clazz) {
        if (clazz == Boolean.TYPE || clazz == Byte.TYPE || clazz == Character.TYPE || clazz == Short.TYPE || clazz == Integer.TYPE) {
            classFileAssembler.opc_iload_2();
        } else if (clazz == Long.TYPE) {
            classFileAssembler.opc_lload_2();
        } else if (clazz == Float.TYPE) {
            classFileAssembler.opc_fload_2();
        } else if (clazz == Double.TYPE) {
            classFileAssembler.opc_dload_2();
        } else {
            throw new InternalError("Illegal primitive type" + clazz.getName());
        }
    }

    private void emitReturnInstructionForPrimitiveType(ClassFileAssembler classFileAssembler, Class clazz) {
        if (clazz == Boolean.TYPE || clazz == Byte.TYPE || clazz == Character.TYPE || clazz == Short.TYPE || clazz == Integer.TYPE) {
            classFileAssembler.opc_ireturn();
        } else if (clazz == Long.TYPE) {
            classFileAssembler.opc_lreturn();
        } else if (clazz == Float.TYPE) {
            classFileAssembler.opc_freturn();
        } else if (clazz == Double.TYPE) {
            classFileAssembler.opc_dreturn();
        } else {
            throw new InternalError("Illegal primitive type" + clazz.getName());
        }
    }

    public FieldAccessor generate(Class clazz, String string, Class clazz2, int n2) {
        ByteVector byteVector = ByteVectorFactory.create();
        this.asm = new ClassFileAssembler(byteVector);
        this.type = clazz2;
        this.modifiers = n2;
        this.asm.emitMagicAndVersion();
        short s2 = 76;
        s2 = AccessorGenerator.isPrimitive(clazz2) ? (short)((short)(s2 + 72)) : (short)((short)(s2 + 2));
        if (Modifier.isFinal(n2)) {
            s2 = (short)(s2 + 5);
        }
        this.asm.emitShort(AccessorGenerator.add(s2, (short)1));
        String string2 = FieldAccessorGenerator.generateName();
        this.asm.emitConstantPoolUTF8(string2);
        this.asm.emitConstantPoolClass(this.asm.cpi());
        this.thisClass = this.asm.cpi();
        this.asm.emitConstantPoolUTF8("sun/reflect/FieldAccessorImpl");
        this.asm.emitConstantPoolClass(this.asm.cpi());
        this.superClass = this.asm.cpi();
        this.asm.emitConstantPoolUTF8(AccessorGenerator.getClassName(clazz, false));
        this.asm.emitConstantPoolClass(this.asm.cpi());
        this.targetClass = this.asm.cpi();
        this.asm.emitConstantPoolUTF8(string);
        this.asm.emitConstantPoolUTF8(AccessorGenerator.getClassName(clazz2, true));
        this.asm.emitConstantPoolNameAndType(AccessorGenerator.sub(this.asm.cpi(), (short)1), this.asm.cpi());
        this.asm.emitConstantPoolFieldref(this.targetClass, this.asm.cpi());
        this.targetFieldRef = this.asm.cpi();
        if (!AccessorGenerator.isPrimitive(clazz2)) {
            this.asm.emitConstantPoolUTF8(AccessorGenerator.getClassName(clazz2, false));
            this.asm.emitConstantPoolClass(this.asm.cpi());
            this.targetFieldType = this.asm.cpi();
        }
        this.asm.emitConstantPoolUTF8("get");
        this.getIdx = this.asm.cpi();
        this.asm.emitConstantPoolUTF8("(Ljava/lang/Object;)Ljava/lang/Object;");
        this.asm.emitConstantPoolUTF8("getBoolean");
        this.getBooleanIdx = this.asm.cpi();
        this.asm.emitConstantPoolUTF8("(Ljava/lang/Object;)Z");
        this.asm.emitConstantPoolUTF8("getByte");
        this.getByteIdx = this.asm.cpi();
        this.asm.emitConstantPoolUTF8("(Ljava/lang/Object;)B");
        this.asm.emitConstantPoolUTF8("getChar");
        this.getCharIdx = this.asm.cpi();
        this.asm.emitConstantPoolUTF8("(Ljava/lang/Object;)C");
        this.asm.emitConstantPoolUTF8("getShort");
        this.getShortIdx = this.asm.cpi();
        this.asm.emitConstantPoolUTF8("(Ljava/lang/Object;)S");
        this.asm.emitConstantPoolUTF8("getInt");
        this.getIntIdx = this.asm.cpi();
        this.asm.emitConstantPoolUTF8("(Ljava/lang/Object;)I");
        this.asm.emitConstantPoolUTF8("getLong");
        this.getLongIdx = this.asm.cpi();
        this.asm.emitConstantPoolUTF8("(Ljava/lang/Object;)J");
        this.asm.emitConstantPoolUTF8("getFloat");
        this.getFloatIdx = this.asm.cpi();
        this.asm.emitConstantPoolUTF8("(Ljava/lang/Object;)F");
        this.asm.emitConstantPoolUTF8("getDouble");
        this.getDoubleIdx = this.asm.cpi();
        this.asm.emitConstantPoolUTF8("(Ljava/lang/Object;)D");
        this.asm.emitConstantPoolUTF8("set");
        this.setIdx = this.asm.cpi();
        this.asm.emitConstantPoolUTF8("(Ljava/lang/Object;Ljava/lang/Object;)V");
        this.asm.emitConstantPoolUTF8("setBoolean");
        this.setBooleanIdx = this.asm.cpi();
        this.asm.emitConstantPoolUTF8("(Ljava/lang/Object;Z)V");
        this.asm.emitConstantPoolUTF8("setByte");
        this.setByteIdx = this.asm.cpi();
        this.asm.emitConstantPoolUTF8("(Ljava/lang/Object;B)V");
        this.asm.emitConstantPoolUTF8("setChar");
        this.setCharIdx = this.asm.cpi();
        this.asm.emitConstantPoolUTF8("(Ljava/lang/Object;C)V");
        this.asm.emitConstantPoolUTF8("setShort");
        this.setShortIdx = this.asm.cpi();
        this.asm.emitConstantPoolUTF8("(Ljava/lang/Object;S)V");
        this.asm.emitConstantPoolUTF8("setInt");
        this.setIntIdx = this.asm.cpi();
        this.asm.emitConstantPoolUTF8("(Ljava/lang/Object;I)V");
        this.asm.emitConstantPoolUTF8("setLong");
        this.setLongIdx = this.asm.cpi();
        this.asm.emitConstantPoolUTF8("(Ljava/lang/Object;J)V");
        this.asm.emitConstantPoolUTF8("setFloat");
        this.setFloatIdx = this.asm.cpi();
        this.asm.emitConstantPoolUTF8("(Ljava/lang/Object;F)V");
        this.asm.emitConstantPoolUTF8("setDouble");
        this.setDoubleIdx = this.asm.cpi();
        this.asm.emitConstantPoolUTF8("(Ljava/lang/Object;D)V");
        this.emitCommonConstantPoolEntries();
        if (AccessorGenerator.isPrimitive(clazz2)) {
            this.emitBoxingContantPoolEntries();
        }
        if (Modifier.isFinal(n2)) {
            this.asm.emitConstantPoolUTF8("Field is final");
            this.asm.emitConstantPoolString(this.asm.cpi());
            this.fieldIsFinalIdx = this.asm.cpi();
            this.asm.emitConstantPoolUTF8("java/lang/IllegalAccessException");
            this.asm.emitConstantPoolClass(this.asm.cpi());
            this.illegalAccessClass = this.asm.cpi();
            this.asm.emitConstantPoolMethodref(this.illegalAccessClass, this.initStringNameAndTypeIdx);
            this.illegalAccessStringCtorIdx = this.asm.cpi();
        }
        if (this.asm.cpi() != s2) {
            throw new InternalError("Adjust this code (cpi = " + this.asm.cpi() + ", numCPEntries = " + s2 + ")");
        }
        this.asm.emitShort((short)1);
        this.asm.emitShort(this.thisClass);
        this.asm.emitShort(this.superClass);
        this.asm.emitShort((short)0);
        this.asm.emitShort((short)0);
        this.asm.emitShort((short)19);
        this.emitConstructor();
        this.emitGet();
        this.emitGetBoolean();
        this.emitGetByte();
        this.emitGetChar();
        this.emitGetShort();
        this.emitGetInt();
        this.emitGetLong();
        this.emitGetFloat();
        this.emitGetDouble();
        if (!Modifier.isFinal(n2)) {
            this.emitSet();
            this.emitSetBoolean();
            this.emitSetByte();
            this.emitSetChar();
            this.emitSetShort();
            this.emitSetInt();
            this.emitSetLong();
            this.emitSetFloat();
            this.emitSetDouble();
        } else {
            this.emitThrowIllegalAccessForFinalField(this.setIdx, false);
            this.emitThrowIllegalAccessForFinalField(this.setBooleanIdx, false);
            this.emitThrowIllegalAccessForFinalField(this.setByteIdx, false);
            this.emitThrowIllegalAccessForFinalField(this.setCharIdx, false);
            this.emitThrowIllegalAccessForFinalField(this.setShortIdx, false);
            this.emitThrowIllegalAccessForFinalField(this.setIntIdx, false);
            this.emitThrowIllegalAccessForFinalField(this.setLongIdx, true);
            this.emitThrowIllegalAccessForFinalField(this.setFloatIdx, false);
            this.emitThrowIllegalAccessForFinalField(this.setDoubleIdx, true);
        }
        this.asm.emitShort((short)0);
        byteVector.trim();
        byte[] byArray = byteVector.getData();
        return (FieldAccessor)AccessController.doPrivileged(new PrivilegedAction(this, string2, byArray, clazz){
            private final String val$generatedName;
            private final byte[] val$bytes;
            private final Class val$declaringClass;
            private final FieldAccessorGenerator this$0;

            public Object run() {
                try {
                    return ClassDefiner.defineClass(this.val$generatedName, this.val$bytes, 0, this.val$bytes.length, this.val$declaringClass.getClassLoader()).newInstance();
                }
                catch (InstantiationException instantiationException) {
                    throw (InternalError)new InternalError().initCause(instantiationException);
                }
                catch (IllegalAccessException illegalAccessException) {
                    throw (InternalError)new InternalError().initCause(illegalAccessException);
                }
            }
            {
                this.this$0 = fieldAccessorGenerator;
                this.val$generatedName = string;
                this.val$bytes = byArray;
                this.val$declaringClass = clazz;
            }
        });
    }
}

