/*
 * Decompiled with CFR 0.152.
 */
package sun.print;

import java.security.AccessController;
import java.util.ArrayList;
import javax.print.DocFlavor;
import javax.print.MultiDocPrintService;
import javax.print.PrintService;
import javax.print.PrintServiceLookup;
import javax.print.attribute.Attribute;
import javax.print.attribute.AttributeSet;
import javax.print.attribute.HashPrintRequestAttributeSet;
import javax.print.attribute.HashPrintServiceAttributeSet;
import javax.print.attribute.PrintRequestAttribute;
import javax.print.attribute.PrintServiceAttribute;
import javax.print.attribute.PrintServiceAttributeSet;
import javax.print.attribute.standard.PrinterName;
import sun.print.Win32PrintService;
import sun.security.action.LoadLibraryAction;

public class Win32PrintServiceLookup
extends PrintServiceLookup {
    private String defaultPrinter;
    private PrintService defaultPrintService;
    private String[] printers;
    private PrintService[] printServices;
    static Class class$javax$print$attribute$standard$PrinterName;

    static {
        AccessController.doPrivileged(new LoadLibraryAction("awt"));
    }

    private native String getDefaultPrinterName();

    private native String[] getAllPrinterNames();

    public PrintService getDefaultPrintService() {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPrintJobAccess();
        }
        if (this.defaultPrintService == null) {
            this.defaultPrinter = this.getDefaultPrinterName();
            if (this.defaultPrinter != null) {
                this.defaultPrintService = new Win32PrintService(this.defaultPrinter);
            }
        }
        return this.defaultPrintService;
    }

    public PrintService[] getPrintServices() {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPrintJobAccess();
        }
        if (this.printServices == null) {
            PrintService printService = this.getDefaultPrintService();
            this.printers = this.getAllPrinterNames();
            if (this.printers == null) {
                return null;
            }
            this.printServices = new PrintService[this.printers.length];
            int n2 = 0;
            while (n2 < this.printers.length) {
                this.printServices[n2] = printService != null && this.printers[n2].equals(printService.getName()) ? printService : new Win32PrintService(this.printers[n2]);
                ++n2;
            }
        }
        return this.printServices;
    }

    static Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private synchronized PrintService getPrintServiceByName(String string) {
        if (string == null || string.equals("")) {
            return null;
        }
        if (this.printServices == null) {
            String[] stringArray = this.getAllPrinterNames();
            int n2 = 0;
            while (n2 < stringArray.length) {
                if (stringArray[n2].equals(string)) {
                    return new Win32PrintService(string);
                }
                ++n2;
            }
            return null;
        }
        int n3 = 0;
        while (n3 < this.printServices.length) {
            if (this.printServices[n3].getName().equals(string)) {
                return this.printServices[n3];
            }
            ++n3;
        }
        return null;
    }

    boolean matchingService(PrintService printService, PrintServiceAttributeSet printServiceAttributeSet) {
        if (printServiceAttributeSet != null) {
            Attribute[] attributeArray = printServiceAttributeSet.toArray();
            int n2 = 0;
            while (n2 < attributeArray.length) {
                PrintServiceAttribute printServiceAttribute = printService.getAttribute(attributeArray[n2].getCategory());
                if (printServiceAttribute == null || !printServiceAttribute.equals(attributeArray[n2])) {
                    return false;
                }
                ++n2;
            }
        }
        return true;
    }

    public MultiDocPrintService[] getMultiDocPrintServices(DocFlavor[] docFlavorArray, AttributeSet attributeSet) {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPrintJobAccess();
        }
        return new MultiDocPrintService[0];
    }

    public PrintService[] getPrintServices(DocFlavor docFlavor, AttributeSet attributeSet) {
        PrinterName printerName;
        PrintService printService;
        Object[] objectArray;
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPrintJobAccess();
        }
        HashPrintRequestAttributeSet hashPrintRequestAttributeSet = null;
        AttributeSet attributeSet2 = null;
        if (attributeSet != null && !attributeSet.isEmpty()) {
            hashPrintRequestAttributeSet = new HashPrintRequestAttributeSet();
            attributeSet2 = new HashPrintServiceAttributeSet();
            objectArray = attributeSet.toArray();
            int n2 = 0;
            while (n2 < objectArray.length) {
                if (objectArray[n2] instanceof PrintRequestAttribute) {
                    hashPrintRequestAttributeSet.add((Attribute)objectArray[n2]);
                } else if (objectArray[n2] instanceof PrintServiceAttribute) {
                    attributeSet2.add((Attribute)objectArray[n2]);
                }
                ++n2;
            }
        }
        objectArray = null;
        objectArray = attributeSet2 != null && attributeSet2.get(class$javax$print$attribute$standard$PrinterName == null ? (class$javax$print$attribute$standard$PrinterName = Win32PrintServiceLookup.class$("javax.print.attribute.standard.PrinterName")) : class$javax$print$attribute$standard$PrinterName) != null ? ((printService = this.getPrintServiceByName((printerName = (PrinterName)attributeSet2.get(class$javax$print$attribute$standard$PrinterName == null ? (class$javax$print$attribute$standard$PrinterName = Win32PrintServiceLookup.class$("javax.print.attribute.standard.PrinterName")) : class$javax$print$attribute$standard$PrinterName)).getValue())) == null || !this.matchingService(printService, (PrintServiceAttributeSet)attributeSet2) ? new PrintService[]{} : new PrintService[]{printService}) : this.getPrintServices();
        if (objectArray.length == 0) {
            return objectArray;
        }
        ArrayList arrayList = new ArrayList();
        int n3 = 0;
        while (n3 < objectArray.length) {
            try {
                if (objectArray[n3].getUnsupportedAttributes(docFlavor, hashPrintRequestAttributeSet) == null) {
                    arrayList.add(objectArray[n3]);
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
            ++n3;
        }
        objectArray = new PrintService[arrayList.size()];
        return (PrintService[])arrayList.toArray(objectArray);
    }
}

