/*
 * Decompiled with CFR 0.152.
 */
package sun.print;

import java.awt.Color;
import java.awt.Composite;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.Image;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.font.FontRenderContext;
import java.awt.font.GlyphVector;
import java.awt.font.TextLayout;
import java.awt.geom.AffineTransform;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RoundRectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.BufferedImageOp;
import java.awt.image.ImageObserver;
import java.awt.image.RenderedImage;
import java.awt.image.renderable.RenderableImage;
import java.awt.print.PrinterGraphics;
import java.awt.print.PrinterJob;
import java.text.AttributedCharacterIterator;
import java.util.Map;
import sun.java2d.Spans;
import sun.print.PeekMetrics;

public class PeekGraphics
extends Graphics2D
implements PrinterGraphics,
ImageObserver,
Cloneable {
    Graphics2D mGraphics;
    PrinterJob mPrinterJob;
    private Spans mDrawingArea = new Spans();
    private PeekMetrics mPrintMetrics = new PeekMetrics();
    private boolean mAWTDrawingOnly = false;

    public void dispose() {
        this.mGraphics.dispose();
    }

    public void setAWTDrawingOnly() {
        this.mAWTDrawingOnly = true;
    }

    public void setPaintMode() {
        this.mGraphics.setPaintMode();
    }

    public boolean getAWTDrawingOnly() {
        return this.mAWTDrawingOnly;
    }

    public void rotate(double d2) {
        this.mGraphics.rotate(d2);
    }

    public void scale(double d2, double d3) {
        this.mGraphics.scale(d2, d3);
    }

    public void shear(double d2, double d3) {
        this.mGraphics.shear(d2, d3);
    }

    public void translate(double d2, double d3) {
        this.mGraphics.translate(d2, d3);
    }

    public void rotate(double d2, double d3, double d4) {
        this.mGraphics.rotate(d2, d3, d4);
    }

    private void addDrawingRect(float f2, float f3, float f4, float f5) {
        Rectangle2D.Float float_ = new Rectangle2D.Float(f2, f3, f4, f5);
        this.addDrawingRect(float_);
    }

    public void translate(int n2, int n3) {
        this.mGraphics.translate(n2, n3);
    }

    public void clearRect(int n2, int n3, int n4, int n5) {
        Rectangle2D.Float float_ = new Rectangle2D.Float(n2, n3, n4, n5);
        this.addDrawingRect(float_);
        this.mPrintMetrics.clear(this);
    }

    public void clipRect(int n2, int n3, int n4, int n5) {
        this.mGraphics.clipRect(n2, n3, n4, n5);
    }

    public void drawLine(int n2, int n3, int n4, int n5) {
        this.addStrokeShape(new Line2D.Float(n2, n3, n4, n5));
        this.mPrintMetrics.draw(this);
    }

    public void drawOval(int n2, int n3, int n4, int n5) {
        this.addStrokeShape(new Rectangle2D.Float(n2, n3, n4, n5));
        this.mPrintMetrics.draw(this);
    }

    public void fillOval(int n2, int n3, int n4, int n5) {
        Rectangle2D.Float float_ = new Rectangle2D.Float(n2, n3, n4, n5);
        this.addDrawingRect(float_);
        this.mPrintMetrics.fill(this);
    }

    public void fillRect(int n2, int n3, int n4, int n5) {
        this.addDrawingRect(new Rectangle2D.Float(n2, n3, n4, n5));
        this.mPrintMetrics.fill(this);
    }

    public void setClip(int n2, int n3, int n4, int n5) {
        this.mGraphics.setClip(n2, n3, n4, n5);
    }

    public void copyArea(int n2, int n3, int n4, int n5, int n6, int n7) {
    }

    public void drawArc(int n2, int n3, int n4, int n5, int n6, int n7) {
        this.addStrokeShape(new Rectangle2D.Float(n2, n3, n4, n5));
        this.mPrintMetrics.draw(this);
    }

    public void drawRoundRect(int n2, int n3, int n4, int n5, int n6, int n7) {
        this.addStrokeShape(new RoundRectangle2D.Float(n2, n3, n4, n5, n6, n7));
        this.mPrintMetrics.draw(this);
    }

    public void fillArc(int n2, int n3, int n4, int n5, int n6, int n7) {
        Rectangle2D.Float float_ = new Rectangle2D.Float(n2, n3, n4, n5);
        this.addDrawingRect(float_);
        this.mPrintMetrics.fill(this);
    }

    public void fillRoundRect(int n2, int n3, int n4, int n5, int n6, int n7) {
        Rectangle2D.Float float_ = new Rectangle2D.Float(n2, n3, n4, n5);
        this.addDrawingRect(float_);
        this.mPrintMetrics.fill(this);
    }

    public void drawPolygon(int[] nArray, int[] nArray2, int n2) {
        if (n2 > 0) {
            this.drawPolyline(nArray, nArray2, n2);
            this.drawLine(nArray[n2 - 1], nArray2[n2 - 1], nArray[0], nArray2[0]);
        }
    }

    public void drawPolyline(int[] nArray, int[] nArray2, int n2) {
        if (n2 > 0) {
            int n3 = nArray[0];
            int n4 = nArray2[0];
            int n5 = 1;
            while (n5 < n2) {
                this.drawLine(n3, n4, nArray[n5], nArray2[n5]);
                n3 = nArray[n5];
                n4 = nArray2[n5];
                ++n5;
            }
        }
    }

    public void fillPolygon(int[] nArray, int[] nArray2, int n2) {
        if (n2 > 0) {
            int n3 = nArray[0];
            int n4 = nArray2[0];
            int n5 = nArray[0];
            int n6 = nArray2[0];
            int n7 = 1;
            while (n7 < n2) {
                if (nArray[n7] < n3) {
                    n3 = nArray[n7];
                } else if (nArray[n7] > n5) {
                    n5 = nArray[n7];
                }
                if (nArray2[n7] < n4) {
                    n4 = nArray2[n7];
                } else if (nArray2[n7] > n6) {
                    n6 = nArray2[n7];
                }
                ++n7;
            }
            this.addDrawingRect(n3, n4, n5 - n3, n6 - n4);
        }
        this.mPrintMetrics.fill(this);
    }

    public Color getBackground() {
        return this.mGraphics.getBackground();
    }

    public Color getColor() {
        return this.mGraphics.getColor();
    }

    public void setBackground(Color color) {
        this.mGraphics.setBackground(color);
    }

    public void setColor(Color color) {
        this.mGraphics.setColor(color);
    }

    public void setXORMode(Color color) {
        this.mGraphics.setXORMode(color);
    }

    public Composite getComposite() {
        return this.mGraphics.getComposite();
    }

    public void setComposite(Composite composite) {
        this.mGraphics.setComposite(composite);
    }

    public Font getFont() {
        return this.mGraphics.getFont();
    }

    public void setFont(Font font) {
        this.mGraphics.setFont(font);
    }

    public Graphics create() {
        PeekGraphics peekGraphics = null;
        try {
            peekGraphics = (PeekGraphics)this.clone();
            peekGraphics.mGraphics = (Graphics2D)this.mGraphics.create();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {}
        return peekGraphics;
    }

    public Graphics2D getDelegate() {
        return this.mGraphics;
    }

    public void setDelegate(Graphics2D graphics2D) {
        this.mGraphics = graphics2D;
    }

    public GraphicsConfiguration getDeviceConfiguration() {
        return this.mGraphics.getDeviceConfiguration();
    }

    private synchronized int getImageHeight(Image image) {
        while (image.getHeight(this) == -1) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        return image.getHeight(this);
    }

    private synchronized int getImageWidth(Image image) {
        while (image.getWidth(this) == -1) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        return image.getWidth(this);
    }

    public synchronized boolean imageUpdate(Image image, int n2, int n3, int n4, int n5, int n6) {
        boolean bl2 = false;
        if ((n2 & 3) != 0) {
            bl2 = true;
            this.notify();
        }
        return bl2;
    }

    public Paint getPaint() {
        return this.mGraphics.getPaint();
    }

    public void setPaint(Paint paint) {
        this.mGraphics.setPaint(paint);
    }

    public Rectangle getClipBounds() {
        return this.mGraphics.getClipBounds();
    }

    public boolean hitsDrawingArea(Rectangle rectangle) {
        return this.mDrawingArea.intersects((float)rectangle.getMinY(), (float)rectangle.getMaxY());
    }

    public RenderingHints getRenderingHints() {
        return this.mGraphics.getRenderingHints();
    }

    public Shape getClip() {
        return this.mGraphics.getClip();
    }

    private void addStrokeShape(Shape shape) {
        Shape shape2 = this.getStroke().createStrokedShape(shape);
        this.addDrawingRect(shape2.getBounds2D());
    }

    public void clip(Shape shape) {
        this.mGraphics.clip(shape);
    }

    public void draw(Shape shape) {
        this.addStrokeShape(shape);
        this.mPrintMetrics.draw(this);
    }

    public void fill(Shape shape) {
        this.addDrawingRect(shape.getBounds());
        this.mPrintMetrics.fill(this);
    }

    public void setClip(Shape shape) {
        this.mGraphics.setClip(shape);
    }

    public Stroke getStroke() {
        return this.mGraphics.getStroke();
    }

    public void setStroke(Stroke stroke) {
        this.mGraphics.setStroke(stroke);
    }

    public FontRenderContext getFontRenderContext() {
        return this.mGraphics.getFontRenderContext();
    }

    public void drawGlyphVector(GlyphVector glyphVector, float f2, float f3) {
        Rectangle2D rectangle2D = glyphVector.getLogicalBounds();
        this.addDrawingRect(rectangle2D, f2, f3);
        this.mPrintMetrics.drawText(this);
    }

    void drawTextLayout(TextLayout textLayout, float f2, float f3) {
        this.addDrawingRect(textLayout.getBounds(), f2, f3);
        this.mPrintMetrics.drawText(this, textLayout);
    }

    public AffineTransform getTransform() {
        return this.mGraphics.getTransform();
    }

    public void setTransform(AffineTransform affineTransform) {
        this.mGraphics.setTransform(affineTransform);
    }

    public void transform(AffineTransform affineTransform) {
        this.mGraphics.transform(affineTransform);
    }

    private void addDrawingRect(Rectangle2D rectangle2D) {
        AffineTransform affineTransform = this.getTransform();
        Shape shape = affineTransform.createTransformedShape(rectangle2D);
        Rectangle2D rectangle2D2 = shape.getBounds2D();
        this.mDrawingArea.add((float)rectangle2D2.getMinY(), (float)rectangle2D2.getMaxY());
    }

    private void addDrawingRect(Rectangle2D rectangle2D, float f2, float f3) {
        this.addDrawingRect((float)(rectangle2D.getX() + (double)f2), (float)(rectangle2D.getY() + (double)f3), (float)rectangle2D.getWidth(), (float)rectangle2D.getHeight());
    }

    public PrinterJob getPrinterJob() {
        return this.mPrinterJob;
    }

    public void drawString(String string, float f2, float f3) {
        if (string.length() == 0) {
            return;
        }
        this.drawTextLayout(new TextLayout(string, this.getFont(), this.getFontRenderContext()), f2, f3);
    }

    public void drawString(String string, int n2, int n3) {
        if (string.length() == 0) {
            return;
        }
        this.drawTextLayout(new TextLayout(string, this.getFont(), this.getFontRenderContext()), n2, n3);
    }

    public void drawString(AttributedCharacterIterator attributedCharacterIterator, float f2, float f3) {
        if (attributedCharacterIterator == null) {
            throw new NullPointerException("attributedcharacteriterator is null");
        }
        this.drawTextLayout(new TextLayout(attributedCharacterIterator, this.getFontRenderContext()), f2, f3);
    }

    public void drawString(AttributedCharacterIterator attributedCharacterIterator, int n2, int n3) {
        if (attributedCharacterIterator == null) {
            throw new NullPointerException("attributedcharacteriterator is null");
        }
        this.drawTextLayout(new TextLayout(attributedCharacterIterator, this.getFontRenderContext()), n2, n3);
    }

    public void addRenderingHints(Map map) {
        this.mGraphics.addRenderingHints(map);
    }

    public void setRenderingHints(Map map) {
        this.mGraphics.setRenderingHints(map);
    }

    public Spans getDrawingArea() {
        return this.mDrawingArea;
    }

    public PeekMetrics getMetrics() {
        return this.mPrintMetrics;
    }

    public FontMetrics getFontMetrics(Font font) {
        return this.mGraphics.getFontMetrics(font);
    }

    public boolean hit(Rectangle rectangle, Shape shape, boolean bl2) {
        return this.mGraphics.hit(rectangle, shape, bl2);
    }

    public void drawRenderedImage(RenderedImage renderedImage, AffineTransform affineTransform) {
        this.mPrintMetrics.drawImage((Graphics2D)this, renderedImage);
        this.mDrawingArea.addInfinite();
    }

    public void drawRenderableImage(RenderableImage renderableImage, AffineTransform affineTransform) {
        this.mPrintMetrics.drawImage((Graphics2D)this, renderableImage);
        this.mDrawingArea.addInfinite();
    }

    public void drawImage(BufferedImage bufferedImage, BufferedImageOp bufferedImageOp, int n2, int n3) {
        this.mPrintMetrics.drawImage((Graphics2D)this, bufferedImage);
        this.mDrawingArea.addInfinite();
    }

    public boolean drawImage(Image image, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, ImageObserver imageObserver) {
        int n10 = n4 - n2;
        int n11 = n5 - n3;
        this.addDrawingRect(n2, n3, n10, n11);
        this.mPrintMetrics.drawImage((Graphics2D)this, image);
        return this.mGraphics.drawImage(image, n2, n3, n4, n5, n6, n7, n8, n9, imageObserver);
    }

    public boolean drawImage(Image image, int n2, int n3, int n4, int n5, ImageObserver imageObserver) {
        this.addDrawingRect(n2, n3, n4, n5);
        this.mPrintMetrics.drawImage((Graphics2D)this, image);
        return this.mGraphics.drawImage(image, n2, n3, n4, n5, imageObserver);
    }

    public boolean drawImage(Image image, int n2, int n3, ImageObserver imageObserver) {
        ImageWaiter imageWaiter = new ImageWaiter(this, image);
        this.addDrawingRect(n2, n3, imageWaiter.getWidth(), imageWaiter.getHeight());
        this.mPrintMetrics.drawImage((Graphics2D)this, image);
        return this.mGraphics.drawImage(image, n2, n3, imageObserver);
    }

    public PeekGraphics(Graphics2D graphics2D, PrinterJob printerJob) {
        this.mGraphics = graphics2D;
        this.mPrinterJob = printerJob;
    }

    public Object getRenderingHint(RenderingHints.Key key) {
        return this.mGraphics.getRenderingHint(key);
    }

    public void setRenderingHint(RenderingHints.Key key, Object object) {
        this.mGraphics.setRenderingHint(key, object);
    }

    public boolean drawImage(Image image, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, Color color, ImageObserver imageObserver) {
        int n10 = n4 - n2;
        int n11 = n5 - n3;
        this.addDrawingRect(n2, n3, n10, n11);
        this.mPrintMetrics.drawImage((Graphics2D)this, image);
        return this.mGraphics.drawImage(image, n2, n3, n4, n5, n6, n7, n8, n9, color, imageObserver);
    }

    public boolean drawImage(Image image, int n2, int n3, int n4, int n5, Color color, ImageObserver imageObserver) {
        this.addDrawingRect(n2, n3, n4, n5);
        this.mPrintMetrics.drawImage((Graphics2D)this, image);
        return this.mGraphics.drawImage(image, n2, n3, n4, n5, color, imageObserver);
    }

    public boolean drawImage(Image image, int n2, int n3, Color color, ImageObserver imageObserver) {
        ImageWaiter imageWaiter = new ImageWaiter(this, image);
        this.addDrawingRect(n2, n3, imageWaiter.getWidth(), imageWaiter.getHeight());
        this.mPrintMetrics.drawImage((Graphics2D)this, image);
        return this.mGraphics.drawImage(image, n2, n3, color, imageObserver);
    }

    public boolean drawImage(Image image, AffineTransform affineTransform, ImageObserver imageObserver) {
        this.mDrawingArea.addInfinite();
        this.mPrintMetrics.drawImage((Graphics2D)this, image);
        return this.mGraphics.drawImage(image, affineTransform, imageObserver);
    }

    protected class ImageWaiter
    implements ImageObserver {
        private int mWidth;
        private int mHeight;
        private boolean badImage;
        private final PeekGraphics this$0;

        public int getHeight() {
            return this.mHeight;
        }

        public int getWidth() {
            return this.mWidth;
        }

        private synchronized void waitForDimensions(Image image) {
            this.mHeight = image.getHeight(this);
            this.mWidth = image.getWidth(this);
            while (!(this.badImage || this.mWidth >= 0 && this.mHeight >= 0)) {
                try {
                    Thread.sleep(50L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                this.mHeight = image.getHeight(this);
                this.mWidth = image.getWidth(this);
            }
            if (this.badImage) {
                this.mHeight = 0;
                this.mWidth = 0;
            }
        }

        public synchronized boolean imageUpdate(Image image, int n2, int n3, int n4, int n5, int n6) {
            boolean bl2 = (n2 & 0xC2) != 0;
            this.badImage = (n2 & 0xC0) != 0;
            return bl2;
        }

        ImageWaiter(PeekGraphics peekGraphics, Image image) {
            this.this$0 = peekGraphics;
            this.badImage = false;
            this.waitForDimensions(image);
        }
    }
}

