/*
 * Decompiled with CFR 0.152.
 */
package sun.nio.cs;

import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CoderResult;
import sun.nio.cs.Surrogate;

public abstract class UnicodeEncoder
extends CharsetEncoder {
    protected static final char BYTE_ORDER_MARK = '\ufeff';
    protected static final char REVERSED_MARK = '\ufffe';
    protected static final int BIG = 0;
    protected static final int LITTLE = 1;
    private int byteOrder;
    private boolean usesMark;
    private boolean needsMark;
    private final Surrogate.Parser sgp;

    protected void implReset() {
        this.needsMark = this.usesMark;
    }

    private void put(char c2, ByteBuffer byteBuffer) {
        if (this.byteOrder == 0) {
            byteBuffer.put((byte)(c2 >> 8));
            byteBuffer.put((byte)(c2 & 0xFF));
        } else {
            byteBuffer.put((byte)(c2 & 0xFF));
            byteBuffer.put((byte)(c2 >> 8));
        }
    }

    protected UnicodeEncoder(Charset charset, int n2, boolean bl2) {
        byte[] byArray;
        float f2 = bl2 ? 4.0f : 2.0f;
        if (n2 == 0) {
            byte[] byArray2 = new byte[2];
            byArray2[0] = -1;
            byArray = byArray2;
            byArray2[1] = -3;
        } else {
            byte[] byArray3 = new byte[2];
            byArray3[0] = -3;
            byArray = byArray3;
            byArray3[1] = -1;
        }
        super(charset, 2.0f, f2, byArray);
        this.sgp = new Surrogate.Parser();
        this.usesMark = this.needsMark = bl2;
        this.byteOrder = n2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected CoderResult encodeLoop(CharBuffer charBuffer, ByteBuffer byteBuffer) {
        CoderResult coderResult;
        int n2;
        block11: {
            CoderResult coderResult2;
            block14: {
                CoderResult coderResult3;
                block13: {
                    CoderResult coderResult4;
                    n2 = charBuffer.position();
                    if (this.needsMark) {
                        if (byteBuffer.remaining() < 2) {
                            return CoderResult.OVERFLOW;
                        }
                        this.put('\ufeff', byteBuffer);
                        this.needsMark = false;
                    }
                    try {
                        while (true) {
                            if (!charBuffer.hasRemaining()) {
                                coderResult = CoderResult.UNDERFLOW;
                                break block11;
                            }
                            char c2 = charBuffer.get();
                            if (!Surrogate.is(c2)) {
                                if (byteBuffer.remaining() < 2) {
                                    coderResult4 = CoderResult.OVERFLOW;
                                    Object var9_8 = null;
                                    break;
                                } else {
                                    ++n2;
                                    this.put(c2, byteBuffer);
                                    continue;
                                }
                            }
                            int n3 = this.sgp.parse(c2, charBuffer);
                            if (n3 < 0) {
                                coderResult3 = this.sgp.error();
                                break block13;
                            }
                            if (byteBuffer.remaining() < 4) {
                                coderResult2 = CoderResult.OVERFLOW;
                                break block14;
                            }
                            n2 += 2;
                            this.put(Surrogate.high(n3), byteBuffer);
                            this.put(Surrogate.low(n3), byteBuffer);
                        }
                    }
                    catch (Throwable throwable) {
                        Object var9_12 = null;
                        charBuffer.position(n2);
                        throw throwable;
                    }
                    charBuffer.position(n2);
                    return coderResult4;
                }
                Object var9_9 = null;
                charBuffer.position(n2);
                return coderResult3;
            }
            Object var9_10 = null;
            charBuffer.position(n2);
            return coderResult2;
        }
        Object var9_11 = null;
        charBuffer.position(n2);
        return coderResult;
    }
}

