/*
 * Decompiled with CFR 0.152.
 */
package sun.nio.cs;

import java.lang.ref.SoftReference;
import java.nio.charset.Charset;
import java.nio.charset.spi.CharsetProvider;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;

public class AbstractCharsetProvider
extends CharsetProvider {
    private Map classMap = new TreeMap(String.CASE_INSENSITIVE_ORDER);
    private Map aliasMap = new TreeMap(String.CASE_INSENSITIVE_ORDER);
    private Map aliasNameMap = new TreeMap(String.CASE_INSENSITIVE_ORDER);
    private Map cache = new TreeMap(String.CASE_INSENSITIVE_ORDER);
    private String packagePrefix;

    protected AbstractCharsetProvider() {
        this.packagePrefix = "sun.nio.cs";
    }

    protected AbstractCharsetProvider(String string) {
        this.packagePrefix = string;
    }

    public final Iterator charsets() {
        return new Iterator(this){
            Iterator i;
            private final AbstractCharsetProvider this$0;

            public void remove() {
                throw new UnsupportedOperationException();
            }

            public boolean hasNext() {
                return this.i.hasNext();
            }

            public Object next() {
                String string = (String)this.i.next();
                return this.this$0.lookup(string);
            }
            {
                this.this$0 = abstractCharsetProvider;
                this.i = AbstractCharsetProvider.access$000(this.this$0).keySet().iterator();
            }
        };
    }

    private String canonicalize(String string) {
        String string2 = (String)this.aliasMap.get(string);
        return string2 != null ? string2 : string;
    }

    public final String[] aliases(String string) {
        return (String[])this.aliasNameMap.get(string);
    }

    public final Charset charsetForName(String string) {
        return this.lookup(this.canonicalize(string));
    }

    protected Charset lookup(String string) {
        Object object;
        SoftReference softReference = (SoftReference)this.cache.get(string);
        if (softReference != null && (object = (Charset)softReference.get()) != null) {
            return object;
        }
        object = (String)this.classMap.get(string);
        if (object == null) {
            return null;
        }
        try {
            Class clazz = Class.forName(this.packagePrefix + "." + (String)object, true, this.getClass().getClassLoader());
            Charset charset = (Charset)clazz.newInstance();
            this.cache.put(string, new SoftReference(charset));
            return charset;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
        catch (IllegalAccessException illegalAccessException) {
            return null;
        }
        catch (InstantiationException instantiationException) {
            return null;
        }
    }

    static Map access$000(AbstractCharsetProvider abstractCharsetProvider) {
        return abstractCharsetProvider.classMap;
    }

    private static void put(Map map, String string, Object object) {
        if (!map.containsKey(string)) {
            map.put(string, object);
        }
    }

    protected void charset(String string, String string2, String[] stringArray) {
        AbstractCharsetProvider.put(this.classMap, string, string2);
        int n2 = 0;
        while (n2 < stringArray.length) {
            AbstractCharsetProvider.put(this.aliasMap, stringArray[n2], string);
            ++n2;
        }
        AbstractCharsetProvider.put(this.aliasNameMap, string, stringArray);
    }
}

