/*
 * Decompiled with CFR 0.152.
 */
package sun.net.www.protocol.http;

import java.io.FileNotFoundException;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.net.Authenticator;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.PasswordAuthentication;
import java.net.ProtocolException;
import java.net.URL;
import java.net.URLConnection;
import java.net.UnknownHostException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.TimeZone;
import sun.net.ProgressData;
import sun.net.ProgressEntry;
import sun.net.www.HeaderParser;
import sun.net.www.MessageHeader;
import sun.net.www.http.HttpClient;
import sun.net.www.http.PosterOutputStream;
import sun.net.www.protocol.http.AuthenticationInfo;
import sun.net.www.protocol.http.BasicAuthentication;
import sun.net.www.protocol.http.DigestAuthentication;
import sun.net.www.protocol.http.EmptyInputStream;
import sun.net.www.protocol.http.Handler;
import sun.net.www.protocol.http.HttpAuthenticator;
import sun.security.action.GetBooleanAction;
import sun.security.action.GetIntegerAction;
import sun.security.action.GetPropertyAction;

public class HttpURLConnection
extends java.net.HttpURLConnection {
    static final String version;
    public static final String userAgent;
    static final int defaultmaxRedirects = 20;
    static final int maxRedirects;
    static final boolean validateProxy;
    static final boolean validateServer;
    static final String httpVersion = "HTTP/1.1";
    static final String acceptString = "text/html, image/gif, image/jpeg, *; q=.2, */*; q=.2";
    private static final String[] EXCLUDE_HEADERS;
    protected HttpClient http;
    protected Handler handler;
    protected PrintStream ps = null;
    private static HttpAuthenticator defaultAuth;
    private MessageHeader requests = new MessageHeader();
    String domain;
    DigestAuthentication.Parameters digestparams;
    AuthenticationInfo currentProxyCredentials = null;
    AuthenticationInfo currentServerCredentials = null;
    boolean needToCheck = true;
    protected ProgressEntry pe;
    private MessageHeader responses = new MessageHeader();
    private InputStream inputStream = null;
    private PosterOutputStream poster = null;
    private boolean setRequests = false;
    private boolean failedOnce = false;
    private Exception rememberedException = null;

    static {
        maxRedirects = (Integer)AccessController.doPrivileged(new GetIntegerAction("http.maxRedirects", 20));
        version = (String)AccessController.doPrivileged(new GetPropertyAction("java.version"));
        String string = (String)AccessController.doPrivileged(new GetPropertyAction("http.agent"));
        string = string == null ? "Java/" + version : string + " Java/" + version;
        userAgent = string;
        validateProxy = (Boolean)AccessController.doPrivileged(new GetBooleanAction("http.auth.digest.validateProxy"));
        validateServer = (Boolean)AccessController.doPrivileged(new GetBooleanAction("http.auth.digest.validateServer"));
        EXCLUDE_HEADERS = new String[]{"Proxy-Authorization", "Authorization"};
    }

    public void connect() throws IOException {
        this.plainConnect();
    }

    public void disconnect() {
        this.responseCode = -1;
        if (this.pe != null) {
            ProgressData.pdata.unregister(this.pe);
        }
        if (this.http != null) {
            this.http.closeServer();
            this.http = null;
            this.connected = false;
        }
    }

    protected synchronized void doTunneling() throws IOException {
        int n2;
        int n3 = 0;
        String string = "";
        AuthenticationInfo authenticationInfo = null;
        String string2 = null;
        int n4 = -1;
        do {
            if (!this.connected) {
                this.proxiedConnect(this.url, string2, n4, false);
            }
            this.sendCONNECTRequest();
            this.responses.reset();
            this.http.parseHTTP(this.responses, new ProgressEntry(this.url.getFile(), null));
            string = this.responses.getValue(0);
            StringTokenizer stringTokenizer = new StringTokenizer(string);
            stringTokenizer.nextToken();
            n2 = Integer.parseInt(stringTokenizer.nextToken().trim());
            if (n2 != 407 || (authenticationInfo = this.resetProxyAuthentication(authenticationInfo)) == null) {
                if (authenticationInfo != null) {
                    authenticationInfo.addToCache();
                }
                if (n2 == 200) break;
                this.disconnect();
                break;
            }
            string2 = this.http.getProxyHostUsed();
            n4 = this.http.getProxyPortUsed();
            this.disconnect();
        } while (++n3 < maxRedirects);
        if (n3 >= maxRedirects || n2 != 200) {
            throw new IOException("Unable to tunnel through proxy. Proxy returns \"" + string + "\"");
        }
        int n5 = this.requests.getKey("Proxy-authorization");
        if (n5 >= 0) {
            this.requests.set(n5, null, null);
        }
        this.responses.reset();
    }

    public void finalize() {
    }

    protected void plainConnect() throws IOException {
        if (this.connected) {
            return;
        }
        this.http = "http".equals(this.url.getProtocol()) && !this.failedOnce ? HttpClient.New(this.url) : new HttpClient(this.url, this.handler.proxy, this.handler.proxyPort);
        this.ps = (PrintStream)this.http.getOutputStream();
        this.connected = true;
    }

    private void sendCONNECTRequest() throws IOException {
        int n2 = this.url.getPort();
        if (n2 == -1) {
            n2 = this.url.getDefaultPort();
        }
        this.requests.prepend("CONNECT " + this.url.getHost() + ":" + n2 + " " + httpVersion, null);
        this.requests.setIfNotSet("User-Agent", userAgent);
        String string = this.url.getHost();
        if (n2 != -1 && n2 != 80) {
            string = string + ":" + String.valueOf(n2);
        }
        this.requests.setIfNotSet("Host", string);
        this.requests.setIfNotSet("Accept", acceptString);
        this.setPreemptiveProxyAuthentication(this.requests);
        this.http.writeRequests(this.requests, null);
        this.requests.set(0, null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeRequests() throws IOException {
        if (!this.setRequests) {
            Object object;
            Cloneable cloneable;
            long l2;
            if (!this.failedOnce) {
                this.requests.prepend(this.method + " " + this.http.getURLFile() + " " + httpVersion, null);
            }
            this.requests.setIfNotSet("User-Agent", userAgent);
            int n2 = this.url.getPort();
            String string = this.url.getHost();
            if (n2 != -1 && n2 != 80) {
                string = string + ":" + String.valueOf(n2);
            }
            this.requests.setIfNotSet("Host", string);
            this.requests.setIfNotSet("Accept", acceptString);
            if (!this.failedOnce && this.http.getHttpKeepAliveSet()) {
                if (this.http.usingProxy) {
                    this.requests.setIfNotSet("Proxy-Connection", "keep-alive");
                } else {
                    this.requests.setIfNotSet("Connection", "keep-alive");
                }
            } else {
                this.requests.set("Connection", "close");
            }
            if (this.http.usingProxy) {
                this.setPreemptiveProxyAuthentication(this.requests);
            }
            if ((l2 = this.getIfModifiedSince()) != 0L) {
                cloneable = new Date(l2);
                object = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss 'GMT'", Locale.US);
                ((DateFormat)object).setTimeZone(TimeZone.getTimeZone("GMT"));
                this.requests.setIfNotSet("If-Modified-Since", ((DateFormat)object).format((Date)cloneable));
            }
            if ((cloneable = AuthenticationInfo.getServerAuth(this.url)) != null && ((AuthenticationInfo)cloneable).supportsPreemptiveAuthorization()) {
                this.requests.setIfNotSet(((AuthenticationInfo)cloneable).getHeaderName(), ((AuthenticationInfo)cloneable).getHeaderValue(this.url, this.method));
                this.currentServerCredentials = cloneable;
            }
            if (this.poster != null) {
                object = this.poster;
                synchronized (object) {
                    this.poster.close();
                    if (!this.method.equals("PUT")) {
                        String string2 = "application/x-www-form-urlencoded";
                        this.requests.setIfNotSet("Content-Type", string2);
                    }
                    this.requests.set("Content-Length", String.valueOf(this.poster.size()));
                }
            }
            this.setRequests = true;
        }
        this.http.writeRequests(this.requests, this.poster);
        if (this.ps.checkError()) {
            String string = this.http.getProxyHostUsed();
            int n3 = this.http.getProxyPortUsed();
            this.disconnect();
            if (this.failedOnce) {
                throw new IOException("Error writing to server");
            }
            this.failedOnce = true;
            if (string != null) {
                this.setProxiedClient(this.url, string, n3);
            } else {
                this.setNewClient(this.url);
            }
            this.ps = (PrintStream)this.http.getOutputStream();
            this.connected = true;
            this.responses = new MessageHeader();
            this.setRequests = false;
            this.writeRequests();
        }
    }

    private boolean followRedirect() throws IOException {
        if (!this.getInstanceFollowRedirects()) {
            return false;
        }
        int n2 = this.getResponseCode();
        if (n2 < 300 || n2 > 307 || n2 == 306 || n2 == 304) {
            return false;
        }
        String string = this.getHeaderField("Location");
        if (string == null) {
            return false;
        }
        URL uRL = new URL(string);
        if (!this.url.getProtocol().equalsIgnoreCase(uRL.getProtocol())) {
            return false;
        }
        this.disconnect();
        this.responses = new MessageHeader();
        if (n2 == 305) {
            this.setProxiedClient(this.url, uRL.getHost(), uRL.getPort());
            this.requests.set(0, this.method + " " + this.http.getURLFile() + " " + httpVersion, null);
            this.connected = true;
        } else {
            this.url = uRL;
            if (this.method.equals("POST") && !Boolean.getBoolean("http.strictPostRedirect") && n2 != 307) {
                this.requests = new MessageHeader();
                this.setRequests = false;
                this.setRequestMethod("GET");
                this.poster = null;
                this.connect();
            } else {
                this.connect();
                this.requests.set(0, this.method + " " + this.http.getURLFile() + " " + httpVersion, null);
                this.requests.set("Host", this.url.getHost() + (this.url.getPort() == -1 || this.url.getPort() == 80 ? "" : ":" + String.valueOf(this.url.getPort())));
            }
        }
        return true;
    }

    public boolean usingProxy() {
        if (this.http != null) {
            return this.http.getProxyHostUsed() != null;
        }
        return false;
    }

    private void checkResponseCredentials(boolean bl2) throws IOException {
        try {
            String string;
            if (!this.needToCheck) {
                return;
            }
            if (validateProxy && this.currentProxyCredentials != null) {
                string = this.responses.findValue("Proxy-Authentication-Info");
                if (bl2 || string != null) {
                    this.currentProxyCredentials.checkResponse(string, this.method, this.url);
                    this.currentProxyCredentials = null;
                }
            }
            if (validateServer && this.currentServerCredentials != null) {
                string = this.responses.findValue("Authentication-Info");
                if (bl2 || string != null) {
                    this.currentServerCredentials.checkResponse(string, this.method, this.url);
                    this.currentServerCredentials = null;
                }
            }
            if (this.currentServerCredentials == null && this.currentProxyCredentials == null) {
                this.needToCheck = false;
            }
        }
        catch (IOException iOException) {
            this.disconnect();
            this.connected = false;
            throw iOException;
        }
    }

    public InputStream getErrorStream() {
        if (this.connected && this.responseCode >= 400 && this.inputStream != null) {
            return this.inputStream;
        }
        return null;
    }

    public synchronized InputStream getInputStream() throws IOException {
        if (!this.doInput) {
            throw new ProtocolException("Cannot read from URLConnection if doInput=false (call setDoInput(true))");
        }
        if (this.rememberedException != null) {
            if (this.rememberedException instanceof RuntimeException) {
                throw (RuntimeException)this.rememberedException;
            }
            throw (IOException)this.rememberedException;
        }
        if (this.inputStream != null) {
            return this.inputStream;
        }
        int n2 = 0;
        Object object = null;
        AuthenticationInfo authenticationInfo = null;
        try {
            do {
                Object object2;
                this.pe = new ProgressEntry(this.url.getFile(), null);
                ProgressData.pdata.register(this.pe);
                this.connect();
                this.ps = (PrintStream)this.http.getOutputStream();
                this.writeRequests();
                this.http.parseHTTP(this.responses, this.pe);
                this.inputStream = new HttpInputStream(this, this.http.getInputStream());
                int n3 = this.getResponseCode();
                if (n3 == 407 && (authenticationInfo = this.resetProxyAuthentication(authenticationInfo)) != null) {
                    ++n2;
                    this.disconnect();
                    continue;
                }
                if (authenticationInfo != null) {
                    authenticationInfo.addToCache();
                }
                if (n3 == 401) {
                    if (object != null) {
                        object2 = this.responses.findValue("WWW-Authenticate");
                        if (((AuthenticationInfo)object).isAuthorizationStale((String)object2)) {
                            this.disconnect();
                            ++n2;
                            this.requests.set(((AuthenticationInfo)object).getHeaderName(), ((AuthenticationInfo)object).getHeaderValue(this.url, this.method));
                            this.currentServerCredentials = object;
                            continue;
                        }
                        ((AuthenticationInfo)object).removeFromCache();
                    }
                    object = this.getServerAuthentication();
                    this.currentServerCredentials = object;
                    if (object != null) {
                        this.disconnect();
                        ++n2;
                        continue;
                    }
                }
                if (object != null) {
                    Object object3;
                    Object object4;
                    if (!(object instanceof DigestAuthentication) || this.domain == null) {
                        if (object instanceof BasicAuthentication) {
                            object4 = ((AuthenticationInfo)object).path;
                            object2 = AuthenticationInfo.reducePath(this.url.getPath());
                            if (!((String)object4).startsWith((String)object2) || ((String)object2).length() >= ((String)object4).length()) {
                                object2 = BasicAuthentication.getRootPath((String)object4, (String)object2);
                            }
                            object3 = (BasicAuthentication)((AuthenticationInfo)object).clone();
                            ((AuthenticationInfo)object).removeFromCache();
                            ((BasicAuthentication)object3).path = object2;
                            object = object3;
                        }
                        ((AuthenticationInfo)object).addToCache();
                    } else {
                        object2 = (DigestAuthentication)object;
                        object4 = new StringTokenizer(this.domain, " ");
                        object3 = ((DigestAuthentication)object2).realm;
                        PasswordAuthentication passwordAuthentication = ((DigestAuthentication)object2).pw;
                        this.digestparams = ((DigestAuthentication)object2).params;
                        while (((StringTokenizer)object4).hasMoreTokens()) {
                            String string = ((StringTokenizer)object4).nextToken();
                            try {
                                URL uRL = new URL(this.url, string);
                                DigestAuthentication digestAuthentication = new DigestAuthentication(false, uRL, (String)object3, "Digest", passwordAuthentication, this.digestparams);
                                digestAuthentication.addToCache();
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                        }
                    }
                }
                if (n3 == 200) {
                    this.checkResponseCredentials(false);
                } else {
                    this.needToCheck = false;
                }
                if (this.followRedirect()) {
                    ++n2;
                    continue;
                }
                int n4 = -1;
                try {
                    n4 = Integer.parseInt(this.responses.findValue("content-length"));
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (this.method.equals("HEAD") || this.method.equals("TRACE") || n4 == 0 || n3 == 304 || n3 == 204) {
                    if (this.pe != null) {
                        ProgressData.pdata.unregister(this.pe);
                    }
                    this.http.finished();
                    this.http = null;
                    this.inputStream = new EmptyInputStream();
                    if (n3 < 400) {
                        this.connected = false;
                        return this.inputStream;
                    }
                }
                if (n3 >= 400) {
                    if (n3 == 404 || n3 == 410) {
                        throw new FileNotFoundException(this.url.toString());
                    }
                    throw new IOException("Server returned HTTP response code: " + n3 + " for URL: " + this.url.toString());
                }
                return this.inputStream;
            } while (n2 < maxRedirects);
            throw new ProtocolException("Server redirected too many  times (" + n2 + ")");
        }
        catch (RuntimeException runtimeException) {
            this.disconnect();
            this.rememberedException = runtimeException;
            throw runtimeException;
        }
        catch (IOException iOException) {
            this.rememberedException = iOException;
            throw iOException;
        }
    }

    public synchronized OutputStream getOutputStream() throws IOException {
        try {
            if (!this.doOutput) {
                throw new ProtocolException("cannot write to a URLConnection if doOutput=false - call setDoOutput(true)");
            }
            if (this.method.equals("GET")) {
                this.method = "POST";
            }
            if (!"POST".equals(this.method) && !"PUT".equals(this.method) && "http".equals(this.url.getProtocol())) {
                throw new ProtocolException("HTTP method " + this.method + " doesn't support output");
            }
            if (this.inputStream != null) {
                throw new ProtocolException("Cannot write output after reading input.");
            }
            this.connect();
            this.ps = (PrintStream)this.http.getOutputStream();
            if (this.poster == null) {
                this.poster = new PosterOutputStream();
            }
            return this.poster;
        }
        catch (RuntimeException runtimeException) {
            this.disconnect();
            throw runtimeException;
        }
        catch (IOException iOException) {
            this.disconnect();
            throw iOException;
        }
    }

    String getMethod() {
        return this.method;
    }

    public String getHeaderField(int n2) {
        try {
            this.getInputStream();
        }
        catch (IOException iOException) {}
        return this.responses.getValue(n2);
    }

    public String getHeaderFieldKey(int n2) {
        try {
            this.getInputStream();
        }
        catch (IOException iOException) {}
        return this.responses.getKey(n2);
    }

    protected void setNewClient(URL uRL) throws IOException {
        this.setNewClient(uRL, false);
    }

    protected void setNewClient(URL uRL, boolean bl2) throws IOException {
        this.http = HttpClient.New(uRL, bl2);
    }

    public Map getHeaderFields() {
        try {
            this.getInputStream();
        }
        catch (IOException iOException) {}
        return this.responses.getHeaders();
    }

    public Map getRequestProperties() {
        if (this.connected) {
            throw new IllegalStateException("Already connected");
        }
        return this.requests.getHeaders(EXCLUDE_HEADERS);
    }

    private void setPreemptiveProxyAuthentication(MessageHeader messageHeader) {
        AuthenticationInfo authenticationInfo = AuthenticationInfo.getProxyAuth(this.http.getProxyHostUsed(), this.http.getProxyPortUsed());
        if (authenticationInfo != null && authenticationInfo.supportsPreemptiveAuthorization()) {
            messageHeader.setIfNotSet(authenticationInfo.getHeaderName(), authenticationInfo.getHeaderValue(this.url, this.method));
            this.currentProxyCredentials = authenticationInfo;
        }
    }

    private AuthenticationInfo getHttpProxyAuthentication() {
        AuthenticationInfo authenticationInfo = null;
        String string = this.responses.findValue("Proxy-Authenticate");
        String string2 = this.http.getProxyHostUsed();
        int n2 = this.http.getProxyPortUsed();
        if (string2 != null && string != null) {
            Object object;
            Object object2;
            String string3;
            char c2;
            HeaderParser headerParser = new HeaderParser(string);
            String string4 = headerParser.findValue("realm");
            authenticationInfo = AuthenticationInfo.getProxyAuth(string2, n2, string4, c2 = "basic".equalsIgnoreCase(string3 = headerParser.findKey(0)) ? (char)'B' : ("digest".equalsIgnoreCase(string3) ? (char)'D' : '\u0000'));
            if (authenticationInfo == null && c2 == 'B') {
                object2 = null;
                try {
                    object = string2;
                    object2 = (InetAddress)AccessController.doPrivileged(new PrivilegedExceptionAction(this, (String)object){
                        private final String val$finalHost;
                        private final HttpURLConnection this$0;

                        public Object run() throws UnknownHostException {
                            return InetAddress.getByName(this.val$finalHost);
                        }
                        {
                            this.this$0 = httpURLConnection;
                            this.val$finalHost = string;
                        }
                    });
                }
                catch (PrivilegedActionException privilegedActionException) {
                    // empty catch block
                }
                object = HttpURLConnection.privilegedRequestPasswordAuthentication(string2, (InetAddress)object2, n2, "http", string4, string3);
                if (object != null) {
                    authenticationInfo = new BasicAuthentication(true, string2, n2, string4, (PasswordAuthentication)object);
                }
            } else if (authenticationInfo == null && c2 == 'D' && (object2 = HttpURLConnection.privilegedRequestPasswordAuthentication(string2, null, n2, this.url.getProtocol(), string4, string3)) != null) {
                object = new DigestAuthentication.Parameters();
                authenticationInfo = new DigestAuthentication(true, string2, n2, string4, string3, (PasswordAuthentication)object2, (DigestAuthentication.Parameters)object);
            }
            if (authenticationInfo == null && defaultAuth != null && defaultAuth.schemeSupported(string3)) {
                try {
                    object2 = new URL("http", string2, n2, "/");
                    object = defaultAuth.authString((URL)object2, string3, string4);
                    if (object != null) {
                        authenticationInfo = new BasicAuthentication(true, string2, n2, string4, (String)object);
                    }
                }
                catch (MalformedURLException malformedURLException) {
                    // empty catch block
                }
            }
            if (authenticationInfo != null && !authenticationInfo.setHeaders(this, headerParser)) {
                authenticationInfo = null;
            }
        }
        return authenticationInfo;
    }

    private AuthenticationInfo getServerAuthentication() {
        AuthenticationInfo authenticationInfo = null;
        String string = this.responses.findValue("WWW-Authenticate");
        if (string != null) {
            Object object;
            int n2;
            HeaderParser headerParser = new HeaderParser(string);
            String string2 = headerParser.findValue("realm");
            String string3 = headerParser.findKey(0);
            char c2 = "basic".equalsIgnoreCase(string3) ? (char)'B' : ("digest".equalsIgnoreCase(string3) ? (char)'D' : '\u0000');
            this.domain = headerParser.findValue("domain");
            authenticationInfo = AuthenticationInfo.getServerAuth(this.url, string2, c2);
            InetAddress inetAddress = null;
            if (authenticationInfo == null) {
                try {
                    inetAddress = InetAddress.getByName(this.url.getHost());
                }
                catch (UnknownHostException unknownHostException) {
                    // empty catch block
                }
            }
            if ((n2 = this.url.getPort()) == -1) {
                n2 = this.url.getDefaultPort();
            }
            if (authenticationInfo == null && c2 == 'B' && (object = HttpURLConnection.privilegedRequestPasswordAuthentication(this.url.getHost(), inetAddress, n2, this.url.getProtocol(), string2, string3)) != null) {
                authenticationInfo = new BasicAuthentication(false, this.url, string2, (PasswordAuthentication)object);
            }
            if (authenticationInfo == null && c2 == 'D' && (object = HttpURLConnection.privilegedRequestPasswordAuthentication(this.url.getHost(), inetAddress, n2, this.url.getProtocol(), string2, string3)) != null) {
                this.digestparams = new DigestAuthentication.Parameters();
                authenticationInfo = new DigestAuthentication(false, this.url, string2, string3, (PasswordAuthentication)object, this.digestparams);
            }
            if (authenticationInfo == null && defaultAuth != null && defaultAuth.schemeSupported(string3) && (object = defaultAuth.authString(this.url, string3, string2)) != null) {
                authenticationInfo = new BasicAuthentication(false, this.url, string2, (String)object);
            }
            if (authenticationInfo != null && !authenticationInfo.setHeaders(this, headerParser)) {
                authenticationInfo = null;
            }
        }
        return authenticationInfo;
    }

    public static void setDefaultAuthenticator(HttpAuthenticator httpAuthenticator) {
        defaultAuth = httpAuthenticator;
    }

    static void access$000(HttpURLConnection httpURLConnection, boolean bl2) throws IOException {
        httpURLConnection.checkResponseCredentials(bl2);
    }

    public static InputStream openConnectionCheckRedirects(URLConnection uRLConnection) throws IOException {
        boolean bl2;
        int n2 = 0;
        InputStream inputStream = null;
        do {
            HttpURLConnection httpURLConnection;
            int n3;
            if (uRLConnection instanceof HttpURLConnection) {
                ((HttpURLConnection)uRLConnection).setInstanceFollowRedirects(false);
            }
            inputStream = uRLConnection.getInputStream();
            bl2 = false;
            if (!(uRLConnection instanceof HttpURLConnection) || (n3 = (httpURLConnection = (HttpURLConnection)uRLConnection).getResponseCode()) < 300 || n3 > 307 || n3 == 306 || n3 == 304) continue;
            URL uRL = httpURLConnection.getURL();
            String string = httpURLConnection.getHeaderField("Location");
            URL uRL2 = null;
            if (string != null) {
                uRL2 = new URL(uRL, string);
            }
            httpURLConnection.disconnect();
            if (uRL2 == null || !uRL.getProtocol().equals(uRL2.getProtocol()) || uRL.getPort() != uRL2.getPort() || !HttpURLConnection.hostsEqual(uRL, uRL2) || n2 >= 5) {
                throw new SecurityException("illegal URL redirect");
            }
            bl2 = true;
            uRLConnection = uRL2.openConnection();
            ++n2;
        } while (bl2);
        return inputStream;
    }

    public String getHeaderField(String string) {
        try {
            this.getInputStream();
        }
        catch (IOException iOException) {}
        return this.responses.findValue(string);
    }

    public String getRequestProperty(String string) {
        if (string != null) {
            int n2 = 0;
            while (n2 < EXCLUDE_HEADERS.length) {
                if (string.equalsIgnoreCase(EXCLUDE_HEADERS[n2])) {
                    return null;
                }
                ++n2;
            }
        }
        return this.requests.findValue(string);
    }

    public void addRequestProperty(String string, String string2) {
        if (this.connected) {
            throw new IllegalStateException("Already connected");
        }
        this.checkMessageHeader(string, string2);
        this.requests.add(string, string2);
    }

    private void checkMessageHeader(String string, String string2) {
        int n2 = 10;
        int n3 = string.indexOf(n2);
        if (n3 != -1) {
            throw new IllegalArgumentException("Illegal character(s) in message header field: " + string);
        }
        n3 = string2.indexOf(n2);
        while (n3 != -1) {
            char c2;
            if (++n3 < string2.length() && ((c2 = string2.charAt(n3)) == ' ' || c2 == '\t')) {
                n3 = string2.indexOf(n2, n3);
                continue;
            }
            throw new IllegalArgumentException("Illegal character(s) in message header value: " + string2);
        }
    }

    void setAuthenticationProperty(String string, String string2) {
        this.checkMessageHeader(string, string2);
        this.requests.set(string, string2);
    }

    public void setRequestProperty(String string, String string2) {
        if (this.connected) {
            throw new IllegalStateException("Already connected");
        }
        this.checkMessageHeader(string, string2);
        this.requests.set(string, string2);
    }

    public HttpURLConnection(URL uRL, String string, int n2) throws IOException {
        this(uRL, new Handler(string, n2));
    }

    protected void setProxiedClient(URL uRL, String string, int n2) throws IOException {
        this.setProxiedClient(uRL, string, n2, false);
    }

    protected void proxiedConnect(URL uRL, String string, int n2, boolean bl2) throws IOException {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkConnect(string, n2);
        }
        this.http = HttpClient.New(uRL, string, n2, bl2);
    }

    protected void setProxiedClient(URL uRL, String string, int n2, boolean bl2) throws IOException {
        this.proxiedConnect(uRL, string, n2, bl2);
    }

    private static boolean hostsEqual(URL uRL, URL uRL2) {
        String string = uRL.getHost();
        String string2 = uRL2.getHost();
        if (string == null) {
            return string2 == null;
        }
        if (string2 == null) {
            return false;
        }
        if (string.equalsIgnoreCase(string2)) {
            return true;
        }
        boolean[] blArray = new boolean[]{false};
        AccessController.doPrivileged(new PrivilegedAction(string, string2, blArray){
            private final String val$h1;
            private final String val$h2;
            private final boolean[] val$result;

            public Object run() {
                try {
                    InetAddress inetAddress = InetAddress.getByName(this.val$h1);
                    InetAddress inetAddress2 = InetAddress.getByName(this.val$h2);
                    this.val$result[0] = inetAddress.equals(inetAddress2);
                }
                catch (UnknownHostException unknownHostException) {
                }
                catch (SecurityException securityException) {}
                return null;
            }
            {
                this.val$h1 = string;
                this.val$h2 = string2;
                this.val$result = blArray;
            }
        });
        return blArray[0];
    }

    private AuthenticationInfo resetProxyAuthentication(AuthenticationInfo authenticationInfo) {
        if (authenticationInfo != null) {
            String string = this.responses.findValue("Proxy-Authenticate");
            if (authenticationInfo.isAuthorizationStale(string)) {
                this.requests.set(authenticationInfo.getHeaderName(), authenticationInfo.getHeaderValue(this.url, this.method));
                this.currentProxyCredentials = authenticationInfo;
                return authenticationInfo;
            }
            authenticationInfo.removeFromCache();
        }
        this.currentProxyCredentials = authenticationInfo = this.getHttpProxyAuthentication();
        return authenticationInfo;
    }

    protected HttpURLConnection(URL uRL, Handler handler) throws IOException {
        super(uRL);
        this.handler = handler;
    }

    private static PasswordAuthentication privilegedRequestPasswordAuthentication(String string, InetAddress inetAddress, int n2, String string2, String string3, String string4) {
        return (PasswordAuthentication)AccessController.doPrivileged(new PrivilegedAction(string, inetAddress, n2, string2, string3, string4){
            private final String val$host;
            private final InetAddress val$addr;
            private final int val$port;
            private final String val$protocol;
            private final String val$prompt;
            private final String val$scheme;

            public Object run() {
                return Authenticator.requestPasswordAuthentication(this.val$host, this.val$addr, this.val$port, this.val$protocol, this.val$prompt, this.val$scheme);
            }
            {
                this.val$host = string;
                this.val$addr = inetAddress;
                this.val$port = n2;
                this.val$protocol = string2;
                this.val$prompt = string3;
                this.val$scheme = string4;
            }
        });
    }

    class HttpInputStream
    extends FilterInputStream {
        private final HttpURLConnection this$0;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void close() throws IOException {
            try {
                super.close();
                Object var2_1 = null;
                this.this$0.http = null;
            }
            catch (Throwable throwable) {
                Object var2_2 = null;
                this.this$0.http = null;
                HttpURLConnection.access$000(this.this$0, true);
                throw throwable;
            }
            HttpURLConnection.access$000(this.this$0, true);
        }

        public HttpInputStream(HttpURLConnection httpURLConnection, InputStream inputStream) {
            this.this$0 = httpURLConnection;
            super(inputStream);
        }
    }
}

