/*
 * Decompiled with CFR 0.152.
 */
package sun.net.www.http;

import java.io.IOException;
import java.io.NotSerializableException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import sun.net.www.http.ClientVector;
import sun.net.www.http.HttpClient;
import sun.net.www.http.KeepAliveEntry;
import sun.net.www.http.KeepAliveKey;
import sun.security.action.GetIntegerAction;

public class KeepAliveCache
extends Hashtable
implements Runnable {
    static final int MAX_CONNECTIONS = 5;
    static int result = -1;
    static final int LIFETIME = 5000;

    static int getMaxConnections() {
        if (result == -1 && (result = ((Integer)AccessController.doPrivileged(new GetIntegerAction("http.maxConnections", 5))).intValue()) <= 0) {
            result = 5;
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        do {
            try {
                Thread.sleep(5000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            KeepAliveCache keepAliveCache = this;
            synchronized (keepAliveCache) {
                long l2 = System.currentTimeMillis();
                Iterator iterator = this.keySet().iterator();
                ArrayList arrayList = new ArrayList();
                while (iterator.hasNext()) {
                    ClientVector clientVector;
                    KeepAliveKey keepAliveKey = (KeepAliveKey)iterator.next();
                    ClientVector clientVector2 = clientVector = (ClientVector)this.get(keepAliveKey);
                    synchronized (clientVector2) {
                        int n2 = 0;
                        while (n2 < clientVector.size()) {
                            KeepAliveEntry keepAliveEntry = (KeepAliveEntry)clientVector.elementAt(n2);
                            if (l2 - keepAliveEntry.idleStartTime <= (long)clientVector.nap) break;
                            HttpClient httpClient = keepAliveEntry.hc;
                            httpClient.closeServer();
                            ++n2;
                        }
                        clientVector.subList(0, n2).clear();
                        if (clientVector.size() == 0) {
                            arrayList.add(keepAliveKey);
                        }
                    }
                }
                iterator = arrayList.iterator();
                while (iterator.hasNext()) {
                    this.removeVector((KeepAliveKey)iterator.next());
                }
            }
        } while (this.size() > 0);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        throw new NotSerializableException();
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        throw new NotSerializableException();
    }

    synchronized void removeVector(KeepAliveKey keepAliveKey) {
        super.remove(keepAliveKey);
    }

    public synchronized void remove(HttpClient httpClient, Object object) {
        KeepAliveKey keepAliveKey = new KeepAliveKey(httpClient.url, object);
        ClientVector clientVector = (ClientVector)super.get(keepAliveKey);
        if (clientVector != null) {
            clientVector.remove(httpClient);
            if (clientVector.empty()) {
                this.removeVector(keepAliveKey);
            }
        }
    }

    public synchronized Object get(URL uRL, Object object) {
        KeepAliveKey keepAliveKey = new KeepAliveKey(uRL, object);
        ClientVector clientVector = (ClientVector)super.get(keepAliveKey);
        if (clientVector == null) {
            return null;
        }
        return clientVector.get();
    }

    public synchronized void put(URL uRL, Object object, HttpClient httpClient) {
        ClientVector clientVector;
        Object object2;
        if (this.size() == 0) {
            object2 = this;
            AccessController.doPrivileged(new PrivilegedAction(this, (KeepAliveCache)object2){
                private final KeepAliveCache val$cache;
                private final KeepAliveCache this$0;

                public Object run() {
                    Thread thread = null;
                    thread = new Thread(this.val$cache, "Keep-Alive-Timer");
                    thread.setDaemon(true);
                    thread.setPriority(8);
                    thread.start();
                    return null;
                }
                {
                    this.this$0 = keepAliveCache;
                    this.val$cache = keepAliveCache2;
                }
            });
        }
        if ((clientVector = (ClientVector)super.get(object2 = new KeepAliveKey(uRL, object))) == null) {
            int n2 = httpClient.getKeepAliveTimeout();
            clientVector = new ClientVector(n2 > 0 ? n2 * 1000 : 5000);
            clientVector.put(httpClient);
            super.put(object2, clientVector);
        } else {
            clientVector.put(httpClient);
        }
    }
}

