/*
 * Decompiled with CFR 0.152.
 */
package sun.net.www;

import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class MessageHeader {
    private String[] keys;
    private String[] values;
    private int nkeys;

    public MessageHeader() {
        this.grow();
    }

    private void grow() {
        if (this.keys == null || this.nkeys >= this.keys.length) {
            String[] stringArray = new String[this.nkeys + 4];
            String[] stringArray2 = new String[this.nkeys + 4];
            if (this.keys != null) {
                System.arraycopy(this.keys, 0, stringArray, 0, this.nkeys);
            }
            if (this.values != null) {
                System.arraycopy(this.values, 0, stringArray2, 0, this.nkeys);
            }
            this.keys = stringArray;
            this.values = stringArray2;
        }
    }

    public synchronized void reset() {
        this.keys = null;
        this.values = null;
        this.nkeys = 0;
        this.grow();
    }

    public MessageHeader(InputStream inputStream) throws IOException {
        this.parseHeader(inputStream);
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    public void mergeHeader(InputStream inputStream) throws IOException {
        if (inputStream == null) {
            return;
        }
        char[] cArray = new char[10];
        int n2 = inputStream.read();
        while (n2 != 10 && n2 != 13 && n2 >= 0) {
            Object object;
            void var2_3;
            int n3;
            int n4;
            block18: {
                int n5;
                n4 = 0;
                n3 = -1;
                boolean bl2 = n2 > 32;
                var2_3[n4++] = (char)n2;
                while ((n5 = inputStream.read()) >= 0) {
                    switch (n5) {
                        case 58: {
                            if (bl2 && n4 > 0) {
                                n3 = n4;
                            }
                            bl2 = false;
                            break;
                        }
                        case 9: {
                            n5 = 32;
                        }
                        case 32: {
                            bl2 = false;
                            break;
                        }
                        case 10: 
                        case 13: {
                            n2 = inputStream.read();
                            if (n5 == 13 && n2 == 10 && (n2 = inputStream.read()) == 13) {
                                n2 = inputStream.read();
                            }
                            if (n2 == 10 || n2 == 13 || n2 > 32) break block18;
                            n5 = 32;
                        }
                    }
                    if (n4 >= ((void)var2_3).length) {
                        object = new char[((void)var2_3).length * 2];
                        System.arraycopy(var2_3, 0, object, 0, n4);
                        Object object2 = object;
                    }
                    var2_3[n4++] = (char)n5;
                }
                n2 = -1;
            }
            while (n4 > 0 && var2_3[n4 - 1] <= 32) {
                --n4;
            }
            if (n3 <= 0) {
                object = null;
                n3 = 0;
            } else {
                object = String.copyValueOf((char[])var2_3, 0, n3);
                if (n3 < n4 && var2_3[n3] == 58) {
                    ++n3;
                }
                while (n3 < n4 && var2_3[n3] <= 32) {
                    ++n3;
                }
            }
            String string = n3 >= n4 ? new String() : String.copyValueOf((char[])var2_3, n3, n4 - n3);
            this.add((String)object, string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void parseHeader(InputStream inputStream) throws IOException {
        MessageHeader messageHeader = this;
        synchronized (messageHeader) {
            this.nkeys = 0;
        }
        this.mergeHeader(inputStream);
    }

    public synchronized void print(PrintStream printStream) {
        int n2 = 0;
        while (n2 < this.nkeys) {
            if (this.keys[n2] != null) {
                printStream.print(this.keys[n2] + (this.values[n2] != null ? ": " + this.values[n2] : "") + "\r\n");
            }
            ++n2;
        }
        printStream.print("\r\n");
        printStream.flush();
    }

    public synchronized String toString() {
        String string = super.toString();
        int n2 = 0;
        while (n2 < this.keys.length) {
            string = string + "{" + this.keys[n2] + ": " + this.values[n2] + "}";
            ++n2;
        }
        return string;
    }

    public synchronized String getKey(int n2) {
        if (n2 < 0 || n2 >= this.nkeys) {
            return null;
        }
        return this.keys[n2];
    }

    public synchronized String getValue(int n2) {
        if (n2 < 0 || n2 >= this.nkeys) {
            return null;
        }
        return this.values[n2];
    }

    public synchronized int getKey(String string) {
        int n2 = this.nkeys;
        while (--n2 >= 0) {
            if (this.keys[n2] != string && (string == null || !string.equalsIgnoreCase(this.keys[n2]))) continue;
            return n2;
        }
        return -1;
    }

    public synchronized Map getHeaders() {
        return this.getHeaders(null);
    }

    public synchronized void set(int n2, String string, String string2) {
        this.grow();
        if (n2 < 0) {
            return;
        }
        if (n2 > this.nkeys) {
            this.add(string, string2);
        } else {
            this.keys[n2] = string;
            this.values[n2] = string2;
        }
    }

    public static String canonicalID(String string) {
        char c2;
        if (string == null) {
            return "";
        }
        int n2 = 0;
        int n3 = string.length();
        boolean bl2 = false;
        while (n2 < n3 && ((c2 = string.charAt(n2)) == '<' || c2 <= ' ')) {
            ++n2;
            bl2 = true;
        }
        while (n2 < n3 && ((c2 = string.charAt(n3 - 1)) == '>' || c2 <= ' ')) {
            --n3;
            bl2 = true;
        }
        return bl2 ? string.substring(n2, n3) : string;
    }

    public synchronized String findValue(String string) {
        if (string == null) {
            int n2 = this.nkeys;
            while (--n2 >= 0) {
                if (this.keys[n2] != null) continue;
                return this.values[n2];
            }
        } else {
            int n3 = this.nkeys;
            while (--n3 >= 0) {
                if (!string.equalsIgnoreCase(this.keys[n3])) continue;
                return this.values[n3];
            }
        }
        return null;
    }

    public synchronized void add(String string, String string2) {
        this.grow();
        this.keys[this.nkeys] = string;
        this.values[this.nkeys] = string2;
        ++this.nkeys;
    }

    public synchronized void prepend(String string, String string2) {
        this.grow();
        int n2 = this.nkeys;
        while (n2 > 0) {
            this.keys[n2] = this.keys[n2 - 1];
            this.values[n2] = this.values[n2 - 1];
            --n2;
        }
        this.keys[0] = string;
        this.values[0] = string2;
        ++this.nkeys;
    }

    public synchronized void set(String string, String string2) {
        int n2 = this.nkeys;
        while (--n2 >= 0) {
            if (!string.equalsIgnoreCase(this.keys[n2])) continue;
            this.values[n2] = string2;
            return;
        }
        this.add(string, string2);
    }

    public synchronized void setIfNotSet(String string, String string2) {
        if (this.findValue(string) == null) {
            this.add(string, string2);
        }
    }

    public synchronized Map getHeaders(String[] stringArray) {
        boolean bl2 = false;
        HashMap hashMap = new HashMap();
        int n2 = this.nkeys;
        while (--n2 >= 0) {
            if (stringArray != null) {
                int n3 = 0;
                while (n3 < stringArray.length) {
                    if (stringArray[n3] != null && stringArray[n3].equalsIgnoreCase(this.keys[n2])) {
                        bl2 = true;
                        break;
                    }
                    ++n3;
                }
            }
            if (!bl2) {
                List list = (List)hashMap.get(this.keys[n2]);
                if (list == null) {
                    list = new ArrayList();
                    hashMap.put(this.keys[n2], list);
                }
                list.add(this.values[n2]);
                continue;
            }
            bl2 = false;
        }
        Set set = hashMap.keySet();
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            Object object = iterator.next();
            List list = (List)hashMap.get(object);
            hashMap.put(object, Collections.unmodifiableList(list));
        }
        return Collections.unmodifiableMap(hashMap);
    }

    public synchronized String findNextValue(String string, String string2) {
        boolean bl2 = false;
        if (string == null) {
            int n2 = this.nkeys;
            while (--n2 >= 0) {
                if (this.keys[n2] != null) continue;
                if (bl2) {
                    return this.values[n2];
                }
                if (this.values[n2] != string2) continue;
                bl2 = true;
            }
        } else {
            int n3 = this.nkeys;
            while (--n3 >= 0) {
                if (!string.equalsIgnoreCase(this.keys[n3])) continue;
                if (bl2) {
                    return this.values[n3];
                }
                if (this.values[n3] != string2) continue;
                bl2 = true;
            }
        }
        return null;
    }
}

