/*
 * Decompiled with CFR 0.152.
 */
package sun.misc;

import java.io.PrintStream;
import sun.misc.REException;
import sun.misc.RegexpNode;
import sun.misc.RegexpTarget;

public class RegexpPool {
    private RegexpNode prefixMachine = new RegexpNode();
    private RegexpNode suffixMachine = new RegexpNode();
    private static final int BIG = Integer.MAX_VALUE;
    private int lastDepth = Integer.MAX_VALUE;

    public void reset() {
        this.lastDepth = Integer.MAX_VALUE;
    }

    public void print(PrintStream printStream) {
        printStream.print("Regexp pool:\n");
        if (this.suffixMachine.firstchild != null) {
            printStream.print(" Suffix machine: ");
            this.suffixMachine.firstchild.print(printStream);
            printStream.print("\n");
        }
        if (this.prefixMachine.firstchild != null) {
            printStream.print(" Prefix machine: ");
            this.prefixMachine.firstchild.print(printStream);
            printStream.print("\n");
        }
    }

    public Object delete(String string) {
        RegexpNode regexpNode;
        Object object = null;
        RegexpNode regexpNode2 = regexpNode = this.prefixMachine;
        int n2 = string.length() - 1;
        boolean bl2 = true;
        if (!string.startsWith("*") || !string.endsWith("*")) {
            ++n2;
        }
        if (n2 <= 0) {
            return null;
        }
        int n3 = 0;
        while (regexpNode != null) {
            if (!(regexpNode.result == null || regexpNode.depth >= Integer.MAX_VALUE || regexpNode.exact && n3 != n2)) {
                regexpNode2 = regexpNode;
            }
            if (n3 >= n2) break;
            regexpNode = regexpNode.find(string.charAt(n3));
            ++n3;
        }
        regexpNode = this.suffixMachine;
        n3 = n2;
        while (--n3 >= 0 && regexpNode != null) {
            if (regexpNode.result != null && regexpNode.depth < Integer.MAX_VALUE) {
                bl2 = false;
                regexpNode2 = regexpNode;
            }
            regexpNode = regexpNode.find(string.charAt(n3));
        }
        if (bl2) {
            if (string.equals(regexpNode2.re)) {
                object = regexpNode2.result;
                regexpNode2.result = null;
            }
        } else if (string.equals(regexpNode2.re)) {
            object = regexpNode2.result;
            regexpNode2.result = null;
        }
        return object;
    }

    public Object match(String string) {
        return this.matchAfter(string, Integer.MAX_VALUE);
    }

    public Object matchNext(String string) {
        return this.matchAfter(string, this.lastDepth);
    }

    private Object matchAfter(String string, int n2) {
        RegexpNode regexpNode;
        RegexpNode regexpNode2 = regexpNode = this.prefixMachine;
        int n3 = 0;
        int n4 = 0;
        int n5 = string.length();
        if (n5 <= 0) {
            return null;
        }
        int n6 = 0;
        while (regexpNode != null) {
            if (!(regexpNode.result == null || regexpNode.depth >= n2 || regexpNode.exact && n6 != n5)) {
                this.lastDepth = regexpNode.depth;
                regexpNode2 = regexpNode;
                n3 = n6;
                n4 = n5;
            }
            if (n6 >= n5) break;
            regexpNode = regexpNode.find(string.charAt(n6));
            ++n6;
        }
        regexpNode = this.suffixMachine;
        n6 = n5;
        while (--n6 >= 0 && regexpNode != null) {
            if (regexpNode.result != null && regexpNode.depth < n2) {
                this.lastDepth = regexpNode.depth;
                regexpNode2 = regexpNode;
                n3 = 0;
                n4 = n6 + 1;
            }
            regexpNode = regexpNode.find(string.charAt(n6));
        }
        Object object = regexpNode2.result;
        if (object != null && object instanceof RegexpTarget) {
            object = ((RegexpTarget)object).found(string.substring(n3, n4));
        }
        return object;
    }

    public void add(String string, Object object) throws REException {
        this.add(string, object, false);
    }

    public void replace(String string, Object object) {
        try {
            this.add(string, object, true);
        }
        catch (Exception exception) {}
    }

    private void add(String string, Object object, boolean bl2) throws REException {
        RegexpNode regexpNode;
        int n2 = string.length();
        if (string.charAt(0) == '*') {
            regexpNode = this.suffixMachine;
            while (n2 > 1) {
                regexpNode = regexpNode.add(string.charAt(--n2));
            }
        } else {
            boolean bl3 = false;
            if (string.charAt(n2 - 1) == '*') {
                --n2;
            } else {
                bl3 = true;
            }
            regexpNode = this.prefixMachine;
            int n3 = 0;
            while (n3 < n2) {
                regexpNode = regexpNode.add(string.charAt(n3));
                ++n3;
            }
            regexpNode.exact = bl3;
        }
        if (regexpNode.result != null && !bl2) {
            throw new REException(string + " is a duplicate");
        }
        regexpNode.re = string;
        regexpNode.result = object;
    }
}

