/*
 * Decompiled with CFR 0.152.
 */
package sun.misc;

import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import sun.misc.CharacterEncoder;

public class HexDumpEncoder
extends CharacterEncoder {
    private int offset;
    private int thisLineLength;
    private int currentByte;
    private byte[] thisLine = new byte[16];

    protected int bytesPerAtom() {
        return 1;
    }

    protected int bytesPerLine() {
        return 16;
    }

    protected void encodeBufferPrefix(OutputStream outputStream) throws IOException {
        this.offset = 0;
        super.encodeBufferPrefix(outputStream);
    }

    protected void encodeLineSuffix(OutputStream outputStream) throws IOException {
        int n2;
        if (this.thisLineLength < 16) {
            n2 = this.thisLineLength;
            while (n2 < 16) {
                this.pStream.print("   ");
                if (n2 == 7) {
                    this.pStream.print("  ");
                }
                ++n2;
            }
        }
        this.pStream.print(" ");
        n2 = 0;
        while (n2 < this.thisLineLength) {
            if (this.thisLine[n2] < 32 || this.thisLine[n2] > 122) {
                this.pStream.print(".");
            } else {
                this.pStream.write(this.thisLine[n2]);
            }
            ++n2;
        }
        this.pStream.println();
        this.offset += this.thisLineLength;
    }

    protected void encodeLinePrefix(OutputStream outputStream, int n2) throws IOException {
        HexDumpEncoder.hexDigit(this.pStream, (byte)(this.offset >>> 8 & 0xFF));
        HexDumpEncoder.hexDigit(this.pStream, (byte)(this.offset & 0xFF));
        this.pStream.print(": ");
        this.currentByte = 0;
        this.thisLineLength = n2;
    }

    protected void encodeAtom(OutputStream outputStream, byte[] byArray, int n2, int n3) throws IOException {
        this.thisLine[this.currentByte] = byArray[n2];
        HexDumpEncoder.hexDigit(this.pStream, byArray[n2]);
        this.pStream.print(" ");
        ++this.currentByte;
        if (this.currentByte == 8) {
            this.pStream.print("  ");
        }
    }

    static void hexDigit(PrintStream printStream, byte by) {
        char c2 = (char)(by >> 4 & 0xF);
        c2 = c2 > '\t' ? (char)(c2 - 10 + 65) : (char)(c2 + 48);
        printStream.write(c2);
        c2 = (char)(by & 0xF);
        c2 = c2 > '\t' ? (char)(c2 - 10 + 65) : (char)(c2 + 48);
        printStream.write(c2);
    }
}

