/*
 * Decompiled with CFR 0.152.
 */
package sun.jdbc.odbc;

import java.io.InputStream;
import java.util.Hashtable;
import java.util.Vector;
import sun.jdbc.odbc.JdbcOdbcObject;

public class JdbcOdbcBoundArrayOfParams
extends JdbcOdbcObject {
    protected int numParams;
    protected Hashtable hashedLenIdx;
    protected Object[] storedParams;
    protected int[] paramLenIdx;
    protected Object[][] storedInputStreams;
    protected Object[][] paramSets;
    protected int[][] paramLenIdxSets;
    protected int batchSize;

    public void clearParameterSet() {
        if (this.storedParams != null) {
            int n2 = 0;
            while (n2 < this.numParams) {
                this.storedParams[n2] = new Object();
                this.paramLenIdx[n2] = -5;
                ++n2;
            }
        }
    }

    public void clearStoredRowIndexs() {
        if (!this.hashedLenIdx.isEmpty()) {
            this.hashedLenIdx.clear();
        }
    }

    public void initialize() {
        this.storedParams = new Object[this.numParams];
        this.paramLenIdx = new int[this.numParams];
        this.hashedLenIdx = new Hashtable();
        this.batchSize = 0;
        int n2 = 0;
        while (n2 < this.numParams) {
            this.paramLenIdx[n2] = -5;
            ++n2;
        }
    }

    public int[] getStoredIndexSet() {
        int[] nArray;
        block4: {
            nArray = new int[]{};
            if (this.paramLenIdx == null) break block4;
            nArray = new int[this.numParams];
            try {
                int n2 = 0;
                while (n2 < this.numParams) {
                    nArray[n2] = this.paramLenIdx[n2];
                    if (nArray[n2] == -5) {
                        nArray = new int[]{};
                        return nArray;
                    }
                    ++n2;
                }
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                System.out.println("exception: " + arrayIndexOutOfBoundsException.getMessage());
                arrayIndexOutOfBoundsException.printStackTrace();
            }
        }
        return nArray;
    }

    public JdbcOdbcBoundArrayOfParams(int n2) {
        this.numParams = n2;
        this.initialize();
    }

    public int[] getColumnWiseIndexArray(int n2) {
        int[] nArray = new int[this.batchSize];
        if (this.paramLenIdxSets != null) {
            int n3 = 0;
            while (n3 < this.batchSize) {
                nArray[n3] = this.paramLenIdxSets[n3][n2 - 1];
                ++n3;
            }
        }
        return nArray;
    }

    public int[] getStoredRowIndex(int n2) {
        return (int[])this.hashedLenIdx.get(new Integer(n2));
    }

    public int getElementLength(int n2, int n3) {
        return this.paramLenIdxSets[n3 - 1][n2 - 1];
    }

    public void storeRowIndex(int n2, int[] nArray) {
        this.hashedLenIdx.put(new Integer(n2), nArray);
    }

    public InputStream getInputStreamElement(int n2, int n3) {
        InputStream inputStream = null;
        if (n2 >= 1 && n2 <= this.numParams && n3 >= 1 && n3 <= this.batchSize) {
            inputStream = (InputStream)this.storedInputStreams[n3 - 1][n2 - 1];
        }
        return inputStream;
    }

    public Object[] getStoredParameterSet() {
        Object[] objectArray;
        block3: {
            objectArray = new Object[]{};
            if (this.storedParams == null) break block3;
            objectArray = new Object[this.numParams];
            try {
                int n2 = 0;
                while (n2 < this.numParams) {
                    objectArray[n2] = this.storedParams[n2];
                    ++n2;
                }
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                System.out.println("exception: " + arrayIndexOutOfBoundsException.getMessage());
                arrayIndexOutOfBoundsException.printStackTrace();
            }
        }
        return objectArray;
    }

    public Object[] getColumnWiseParamSet(int n2) {
        Object[] objectArray = new Object[this.batchSize];
        if (this.paramSets != null) {
            int n3 = 0;
            while (n3 < this.batchSize) {
                objectArray[n3] = this.paramSets[n3][n2 - 1];
                ++n3;
            }
        }
        return objectArray;
    }

    public void storeValue(int n2, Object object, int n3) {
        this.storedParams[n2] = object;
        this.paramLenIdx[n2] = n3;
    }

    public void setInputStreamElements(int n2, Object[] objectArray) {
        if (n2 >= 1 && n2 <= this.numParams && this.storedInputStreams != null && objectArray != null) {
            int n3 = 0;
            while (n3 < this.batchSize) {
                this.storedInputStreams[n3][n2 - 1] = objectArray[n3];
                ++n3;
            }
        }
    }

    public void builtColumWiseParameteSets(int n2, Vector vector) {
        int[] nArray = new int[]{};
        Object[] objectArray = new Object[]{};
        this.batchSize = n2;
        if (vector.size() == this.batchSize) {
            this.storedInputStreams = new Object[this.batchSize][this.numParams];
            this.paramSets = new Object[this.batchSize][this.numParams];
            this.paramLenIdxSets = new int[this.batchSize][this.numParams];
            int n3 = 0;
            while (n3 < this.batchSize) {
                nArray = this.getStoredRowIndex(n3);
                objectArray = (Object[])vector.elementAt(n3);
                int n4 = 0;
                while (n4 < this.numParams) {
                    this.paramSets[n3][n4] = objectArray[n4];
                    this.paramLenIdxSets[n3][n4] = nArray[n4];
                    ++n4;
                }
                ++n3;
            }
        }
    }
}

