/*
 * Decompiled with CFR 0.152.
 */
package sun.java2d.loops;

import java.awt.Composite;
import java.awt.CompositeContext;
import java.awt.RenderingHints;
import java.awt.image.ColorModel;
import java.awt.image.Raster;
import java.awt.image.WritableRaster;
import java.lang.ref.WeakReference;
import sun.java2d.SurfaceData;
import sun.java2d.loops.CompositeType;
import sun.java2d.loops.GraphicsPrimitive;
import sun.java2d.loops.GraphicsPrimitiveMgr;
import sun.java2d.loops.MaskBlit;
import sun.java2d.loops.RenderCache;
import sun.java2d.loops.SurfaceType;

public class Blit
extends GraphicsPrimitive {
    public static final String methodSignature = "Blit(Lsun/java2d/SurfaceData;Lsun/java2d/SurfaceData;Ljava/awt/Composite;" + "IIIIII)V".toString();
    private static RenderCache blitcache = new RenderCache(20);

    static {
        GraphicsPrimitiveMgr.registerGeneral(new Blit(null, null, null));
    }

    public GraphicsPrimitive traceWrap() {
        return new TraceBlit(this);
    }

    public native void Blit(SurfaceData var1, SurfaceData var2, Composite var3, int var4, int var5, int var6, int var7, int var8, int var9);

    public Blit(long l2, SurfaceType surfaceType, CompositeType compositeType, SurfaceType surfaceType2) {
        super(l2, methodSignature, surfaceType, compositeType, surfaceType2);
    }

    protected Blit(SurfaceType surfaceType, CompositeType compositeType, SurfaceType surfaceType2) {
        super(methodSignature, surfaceType, compositeType, surfaceType2);
    }

    public static synchronized Blit getFromCache(SurfaceType surfaceType, CompositeType compositeType, SurfaceType surfaceType2) {
        Object object = blitcache.get(surfaceType, compositeType, surfaceType2);
        if (object != null) {
            return (Blit)object;
        }
        Blit blit = Blit.locate(surfaceType, compositeType, surfaceType2);
        if (blit == null) {
            System.out.println("blit loop not found for:");
            System.out.println("src:  " + surfaceType);
            System.out.println("comp: " + compositeType);
            System.out.println("dst:  " + surfaceType2);
        } else {
            blitcache.put(surfaceType, compositeType, surfaceType2, blit);
        }
        return blit;
    }

    public static Blit locate(SurfaceType surfaceType, CompositeType compositeType, SurfaceType surfaceType2) {
        return (Blit)GraphicsPrimitiveMgr.locate(methodSignature, surfaceType, compositeType, surfaceType2);
    }

    public GraphicsPrimitive makePrimitive(SurfaceType surfaceType, CompositeType compositeType, SurfaceType surfaceType2) {
        if (compositeType.isDerivedFrom(CompositeType.Xor)) {
            GeneralXorBlit generalXorBlit = new GeneralXorBlit(surfaceType, compositeType, surfaceType2);
            this.setupGeneralBinaryOp(generalXorBlit);
            return generalXorBlit;
        }
        if (compositeType.isDerivedFrom(CompositeType.AnyAlpha)) {
            return new GeneralMaskBlit(surfaceType, compositeType, surfaceType2);
        }
        return AnyBlit.instance;
    }

    private static class AnyBlit
    extends Blit {
        public static AnyBlit instance = new AnyBlit();

        public AnyBlit() {
            super(SurfaceType.Any, CompositeType.Any, SurfaceType.Any);
        }

        public void Blit(SurfaceData surfaceData, SurfaceData surfaceData2, Composite composite, int n2, int n3, int n4, int n5, int n6, int n7) {
            ColorModel colorModel = surfaceData.getColorModel();
            ColorModel colorModel2 = surfaceData2.getColorModel();
            CompositeContext compositeContext = composite.createContext(colorModel, colorModel2, new RenderingHints(null));
            Raster raster = surfaceData.getRaster(n2, n3, n6, n7);
            raster = raster.createChild(n2, n3, n6, n7, 0, 0, null);
            WritableRaster writableRaster = (WritableRaster)surfaceData2.getRaster(n4, n5, n6, n7);
            writableRaster = writableRaster.createWritableChild(n4, n5, n6, n7, 0, 0, null);
            compositeContext.compose(raster, writableRaster, writableRaster);
            compositeContext.dispose();
        }
    }

    private static class GeneralMaskBlit
    extends Blit {
        MaskBlit performop;

        public void Blit(SurfaceData surfaceData, SurfaceData surfaceData2, Composite composite, int n2, int n3, int n4, int n5, int n6, int n7) {
            this.performop.MaskBlit(surfaceData, surfaceData2, composite, n2, n3, n4, n5, n6, n7, null, 0, 0);
        }

        public GeneralMaskBlit(SurfaceType surfaceType, CompositeType compositeType, SurfaceType surfaceType2) {
            super(surfaceType, compositeType, surfaceType2);
            this.performop = MaskBlit.locate(surfaceType, compositeType, surfaceType2);
        }
    }

    private static class GeneralXorBlit
    extends Blit
    implements GraphicsPrimitive.GeneralBinaryOp {
        Blit convertsrc;
        Blit convertdst;
        Blit performop;
        Blit convertresult;
        WeakReference srcTmp;
        WeakReference dstTmp;

        public synchronized void Blit(SurfaceData surfaceData, SurfaceData surfaceData2, Composite composite, int n2, int n3, int n4, int n5, int n6, int n7) {
            int n8;
            int n9;
            SurfaceData surfaceData3;
            SurfaceData surfaceData4;
            int n10;
            int n11;
            SurfaceData surfaceData5;
            if (this.convertsrc == null) {
                surfaceData5 = surfaceData;
                n11 = n2;
                n10 = n3;
            } else {
                surfaceData4 = null;
                if (this.srcTmp != null) {
                    surfaceData4 = (SurfaceData)this.srcTmp.get();
                }
                surfaceData5 = GraphicsPrimitive.convertFrom(this.convertsrc, surfaceData, n2, n3, n6, n7, surfaceData4);
                n11 = 0;
                n10 = 0;
                if (surfaceData5 != surfaceData4) {
                    this.srcTmp = new WeakReference(surfaceData5);
                }
            }
            if (this.convertdst == null) {
                surfaceData3 = surfaceData2;
                n9 = n4;
                n8 = n5;
            } else {
                surfaceData4 = null;
                if (this.dstTmp != null) {
                    surfaceData4 = (SurfaceData)this.dstTmp.get();
                }
                surfaceData3 = GraphicsPrimitive.convertFrom(this.convertdst, surfaceData2, n4, n5, n6, n7, surfaceData4);
                n9 = 0;
                n8 = 0;
                if (surfaceData3 != surfaceData4) {
                    this.dstTmp = new WeakReference(surfaceData3);
                }
            }
            this.performop.Blit(surfaceData5, surfaceData3, composite, n11, n10, n9, n8, n6, n7);
            if (this.convertresult != null) {
                GraphicsPrimitive.convertTo(this.convertresult, surfaceData3, surfaceData2, n4, n5, n6, n7);
            }
        }

        public GeneralXorBlit(SurfaceType surfaceType, CompositeType compositeType, SurfaceType surfaceType2) {
            super(surfaceType, compositeType, surfaceType2);
        }

        public void setPrimitives(Blit blit, Blit blit2, GraphicsPrimitive graphicsPrimitive, Blit blit3) {
            this.convertsrc = blit;
            this.convertdst = blit2;
            this.performop = (Blit)graphicsPrimitive;
            this.convertresult = blit3;
        }
    }

    private static class TraceBlit
    extends Blit {
        Blit target;

        public TraceBlit(Blit blit) {
            super(blit.getSourceType(), blit.getCompositeType(), blit.getDestType());
            this.target = blit;
        }

        public GraphicsPrimitive traceWrap() {
            return this;
        }

        public void Blit(SurfaceData surfaceData, SurfaceData surfaceData2, Composite composite, int n2, int n3, int n4, int n5, int n6, int n7) {
            GraphicsPrimitive.tracePrimitive(this.target);
            this.target.Blit(surfaceData, surfaceData2, composite, n2, n3, n4, n5, n6, n7);
        }
    }
}

